CODE	segment
	assume	cs:CODE,ds:CODE

movseg	macro	seg1,seg2
	push	seg2
	pop	seg1
	endm

jmps	macro	label
	jmp	short label
	endm

LF		equ	0Ah
CR		equ	0Dh
DOS		equ	21h
ESC_SC		equ	01h		; Esc Scan Code
Z_SC		equ	2Ch		; 'Z' Scan Code
UP_SC		equ	48h		; up arrow Scan Code
LEFT_SC		equ	4Bh		; left arrow Scan Code
RGHT_SC		equ	4Dh		; right arrow Scan Code
DOWN_SC		equ	50h		; down arrow Scan Code

;	at segment 0040h
SHFT_STAT	equ	0017h		; shift keys status.
KBUF_RPTR	equ	001Ah		; key buffer read pointer
KBUF_WPTR	equ	001Ch		; key buffer write pointer
CRTC_PORT	equ	0063h		; CRTC port(3D4h or 3C4h)
KBUF_BGN	equ	0080h		; key buffer start address
KBUF_END	equ	0082h		; key buffer end address
MODE_OPT	equ	0089h		; MCGA/VGA mode option

ON		equ	0
OFF		equ	0FFh

TVBUF_PAGE	equ	1		; ʕۑرƂ1߰ގgp

	org	0h
PSP_ID		dw	?		; = int 20h

	org	16h
PID		label	word		; e۾

	org	2Ch
envseg		label	word		; ϐ

	org	80h
argc		db	?		; ߼ݥײ݂̕
argv		label	byte		; ߼ݥײ

	org	100h
START:
	jmp	SETUP

ID	db	'ZoomC100'

VRAM_SEG	dw	0B800h		; VRAM
CRSR_FIG	dw	?		; ٌ`ۑر
TVBUF_MAP	dw	0, 0		; _߰/߰ނð
EMM_HANDLE	dw	?
EMS_SEG		dw	?		; ޯ̧
SYS_SEG		dw	0040h		; ѥر
CRTC		dw	3D4h
VTOP		dw	?		; VRAM擪ڽ
VTOPO		dw	?		; VRAM擪ڽ
POSX		db	0
POSY		db	0		; 0..49
KEMS		db	0		; EMS gp\

TRAP_16h:
	sti
	test	ah,	0EEh		; KBD read or sense or other ?
	jz	T16_01
	jmp	T16_X

T16_01:	push	ds
	push	bx
	push	ax
	push	si
	mov	ds,	cs:SYS_SEG
	test	byte ptr ds:[SHFT_STAT], 4	; Cntrl Key?
	jz	T16_3
	test	byte ptr ds:[SHFT_STAT], 8	; Alt Key?
	jz	T16_3

T16_1:	cli
	mov	bx,	ds:[KBUF_RPTR]
	cmp	bx,	ds:[KBUF_WPTR]
	jnz	T16_2
	test	ah,	1
	jnz	T16_3
	sti
	jmps	T16_1

T16_2:	inc	bx
	mov	al,	ds:[bx]
	cmp	al,	Z_SC
	jnz	T16_3

	call	ZOOM

T16_3:	pop	si
	pop	ax
	pop	bx
	pop	ds
	cli
T16_X:		db	0EAh		; code of ( jump far imm. )
ORG_INT16	dd	?

ZOOM:
	push	di
	push	es
	movseg	ds,	cs
	push	dx
	push	cx
	call	SAVE_SCREEN

	cli
	mov	dx,	CRTC
	mov	al,	12
	out	dx,	al
	jmps	$+2
	inc	dx
	in	al,	dx
	mov	bh,	al
	jmps	$+2
	dec	dx
	mov	al,	13
	out	dx,	al
	jmps	$+2
	inc	dx
	in	al,	dx
	mov	bl,	al
GVNOP	label	word
	shl	bx,	1
	mov	VTOP,	bx
	mov	VTOPO,	bx
	mov	word ptr POSX,	0
	sti

ZM10:
	mov	di,	VTOP
	mov	cx,	50		; 50x4ײݕ\

ZM11:	mov	dl,	40		; 40\
ZM110:	mov	al,	POSY
ZM111:	mov	ah,	80*4/2
	mul	ah
ZM112:	mov	si,	VTOPO
	add	si,	ax
	xor	ah,	ah
	mov	al,	POSX
	add	si,	ax
	mov	bx,	1FFFh
	mov	es,	VRAM_SEG
	mov	ds,	EMS_SEG

ZM12:	push	cx
	push	si
	push	di

	mov	cl,	dl
ZM14:	push	cx
	and	si,	bx

ZM15:	and	di,	bx
	lodsb

        mov	cx,	8
	mov	dh,	al
ZM16:   ror	dh,	1
        rcr	ax,	1
        sar	ax,	1
	loop	ZM16
	xchg	ah,	al

	mov	es:[di],	ax
	mov	es:[di+2000h],	ax
	add	si,	bx
	add	di,	80
	cmp	si,	4000h
	jc	ZM15

	sub	di,	160 - 2
	inc	si
	pop	cx
	loop	ZM14

	pop	di
	pop	si
	add	di,	160
	add	si,	80
	pop	cx
	loop	ZM12

	mov	cx,	cs:VTOP
ZM20:	mov	ds,	cs:SYS_SEG
	mov	si,	ds:[KBUF_WPTR]
	cli
	mov	ds:[KBUF_RPTR],	si
ZM21:	cmp	ds:[KBUF_WPTR],	si
	sti
	jz	ZM21
	cli
	mov	ds:[KBUF_WPTR],	si
	sti
	lodsw
	mov	al,	ds:[SHFT_STAT]
	movseg	ds,	cs
	cmp	ah,	UP_SC
	jz	GO_U
	cmp	ah,	LEFT_SC
	jz	GO_L
	cmp	ah,	RGHT_SC
	jz	GO_R
	cmp	ah,	DOWN_SC
	jz	GO_D
	cmp	ah,	ESC_SC
	jnz	ZM20

	mov	cx,	VTOPO
	call	SET_VTOP
	call	RESTORE_SCREEN
	pop	cx
	pop	dx
	pop	es
	pop	di
	ret

GO_U:	cmp	POSY,	0
	jz	ZM20
	test	al,	3
	jz	GO_US
	cmp	POSY,	1
	jz	GO_US
	mov	POSY,	0
	jmp	ZM10

GO_US:	dec	POSY
	sub	cx,	320
	call	SET_VTOP
	mov	cx,	2
	jmp	ZM11

GO_L:	cmp	POSX,	0
	jz	ZM20
	test	al,	3
	jz	GO_LS
	cmp	POSX,	1
	jz	GO_LS
	mov	POSX,	0
	jmp	ZM10

GO_LS:	dec	POSX
	dec	cx
	dec	cx
	call	SET_VTOP
	mov	cx,	50
	mov	dl,	1
	jmp	ZM110

GO_R:	cmp	POSX,	40
	jae	ZM20
	test	al,	3
	jz	GO_RS
	cmp	POSX,	39
	jz	GO_RS
	mov	POSX,	40
	jmp	ZM10

GO_RS:	inc	POSX
	inc	cx
	inc	cx
	call	SET_VTOP
	add	di,	78
	mov	cx,	50
	mov	dl,	1
	mov	al,	POSY
	mov	ah,	80*4/2
	mul	ah
	add	ax,	39
	jmp	ZM112

GO_D:	cmp	POSY,	25
	jae	ZM20
	test	al,	3
	jz	GO_DS
	cmp	POSY,	24
	jz	GO_DS
	mov	POSY,	25
	jmp	ZM10

GO_DS:	inc	POSY
	add	cx,	320
	call	SET_VTOP
	add	di,	320*24
	mov	al,	POSY
	add	al,	24
	mov	cx,	2
	mov	dl,	40
	jmp	ZM111

SAVE_SCREEN:
	mov	ah,	3
	xor	bh,	bh		; ߰ނ0
	int	10h			; ٌ`̎擾
	mov	CRSR_FIG,	cx
	mov	cx,	2000h		; ٔ\
	mov	ah,	1
	int	10h
	cmp	KEMS,	0
	jne	SSN1
	call	TVBUF_ALOC		; EMS ߰ޥϯݸ
SSN1:	push	ds
	mov	es,	EMS_SEG
	mov	ds,	VRAM_SEG
	xor	si,	si
	mov	di,	si
	mov	cx,	2000h		; VRAM16kB
	cld
	rep	movsw
	pop	ds
	ret

TVBUF_ALOC:
	mov	cx,	TVBUF_PAGE
	mov	si,	offset TVBUF_MAP
	mov	dx,	EMM_HANDLE	; save current page map.
	mov	ah,	47h
	int	67h
	mov	ax,	5000h
	int	67h			; assign text buffer page
	ret

RESTORE_SCREEN:
	push	ds
	mov	ds,	EMS_SEG
	sub	si,	si
	mov	di,	si
	mov	cx,	2000h
	cld
	rep	movsw
	pop	ds
	mov	cx,	CRSR_FIG
	mov	ah,	1
	int	10h			; J[\`̕A
	cmp	KEMS,	0
	je	EMS_DALOC
	ret

EMS_DALOC:
	mov	dx,	EMM_HANDLE
	mov	ah,	48h
	int	67h			; restore page map
	ret

SET_VTOP:
	and	cx,	bx
	mov	VTOP,	cx
	mov	di,	cx
SVNOP	label	word
	shr	cx,	1
	mov	dx,	CRTC
	mov	ah,	ch
	mov	al,	12
	cli
	out	dx,	ax
	jmp	$+2
	mov	ah,	cl
	mov	al,	13
	out	dx,	ax
	sti
	ret

SETUP:
	mov	dx,	offset OPNMSG
	mov	ah,	9
	int	DOS
	call	TSRCK
	jnc	UNLOAD

LOAD:
	call	TSR			; 풓̏풓

UNLOAD:
	call	CHKUL			; 풓\H
	jc	TERM
	call	TSROFF			; 풓
	xor	al,	al
TERM:	movseg	ds,	cs
	push	ax
	mov	ah,	9
	int	DOS
	pop	ax
	mov	ah,	4Ch
	int	DOS			; ۸ ̏I

TSR:	call	EMS_INIT
	jnc	TSRON
	inc	KEMS

TSRON:
	mov	ax,	3500h + 16h
	int	DOS			; GET INTERRUPT VECTOR
	mov	word ptr ORG_INT16,	bx
	mov	ax,	es
	mov	word ptr ORG_INT16+2,	ax
	mov	dx,	offset TRAP_16h
	mov	ax,	2500h + 16h
	int	DOS			; SET INTERRUPT VECTOR
	mov	es,	SYS_SEG
	mov	ax,	es:CRTC_PORT
	mov	CRTC,	ax
	mov	al,	es:MODE_OPT
	cmp	al,	11h
	jne	TON1			; is VGA?
	mov	ax,	9090h		; nop/nop
	mov	GVNOP,	ax
	mov	SVNOP,	ax
TON1:	mov	dx,	offset TONMSG
	mov	ah,	9
	int	DOS
	mov	es,	ds:envseg
	mov	ah,	49h
	int	DOS			; 풓̉
	mov	dx,	offset SETUP + 0Fh
	mov	cl,	4
	shr	dx,	cl
	cmp	KEMS,	0
	je	TON2
	mov	ax,	cs
	add	ax,	dx
	mov	EMS_SEG,	ax
	add	dx,	4000h/16
TON2:	mov	ax,	3100h
	int	DOS			; ۸ ̏풓I

	assume	es:code
TSROFF:	lds	dx,	dword ptr es:ORG_INT16
	mov	ax,	2500h + 16h
	int	DOS			; 荞޸̕A
	cmp	KEMS,	0
	jne	TOFF1
	mov	dx,	es:EMM_HANDLE	; EMS ̉
	mov	ah,	45h
	int	67h
TOFF1:	mov	ah,	49h
	int	DOS			; 풓̉
	mov	dx,	offset TOFMSG
	ret

TSRCK:
	mov	ax,	3500h + 16h
	int	DOS			; 
	mov	di,	offset ID
	mov	si,	offset ID
	mov	cx,	8
	repz	cmpsb
	jz	TSRCEX
	stc
TSRCEX:	ret

CHKUL:
	push	es
	mov	cx,	es		; cx = 풓ZOg
	mov	ax,	3500h + 16h	; int 16h = ްޥײ
	int	DOS			; 荞݃xN^𓾂
	mov	bx,	es
	cmp	bx,	cx
	jnz	CHKULX			; ătbNĂ

CHKUL2:	pop	es
	ret

CHKULX:	stc
	pop	es
	ret

HANDLE_NAME db	'zoomc   ',0

EMS_INIT:
	call	CHK_EMM			; EMM ̑݊mF
	jc	EMM_ERR
	mov	ah,	40h		; EMM gp\H
	int	67h
	or	ah,	ah
	jnz	EMM_ERR
	mov	ah,	46h		; EMM ̃o[W`FbN
	int	67h
	or	ah,	ah
	jnz	EMM_ERR
	cmp	al,	40h		; o[W 4.0 ȉH
	jb	EMM_ERR
	mov	ah,	41h		; y[Wt[̃ZOg߂
	int	67h
	or	ah,	ah
	jnz	EMM_ERR
	mov	EMS_SEG,	bx
	mov	ah,	42h		; gp\y[W߂
	int	67h
	or	ah,	ah
	jnz	EMM_ERR
	mov	ax,	TVBUF_PAGE
	cmp	bx,	ax
	jb	EMM_ERR
	mov	bx,	ax		; EMM nh̊蓖
	mov	ah,	43h
	int	67h
	or	ah,	ah
	jnz	EMM_ERR
	mov	EMM_HANDLE,	dx
	mov	si,	offset HANDLE_NAME	; nh̐ݒ
	mov	ax,	5301h
	int	67h
	clc
	ret
EMM_ERR:
	stc
	ret

EMM_NAME db	'EMMXXXX0'
EMM_LEN  =	offset $ - EMM_NAME

CHK_EMM:				; EMM ݂̑mF
	xor	ax,	ax
	mov	es,	ax
	mov	es,	es:[67h*4+2]	; es = EMM 荞݂̃ZOg
	mov	di,	0Ah
	push	ds
	mov	si,	cs
	mov	ds,	si
	mov	si,	offset EMM_NAME
	mov	cx,	EMM_LEN
	cld
	repe	cmpsb
	pop	ds
	jnz	NOEMM
	clc
	ret
NOEMM:
	stc
	ret

OPNMSG	db	'     ZoomC V1.00 by Torry',CR,LF,'$'
TONMSG	db	'      ...installed.',CR,LF,'$'
TOFMSG  db      '      ...removed.',CR,LF,'$'

CODE	ends
end	START
