#!/usr/bin/perl

use File::Copy;
use Cwd;

$cwd = getcwd;

$dos = $^O =~ /Win/ || $^O =~ /DOS/i;

($src, $dst) = @ARGV;

$dst ||= ".";

$src = "$src/language" if (-d "$src/language");

unless (-d $dst && -d $src) {
        die <<EOM;
Usage: $0 <source directory> [<target directory>]

Source directory - where the installers from freedict.org installed
the dictionaries.
Target directory - where this package is installed.


EOM
}

system ($dos ? "cls" : "clear");
print "\n" x 30;


@dicts = glob "$src/*.wb";
@bdicts = @dicts;

foreach (@dicts) {
        s|^.*/||;
        s/\.wb$//;
        tr/A-Z/a-z/;
        next unless (-f "$src/$_.wb");
        ($from, $to) = split(/_/, $_);
        $hash{$from, $to} = 1;
}

foreach (keys %hash) {
        my @t = split(/[^ -z]/);
        @t = map {ucfirst(lc($_));} @t;
        if ($h2{$t[1], $t[0]}) {
                $h2{$t[1], $t[0]}++;
                next;
        }
        $h2{$t[0], $t[1]} = 1;
}

@opts = grep {$h2{$_} == 2;} keys %h2;
$n = @opts;

exit unless (@opts);

foreach(@opts) {
        $line++;
        my @t = split(/[^ -z]/);
        print "$line) $t[0] - $t[1]\n";
}

for (;;) {
        print "Please choose one [1 - $n]: ";
        $c = int(<STDIN>);
        last if ($c > 0 && $c <= $n);
}

$key = $opts[$c - 1];
@t = split(/[^ -z]/, $key);

@t = reverse @t if ($t[1] eq 'English');

$fn1 = "$t[0]_$t[1]";
$fn2 = "$t[1]_$t[0]";

foreach (@bdicts) {
        $d1 = $_ if (/$fn1\.wb$/i);
        $d2 = $_ if (/$fn2\.wb$/i);
}

@tt = map {lc(substr($_, 0, 3));} @t;

$dt1 = "$tt[0]_$tt[1].wb";
$dt2 = "$tt[1]_$tt[0].wb";

print "Copying $d1 to $dst/$dt1\n";
copy($d1, "$dst/$dt1");
print "Copying $d2 to $dst/$dt2\n";
copy($d2, "$dst/$dt2");

print "\n\n\n\nHow shall I call the configuration file? ";
$name = <STDIN>;
chop $name;

chdir $dst;

open(O, ">$name.ini");
print O <<EOM;
[languages]
from=$t[0]
to=$t[1]
[files]
forward=$dt1
backward=$dt2
EOM
close(O);

print "\n" x 10;

$bin = "./dict";
if ($dos) {
        $bin = "dict.exe";
        $bin = "dict.exe" if (! -x $bin && -x "bdict.exe");
        $bin = "lxdict.exe" if (! -x $bin && -x "lxdict.exe");
}

print "Probing dictionary...\n";

system "$bin -PCsVaS $name.ini";

chdir $cwd;
