;---------------------------------------------------------------------------;
;										 ed200.asm												 ;	
; program to call Hp200 system manager as an editor                         ;
;                                                                           ;
; called by: ed200 [edfile]                                                 ;
; where edfile is the name of the file we want to edit                      ;
;                                                                           ;
; David Becher (davidb@netmedia.net.il)                                    ;
;                                                                           ;
;---------------------------------------------------------------------------;
	DOSSEG
	.MODEL tiny

CR		equ	0dh
SPACE	equ	' '
TAB	equ	9

	.CODE
	ORG 100h
start:
	jmp	getTail

;
;	subroutine that simulates key presses.
;	Key to be pressed is passed in al
;
pressKey	proc	near
	push	ax				; press
	out	60h,al
	int	9

	pop	ax				; release
	or	   al,80h
	out	60h,al
	int	9
	ret
pressKey	endp

;
;	Subroutine to check char in al for whitespace
;	If whitespace Z flag is set
;
whiteSpace	proc	near
	and	al,al
	jz		w1
	cmp	al, CR
	je		w1
	cmp	al, SPACE
	je		w1
	cmp	al, TAB
w1:
	ret
whiteSpace	endp

;
;	get the command tail from the psp, null terminate the first parameter
;	and get its length in bytes
;	si points to the string, bx has its length
;
getTail:
	xor	bx, bx
	mov	si, 80h
	cld
	lodsb				; check byte count
	and	al,al
	jz		noPatch

getT1:					;	start reading the command line
	lodsb					;	skip leading whitespace
	call	whiteSpace
	je		getT1
	push	si				; si is one char past start of filename - save it

getT2:					;	we are now inside the first parameter
	lodsb					;	loop until we are out of it
	inc	bx
	call	whiteSpace
	jne	getT2

getT3:					; we are at the end of the first parameter,
	dec	si				; Null terminate the string
	mov	BYTE PTR [si], 0
	pop	si
	dec	si
	and	bx, bx		; check again if we have a filename parameter
	je	PressMemoKey

;
;	now we open the memoed.env file and patch it
;
	.DATA
patchPos	equ	72		; where we patch the file
cpMemo:
	db	'c:\_dat\memoed.env', 0
patchFlag:
	db		0				; signals if we patched the file

	.CODE
Patch:
	push	bx				; save them
	push	si

open:
	mov	dx,OFFSET cpMemo
	mov	ax,03d42h
	int	21h
	jc		openFail
seek:
	push	ax			; save the handle
	mov	dx, patchPos
	xor	cx, cx
	pop	bx
	mov	ax, 4200h
	int	21h
	jc		seekFail
write:
	pop	dx			; command line parameter
	pop	cx			; no of bytes
	inc	cx			; include the null terminator
	mov	ah, 40h
	int	21h
	jc		close
	mov	BYTE PTR [patchFlag], 1	; the patch succeeded!
close:
	mov	ah, 3eh
	int	21h
	jmp	short PressMemoKey
seekFail:			; clean up the stack
openFail:
	pop 	ax
	pop	ax

;
;	Simulate keypresses for the memo
;
KEYMEMO	equ 76h	; scan codes
KEYMENU	equ 7ah
KEYF		equ 21h
KEY1   	equ 02h

NoPatch:
PressMemoKey:
	mov	al, KEYMEMO
	call	pressKey

;
;	Check if System manager is already running
;	by looking for interrupt 7e & 7f services
;

IRETCODE	equ	0cfh			; opcode for an iret instruction
InterruptSeg	SEGMENT AT 0
	ORG	7eh * 4
Int7e		dd (?)
Int7f		dd (?)

InterruptSeg	ENDS

	.CODE
Check200:
	ASSUME ds:InterruptSeg
	xor	ax, ax
	push	ax
	pop	ds

	les	bx, DWORD PTR [Int7e]	;	check that interrupt 7e isnt 0
C1:
	mov	cx, 2
	push	es
	pop	ax
	or		ax, bx
	je		No200
	cmp	byte ptr es:[bx], IRETCODE	; and that it isnt pointing to an IRET
	je		No200

	les	bx, DWORD PTR [Int7f]	;	check that interrupt 7f isnt 0
	loop	C1

;
; if we arrived here we are running under SysMgr & have finished
;
exit:
	mov	ax, 4c00h
	int	21h

;
;	SysMgr is not running so press some more keys & then invoke it
;
No200:
	push	cs					; restore ds & es to the same as cs
	pop	ds
	ASSUME ds:DGROUP
	push	ds
	pop	es

	mov	al, BYTE PTR [patchFlag]	; check if we patched a file
	and	al, al
	jz		Spawn200

;
;	Press the memo keys to load the file Menu - f - 1
;
MemoFileMenu:
	mov	al, KEYMENU
	call	pressKey
	mov	al, KEYF
	call	pressKey
	mov	al, KEY1
	call	pressKey

Spawn200:
	jmp	FAR PTR SysMgr

SysMgrSeg	SEGMENT AT 0f000h
	ASSUME	cs:SysMgrSeg
	ORG	0
SysMgr	LABEL FAR

SysMgrSeg	ENDS

END	start

