//
//	This file can be considered as an example how to insert your own
//	comments for the imported DLLs. Now this file inserts a comment for
//	the kernel function #23 'LOCKSEGMENT'. You can add your own comments
//	for other functions and DLLs. To execute this file your should
//	choose 'Execute IDC file' command from the IDA menu. Usually the
//	hotkey is F2.
//

static main(void) {
  auto kernel;

  Message("Loading comments...\n");
  kernel = SegByName("KERNEL");		// get segment base
  if ( kernel != -1 ) {			// if KERNEL exists
    kernel = kernel << 4;		// convert to effective address

    ExtLinA(kernel+23,0,";--------------------------------------------------------");
    ExtLinA(kernel+23,1,"; LockSegment (2.x)");
    ExtLinA(kernel+23,2,"; ");
    ExtLinA(kernel+23,3,"; In: AX - segment to lock");
    ExtLinA(kernel+23,4,";     LockSegment function locks the specified discardable");
    ExtLinA(kernel+23,5,"; segment. The segment is locked into memory at the given");
    ExtLinA(kernel+23,6,"; address and its lock count is incremented (increased by one).");
    ExtLinA(kernel+23,7,"; Returns");
    ExtLinA(kernel+23,8,"; The return value specifies the data segment if the function is");
    ExtLinA(kernel+23,9,"; successful. It is NULL if the segment has been discarded or an");
    ExtLinA(kernel+23,10,"; error occurs.");
  }
  Message("Comment(s) are loaded.\n");
}
