(*
 * ʃLv`[c[ for HP100LX
 * CAPLX ver.1.03
 * Copyright(C) 1994 Hiroyuki Sekiya
 *
 * :
 *	1.00	98p̃Lv`[c[CGAɈڐA
 *	1.01	VRAMǂ݂ƃmCŶŁCLXŗL̃OtBbNBIOS
 *		g悤ɕύX
 *	1.02	t@CtH[}bgPCXɂ
 *	1.03	PCXwb_̃pbgԈĂ̂𒼂
 *)

(*$M 1024,0,0*)	(* minimum stack, no heap *)
(*$S-,I-,R-*)	(* no stack checking, no I/O checking, no range checking *)

program CapLX;

  uses
    Dos;

  type
    PtrRec	= record
      POfs, PSeg : Word;
    end;
    SwapRec	= record
      Addr	: Pointer;
      MinSize	: Word;
      MaxSize	: Word;
      LastSize	: Word;
    end;
  var
    Old09	: procedure;		(* L[{[h荞 *)
    Old23	: Pointer;		(* CTRL+C荞 *)
    Old24	: Pointer;		(* vIG[荞 *)
    LocalStack	: Pointer;		(* [JX^bN *)
    SaveStack	: Pointer;		(* ۑX^bN|C^ *)
    IndosAddr	: Pointer;
    SwapInfo	: SwapRec;
    SwapBuf	: array[1..2048] of Byte;
    Stayed	: Boolean;		(* 풓ς݃tO *)
    OutDir	: DirStr;
  const
    Cutting	: Boolean = False;	(* ʃJbgtO *)
    (* zbgL[ *)
    ShiftCode	: Byte = $08;		(* ALT *)
    KeyCode	: Byte = $7A;		(* 3 *)


  (* inline}V}N *)
  procedure cli; inline($FA);
  procedure sti; inline($FB);
  procedure pushf; inline($9C);


  (* indostÕAhX𓾂 *)
  function GetIndosAddr : Pointer; assembler;
  asm
	mov	ah, 34h
	int	21h
	mov	dx, es
	mov	ax, bx
  end;(* GetIndosAddr *)


  (* ubN *)
  procedure MemFree(Segment : Word); assembler;
  asm
	mov	es, [Segment]
	mov	ah, 49h
	int	21h
  end;(* MemFree *)


  (* gp@̕\ *)
  procedure Usage;
  begin
    Writeln('Usage:	CAPLX [-kXXYY] [-pPATH]'#13#10
	  + '	XX   : shift code'#13#10
	  + '	YY   : key code'#13#10
	  + '	PATH : file save path');
    Halt(1);
  end;(* Usage *)


  (* R}hCIvV̌ *)
  procedure CheckParam;
    var
      Param	: ComStr;
      i		: Byte;
      Err	: Integer;
  begin
    OutDir := '';
    for i := 1 to ParamCount do begin
      Param := ParamStr(i);
      if (Param[1] = '-') or (Param[1] = '/') then begin
	case UpCase(Param[2]) of
	  'P' : OutDir := Copy(Param, 3, 255);
	  'K' : begin
	          Val('$' + Copy(Param, 3, 2), ShiftCode, Err);
	          if Err <> 0 then Usage;
	          Val('$' + Copy(Param, 5, 2), KeyCode, Err);
	          if Err <> 0 then Usage;
	        end;
	  else Usage;
	end;
      end else
	Usage;
    end;
    if (OutDir <> '') and (OutDir[Length(OutDir)] <> '\') then
      OutDir := OutDir + '\';
  end;(* CheckParam *)


  procedure Int23; assembler;
  asm
	iret
  end;

  (* vIG[荞݃[` *)
  procedure Int24; assembler;
  asm
	xor	ax, ax
	iret
  end;(* Int24 *)


  procedure Delay(MS : Word);
    var
      i		: Word;
  begin
    while MS > 0 do begin
      for i := 0 to 99 do ;
      Dec(MS);
    end;
  end;(* Delay *)

  procedure BeepOn; assembler;
  asm
	in	al, 61h
	or	al, 03h
	out	61h, al
  end;

  procedure BeepOff; assembler;
  asm
	in	al, 61h
	and	al, not 03h
	out	61h, al
  end;

  procedure InitGraph; assembler;
  asm
	(* Get code page in BX *)
	mov	ax, 6601h
	int	21h
	push	bx
	(* Get video mode in AL *)
	mov	ah, 0Fh
	int	10h
	push	ax
	(* Set CGA graphics mode *)
	mov	ax, 0006h
	int	5Fh
	(* Restore video mode *)
	pop	ax
	xor	ah, ah
	int	10h
	(* Restore code page *)
	pop	bx
	mov	ax, 6602h
	int	21h
  end;

  procedure GetImage(X1, Y1, X2, Y2 : Word; var Buf); assembler;
  asm
	les	di, [Buf]
	mov	cx, [X1]
	mov	dx, [Y1]
	mov	si, [X2]
	push	bp
	mov	bp, [Y2]
	mov	ah, 0Dh
	int	5Fh
	pop	bp
  end;

  function Encode(var _InBuf, _OutBuf) : Word;
    var
      InBuf	: array[0..79] of Byte absolute _InBuf;
      OutBuf	: array[0..159] of Byte absolute _OutBuf;
      InCnt	: Byte;
      OutCnt	: Byte;
      Last	: Byte;
      RunLen	: Byte;
      Temp	: Byte;
    procedure EncPut(Data, Count : Byte);
    begin
      if (Count = 1) and (Data and $C0 <> $C0) then begin
        OutBuf[OutCnt] := Data; Inc(OutCnt);
      end else begin
        OutBuf[OutCnt] := $C0 or Count; Inc(OutCnt);
        OutBuf[OutCnt] := Data; Inc(OutCnt);
      end;
    end;
  begin
    OutCnt := 0; InCnt := 0; Last := InBuf[0]; RunLen := 1;
    while InCnt < 79 do begin
      Inc(InCnt); Temp := InBuf[InCnt];
      if Temp = Last then begin
        Inc(RunLen);
        if RunLen = 63 then begin
          EncPut(Last, RunLen);
          RunLen := 0;
        end;
      end else begin
        if RunLen <> 0 then
          EncPut(Last, RunLen);
        Last := Temp;
        RunLen := 1;
      end;
    end;
    if RunLen <> 0 then
      EncPut(Last, RunLen);
    Encode := OutCnt;
  end;

  type
    PcxHeader	= record
      ID	: Byte;
      Version	: Byte;
      Encoding	: Boolean;
      Bits	: Byte;			(* Bits per pixel *)
      Window	: array[0..3] of Word;
      HDPI	: Word;
      VDPI	: Word;
      ColMap	: array[1..48] of Byte;
      Reserved	: Byte;
      NPlanes	: Byte;
      LineLen	: Word;
      Palette	: Word;
      HSize	: Word;
      VSize	: Word;
      Filler	: array[1..54] of Byte;
    end;
  const
    Header	: PcxHeader = (
      ID	: $0A;
      Version	: 5;
      Encoding	: True;
      Bits	: 1;
      Window	: (0, 0, 639, 199);
      HDPI	: 640;
      VDPI	: 200;
      ColMap	: (0,0,0,$FF,$FF,$FF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
      Reserved	: 0;
      NPlanes	: 1;
      LineLen	: 640 div 8;
      Palette	: 1;
      HSize	: 0;
      VSize	: 0;
      Filler	: (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)
    );
  var
    InBuf	: record
      X1,Y1,X2,Y2 : Word;
      Img	: array[0..79] of Byte;
    end;
    OutBuf	: array[0..159] of Byte;

  (* t@Co̓[` *)
  procedure CutScreen;
    var
      CGA_VRAM	: array[0..15999] of Byte absolute $B800:0;
      F		: file;
      Line	: Word;
      Len	: Word;
      Result	: Word;
      Success	: Boolean;		(* ݐtO *)
      CntStr	: string[4];
    const
      Count	: Word = 0;
  begin
    FileMode := 0;			(* Read only open *)
    if Count > 999 then Count := 0;
    repeat
      Str(Count, CntStr);
      if Count < 10 then CntStr := '0' + CntStr;
      if Count < 100 then CntStr := '0' + CntStr;
      if Count < 1000 then CntStr := '0' + CntStr;
      Assign(F, OutDir + 'SCRN' + CntStr + '.PCX');
      Reset(F, 1);
      Success := (IOResult <> 0);
      if not Success then begin
        Close(F);
        Inc(Count);
      end;
    until Success or (Count > 9999);

    if Success then begin
      Rewrite(F, 1);
      Success := (IOResult = 0);
      if Success then begin
        BlockWrite(F, Header, SizeOf(Header), Result);
        Success := Result = SizeOf(Header);
	if Success then begin
	  cli;
	  Line := 0;
	  repeat
	    GetImage(0, Line, 639, Line, InBuf);
	    Len := Encode(InBuf.Img, OutBuf);
	    BlockWrite(F, OutBuf, Len, Result);
	    Success := Result = Len;
	    Inc(Line);
	  until (Line >= 200) or not Success;
	  Close(F);
	  if Success then
	    Inc(Count)
	  else
	    Erase(F);
	end;
      end;
    end;

    (* ʂr[vŒm点i:s, s:s[j *)
    BeepOn;
    if Success then Delay(10) else Delay(100);
    BeepOff;
  end;(* CutScreen *)



  function KeySense : Word; assembler;
  asm
	mov	ah, 01h
	int	16h
	jnz	@@exit
	mov	ax, -1
  @@exit:
  end;

  function KeyRead : Word; assembler;
  asm
	xor	ah, ah
	int	16h
  end;

  (* L[{[h荞݃[` *)
  procedure New09; interrupt;
    const
      Int23Ofs	: Word = Ofs(Int23);
      Int24Ofs	: Word = Ofs(Int24);
    var
      ShiftTable: Byte absolute $0040:$0017;
  begin
    pushf; Old09;			(* 荞݂R[ *)
    sti;
    (* zbgL[̉ *)
    if not Cutting
      and (ShiftTable and ShiftCode = ShiftCode)
      and (Hi(KeySense) = KeyCode) then begin
      KeyCode := Hi(KeyRead);		(* L[Hׂ *)
      Cutting := True;
      asm
	(* [JX^bNݒ *)
	cli
	mov	[PtrRec(SaveStack).POfs], sp
	mov	[PtrRec(SaveStack).PSeg], ss
	mov	ss, [PtrRec(LocalStack).PSeg]
	mov	sp, [PtrRec(LocalStack).POfs]

	(* DOSXbv *)
	mov	cx, [SwapInfo.MinSize]
	les	di, [IndosAddr]
	cmp	BYTE [es:di], 0
	je	@@1
	mov	cx, [SwapInfo.MaxSize]
      @@1:
	mov	[SwapInfo.LastSize], cx
	push	ds
	pop	es
	mov	di, OFFSET SwapBuf
	push	ds
	lds	si, [SwapInfo.Addr]
	cld
	rep movsb
	pop	ds
      end;

      SetCBreak(False);			(* break=off *)

      asm
	(* set PSP *)
	mov	bx, [PrefixSeg]
	mov	ah, 50h
	int	21h
	(* set DTA *)
	push	ds
	mov	ds, [PrefixSeg]
	mov	dx, 80h
	mov	ah, 1Ah
	int	21h
	pop	ds

	(* xN^tbN *)
	cli
	xor	ax, ax
	mov	es, ax
	mov	ax, [es:(23h*4)]
	mov	[PtrRec(Old23).POfs], ax
	mov	ax, [es:(23h*4+2)]
	mov	[PtrRec(Old23).PSeg], ax
	mov	ax, Int23Ofs
	mov	[es:(23h*4)], ax
	mov	[es:(23h*4+2)], cs
	mov	ax, [es:(24h*4)]
	mov	[PtrRec(Old24).POfs], ax
	mov	ax, [es:(24h*4+2)]
	mov	[PtrRec(Old24).PSeg], ax
	mov	ax, Int24Ofs
	mov	[es:(24h*4)], ax
	mov	[es:(24h*4+2)], cs
      end;

      CutScreen;

      asm
	cli
	xor	ax, ax
	mov	es, ax
	mov	ax, [PtrRec(Old23).POfs]
	mov	[es:(23h*4)], ax
	mov	ax, [PtrRec(Old23).PSeg]
	mov	[es:(23h*4+2)], ax
	mov	ax, [PtrRec(Old24).POfs]
	mov	[es:(24h*4)], ax
	mov	ax, [PtrRec(Old24).PSeg]
	mov	[es:(24h*4+2)], ax

	mov	si, OFFSET SwapBuf
	les	di, [SwapInfo.Addr]
	mov	cx, [SwapInfo.LastSize]
	cld
	rep movsb

      (* [JX^bN *)
	mov	ss, [PtrRec(SaveStack).PSeg]
	mov	sp, [PtrRec(SaveStack).POfs]
      end;
      Cutting := False;
    end;
  end;(* New09 *)


  (* d풓C\̌ *)
  procedure CheckTsr;
    type
      Char10	= array[1..10] of Char;
  begin
    (* 荞݃xN^擾 *)
    GetIntVec($09, @Old09);

    (* xN^풓wĂ邩H *)
    Stayed := (Char10(@Old09^) = Char10(@New09^))
		and (PtrRec(@Old09).POfs = Ofs(New09));

  end;(* CheckTsr *)


  (* 풓 *)
  procedure Stay;
  begin
    IndosAddr := GetIndosAddr;
    asm
	push	ds
	mov	ax, 5D06h
	int	21h
	mov	ax, ds
	pop	ds
	mov	[PtrRec(SwapInfo.Addr).PSeg], ax
	mov	[PtrRec(SwapInfo.Addr).POfs], si
	mov	[SwapInfo.MinSize], dx
	mov	[SwapInfo.MaxSize], cx
    end;
    if SwapInfo.MaxSize > SizeOf(SwapBuf) then begin
      Writeln('Swap area too large');
      Halt(1);
    end;

    (* p[^̈ɃvO(vmap̂) *)
    ComStr(Ptr(PrefixSeg, $80)^) := 'CAPLX.EXE' + #$0D;
    Dec(Mem[PrefixSeg : $80]);

    (* ϐ̈ *)
    MemFree(MemW[PrefixSeg : $2C]);
    MemW[PrefixSeg : $2C] := 0;

    (* 荞݃xN^tbN *)
    SetIntVec($09, @New09);

    (* SYSTEMjbgtbNĂ銄荞݂߂ *)
    SetIntVec($00, SaveInt00);
    SetIntVec($3F, SaveInt3F);

    (* 풓I *)
    Keep(0);
  end;(* Stay *)


  (*  *)
  procedure Remove;
    var
      TSRDSeg	: Word;			(* TSR̃f[^ZOg *)
      TSRPSP	: Word;			(* TSRPSPZOg *)
  begin
    (* 풓̃AhXZo *)
    TSRDSeg := PtrRec(@Old09).PSeg + (DSeg - CSeg);
    TSRPSP  := PtrRec(@Old09).PSeg - (CSeg - PrefixSeg);

    (* 荞݃xN^𕜋A *)
    SetIntVec($09, Pointer(MemL[TSRDSeg : Ofs(@Old09)]));

    (* 풓̃ *)
    MemFree(TSRPSP);
  end;(* Remove *)


begin
  (* X^bNgbvLBŃ[JX^bNɎg *)
  LocalStack := Ptr(SSeg, SPtr);

  Writeln('CAPLX v1.03 (C)1994 H.Sekiya');

  CheckParam;				(* p[^̌ *)
  CheckTsr;				(* 풓mF *)
  if Stayed then begin
    Remove;				(*  *)
    Writeln('Removed.');
  end else begin
    InitGraph;
    Writeln('Installed.');
    Stay;				(* 풓 *)
  end;
end.
