program dbcheck;

{ improvements:
  * if a lookup table exists, start there, and warn if there are extra un-accounted for bytes
}

uses Dos;

type
  RecType = record
    Pos,Length,Index :word;
    HiPos,RType :byte;
    end;
  FieldType = record
    Name      :String[21];
    Index,Offset,Reserved    :word;
    FType,Rel :byte;
    end;
  NoteRecordType = record
    Size,Pos     :word;
    HiPos,Status :byte;
    end;
  DataRecordType = record
    Size,Pos     :word;
    Links,HiPos  :byte;
    end;
  BufferType =array[0..9999] of byte;
  HeaderType = record
    RType,Status: byte;
    Size,Index: word;
    end;
  DateLinkPtr = ^DateLinkType;
  DateLinkType = record
    Year,Month,Day :byte;
    FirstRec       :word;
    Next           :DateLinkPtr;
    end;

const  { for decoding password-encrypted files }
  PW :array[0..16] of byte=(
       $ff,$13,$72,$4f,$7f,$22,$40,$37,$7e,$18,$65,$2d,$55,$47,$77,$68,$00);
  CodeA:array[0..126] of byte=(
       $e8,$a3,$fe,$1b,$02,$ce,$40,$35,$a4,$7b,$f2,$a1,$70,$d5,$40,$65,
       $09,$42,$23,$ff,$aa,$ed,$f0,$2a,$a2,$a9,$38,$d7,$e5,$95,$ea,$8c,
       $46,$dd,$90,$94,$5e,$6b,$5d,$a4,$7b,$8c,$ea,$24,$a1,$7c,$af,$30,
       $62,$2a,$a5,$8e,$ad,$67,$de,$3f,$b3,$e3,$53,$de,$19,$42,$f8,$40,
       $96,$e8,$15,$75,$43,$08,$2f,$e9,$b1,$4f,$1d,$d5,$a9,$16,$2c,$fb,
       $9f,$0f,$b2,$cc,$e4,$27,$bc,$1b,$49,$a6,$90,$79,$03,$9a,$a6,$1a,
       $70,$89,$9d,$35,$81,$ad,$80,$b0,$79,$45,$21,$5f,$94,$1c,$d1,$3f,
       $df,$a8,$a3,$40,$31,$34,$66,$84,$85,$28,$f1,$8d,$82,$04,$a4);
  CodeB :array[0..16] of byte=(
       $09,$0b,$09,$0f,$09,$0b,$09,$77,$08,$08,$08,$08,$08,$08,$08,$08,$78);

var
  inf              :file;
  i,j,ErrorLevel,
  TotalRecords,ExpectedRecords,GarbageRecords,NumDeleted,
  RecordCount      :integer;
  TypeCount        :array[0..31] of integer;
  Encrypted,
  ReadError,TypeError,LookupError,NoteError,ThisFileError,DataError,
  ViewPointError,UnknownTypeError,LinkError,NoteLinkError,
  FileEnd          :boolean;
  buffer           :^BufferType;
  buffer2          :array[0..999] of byte;
  header,header2   :HeaderType;
  TotalSize,bytecount  :longint;
  FieldList        :array[0..98] of FieldType;
  FieldCount       :byte;  { [0..50] }
  RecurList        :array[0..1999] of word;
  FirstLink, { record number of first data record in recurring list }
  NoteOffset       :word;
  WDBFile,PrintNotes,
  Details,ADBFile  :boolean;
  ThisDateLink,FirstDateLink,NextDateLink    :DateLinkPtr;
  DateLinkCount    :integer;
  { keeping track of note records }
  NoteRecord       :array[0..2999] of NoteRecordType;
  NotesCount       :integer;
  DataRecord       :array[0..2999] of DataRecordType;
  DataCount        :integer;
  { list of non-data, non-note records }
  RecList          :array[0..499] of RecType;
  RecCount         :integer;
  st               :String;
  { used in looping through command line parameters: }
  Params,FileCount,ErrorCount :integer;
  DirInfo          :SearchRec;
  FileFound        :boolean;
  ResultsList,
  FileName         :String;
  DStr: DirStr;
  NStr: NameStr;
  EStr: ExtStr;

procedure Decrypt(var buffer:array of byte; count:integer);
  { decrypts data in variable buffer }
  var
    i                :integer;
    PassIndex,PassIndex17,TempIndex,
    PassIndex127     :word;
  begin
  PassIndex:=0; PassIndex17:=0; PassIndex127:=0;
  for i:=0 to count-1 do
    begin
    buffer[i]:=buffer[i] xor CodeA[PassIndex127] xor PW[PassIndex17] xor CodeB[PassIndex17];
    if PassIndex>126 then
      begin
      TempIndex:=PassIndex-127;
      while TempIndex<32000 do { <0, except it's unsigned }
        begin
        buffer[i]:=buffer[i] xor CodeB[TempIndex mod 17];
        TempIndex:=TempIndex-127;
        end;
      end;
    PassIndex:=PassIndex+1;
    PassIndex17:=PassIndex17+1; while PassIndex17>16 do PassIndex17:=PassIndex17-17;
    PassIndex127:=PassIndex127+1; while PassIndex127>126 do PassIndex127:=PassIndex127-127;
    end;
  end;

function MakeWord(n:word):word;
  { takes an index into buffer^, and makes a word out of the next two bytes }
  begin
  MakeWord:=buffer^[n] + (buffer^[n+1] shl 8);
  end;

function GetDescription(n:word):String;
  var
    oldfp :longint;
    add :word;
    Field :byte;
  begin
  {$I-}
  oldfp:=FilePos(inf);
  if (n>=3000) then
    begin
    GetDescription:='<bad record number>';
    Exit;
    end;
  if (DataRecord[n].Pos=0) and (DataRecord[n].HiPos=0) then
    begin
    GetDescription:='<not found>';
    Exit;
    end;
  { find a string field }
  Field:=0; while (Field<FieldCount-1) and (FieldList[Field].Ftype<>2) do Field:=Field+1;
  if FieldList[Field].Ftype<>2 then
    begin
    GetDescription:='<no string field>';
    Exit;
    end;
  Seek(inf,DataRecord[n].Pos+(longint(DataRecord[n].HiPos) shl 16));
  BlockRead(inf,header2,6);
  Header2.Size:=Header2.Size-6;
  if Header2.Size>1006 then Header2.Size:=1000;
  BlockRead(inf,buffer2,Header2.Size);
  if IOResult<>0 then;
  if Encrypted then Decrypt(buffer2,Header2.Size);
  if (FieldList[Field].Rel and $20)>0 then add:=buffer2[FieldList[Field].offset]+(buffer2[FieldList[Field].offset+1] shl 8)
  else add:=FieldList[Field].offset;
  st:='';
  while (add<header.Size) and (buffer^[add]<>0) do
    begin
    st:=st+Chr(buffer^[add]);
    add:=add+1;
    end;
  GetDescription:=st;
  Seek(inf,oldfp);
  end;

function GetNextLink(n:word):word;
  var
    oldfp :longint;
  begin
  {$I-}
  oldfp:=FilePos(inf);
  if (DataRecord[n].Pos=0) and (DataRecord[n].HiPos=0) then begin GetNextLink:=65535; Exit; end;
  Seek(inf,6+longint(DataRecord[n].Pos)+(longint(DataRecord[n].HiPos) shl 16));
  BlockRead(inf,buffer2,15);
  if IOResult<>0 then;
  if Encrypted then Decrypt(buffer2,15);
  GetNextLink:=buffer2[12]+(buffer2[13] shl 8);
  Seek(inf,oldfp);
  end;

procedure CompareLookup(len:integer);
  var
    i,j,li   :integer;
    HiPos,
    ThisType :byte;
    size,pos :word;
    found,deleted    :boolean;
    TypeFirst  :array[0..31] of word;
  begin
  { lookup table isn't encrypted }
  { first get the TypeFirst table }
  {$I-}
  Seek(inf,FilePos(inf)+len);
  BlockRead(inf,TypeFirst,64);
  Seek(inf,FilePos(inf)-64-len);
  if IOResult<>0 then;
  ThisType:=0;
  i:=0;
  if Details then writeln('Comparing lookup table against actual record locations...');
  while i < len-1 do
    begin
    while (TypeFirst[ThisType+1]<=(i div 8)) and (ThisType<30) do ThisType:=ThisType+1;
    deleted:=false;

    BlockRead(inf,buffer^,8);  { get this lookup entry }
    if IOResult<>0 then;
    size:=MakeWord(0);
    if buffer^[4]>127 then begin NumDeleted:=NumDeleted+1; deleted:=true; end;
    pos:=MakeWord(5);
    HiPos:=(buffer^[7]);
    found:=true;
    case ThisType of
      11:
      begin
      j:=(i div 8) - TypeFirst[11];
      if (DataRecord[j].Size<>size) or (DataRecord[j].Pos<>Pos) or (DataRecord[j].HiPos<>HiPos) then found:=false;
      end;
      9:
      begin
      j:=(i div 8) - TypeFirst[9];
      if (NoteRecord[j].Size<>size) or (NoteRecord[j].Pos<>Pos) or (NoteRecord[j].HiPos<>HiPos) then found:=false;
      end;
    else
      begin
      found:=false;
      for li:=0 to RecCount-1 do
        if (pos=RecList[li].Pos) and (HiPos=RecList[li].HiPos) then begin found:=true; break; end;
      if not LookupError and not deleted and (not found or found and (size<>RecList[li].Length)) then
        begin
        LookupError:=true;
        if not Details then writeln;
        writeln('LookupTable Error: no record at address ',pos);
        end;
      end;
      end;
    i:=i+8;
    end;
  end;

procedure CompareViewpoint(len:integer);
  var
    i,li,bcount :integer;
    num:word;
  begin
  { does viewpoint definition number num exist? }
  if not ADBFile then
    begin
    li:=0;
    for i:=0 to RecCount-1 do
      if (RecList[i].Rtype=7) and (RecList[i].Index=header.Index) then li:=1;
    if li=0 then    { not found }
      begin
      ViewPointError:=true;
      if not Details then writeln;
      writeln('Error: Viewpoint table ',header.Index,' has no corresponding viewpoint definition record.');
      end;
    end;
  if Details then writeln('Comparing viewpoint table ',header.Index,' against existing record numbers...');
  { WDB files have 490 records that show as deleted }
  if WDBFile and (DataCount<490) then DataCount:=490;
  if len>10000 then bcount:=10000 else bcount:=len;
  {$I-}
  BlockRead(inf,buffer^,bcount);
  if Encrypted then Decrypt(buffer^,bcount);
  if IOResult<>0 then;
  i:=0;
  if not (bcount=2) and (buffer^[0]=$ff) and (buffer^[1]=$ff) then while i < bcount-1 do
    begin
    num:=MakeWord(i);
    if (num>DataCount+50) and ((not ViewPointError) or Details) then
      begin
      ViewPointError:=true;
      if not Details then writeln;
      writeln('ViewPoint Table Error: Record number ',header.Index,' out of proper range.');
      end;
    i:=i+2;
    end;
  if len>10000 then Seek(inf,FilePos(inf)+len-10000);
  if IOResult<>0 then;
  end;

function pad(n:integer):String;
  var s :String;
  begin
  Str(n,s);
  if n<10 then s:='0'+s;
  pad:=s;
  end;

procedure CompareLinks(len:word);
  var i,num:word;
  procedure FollowLink;
    begin
    if not LinkError and (num<>65535) and ((num>=3000) or (DataRecord[num].Size=0)) then
      begin
      LinkError:=true;
      if not Details then writeln;
      writeln('Link Error - record ',num,' doesn''t exist');
      end;
    { make the record linked to look as if it had a previous record linking it }
    if num<3000 then DataRecord[num].Links:=DataRecord[num].Links+10;
    { now go through the list of all the links }
    while (num<3000) and (DataRecord[num].Size>0) do
      begin
      num:=GetNextLink(num);
      if Details then
        begin
        if (buffer2[14] and 32)=32 then write('E');
        if (buffer2[14] and 128)=128 then write('A');
        if (buffer2[14] and 18)=16 then write('T');
        if (buffer2[14] and 18)=18 then write('CT');
        if num<>65535 then write(',',num);
        end;
      if (num<>65535) and ((num>3000) or (DataRecord[num].Size=0)) then
        begin
        LinkError:=true;
        if not Details then writeln;
        writeln('Link error - record ',num,' doesn''t exist');
        end;
      end;
    if Details then writeln;
    end;

  begin
  {$I-}
  if ((header.Status and 1)=0) then
    begin
    BlockRead(inf,buffer^,len);
    if IOResult<>0 then;
    if Encrypted then Decrypt(buffer^,len);
    if header.Index=1 then { link start locs by date }
      begin
      i:=0;
      if Details then
        begin
        writeln('----------------------------------------------');
        writeln('Link list location: ',FilePos(inf)-6-len,'  length: ',len+6);
        end;
      while (i<len) and not EOF(inf) do
        begin
        { does this record exist? }
        num:=MakeWord(i+3);
        if Details then write(pad(buffer^[i+1]+1),'/',pad(buffer^[i+2]+1),'/',buffer^[i+0]+1900,': record ',num);
        if (buffer^[i+1]>11) or (buffer^[i+2]>30) then
          begin DataError:=true;
          if Details then writeln('Data error - invalid date')
          else write(#13,#10,'Invalid date in record "',GetDescription(num),'"');
          end;
        FollowLink;
        i:=i+5;
        end;
      end
    else
      begin
      if header.Index<>0 then begin writeln('Type 14 Table Error'); LinkError:=true; Exit; end;
      if Details then
        begin
        writeln('----------------------------------------------');
        writeln('Type 14 table location: ',FilePos(inf)-6,'  length: ',len+6);
        end;
      { is the recurring list an unbroken chain? }
      FirstLink:=MakeWord(17);
      if Details then write('links: ',FirstLink);
      num:=FirstLink;
      FollowLink;
      if Details then writeln;
      { are there the right number of entries in the DateLink list? }
      num:=MakeWord(19);
      if DateLinkCount-1<>num then
        begin
        if Details or not LinkError then writeln('Error - expected ',num,' date links, found ',DateLinkCount-1);
        LinkError:=true;
        end;
      end;
    end
  else Seek(inf,FilePos(inf)+len);
  end;

procedure GetFieldDef(len:word);
  var c:word; i:longint;
  begin
  {$I-}
  i:=FilePos(inf);
  if FieldCount<99 then with FieldList[FieldCount] do
    begin
    BlockRead(inf,buffer^,len);
    if IOResult<>0 then;
    if Encrypted then Decrypt(buffer^,len);
    FType:=buffer^[0];
    Offset:=MakeWord(2);
    if FType=10 then NoteOffset:=Offset;
    Rel:=buffer^[4];
    Reserved:=MakeWord(5);
    c:=7;  { count of bytes read }
    repeat
      if buffer^[c]<>0 then Name:=Name+Chr(buffer^[c]);
      c:=c+1;
    until (buffer^[c]=0) or (Length(Name)>20);
    if Details then
      begin
      write('Field ',header.Index,': ',Name,' = ');
      case FType of
        0 :write('check box (8-bit)');
        1 :write('check box (16-bit)');
        2 :write('string');
        3 :write('phone');
        4 :write('number');
        5 :write('currency');
        6 :write('category');
        7 :write('time');
        8 :write('date');
        9 :write('radio');
        10 :write('note');
        11 :write('group');
        12 :write('static');
        13 :write('multi-line string');
        14 :write('list');
        15 :write('combo');
        16 :write('user-defined');
        18 :write('repeat type');
        19 :write('start date');
        20 :write('due date number');
        22 :write('priority');
        23 :write('consecutive days');
        24 :write('lead time number');
        else write('unknown (',FType,')');
        end;
        write('  offset: ',Offset);
        if FType in [0,1,6,9] then writeln('  res: ',Reserved) else writeln;
      end;
    FieldCount:=FieldCount+1;
    end
  else
    Seek(inf,FilePos(inf)+len);
    if IOResult<>0 then;
  end;

procedure ReadNote(len:integer);
  var
    i,j,bcount   :integer;
  begin
  if Details then
    begin
    writeln('----------------------------------------------');
    writeln('Note ',header.Index,' found at location ',FilePos(inf)-6,', length=',len+6);
    end;
  { bcount is number of bytes to read }
  if len>10000 then bcount:=10000 else bcount:=len;
  {$I-}
  BlockRead(inf,buffer^,bcount);
  if Encrypted then Decrypt(buffer^,bcount);
  if IOResult<>0 then;
  if ((header.Status and 1)=0) then NoteRecord[header.Index].Status:=NoteRecord[header.Index].Status+10;
  for i:=0 to bcount-1 do
    begin
    if (buffer^[i]=0) or (buffer^[i]=255) then if bcount>1 then
      begin
      if not NoteError or Details then writeln(#13,#10,'Error: Note field has illegal character (',buffer^[i],')');
      NoteError:=true;
      end;
    if PrintNotes then write(Chr(buffer^[i]));
    end;
  { if the note was longer than 10k, position file pointer after }
  if PrintNotes then writeln;
  if len>10000 then Seek(inf,FilePos(inf)+len-10000);
  if IOResult<>0 then;
  end;

procedure FindInRecurringList(n:word);
  var
    i    :integer;
    fp   :longint;
    found:boolean;
  begin
  found:=false;
  { is the RecurList populated yet? }
  if RecurList[0]=65535 then
    begin
    { get Type14,0 table }
    for i:=0 to RecCount-1 do if (RecList[i].RType=14) and (RecList[i].Index=0) then break;
    if (RecList[i].RType=14) then
      begin
      fp:=FilePos(inf);
      Seek(inf,RecList[i].Pos+(longint(RecList[i].HiPos) shl 16)+6);
      BlockRead(inf,buffer^,19);
      if Encrypted then Decrypt(buffer^,19);
      i:=0; RecurList[i]:=MakeWord(17);
      while (RecurList[i]<10000) and (DataRecord[RecurList[i]].Size>6) and (i<2000) do
        begin
        Seek(inf,DataRecord[RecurList[i]].Pos+(longint(DataRecord[RecurList[i]].HiPos) shl 16)+6);
        BlockRead(inf,buffer^,14);
        if Encrypted then Decrypt(buffer^,14);
        i:=i+1; RecurList[i]:=MakeWord(12);
        end;
      Seek(inf,fp);
      end;
    end;
  { look through the RecurList for this record }
  i:=0; while (i<2000) and (RecurList[i]<>65535) do
    begin
    if RecurList[i]=n then begin found:=true; break; end;
    i:=i+1;
    end;
  if not found then
    begin
    if Details or not LinkError then writeln(#13,#10,'Error - data record ',n,' not found in recurring list');
    LinkError:=true;
    end
  else if Details then writeln('Found in recurring list');
  end;

procedure FindInDateList(yr,mn,da:byte;n:word);
  var
    Next :word;
    i    :integer;
    fp   :longint;
    found:boolean;
  begin
  found:=false;
  ThisDateLink:=FirstDateLink;
  while not found do
    begin
    if (ThisDateLink^.Year=yr) and (ThisDateLink^.Month=mn) and (ThisDateLink^.Day=da) then break;
    if ThisDateLink^.Next=nil then break
    else ThisDateLink:=ThisDateLink^.Next;
    end;
  if (ThisDateLink^.Year=yr) and (ThisDateLink^.Month=mn) and (ThisDateLink^.Day=da) then
    begin
    fp:=FilePos(inf);
    Next:=ThisDateLink^.FirstRec;
    while (Next<>n) and (Next<10000) and (DataRecord[Next].Size>6) do
      begin
      Seek(inf,DataRecord[Next].Pos+(longint(DataRecord[Next].HiPos) shl 16)+6);
      BlockRead(inf,buffer^,14);
      if Encrypted then Decrypt(buffer^,14);
      Next:=MakeWord(12);
      end;
    if Next=n then found:=true;
    Seek(inf,fp);
    end;
  if not found then
    begin
    if Details or not LinkError then writeln(#13,#10,'Error - data record ',n,' not found in date link list');
    LinkError:=true;
    end
  else if Details then writeln('Found in date link list');
  end;

procedure ReadData(len:integer);
  var
    st      :String;
    i,j,k,f :integer;
    num,add :word;
    DeletedRecord,
    Appt    :boolean;
  begin
  i:=6;
  if Details then
    begin
    writeln('----------------------------------------------');
    writeln('location: ',FilePos(inf)-6,'  length: ',len+6,'  record number: ',header.Index);
    end;
  {$I-}
  if FilePos(inf)-6<>(DataRecord[header.Index].Pos+(longint(DataRecord[header.Index].HiPos) shl 16)) then DeletedRecord:=true
  else DeletedRecord:=false;
  if Details and ((header.Status and 1)=1) then writeln('This is a garbage record which will be deleted');
  BlockRead(inf,buffer^,len);
  if IOResult<>0 then;
  if Encrypted then Decrypt(buffer^,len);

  { if it's an ADB file, is this an appointment or todo? }
  if ADBFile then
    begin
    if (buffer^[14] and 16)>0 then Appt:=false else Appt:=true;
    if Details then if Appt then writeln('Appointment/Event') else writeln('ToDo');
    end;

  { is the reported size correct? }
  if ADBFile and (MakeWord(0)<>header.Size-6) then
    begin
    if not Details then writeln;
    writeln('Error: data record size doesn''t agree with its header');
    DataError:=true;
    end;

  { look at the data for each field }
  for i:=0 to FieldCount do
    begin
    { find location of this field's data - is it relative or abs? }
    if (FieldList[i].Rel and $20) > 0 then add:=MakeWord(FieldList[i].Offset)
    else add:=FieldList[i].Offset;
    if not ADBFile or (not Appt and (i in [0,1,8..13,16..22,26])) or (Appt and (i in [0..7,12..22])) then
      begin
      if Details and not (FieldList[i].FType in [0,1,9,12,14,18]) then write(FieldList[i].Name,': ');
      case FieldList[i].FType of
        2,3,4,5,6,13,15 : if Details then
           begin
           st:='';
           repeat
             if buffer^[add]<>0 then st:=st+Chr(buffer^[add]) else Break;
             add:=add+1;
           until (add>=10000) or (buffer^[add]=0);
           writeln(st);
           end;
        8,19 :  { date }
            begin
            if (buffer^[add]<>$ff) or (buffer^[add+1]<>$ff) then
              begin
              { is it a pointer to the last completed recurring ToDo? }
              if ADBFile and (i=9) and (buffer^[26]>1) and ((buffer^[14] and 2)=0) then
                begin
                num:=MakeWord(add);
                if Details then writeln('See record number ',num);
                if DataRecord[num].Size=0 then
                  begin
                  if not Details then writeln;
                  writeln('Data error: record number ',num,' doesn''t exist');
                  DataError:=true;
                  end;
                end
              else
                begin
                if Details then writeln(buffer^[add+1]+1,'/',pad(buffer^[add+2]+1),'/',buffer^[add]+1900);
                if (buffer^[add+1]>11) or (buffer^[add+2]>30) then
                  begin DataError:=true;
                  if Details then writeln('Data error - invalid date')
                  else write(#13,#10,'Invalid date in record "',GetDescription(header.Index),'"');
                  end;
                end;
              end
            else if Details then writeln('none');
            end;
        7 : begin { time field }
            num:=MakeWord(add);
            if Details then if (num<>65535) and (num<>32768) then writeln(num div 60,':',pad(num mod 60)) else writeln('none');
            if (num<>65535) and (num<>32768) and (num>1439) then
              begin
              DataError:=true;
              if Details then writeln('Data error - invalid time')
              else writeln(#13,#10,'Invalid time in record "',GetDescription(header.Index),'"');
              end;
            end;
        10 :begin  { note }
            num:=MakeWord(add);
            if num<>65535 then  { not -1 }
              begin
              if Details then writeln('number ',num);
              if ((header.Status and 1)=0) then NoteRecord[num].Status:=NoteRecord[num].Status+1;
              end
            else if Details then writeln('none');
            end;
        9 : { radio }
            if Details then
              begin
              k:=0;
              if ADBFile then if ( (buffer^[add] and (1 shl FieldList[i].Reserved)) <> 0) then k:=1;
              if not ADBFile then if buffer^[add] = FieldList[i].Reserved then k:=1;
              if k=1 then writeln(FieldList[i].name,' = X');
              end;
        0,1 : if Details then
                begin { check box }
                num:=buffer^[add]; if FieldList[i].FType=1 then num:=num+(buffer^[add+1] shl 8);
                if ((num and FieldList[i].Reserved)<>0) then writeln(FieldList[i].Name,' = X');
                end;
        22 : { priority }
            if Details then
              begin
              write(Chr(buffer^[add]));
              if buffer^[add+1]>$20 then writeln(Chr(buffer^[add+1])) else writeln;
              end;
        20,23,24 :     { integer }
             if Details then writeln(MakeWord(add));
        11 : if Details then writeln;  { a group field is an identifier of the next few }
        12,14,18 : { do nothing };
        else if Details then writeln('not implemented')
        end;
      end;
    end;
    { print recurrence info for ADB files }
    if ADBFile and (MakeWord(6)<header.Size-6) then
      begin
      { add is the address of the beginning of the recur info block }
      add:=MakeWord(6);
      if Details then write('repeat every ',buffer^[add]);
      if Details and (buffer^[26]>=16) then
        begin
        num:=MakeWord(add+3);
        write(', months:');
        if (num and $1)>0 then write(' Jan');
        if (num and $2)>0 then write(' Feb');
        if (num and $4)>0 then write(' Mar');
        if (num and $8)>0 then write(' Apr');
        if (num and $10)>0 then write(' May');
        if (num and $20)>0 then write(' Jun');
        if (num and $40)>0 then write(' Jul');
        if (num and $80)>0 then write(' Aug');
        if (num and $100)>0 then write(' Sep');
        if (num and $200)>0 then write(' Oct');
        if (num and $400)>0 then write(' Nov');
        if (num and $800)>0 then write(' Dec');
        end;
      num:=MakeWord(add+1);
      if buffer^[26]<4 then begin if Details then writeln; end
      else if num<128 then
        begin
        if Details then writeln(', on day ',num);
        if num>31 then
          begin
          if Details then writeln(#13,#10,'Data error - invalid date',#13,#10)
          else write(#13,#10,'Invalid repeat day in record "',GetDescription(header.Index),'"');
          DataError:=true;
          end;
        end
      else if Details then
        begin
        write(', on days:');
        if (num and $100)>0 then write(' first');
        if (num and $200)>0 then write(' second');
        if (num and $400)>0 then write(' third');
        if (num and $800)>0 then write(' fourth');
        if (num and $1000)>0 then write(' last');
        if (num and $1)>0 then write(' mon');
        if (num and $2)>0 then write(' tue');
        if (num and $4)>0 then write(' wed');
        if (num and $8)>0 then write(' thu');
        if (num and $10)>0 then write(' fri');
        if (num and $20)>0 then write(' sat');
        if (num and $40)>0 then write(' sun');
        writeln;
        end;
      if Details then writeln('Beginning ',buffer^[add+6]+1,'/',pad(buffer^[add+7]+1),'/',buffer^[add+5]+1900,' until ',
              buffer^[add+9]+1,'/',pad(buffer^[add+10]+1),'/',buffer^[add+8]+1900);
      if (buffer^[add+6]>11) or (buffer^[add+7]>30) or (buffer^[add+9]>11) or (buffer^[add+10]>30) then
        begin DataError:=true;
        if Details then writeln('Data error - invalid date')
        else write(#13,#10,'Invalid date in record "',GetDescription(header.Index),'"');
        end;
      { is it a completed ToDo? look at recurrence index at the end }
      if (buffer^[14] and 18)=18 then
        begin
        i:=12;
        if Details then writeln('Exception index number: ',buffer^[add+11]);
        while i<17 do   { for i=12, 14, 16 }
          begin
          num:=MakeWord(add+i);
          if Details then case i of
            12: write('Previous recurrence exception: ');
            14: write('Next recurrence exception: ');
            16: write('Record number of main ToDo entry: ');
            end;
          if (num<>65535) or (i=16) then
            begin
            if Details then writeln(num);
            if (num>3000) or (DataRecord[num].Size=0) then
              begin
              if not Details then writeln;
              writeln('Link error - link to invalid record number');
              LinkError:=true;
              end;
            end
          else if Details then writeln('none');
          i:=i+2;
          end;
        end
      else  { it's something else with a recurrence table - get date list }
        begin
        if Details and (buffer^[add+11]>0) then write('Number of exception dates: ',buffer^[add+11],': ');
        for i:=1 to buffer^[add+11] do
          begin
          if Details then write(buffer^[add+9+4*i]+1,'/',pad(buffer^[add+10+4*i]+1),'/',buffer^[add+8+4*i]+1900);
          if Details then if buffer^[add+11+4*i]=0 then write('d; ') else write('; ');
          if (buffer^[add+9+4*i]>11) or (buffer^[add+10+4*i]>30) then
            begin DataError:=true;
            if Details then writeln('Data error - invalid date')
            else write(#13,#10,'Invalid date in record "',GetDescription(header.Index),'"');
            end;
          end;
        if Details then writeln;
        end;
      end;
    { print out linking info for ADB files }
    if ADBFile and not DeletedRecord then
      begin
      j:=10;
      while j<13 do  { do it for j=10 and j=12 }
        begin
        i:=MakeWord(j);
        if Details then
          begin
          if j=10 then write('Previous link: ') else write('Next link: ');
          if i<>-1 then writeln(i) else writeln('none');
          end;
        if j=10 then
          begin if (i>=0) and (i<3000) then DataRecord[i].Links:=DataRecord[i].Links+1; end
        else
          if (i>=0) and (i<3000) then DataRecord[i].Links:=DataRecord[i].Links+10;
        if (i>=0) and (DataRecord[i].size=0) then
          begin
          LinkError:=true;
          if Details then writeln('Link to non-existent data record ',i)
          else
            writeln(#13,#10,'Link error in record "',GetDescription(header.Index),'"');
          end;
        j:=j+2;
        end;
      end;
    { if it's an ADB file, check that the link is in the right place. }
    if ADBFile and not DeletedRecord then
      begin
      { is it recurring? }
      i:=0;
      if MakeWord(6)<header.Size-6 then i:=1;
      if (buffer^[14] and 18)=18 then i:=0; { completed ToDo }
      if (Buffer^[14] and 18)=16 then i:=1; { uncompleted ToDo }
      if ((buffer^[14] and 160)>0) and (MakeWord(20)>0) then i:=1;
      if i=1 then FindInRecurringList(header.Index)
      else
        begin
        if (buffer^[14] and 18)=18 then FindInDateList(buffer^[22],buffer^[23],buffer^[24],Header.Index)
        else FindInDateList(buffer^[15],buffer^[16],buffer^[17],header.Index);
        end;
      end;
  end;

procedure ReadRecord;
  var
    i,k   :integer;
  begin
  {$I-}
  BlockRead(inf,header,6);
  if IOResult<>0 then Exit;
  RecordCount:=RecordCount+1;
  if header.RType<=31 then
    begin
    TypeCount[header.RType]:=TypeCount[header.RType]+1;
    if header.Size<6 then header.Size:=6;
    case header.RType of
      0:  begin
          BlockRead(inf,buffer^,header.Size-6);
          if IOResult<>0 then;
          ADBFile:=false; WDBFile:=false;
          case Chr(buffer^[2]) of
            '2': begin ADBFile:=true; write('File type: Appointment'); end;
            'W': begin WDBFile:=true; write('File type: World Time'); end;
            'D': write('File type: Database');
            'N': write('File type: Notetaker');
            else
              begin
              writeln('File type: Unknown');
              UnknownTypeError:=true;
              end;
            end;
          { is the lookup table pointed to correctly? }
          if (buffer^[8]<>0) or (buffer^[9]<>0) or (buffer^[10]<>0) then
            begin
            for i:=0 to RecCount-1 do if RecList[i].RType=31 then k:=i;
            if (RecList[i].Pos<>MakeWord(8)) or (RecList[i].HiPos<>buffer^[10]) then
              begin
              writeln('Lookup table pointer is wrong');
              LookupError:=true;
              end;
            end;
          if Encrypted then writeln(' (encrypted)') else writeln;
          ExpectedRecords:=MakeWord(6);
          j:=14;
          end;
     {6:  GetFieldDef(header.Size-6); }
      31: CompareLookup(header.Size-6);
      10: CompareViewPoint(header.Size-6);
      9:  ReadNote(header.Size-6);
      14: CompareLinks(header.Size-6);
      11: ReadData(header.Size-6);
      else Seek(inf,FilePos(inf)+header.Size-6);
      end;
    if IOResult<>0 then;
    { eat the TypeFirst Table - 64 bytes at the end. }
    if (header.RType=31) and ((header.Status and 1)=0) then Seek(inf,FilePos(inf)+64);
    if IOResult<>0 then;
    if not Details and (RecordCount and 31 =31) then write('.');
    end
  else
    begin
    TypeError:=true;
    writeln;
    writeln('Error: undefined record type ',header.RType);
    end;
  end;

procedure SetErrorLevel(n:integer);
  begin
  if ErrorLevel<n then ErrorLevel:=n;
  ThisFileError:=true;
  end;

procedure PreviewFile;
  var
    posn  :longint;
    poslo :word;
    poshi :byte;
    done  :boolean;
    i,k   :integer;
  begin
  {$I-}
  done:=false;
  RecCount:=0; TotalRecords:=0; GarbageRecords:=0;
  ExpectedRecords:=0; NumDeleted:=0;
  FillChar(RecurList,SizeOf(RecurList),$ff);
  posn:=4;  { first record }
  if Details then writeln('Index of all records:');
  if Details then writeln('Type#  Index   Start   Length    Type Desc');
  while (RecCount<500) and not done do
    begin
    Seek(inf,posn);
    BlockRead(inf,header,6);
    if IOResult<>0 then;
    if header.Size=0 then header.Size:=6; { should never be, but prevent hanging on zero bytes }
    poslo:=(posn and $ffff);
    poshi:=(posn and $ff0000) shr 16;
    if header.RType<32 then TotalRecords:=TotalRecords+1;
    if (header.Status and 1)=0 then case header.RType of  { not garbage record }
      11:
      if header.Index<3000 then
        begin
        DataRecord[header.Index].Size:=header.Size;
        DataRecord[header.Index].Pos:=poslo;
        DataRecord[header.Index].HiPos:=poshi;
        if header.Index>DataCount then DataCount:=header.Index;
        end;
      9:
      if header.Index<3000 then
        begin
        NoteRecord[header.Index].Size:=header.Size;
        NoteRecord[header.Index].Pos:=poslo;
        NoteRecord[header.Index].HiPos:=poshi;
        if header.Index>NotesCount then NotesCount:=header.Index;
        end;
      else
        begin
        RecList[RecCount].Pos:=poslo;
        RecList[RecCount].HiPos:=poshi;
        RecList[RecCount].RType:=header.RType;
        RecList[RecCount].Length:=header.Size;
        RecList[RecCount].Index:=header.Index;
        if header.RType=1 then   { password record }
          begin
          Encrypted:=true;
          BlockRead(inf,PW,17);
          if IOResult<>0 then;
          for i:=0 to 16 do PW[i]:=PW[i] xor i xor CodeA[i] xor CodeB[i];
          end;
        if (header.RType=31) and (TotalSize-posn-header.Size<65) then done:=true;
        RecCount:=RecCount+1;
        end;
      end
    else GarbageRecords:=GarbageRecords+1;
    posn:=posn+header.Size;
    if Details then
      begin
      write(header.RType:3);
      if (header.Status and 1)=1 then
        write('x')
      else write(' ');
      write(header.Index:7,(posn-header.Size):9,header.Size:9,'    ');
      case header.RType of
         0: writeln('db header');
         1: writeln('password');
         4: writeln('card definition');
         5: writeln('category list');
         6: writeln('field definition');
         7: writeln('subset definition');
         9: writeln('note');
        10: writeln('subset table');
        11: writeln('data record');
        12: writeln('smart clip definition');
        13: writeln('mult card page definition');
        14: if header.Index=0 then writeln('ADB preferences') else writeln('ADB date links');
        31: writeln('lookup table');
        15: writeln('ADB smart clip definition');
        else writeln('unknown');
        end;
      end;
    if (TotalSize<=posn) then done:=true;
    end;
  if (RecCount=500) and not done then
    begin writeln('Error: file has too many records'); ReadError:=true; end;
  if (RecCount<500) and not done then begin writeln('Error: end of file reached before data end.'); ReadError:=true; end;

  { if there's a Type14,1 table, make a catalog of the date/record pairs }
  k:=-1;
  for i:=0 to RecCount-1 do if (RecList[i].RType=14) and (RecList[i].Index=1) then k:=i;
  if k>=0 then
    begin
    Seek(inf,RecList[k].Pos+(longint(RecList[k].HiPos) shl 16)+6);
    BlockRead(inf,buffer^,RecList[k].Length-6);
    if encrypted then Decrypt(buffer^,RecList[k].Length-6);
    i:=0;
    if MaxAvail<SizeOf(DateLinkType) then begin writeln('not enough memory'); Halt(3); end;
    New(FirstDateLink);
    DateLinkCount:=DateLinkCount+1;
    ThisDateLink:=FirstDateLink;
    while (i<RecList[k].Length-6) do
      begin
      ThisDateLink^.Year:=buffer^[i+0];
      ThisDateLink^.Month:=buffer^[i+1];
      ThisDateLink^.Day:=buffer^[i+2];
      ThisDateLink^.FirstRec:=MakeWord(i+3);
      if i+5<RecList[k].Length-6 then
        begin
        if MaxAvail<SizeOf(DateLinkType) then begin writeln('not enough memory'); Halt(3); end;
        New(NextDateLink);
        DateLinkCount:=DateLinkCount+1;
        ThisDateLink^.Next:=NextDateLink;
        ThisDateLink:=NextDateLink;
        end
      else ThisDateLink^.Next:=nil;
      i:=i+5;
      end;
    end;

  { first, read in all the field definitions, 'cause they're needed as soon
    as we get to a record. }
  for i:=0 to RecCount-1 do if RecList[i].RType=6 then
    begin
    Seek(inf,RecList[i].Pos+ (longint(RecList[i].HiPos) shl 16) +6);
    header.Index := RecList[i].Index;
    GetFieldDef(RecList[i].Length-6);
    end;

  end;



begin
if ParamCount=0 then
  begin
  writeln('DBCHECK HPLX data file checker version 1.73');
  writeln('usage: dbcheck [/d] filename1 [filename2 [filename3...]]');
  writeln('  /d = details (lots of data)');
  writeln('  filename = name of 100/200LX db file');
  writeln('  wildcards may be used for filenames.');
  Halt(1);
  end;
ErrorLevel:=0;
FileCount:=0; ErrorCount:=0; ResultsList:='';
Details:=false; PrintNotes:=false;
if MaxAvail<SizeOf(buffer^) then
  begin
  writeln('I need more memory to run (',SizeOf(buffer^)-MaxAvail,' bytes more).');
  Halt(3);
  end;
New(buffer);
for Params:=1 to ParamCount do
  begin
  st:=ParamStr(Params);
  if (st[1]='-') or (st[1]='/') then { it is a switch }
    begin
    if (Pos('d',st)>0) or (Pos('D',st)>0) then Details:=true;
    if (Pos('n',st)>0) or (Pos('N',st)>0) then PrintNotes:=true;
    end
  else
    begin
    FindFirst(ParamStr(Params), AnyFile, DirInfo);
    if DosError<>0 then writeln('File not found: ',ParamStr(Params));
    while DosError = 0 do
      begin
      FSplit(ParamStr(Params),DStr,NStr,EStr);
      FileName:=DStr+DirInfo.name;

      { initialize variables }
      FileFound:=true; ThisFileError:=false;
      FillChar(TypeCount,SizeOf(TypeCount),0);
      FillChar(FieldList,SizeOf(FieldList),0);
      FieldCount:=0;  NoteOffset:=0;
      UnknownTypeError:=false; LinkError:=false;
      TypeError:=false; ReadError:=false; LookupError:=false; NoteError:=false;
      FileEnd:=false; NoteLinkError:=false;
      RecordCount:=0; ViewPointError:=false;
      FillChar(NoteRecord,SizeOf(NoteRecord),0);
      FillChar(DataRecord,SizeOf(DataRecord),0);
      NotesCount:=0; DataCount:=0; DataError:=false; DateLinkCount:=0;
      Encrypted:=false;

      FileMode:=0; { read-only access }
      writeln(FileName,':');
      {$I-}
      Assign(inf,FileName);
      if IOResult<>0 then begin FileFound:=false; writeln('File not found: ',FileName); SetErrorLevel(1); end;
      ReSet(inf,1);
      if IOResult<>0 then begin FileFound:=false; writeln('Unable to read file ',FileName); SetErrorLevel(1); end;
      TotalSize:=FileSize(inf);

      { preview all the records in the file }
      PreviewFile;

      Seek(inf,4);
      while not EOF(inf) and (IOResult=0) do ReadRecord;

      Close(inf);

      { was each referenced note found ? }
      for i:=0 to NotesCount-1 do if (NoteRecord[i].Status <10) and (NoteRecord[i].Status >0) then
        begin
        NoteLinkError:=true;
        if Details then writeln('Note ',i,' was referenced ',NoteRecord[i].Status mod 10,' times but found ',
                                 NoteRecord[i].Status div 10,' times.');
        end;

      { write a report of the fields }
      writeln;
      writeln(TypeCount[0],' db header, ',TypeCount[4],' card def');
      writeln(TypeCount[5],' categories, ',TypeCount[6],' fields defined');
      writeln(TypeCount[7],' view point defs, ',TypeCount[10],' view point tables');
      writeln(TypeCount[12],' smart clips, ',TypeCount[31],' lookup tables');
      writeln(TypeCount[11],' data records, ',TypeCount[9],' with notes');

      { were there errors? }
      writeln(  'Found records:',TotalRecords:8,'     Garbage records:',GarbageRecords:4);
      if TypeCount[31]>0 then
        begin
        writeln('Expected records:',ExpectedRecords:5,'     Deleted records:',NumDeleted:4);
        if TotalRecords+NumDeleted-GarbageRecords<>ExpectedRecords+1 then
          begin
          writeln('Error: expected records should be found plus deleted minus garbage plus one.');
          SetErrorLevel(3);
          end;
        end;
      if ReadError then writeln('Read Error');
      if TypeCount[0]>1 then begin writeln('Error: more than one database header found.'); SetErrorLevel(3); end;
      if TypeCount[31]>1 then begin writeln('Error: more than one lookup table found.'); SetErrorLevel(3); end;
      if TypeError then begin writeln('Error: a record was found with a type greater than 31.'); SetErrorLevel(3); end;
      if ReadError then begin
        writeln('Error: the end of file was reached before all the data was read.'); SetErrorLevel(3); end;
      if DataError then begin writeln('Error: a data record contained an invalid value.'); SetErrorLevel(3); end;
      if UnknownTypeError then begin writeln('Error: the file is an unknown type.'); SetErrorLevel(3); end;
      if LookupError then
        begin writeln('Error: the lookup table doesn''t agree with the position of the data records.'); SetErrorLevel(3); end;
      if ViewPointError then
        begin writeln('Error: a view point table had errors.'); SetErrorLevel(3); end;
      if NoteError then begin writeln('Error: Note field has illegal character 0 or 255');
        SetErrorLevel(3); end;
      if NoteLinkError then begin writeln('Error: a note was linked incorrectly.');
        SetErrorLevel(3); end;
      if LinkError then begin writeln('Error: links in record(s) point to other non-existent records.');
        SetErrorLevel(3); end;
      if ADBFile then for i:=0 to DataCount-1 do
        if (DataRecord[i].Size>0) and not (DataRecord[i].Links in [10,11]) then
          begin
          writeln('Error: Data record ',i,' was linked incorrectly.');
          SetErrorLevel(3);
          end;
      if not ThisFileError then writeln('No problems found with ',FileName)
      else writeln(FileName,' had errors.');
      writeln;
      FileCount:=FileCount+1;
      ResultsList:=ResultsList+FileName+': ';
      if ThisFileError then
        begin
        ErrorCount:=ErrorCount+1;
        ResultsList:=ResultsList+'error'+chr(13)+chr(10);
        end
      else ResultsList:=ResultsList+'OK'+chr(13)+chr(10);
      FindNext(DirInfo);
      end;
    end;
  end;
if FileCount>1 then
  begin
  writeln(FileCount,' files checked');
  writeln(ErrorCount,' had errors.');
  writeln(ResultsList);
  end;
Dispose(buffer);
Halt(ErrorLevel);

end.