/**************************************************************************

Star Trek for MS-DOS	by KISS

<J>
	96.03.03	0.00a	JnAlEvނ
				0.01a	R}hI
				0.02a	NS̍U
	96.03.04	0.03a	tF[U[EXRA\
				0.04a	[vEnւ̃hbLOiƂ肠Vׂj
				0.05a	Fɂvނ̌̏Eq
	96.03.05	0.06a	TAD31ւ̎bJ
				0.07a	\[XJɔAȂCERg}
	97.09.24	0.10	Vׂ]

***************************************************************************/

#define	VERSION	"0.10"

#include	<stdio.h>
#include	<stdlib.h>
#include	<time.h>
#include	<ctype.h>

typedef	char	bool;
#define	TRUE	1
#define	FALSE	0



#define	GALAXY_SIZE		8				/* ͂̈ӂ̒ */
#define	SIDE			8				/* ͂̈ӂ̒ */
#define	SIDE_GALAXY		(GALAXY_SIZE * SIDE)
#define	MAX_ENERGY		5000			/* GlM[ől */
#define	MAX_TORPEDO		10				/* qgse */
#define	MAX_YEAR		30				/* N */
#define	STORM_RATE		300				/* F߂TCȒ傫 */
#define	MAX_KLINGON		(MAX_YEAR-6)	/* oꂷNS̍ől */
#define	STAR_DESTROY_RATE	70			/* Őm */

#define	HIDE	0
#define	VISIBLE	1
#define	OK		0
#define	NG		-1

#define	FGALAXY		0					/* Stat.flag[i]p */
#define	FSECTOR		1
#define	FSHIELD		2
#define	FTORPEDO	3
#define	FPHASER		4
#define	FWARP		5
#define	FCPUDISP	6
#define	MAX_FLAG	7

#define	KLINGON	0						/* Sector[][][i]p */
#define	STAR	1
#define	BASE	2
#define	FLAG	3

unsigned	GameScore = 0, Score, HiScore = 0;
char	Galaxy[SIDE_GALAXY][SIDE_GALAXY];	/* ̓}bv */
int		Sector[GALAXY_SIZE][GALAXY_SIZE][4];

char	*FlagMsg[] = {
		"Long range sensor",		"Short range sensor",
		"Energy shield",			"Photon torpedo tubes",
		"Phaser",					"Warp engine",
		"Computer display"
};
struct	stat	{
	int		year;						/* oߔN */
	int		galaxyX;					/* ͂ł̂wW */
	int		galaxyY;					/* ͂ł̂xW */
	int		energy;						/* GlM[ */
	int		torpedo;					/* qe */
	int		klingon;					/* NS */
	int		star;						/* ̐ */
	int		base;						/* n̐ */
	int		flag[MAX_FLAG];				/* @̏CɂN */
}	Stat;

struct	klingon	{
	int		galaxyX;					/* ͂ł̂wW */
	int		galaxyY;					/* ͂ł̂xW */
	int		sectorX;					/* ͂ł̂wW */
	int		sectorY;					/* ͂ł̂xW */
	int		energy;						/* GlM[ */
}	Klin[MAX_KLINGON];






/*** Op֐ie[uQƁEŒ菬_Łj ***/
int	sin100(int degree)
{
	int	sini;
	static signed char	sinc[] = {
		0,	2,	3,	5,	7,	9,	10,	12,	14,	16,
		17,	19,	21,	22,	24,	26,	28,	29,	31,	33,
		34,	36,	37,	39,	41,	42,	44,	45,	47,	48,
		50,	52,	53,	54,	56,	57,	59,	60,	62,	63,
		64,	66,	67,	68,	69,	71,	72,	73,	74,	75,
		77,	78,	79,	80,	81,	82,	83,	84,	85,	86,
		87,	87,	88,	89,	90,	91,	91,	92,	93,	93,
		94,	95,	95,	96,	96,	97,	97,	97,	98,	98,
		98,	99,	99,	99,	99,	100,100,100,100,100,
		100
	};

	if (degree >= 360)	degree %= 360;
	while (degree < 0)	degree += 360;

	if (degree <= 90){
		sini =  (int)sinc[ degree -0];
	}else if (degree <= 180){
		sini =  (int)sinc[-degree +180];
	}else if (degree <= 270){
		sini = -(int)sinc[ degree -180];
	}else{
		sini = -(int)sinc[-degree +360];
	}
	return	sini;
}

int	cos100(int degree)
{
	return	sin100(degree + 90);
}


/*** F ***/

bool	isDocking()
{
	int		mx, my, dx, dy, sx, sy, i, j;
	bool	retCode;

	sx = Stat.galaxyX % SIDE;
	sy = Stat.galaxyY % SIDE;
	mx = sx-1;	my = sy-1;
	dx = sx+1;	dy = sy+1;

	if (mx <  0)	mx = 0;
	if (my <  0)	my = 0;
	if (dx >= SIDE)	dx = SIDE - 1;
	if (dy >= SIDE)	dy = SIDE - 1;

	retCode = FALSE;
	for (i = my; i <= dy; ++i){
		for (j = mx; j <= dx; ++j){
			if (Galaxy[Stat.galaxyX/SIDE*SIDE+j]
										[Stat.galaxyY/SIDE*SIDE+i] == 'B'){
				retCode	= TRUE;
			}
		}
	}
	return	retCode;
}


int		getint(char *msg, int min, int max)
{
	char	buf[20];
	int		i;
	bool	flagNG = TRUE;

	while (flagNG){
		printf("%s:%d\-%d>", msg, min, max);
		fgets(buf, 20, stdin);
		printf("\n");
		i = atoi(buf);
		if (i != 0 || buf[0] == '0'){
			if (i < min)	i = min;
			if (i > max)	i = max;
			flagNG = FALSE;
		}
	}
	return	i;
}


void	_base()
{
	int		i;

	Stat.torpedo =			MAX_TORPEDO;
	Stat.energy =			MAX_ENERGY;
	for (i = 0; i < MAX_FLAG; ++i){
		Stat.flag[i] =	OK;
	}
}


void	attackKlingon()
{
	int i,gx,gy,damage;

	gx = Stat.galaxyX / SIDE;
	gy = Stat.galaxyY / SIDE;

	if (Sector[gx][gy][KLINGON] <= 0){
		return;
	}
	printf("Klingon attack.\n");
	if (isDocking()){
		printf("No damage. because starbase protects Enterprise.\n\n");
		return;
	}
	for (i=0; i<MAX_KLINGON; ++i){
		if ((gx == Klin[i].galaxyX) &&
					(gy == Klin[i].galaxyY) && (Klin[i].energy > 0)){
			damage = random(2 + Klin[i].energy) + Klin[i].energy/2;
			if (Stat.flag[FSHIELD] == OK){
				damage = (damage * 2) / 3;
			}
			printf("\a%d units hit from Klingon at (%d,%d).\n",
					damage, Klin[i].sectorX, Klin[i].sectorY);
			Stat.energy -= damage;
		}
	}
	printf("\n");
}


int		getPhase()
{
	return	getint("course", 0, 360);
}


void	goTorpedo()
{
	int		course, gx, gy, sx, sy, x, y, i, j;
	char	c;

	if (Stat.flag[FTORPEDO] != OK){
		printf("Photon torpedo tubes are broken.\n\n");
		return;
	}
	if (Stat.torpedo == 0){
		printf("Photon torpedo is empty.\n\n");
		return;
	}
	gx = Stat.galaxyX / SIDE;
	gy = Stat.galaxyY / SIDE;
	sx = Stat.galaxyX % SIDE;
	sy = Stat.galaxyY % SIDE;
	course = getPhase();
	printf("Photon torpedo is loaded.\nTorpedo track ");
	--Stat.torpedo;
	for (i = 1; i < 16; ++i){
		x = (i * cos100(course))/100;
		y = (i * sin100(course))/100;
		if (sx+x >= 0 && sx+x < SIDE &&	sy+y >= 0 && sy+y < SIDE){
			printf("%d\,%d\ ", sx+x, sy+y);
			c = Galaxy[gx*SIDE+sx+x][gy*SIDE+sy+y];
			switch (c){
				case 'K':
					printf("Klingon destroyed.\n\n");
					Galaxy[gx*SIDE+sx+x][gy*SIDE+sy+y] = '.';
					for (j = 0; j < MAX_KLINGON; ++j){
						if (Klin[j].galaxyX == gx  && Klin[j].galaxyY == gy &&
							Klin[j].sectorX ==sx+x && Klin[j].sectorY ==sy+y){
							Klin[j].galaxyX = Klin[j].galaxyY = -1;
							Klin[j].sectorX = Klin[j].sectorY = -1;
							Klin[j].energy = -1;
						}
					}
					--Stat.klingon;
					--Sector[gx][gy][KLINGON];
					return;
				case '*':
					printf("Hit a star, ");
					if (random(100) <= STAR_DESTROY_RATE){
						printf("star destroyed.\n\n");
						Galaxy[gx*SIDE+sx+x][gy*SIDE+sy+y] = '.';
						--Stat.star;
						--Sector[gx][gy][STAR];
					}else{
						printf("torpedo absorbed.\n\n");
					}
					return;
				case 'B':
					printf( "Starbase destroyed.\n"
						"Spock:I often find human behaviour fascinating.\n\n");
					--Stat.base;
					--Sector[gx][gy][BASE];
					Galaxy[gx*SIDE+sx+x][gy*SIDE+sy+y] = '.';
					return;
				case '.':
				default:
					break;
			}
		}else{
			printf("Missed.\n\n");
			return;
		}
	}
}


void	goPhaser()
{
	int	energy, i, gx, gy, damage, kl;

	gx = Stat.galaxyX / SIDE;
	gy = Stat.galaxyY / SIDE;
	kl = Sector[gx][gy][KLINGON];

	if (Stat.flag[FPHASER] != OK){
		printf("Phaser is broken.\n\n");
		return;
	}
	energy = getint("Phaser energy",0 ,5000);
	if (energy >= 1000){
		printf("Over loaded!\n\n");
		return;
	}
	Stat.energy -= energy;

	if (kl <= 0){
		printf("Phaser fired at empty space...\n\n");
		return;
	}else{
		printf("Enterprise attack.\n");
	}
	for (i=0; i<MAX_KLINGON; ++i){
		if ((gx == Klin[i].galaxyX) &&
					(gy == Klin[i].galaxyY) && (Klin[i].energy > 0)){
			damage = (random(2 + energy) + energy/2) / Sector[gx][gy][KLINGON];
			printf("\a%d units hit for Klingon at (%d,%d).\n",
					damage, Klin[i].sectorX, Klin[i].sectorY);
			Klin[i].energy -= damage;
			if (Klin[i].energy <= 0){
				printf("Klingon at (%d,%d) destroyed.\n",
					Klin[i].sectorX, Klin[i].sectorY);
				Galaxy[Klin[i].sectorX+gx*SIDE][Klin[i].sectorY+gy*SIDE] = '.';
				Klin[i].galaxyX = Klin[i].galaxyY = -1;
				Klin[i].sectorX = Klin[i].sectorY = -1;
				--kl;
				--Stat.klingon;
			}
		}
	}
	Sector[gx][gy][KLINGON] = kl;
	printf("\n");
}


void	goYear()
{
	if (--Stat.year < 0){
		return;
	}
	if (--Stat.flag[FGALAXY]  < 0)		Stat.flag[FGALAXY]  = OK;
	if (--Stat.flag[FSECTOR]  < 0)		Stat.flag[FSECTOR]  = OK;
	if (--Stat.flag[FSHIELD]  < 0)		Stat.flag[FSHIELD]  = OK;
	if (--Stat.flag[FTORPEDO] < 0)		Stat.flag[FTORPEDO] = OK;
	if (--Stat.flag[FPHASER]  < 0)		Stat.flag[FPHASER]  = OK;
	if (--Stat.flag[FWARP]    < 0)		Stat.flag[FWARP]    = OK;
	if (--Stat.flag[FCPUDISP] < 0)		Stat.flag[FCPUDISP] = OK;
}


void	goWarp()
{
	int		distance, energy, course, x, y, rate, d, i;

	if (Stat.flag[FWARP] != OK){
		printf("Warp engine is broken.\n\n");
		return;
	}

	distance = getint("Sector distance", 0, 100);
	if (Stat.energy <= (distance^2)/2){
		printf("Scotty:Captain, we don't have the energy.\n\n");
		return;
	}
	goYear();
	if (Stat.year < 0){
		return;
	}
	course = getPhase();
	Stat.energy -= (distance^2)/2;
	Galaxy[Stat.galaxyX][Stat.galaxyY] = '.';

	x = Stat.galaxyX += ((distance * cos100(course)) / 100);
	y = Stat.galaxyY += ((distance * sin100(course)) / 100);
	if (Stat.galaxyX < 0 || Stat.galaxyX >=64 ||
								Stat.galaxyY < 0 || Stat.galaxyY >=64){
		printf("Scotty:We wondered outside of the galaxy...\n");
		do{
			x = Stat.galaxyX = random(64);
			y = Stat.galaxyY = random(64);
		} while (Galaxy[x][y] != '.');
	}else if (Galaxy[Stat.galaxyX][Stat.galaxyY] != '.'){
		printf("Spock:Emergency stop. To error is human.\n");
		x = Stat.galaxyX -= ((distance * cos100(course)) / 100);
		y = Stat.galaxyY -= ((distance * sin100(course)) / 100);
	}
	Galaxy[x][y] = 'E';
	Sector[x/SIDE][y/SIDE][FLAG] = VISIBLE;
	if (isDocking()){
		printf("We are docked at starbase.\n");
		_base();
	}else{
		rate =Sector[x/SIDE][y/SIDE][KLINGON]+Sector[x/SIDE][y/SIDE][STAR]/2+1;
		d = OK;
		for (i = 0; i < MAX_FLAG; ++i){
			if (random(STORM_RATE) <= rate){
				Stat.flag[i] += random(3) + 1;
				d = NG;
			}
		}
		if (d == NG){
			printf("Space storm!!\n");
		}
	}
	printf("\n");
}


void	lookSector()
{
	int		i, j;

	printf("sector(%d\,%d)\n", Stat.galaxyX%SIDE, Stat.galaxyY%SIDE);
	if (Stat.flag[FSECTOR] != OK){
		printf("Short range sensor is broken.\n\n");
		return;
	}
	for (i = SIDE-1; i >=0; --i){
		printf("%d",i);
		for (j = 0; j < SIDE; ++j){
			printf(" %c",(int)Galaxy[(Stat.galaxyX/SIDE)*SIDE+j]
												[(Stat.galaxyY/SIDE)*SIDE+i]);
		}
		printf("\n");
	}
	printf("+");
	for (i = 0; i < SIDE; ++i){
		printf(" %d", i);
	}
	printf("\n\n");
}


void	lookGalaxy()
{
	int		i, j, k, x, y;

	printf("galaxy(%d\,%d)\n", Stat.galaxyX/SIDE, Stat.galaxyY/SIDE);
	if (Stat.flag[FGALAXY] != OK){
		printf("Long range sensor is broken.\n\n");
		return;
	}
	x = Stat.galaxyX / SIDE;
	y = Stat.galaxyY / SIDE;
	for (i = y-1; i <= y+1; ++i){
		for (j = x-1; j <= x+1; ++j){
			if (i >= 0 && i < SIDE && j >= 0 && j < SIDE){
				Sector[j][i][FLAG] = VISIBLE;
			}
		}
	}
	printf("+ KSB KSB KSB KSB KSB KSB KSB KSB\n");
	for (i = 7; i >= 0; --i){
		printf("%d ", i);
		for (j = 0; j < SIDE; ++j){
			if (Sector[j][i][FLAG] == HIDE){
				printf("*** ");
			}else{
				for (k = 0; k < 3; ++k){
					printf("%d", Sector[j][i][k]);
				}
				printf(" ");
			}
		}
		printf("\n");
	}
	printf("+ -0- -1- -2- -3- -4- -5- -6- -7-\n\n");
}


void	lookStatus()
{
	int		i ,j ,f;
	char	*conMsg;

	for (i = f = 0; i < MAX_FLAG; ++i){
		f += Stat.flag[i];
	}
	if (Stat.energy < MAX_ENERGY/4 || Stat.klingon >= Stat.year+2 || f >= 8){
		conMsg = "red";
	}else if (Stat.energy < MAX_ENERGY/2 || Stat.torpedo <= 1 || f > 0){
		conMsg = "yellow";
	}else{
		conMsg = "green";
	}
	printf("galaxy(%d\,%d)   ", Stat.galaxyX/SIDE, Stat.galaxyY/SIDE);
	printf("sector(%d\,%d)\n" , Stat.galaxyX%SIDE, Stat.galaxyY%SIDE);
	if ((i = Stat.flag[FCPUDISP]) != OK){
		printf("%s damaged. %d stardates estimated "
									"for repair.\n\n", FlagMsg[FCPUDISP], i);
		return;
	}
	printf("<Status report>\n");
	printf("  Stardate %d, time left %d.\n",
									3200 + MAX_YEAR - Stat. year, Stat.year);
	printf("  condition %s\n", conMsg);
	printf("  %d energy, "      , Stat.energy);
	printf("  %d torpedoes, "   , Stat.torpedo);
	printf("  %d starbases.\n"  , Stat.base);
	printf("  %d Klingons, "    , Stat.klingon);
	printf("  %d stars.\n"      , Stat.star);
	for (j = 0; j < MAX_FLAG-1; ++j){
		if ((i = Stat.flag[j]) != OK){
			printf("%s damaged. "
				"%d stardates estimated for repair.\n", FlagMsg[j], i);
		}
	}
	printf("\n");
}


void	setMap(int item, char map, int i)
{
	int		x, y;
	char	c;

	do{
		x = random(64);
		y = random(64);
	} while ((Galaxy[x][y] != '.')||(Sector[x/SIDE][y/SIDE][item] > 8));
	if (item == KLINGON){
		Klin[i].galaxyX = x / SIDE;
		Klin[i].galaxyY = y / SIDE;
		Klin[i].sectorX = x % SIDE;
		Klin[i].sectorY = y % SIDE;
		Klin[i].energy
			= random(35) + random(30)*3 + random(25)*6 + random(20)*9 + 75;
		Score += Klin[i].energy;
	}
	Galaxy[x][y] = map;
	++Sector[x/SIDE][y/SIDE][item];
}


void	initialize()
{
	int 	i, j;

	Score = 0;
	for (i = 0; i < SIDE_GALAXY; ++i){
		for (j = 0; j < SIDE_GALAXY; ++j){
			Galaxy[j][i] = '.';
		}
	}
	for (i = 0; i < SIDE; ++i){
		for (j = 0; j < SIDE; ++j){
			Sector[j][i][KLINGON]
				= Sector[j][i][STAR]
				= Sector[j][i][BASE] = 0;
			Sector[j][i][FLAG] = HIDE;
		}
	}
	for (i = 0; i < MAX_FLAG; ++i){
		Stat.flag[i] = 0;
	}
	for (i = 0; i < MAX_KLINGON; ++i){
		Klin[i].galaxyX = Klin[i].galaxyY = -1;
		Klin[i].energy  = 0;
	}
	Stat.year = MAX_YEAR;

	Stat.galaxyX = random(64);
	Stat.galaxyY = random(64);
	Galaxy[Stat.galaxyX][Stat.galaxyY] = 'E';
	Sector[Stat.galaxyX/SIDE][Stat.galaxyY/SIDE][FLAG] = VISIBLE;

	_base();

	Stat.klingon = random(6) + random(6) + random(5) + random(4)*3 + 9;
	if (Stat.klingon > MAX_KLINGON)	Stat.klingon = MAX_KLINGON;

	Stat.star = random(20)*2 + random(18)*2 + random(15)*2 + random(12)*2
				+ random(20) + random(18) + random(15) + random(12)
				+ random(8)*2 + random(4)*2 + 60;
	Stat.base = random(3) + random(2) + 2;

	for (i = 0; i < Stat.klingon; ++i){
		setMap(0,'K',i);
	}
	for (i = 0; i < Stat.star; ++i){
		setMap(1, '*', i);
	}
	for (i = 0; i < Stat.base; ++i){
		setMap(2, 'B', i);
	}

	printf(	" Stardate 3200, your mission is "
			"to destroy %d Klingons in %d stardates.\n"
			" There are %d Starbases.\n\n",
			Stat.klingon, MAX_YEAR, Stat.base);
}


void	mainLoop()
{
	char	c;

	initialize();
	lookSector();

	attackKlingon();
	while (1){
		/*** sk(;_;) ***/
		if (Stat.year < 0){
			printf( "It's too late! The frederation has been conquered.\n"
					"=== game over ===\n\n");
			GameScore = 0;
			return;
		}
		if (Stat.energy <= 0){
			printf( "Enterprise destroyed...\n"
					"=== game over ===\n\n");
			GameScore = 0;
			return;
		}
		/*** (^^)v ***/
		if (Stat.klingon <= 0){
			GameScore += Score*(Stat.year+1)/90 +Stat.energy/100 +Stat.torpedo;
			printf( "Boy, you barely made it! It's ");
			if (Stat.year > 15)		printf("miracle, ");
			if (Stat.year > 10)		printf("unbelievable, ");
			if (Stat.year >  5)		printf("fantastic, ");
			printf("good work.\n\n");
			return;
		}
		/*** Q[s ***/
		printf( "[L-ookStat G-alaxy S-ector T-orpedo P-haser W-arp R-est Q-uit]\n"
				"command>");
		switch (c = toupper(getch())){
			case 'R':
				goYear();
				attackKlingon();
			case 'L':
				printf("%c\n\n", (int)c);
				lookStatus();
				break;
			case 'G':
				printf("%c\n\n", (int)c);
				lookGalaxy();
				break;
			case 'S':
				printf("%c\n\n", (int)c);
				lookSector();
				break;
			case 'T':
				printf("%c\n\n", (int)c);
				goTorpedo();
				attackKlingon();
				break;
			case 'P':
				printf("%c\n\n", (int)c);
				goPhaser();
				attackKlingon();
				break;
			case 'W':
				printf("%c\n\n", (int)c);
				goWarp();
				attackKlingon();
				break;
			case 'Q':
				printf("%c\n=== Quit this game. ===\n\n", (int)c);
				GameScore = 0;
				return;
			default:
				printf("--- error! ---\n");
				break;
		}
	}

}


main()
{
	char	c;

	printf("STAR TREK for MS-DOS ver.%s by KISS\n\n",VERSION);
	srand(abs(time(NULL)));
	do{
		mainLoop();
		printf( "[N-ewGame Q-uit] (Score = %d / HiScore = %d)\n"
				"command>", GameScore, HiScore);
LOOP:
		switch (c = toupper(getch())){
			case 'N':
				printf("%c\n\n", (int)c);
				break;
			case 'Q':
				printf("%c\n\n", (int)c);
				return;
			default:
				goto LOOP;
		}
		if (GameScore > HiScore)	HiScore = GameScore;
	} while(1);
}
