//
//		Metronome
//

#include <stdio.h>
#include <dos.h>
#include <math.h>
#include <string.h>
#include <graphics.h>
#include "hp100.h"

extern int end;

extern int inkey(int);

int	metroval = 120;

void 	setendmode(int m);
void 	initinter(void);
void	disponpuu(int);
void 	resetinter(void);

//
//
//
void interrupt (*old_int1c)();
int clck;

#define TIM_INT 0x08

void dometro(void);

static	uchar _clck;
void interrupt int1c()
{

	clck++;

//	dometro();

	_clck = (_clck+1) & 0x03;
	if(!_clck){
		outportb(0x21,(inportb(0x21) & 0xFE));
		old_int1c();
		}

	outportb(0x20,0x20);
	enable();
}

void initinter()
{
	disable();
	old_int1c = getvect(TIM_INT);
	setvect(TIM_INT,int1c);

	outportb(CTCC,0x34);				/*  */
	outportb(CTC0,  0);
	outportb(CTC0, 0x40);

	enable();
}

void resetinter()
{

	disable();
	setvect(TIM_INT,old_int1c);
	outportb(CTCC,0x34);				/*  */
	outportb(CTC0,255);
	outportb(CTC0,255);
	enable();

}

int		metroflg = 0;
int		metovr = 36;			// Defalt tempo 120
extern uint	table[16];

void metroout(int flg)
{

	if(flg){
		outportb(0x43,0xB6);
		outportb(0x42,(table[9]/2) & 0xFF);
		outportb(0x42,(table[9]/2) >> 8  );
		outportb(0x61,inportb(0x61) | 0x03);
		}
	else {
		outportb(0x61,inportb(0x61) & 0xFC);
		}
}


void setmetro(int d)
{
	if(d == OFF){
		metroflg=0;
		metroout(OFF);
		return;
		}

	if(d == ON){
		metroflg = 1;
		clck = -1;
		metroout(OFF);
		return;
		}

	metovr = (int)(60. / (float)d * 72.832 );  // 1193280 / 4

}

void	dispmetro(int);

void upmetro(void)
{

	metroval++;
	if(metroval > 220)
		metroval = 220;
	metroout(OFF);
	setmetro(metroval);
	dispmetro(metroval);

}

void dwnmetro(void)
{
	metroval--;
	if(metroval < 40)
		metroval = 40;

	metroout(OFF);
	setmetro(metroval);
	dispmetro(metroval);
}
//
//	
//
void dometro(void)
{
	static int oldclck=-1;
	static	mon;

	if(!metroflg)
		return;

	if(oldclck == clck)
		return;

	oldclck = clck;

	if(clck >=  metovr){
		clck = 0;
		oldclck = 0;
		}
	if(clck >= 3 && mon){
		metroout(OFF);
		mon = 0;
		}
	if(clck == 0 ){
		mon = 1;
		metroout(ON);
		}
	if(clck == metovr-2)
		disponpuu(0);
		
}

void metroloop()
{
	int brk=0;
	int	c;

	initinter();

	settextstyle(0,HORIZ_DIR,0);
	settextjustify(CENTER_TEXT,CENTER_TEXT);
	outtextxyinv(CLX3,CLY," Metro ");

	clck = 0;
	setmetro(metroflg);
	setmetro(metroval);
	dispmetro(metroval);
	disponpuu(1);

	while(!end && !brk){
		dometro();
		c = inkey(0);
		enable();
		switch(c){
			case UP :upmetro();
					break;
			case DWN:dwnmetro();
					break;

			case F2:metroout(OFF);
					setendmode(0);		
					brk=1;
					break;

			case F4:setendmode(F4);		// Exg. Seq mode
					brk = 1;
					break;

			case F9 :end = 1;
					break;

			default :
				break;

			}
		c = c & 0xFF;
		switch(c){
			case 0x0D:
			case 0x20:
					setmetro(metroflg ^ 1);
					break;
			}

		}

	settextstyle(0,HORIZ_DIR,0);
	settextjustify(CENTER_TEXT,CENTER_TEXT);
	outtextxynrm(CLX3,CLY," Metro ");

	resetinter();
}

