
//=====


#include <stdio.h>
#include <dos.h>
#include <math.h>
#include <string.h>
#include <graphics.h>
#include "hp100.h"


extern int tone;

char *keystr[]={"C","C#","D","D#","E","F","F#","G","G#","A","A#","B"};
uchar _backptn[] ={0x33,0x33,0xCC,0xCC,0x33,0x33,0xCC,0xCC}; 
uchar backptn2[] ={0x55,0x55,0xaa,0xaa,0x55,0x55,0xaa,0xaa}; 
uchar backptn[] ={0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa}; 

uchar onp2   [] = { 
           0x17,0x00,0x17,0x00,
           0x00,0x00,0x00,
           0x00,0x00,0x00,
           0x00,0x00,0xF8,
           0x00,0x1F,0xF8,
           0x03,0xFF,0xF8,
           0x03,0xFF,0x08,
           0x03,0xE0,0x08,
           0x02,0x00,0x08,
           0x02,0x00,0x08,
           0x02,0x00,0x08,
           0x02,0x00,0x08,
           0x02,0x00,0x08,
           0x02,0x00,0x08,
           0x02,0x00,0x08,
           0x02,0x00,0x08,
           0x02,0x00,0xF8,
           0x02,0x01,0xF8,
           0x3E,0x01,0xF8,
           0x7E,0x00,0xF0,
           0x7E,0x00,0x00,
           0x3C,0x00,0x00,
           0x00,0x00,0x00,
           0x00,0x00,0x00,
           0x00,0x00,0x00,
         };


void dotdial(int col)
{
	int	d,x1,y1,x2,y2;
	d = (12 - tone) * 30;
	while(d>=360)
		d -= 360; 

	setcolor(col);
	setfillstyle(SOLID_FILL,col);
	setlinestyle(0,0,NORM_WIDTH);
	if(d!=0){
		pieslice(DIAL_X,DIAL_Y,d-4,d+4,DIAL_R-2);
		}
	else {
		pieslice(DIAL_X,DIAL_Y,d,d+4,DIAL_R-2);
		pieslice(DIAL_X,DIAL_Y,360-4,359,DIAL_R-2);
		}
}

//
//	pۃN^O
//
void rrect(int x1,int y1,int x2,int y2,int r)
{
	arc(x1 + r,y1 + r , 90,180,r);
	arc(x2 - r,y1 + r ,  0, 90,r);
	arc(x1 + r,y2 - r ,180,270,r);
	arc(x2 - r,y2 - r ,270,360,r);
	line(x1 + r,y1, x2 - r, y1);
	line(x2, y1 + r, x2 ,y2 - r);
	line(x1 + r, y2, x2 - r, y2);
	line(x1 , y1 + r,x1,y2 - r );

}



//
//		Co[X
//

void outtextxyinv(int x,int y,char *str)
{
	char	s[80];
	int		i;
	for(i=0;i<strlen(str);i++)
		s[i] = 0xDB ;    // uN

	s[i] = 0;
	setcolor(1);
	outtextxy(x,y-2,s);
	outtextxy(x,y+2,s);
	setcolor(0);
	outtextxy(x,y,str);
	setcolor(1);
}

//
//		tCo[X
//

void outtextxynrm(int x,int y,char *str)
{
	char	s[80];
	int		i;
	for(i=0;i<strlen(str);i++)
		s[i] = 0xDB ;    // uN

	s[i] = 0;
	setcolor(0);
	outtextxy(x,y-2,s);
	outtextxy(x,y+2,s);
	setcolor(1);
	outtextxy(x,y,str);

}

//
//		`[isb`\
//

void disppitch(int p)
{
	#define PW 30
	
	char	s[32];
	sprintf(s,"%3d",p);
	settextstyle(SANS_SERIF_FONT,HORIZ_DIR,2);
	settextjustify(1,2);

	setfillstyle(SOLID_FILL,0);
	bar(PX-PW-10,PY+2 ,PX+PW-8,PY+22);

	setcolor(1);
	outtextxy(PX-10  ,PY,s);
	outtextxy(PX-1-10,PY,s);

}
//
//	`[i[IN^[u
//
dispoct(int c)
{
	static char *octs[]={"L","M","H"};
	int		x,y;
	x = PX+24;
	y = PY+7;

	settextjustify(0,2);
	settextstyle(0,HORIZ_DIR,2);
	setfillstyle(SOLID_FILL,0);
	bar( x, y, x+16,PY+22);
	outtextxy( x, y,octs[c]);

}


uchar onpuu    [] = { 
		 15,0x00,15,0x00,
		 0x00,0x00,
		 0x00,0xC0,
		 0x00,0xE0,
		 0x00,0xB0,
		 0x00,0x98,
		 0x00,0x8C,
		 0x00,0x84,
		 0x00,0x84,
		 0x00,0x84,
		 0x00,0x84,
		 0x00,0x88,
		 0x07,0x88,
		 0x0F,0x90,
		 0x1F,0x80,
		 0x1F,0x80,
		 0x0F,0x00,
	 };

uchar empty  [] = { 
         15,0x00,15,0x00,
         0x00,0x00,
         0x00,0x00,
         0x00,0x00,
         0x00,0x00,
         0x00,0x00,
         0x00,0x00,
         0x00,0x00,
         0x00,0x00,
         0x00,0x00,
         0x00,0x00,
         0x00,0x00,
         0x00,0x00,
         0x00,0x00,
         0x00,0x00,
         0x00,0x00,
         0x00,0x00
         };

//
//	Metronome Display
//


void	dispmetro(int d)
{

	char	s[32];

	sprintf(s,"%3d",d);
	settextstyle(SANS_SERIF_FONT,HORIZ_DIR,2);
	settextjustify(0,2);

	setfillstyle(SOLID_FILL,0);
	bar(MX,MY,MX+40,MY+24);

	setcolor(1);
	outtextxy(MX  ,MY,s);
	outtextxy(MX-1,MY,s);

}

void disponpuu(int d)
{
	static int xp=0;

	if(!d)
		xp = (xp+1) & 0x01;
	else xp =1;

	if(xp)
		putimage(MX-24, MY+6 ,onpuu,COPY_PUT);
	else 
		putimage(MX-24, MY+6 ,empty,COPY_PUT);

}

//
//		aspect ɔႵĂx␳
//

adjstY(int y,int d,int yr)
{
	int	yo;
	yo = y - (int)(49./40. * sin(d*3.14/180) * yr);
	return yo;
}

//
//		ʑŜ̕`
//

void initscreen(void)
{
	int	gd=DETECT,gm;
	int	maxx,maxy,i;
	int	ax,ay,d,r;

	gd=CGA;
	gm=CGAHI;

	initgraph(&gd,&gm,"");
	setaspectratio(10000,10000);

//	registerbgifont(triplex_font);
	settextstyle(TRIPLEX_FONT,HORIZ_DIR,10);

	maxx = getmaxx();
	maxy = getmaxy();

	setcolor(1);
	setlinestyle(0,0,NORM_WIDTH);
	rrect(0,0,639,199,10);

	//
	// 		`[i[ZNV 
	//

	rrect(4,4,DIAL_X*2,180,5);

	rrect(PX-PW-18,PY  ,PX+PW+18,PY+29,3);
	rrect(PX-PW-19,PY-1  ,PX+PW+19,PY+30,2);

	setaspectratio(8200,10000);	

	circle(DIAL_X,DIAL_Y,DIAL_R);
	circle(DIAL_X,DIAL_Y,DIAL_R+1);
	circle(DIAL_X,DIAL_Y,DIAL_R+26);

	settextstyle(SMALL_FONT,HORIZ_DIR,5);
	settextjustify(CENTER_TEXT,CENTER_TEXT);
	r = DIAL_R+12;
	for(i=0,d=0;d<360;d += 30,i++){
		ax = DIAL_X; ay = DIAL_Y;
		ax = ax+r*cos(d*3.14 /180);
		ay = ay+r*sin(d*3.14 /180);
		ay = adjstY(ay,d,r/4-5);
		outtextxy(ax,ay,keystr[i]);
		outtextxy(ax+1,ay,keystr[i]);
		}

	setfillstyle(CLOSE_DOT_FILL,1);
	floodfill(10,10,1);

	setaspectratio(10000,10000);	

//
//		gm[ZNV
//

	rrect(MFX,MFY,MFX+MFW,MFY+MFH,5);
	dispmetro(120);
	disponpuu(1);
	rrect(MFX+33,MFY+13,MFX+125 ,MFY+44  ,3);
	rrect(MFX+32,MFY+12,MFX+126 ,MFY+43  ,2);

	setfillstyle(CLOSE_DOT_FILL,1);
	floodfill(MFX+10,MFY+10,1);

//
//		Scale Section
//

	setlinestyle(0,0,NORM_WIDTH);
	rectangle(SQX,SQY,SQX+SQW,SQY+SQH);
	rectangle(SQX-1,SQY-1,SQX+SQW+1,SQY+SQH+1);

	
	draw5line();
	drawScale(0,0);

//
//		Title
//


	rrect(TLX,TLY,TLX+TLW,TLY+TLH,3);

	circle(TLX+6,TLY+6,2);
	circle(TLX+TLW-6,TLY+6,2);
	circle(TLX+6,TLY+TLH-6,2);
	circle(TLX+TLW-6,TLY+TLH-6,2);


	putimage(TLX+34,TLY+4,onp2,0);
	settextstyle(0,HORIZ_DIR,2);
	settextjustify(CENTER_TEXT,CENTER_TEXT);

	outtextxy(TLC+10+1,TLY+18+1,"Tune");
	setcolor(0);
	outtextxy(TLC+10,TLY+18,"Tune");
	setcolor(1);
	outtextxy(TLC+ 9,TLY+17,"Tune");


	settextstyle(0,HORIZ_DIR,1);
	outtextxy(TLC,TLY+38,"(c) 1994 Ringoro ");

//
//	t@NVL[
//

	settextjustify(CENTER_TEXT,CENTER_TEXT);
	settextstyle(0,HORIZ_DIR,0);
	setcolor(1);
	outtextxy(CLX9,CLY,"Quit");
	outtextxy(CLX2,CLY,"Tune");
	outtextxy(CLX3,CLY,"Metro");
	outtextxy(CLX4,CLY,"Scale");

/*
	outtextxy( CLX1,CLY,"XXX");
	outtextxy( CLX2,CLY,"XXX");
	outtextxy( CLX3,CLY,"XXX");
	outtextxy( CLX4,CLY,"XXX");

	outtextxy( CLX8,CLY,"XXX");
	outtextxy(CLX10,CLY,"XXX");

*/
	setlinestyle(0,0,NORM_WIDTH);
	line(0,CLY-8,639,CLY-8);




//

	setfillpattern(backptn,1);
	floodfill(630,10,1);

	setaspectratio(8200,10000);	

}

