/*
wdat.c
Decode of Huffman file world.dat by Richard C. Allen
*/

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

#include "wdat.h"

#define C2D (1.0 / 3.0)     /* convert lat/lon codes to real degrees */

static FILE *fp;

static short mask;        /* current bit mask */
static short data;        /* current data byte */


CITY cities[NC];

/*
**   sysabort - replacement for old ci86 abort() function
**
**     may be called with a printf style argument list
*/

static void sysabort(
char *fmt, ...)
{
    va_list arg_ptr;

    fprintf(stderr,"\n\nabort: ");  /* preamble */
    va_start(arg_ptr, fmt);         /* arg_ptr -> first arg */
    vfprintf(stderr,fmt,arg_ptr);   /* display the message */
    va_end(arg_ptr);                /* arg_ptr = NULL */
    fprintf(stderr,"\n\n");         /* postamble */
    exit(0x7fff);                   /* do the abort */
}

static void *allocate(short nbytes)
{
    void *p;

    p = malloc(nbytes);
    if (p == NULL) sysabort("no more memory ...");
    return (p);
}

static short next(void)     /* next bit from the stream */
{
    short b;

    if (mask == 0)
    {
        data = fgetc(fp);
        if (data == EOF) sysabort("premature eof");
        data &= 0xff;
        mask = 0x80;
    }
    b = (data & mask) ? 1 : 0;
    mask >>= 1;
    return (b);
}

static short getn(short n)  /* next n bits from the stream */
{
    short k;
    short d;

    d = 0;
    k = n;
    while (k--)
    {
        d <<= 1;
        d |= next();
    }
    if (n < 16)     /* extend the sign bit */
    {
        d <<= 16-n;
        d >>= 16-n;
    }
    return (d);
}

static char get_character(void)     /* next character from the stream */
{
    if (next())
    {
        if (next())
        {
            if (next())
            {
                if (next())
                {
                    if (next()) return ('c');
                    else return ('b');
                }
                else return ('r');
            }
            else return (0);    /* null */
        }
        else
        {
            if (next())
            {
                if (next())
                {
                    if (next()) return ('d');
                    else
                    {
                        if (next()) return (',');
                        else
                        {
                            if (next()) return ('f');
                            else return ('w');
                        }
                    }
                }
                else return ('e');
            }
            else
            {
                if (next()) return ('o');
                else
                {
                    if (next()) return ('u');
                    else return ('m');
                }
            }
        }
    }
    else
    {
        if (next())
        {
            if (next())
            {
                if (next())
                {
                    if (next()) return ('t');
                    else return (' ');
                }
                else return ('n');
            }
            else
            {
                if (next())
                {
                    if (next())
                    {
                        if (next()) return ('h');
                        else return ('g');
                    }
                    else
                    {
                        if (next()) return ('p');
                        else
                        {
                            if (next())
                            {
                                if (next()) return ('z');
                                else return ('j');
                            }
                            else return ('v');
                        }
                    }
                }
                else
                {
                    if (next()) return ('l');
                    else return ('s');
                }
            }
        }
        else
        {
            if (next()) return ('a');
            else
            {
                if (next()) return ('i');
                else
                {
                    if (next())
                    {
                        if (next()) return ('k');
                        else
                        {
                            if (next()) return ('y');
                            else
                            {
                                if (next())
                                {
                                    if (next()) return ('x');
                                    else return ('.');
                                }
                                else
                                {
                                    if (next()) return ('q');
                                    else
                                    {
                                        if (next()) return ('-');
                                        else
                                        {
                                            if (next()) return ('\'');
                                            else
                                            {
                                                if (next()) return (')');
                                                else return ('(');
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    else return ('!');
                }
            }
        }
    }
    sysabort("get_character failed");
}

static void get_string(char *s)
{
    short c, cc, last;

    last = 0;
    for (;;)
    {
        c = get_character();
        if (last <= 64)
        {
            if (c >= 'a' && c <= 'z')
            {
                c = (c - 'a') + 'A';
            }
        }
        if (c == '!')
        {
            c = getn(8) & 0xff;
        }
        *s++ = c;
        if (!c) return;
        last = c;
    }
}

static void get_bcd(char *s)
{
    short c;
    static char table[16] = "0123456789#*/ ,";

    for (;;)
    {
        c = getn(4) & 0xf;
        *s++ = table[c];
        if (c == 15) return;
    }
}

static void get_entry(short n, int StartIndex)
{
    CITY *c;
    short nc;
    char country_name[99];
    char country_access[99];
    char city_name[99];
    char city_prefix[99];
    short k, jlat, jlon;
    long ll;

    c = &cities[n];

    nc = getn(9) & 0x1ff;  /* get country code, 0x1ff if primary */
    if (nc == 0x1ff)    /* this is prime entry, fetch country info */
    {
        get_string(country_name);
        get_bcd(country_access);
        c->cname = allocate(strlen(country_name)+1);
        strcpy(c->cname,country_name);
        c->access = allocate(strlen(country_access)+1);
        strcpy(c->access,country_access);
        c->country = n;
    }
    else
    {
        c->cname = c->access = NULL;
        c->country = nc + StartIndex;
    }
    get_string(city_name);
    c->name = allocate(strlen(city_name)+1);
    strcpy(c->name,city_name);
    get_bcd(city_prefix);
    c->prefix = allocate(strlen(city_prefix)+1);
    strcpy(c->prefix,city_prefix);

    c->offset_hours = ((double) getn(12)) / 60.0;

    next();                                 /* flush an unused bit */
    c->w_lon = ((double) getn(12)) * C2D;
    c->n_lat = ((double) getn(11)) * C2D;
    c->dst_zone = get_character();
}
/*
static void show_entry(CITY *c)
{
    CITY *cc;

    cc = &cities[c->country];
    printf("\n%s %s (%s %s) %g %c %g %g",
        c->name,
        cc->cname,
        c->prefix,
        cc->access,
        c->offset_hours,
        c->dst_zone,
        c->n_lat,
        c->w_lon);
}
*/

/*alal extern */
int GetCityInfo(int StartIndex)
{
   short nent, n;

   fp = fopen("world.dat","rb");
   if (fp == NULL) fp = fopen("d:\\_sys\\world.dat", "rb");
   if (fp == NULL) sysabort("cannot open world.dat");

   nent = getn(16);
   if (nent > NC) sysabort("%d is invalid # entries",nent);
   for (n = StartIndex; n < nent + StartIndex; n++)  get_entry(n, StartIndex);
   return n;
}
