#ifndef __JULIAN_DATE__
#define __JULIAN_DATE__

#include <time.h>

void get_tm (struct tm *t);     /*  get current tm */
void print_tm (struct tm *t);   /*  print struct tm */
void sprint_tm (char *buf, struct tm *t);   /*  print struct tm */
double tm_to_jd (struct tm *t); /*  convert struct tm to Julian date */
double tm_to_jd2k (struct tm *t); /*  convert struct tm to Julian date */
double cal_to_jd (              /*  convert ymdhms to Julian */
    long year,
    int month,
    double day,
    double hour,
    double min,
    double sec
);
double tm_to_jd2k (struct tm *t); /*  convert struct tm to J2000 */
double cal_to_jd2k (              /*  convert ymdhms to J2000 */
    long year,
    int month,
    double day,
    double hour,
    double min,
    double sec
);
int print_jd (double J);        /*  print Julian date in calendar */
int print_jd2k (double J);        /*  print Julian date in calendar */
int alhms (double x);





void radec2topo (
    double ra,
    double dec,
    double lon,
    double lat,
    double j,
    double *alt,
    double *az
);

#endif
