BAT * Sample of advanced EBL-PLUS File I/O ...

-Top
  %N = "EBLDATA.TMP"        |* name of database file

        *
        * Define a window for text.
        *   Select both color and size (x/y coordinates).
        *
  CLS
  RAM                       |* Some systems need BIOS not RAM compatibility
  COLOR( black on cyan )
  WINDOW( 10, 1, 70, 8, Double)
  BEGTYPE

    This example shows we can create a simple data
    base from EBL-Plus. This shows how File I/O and
    SEEK() functions work in EBL-Plus.
END
  Color( normal)

        *
        * Start by finding out how many records are already saved
        *       in our simple database. For this example, our data
        *       is saved in records of 80 characters each. The SEEK()
        *       function here allows us to find out the number of
        *       characters (bytes) in the file. In that function, 'R'
        *       indicates the file we are presently Reading, and EOF
        *       indicates to report the characters from the start of the
        *       file to the End-Of-File (EOF).
        *
-Show
  <%N                        |* open the test file
  %I = SEEK( R,EOF)+79/80    |* How many 80 byte records?
  Window( 15, 7, 65, 9, Single)
  Type "Data base" %N "now contains" %I "records."
  <                          |* close the file

        *
        *    We will use COLORCHAR to "paint" each field where
        *    a selection bar can be placed. For variety, we will
        *    use different colors than before. Also note that we have
        *    chosen the @ character to paint with because other characters
        *    may be in our text that we will show.
        *
-Reqst
  Color( Black on Black)
  Window( 11, 12, 72, 18)
  COLORCHAR '@' as color(Cyan on Blue)
  Color( White on Blue)
  Window( 10, 11, 70, 16)
  TYPE
  TYPE "     Select one:"
  TYPE
  TYPE "     @Add a record@   @Display a record@   @Exit@"
  Color( Normal )

        *
        * Now use the SELECT() function to show moving bar. Note that the
        *    "field color" here must again match what was painted on the
        *    screen above.
        *
        * When the SELECT() function ends, there are two important
        *    pieces of information available.
        *      1. The function itself will have a value of the key used
        *         to make the selection. This is saved here in the
        *         variable %K.
        *      2. The %R return code variable will contain the "field
        *         number" where the bar is positioned. For this example,
        *         this is the easiest way to make a decision of what to do.
        *
    %K = SELECT( color(Cyan on Blue) )    |* Ask for selection

        *
        * Now we will hold the resulting "field number" in %0 for convenience.
        *
    %0 = %R

        *
        * Based on this information, we will choose which command to execute.
        * Like BATDEMO3, we will use a computed-GOTO to decide which
        *    choice to make. Remember from above, %0 now contains the field
        *    number of the selection.
        *
  IF %K = ESC then EXIT                 |* exit if certain keys are pressed.
  TYPE
  TYPE
  goto -Cmd.%0       |* goto routine to handle request

        *
        * This section adds a record to the database. Adding information
        * is started by opening a file for 'appending'. This is done so
        * the existing contents is kept while new information is being
        * written into the file. Although the data can be added at any
        * record, we will always add it to the end of the database in this
        * example.
        *
        * First, build a window to request the data to be saved.
        *
-Cmd.1
  COLORCHAR '@' as color(white on Cyan)
  Color( White on Blue)
  Window( 11, 12, 71, 17)
  TYPE
  TYPE "Enter data to be saved:"
  TYPE
  TYPE "@                                                        @"
  EDIT( color(white on cyan), Enter)
  %A = strip(Field(1))
  IF %A = "" then GOTO -reqst

        *
        * Then put the data into the file.
        *
  >>%N               |* append to write (not create)
  seek(W,(%I * 80))  |* seek to next available record
  type left(%A,78)   |* write 78 chars max + CR/LF into rec
  >                  |* close file
  goto -show

        *
        * This section displays a record's contents. First find out
        * which record number is desired.
        *
-Cmd.2
  COLORCHAR '@' as color(white on Cyan)
  Color( White on Blue)
  Window( 11, 12, 71, 17)
  IF %I < 1 THEN
    THEN TYPE "No records have been stored yet!"| TYPE
    THEN TYPE 'Press < then select "Add a record";'| READ
    THEN GOTO -reqst
  TYPE "Record numbers 1 to" %I "are available."
  TYPE "Which record to display? @@"
  EDIT( color(white on cyan), Enter)
  %A = strip(Field(1))
  IF %A = "" then GOTO -reqst

        *
        * Then open the file for reading, SEEK() to the requested
        * record number, display it, and close the file.
        *
 <%N                      |* open to read file
 seek( R, (%A - 1 * 80) ) |* go to requested record
 read.parsed %0
 <                        |* and close file

 color( Yellow on blue )
 window( 12, 15, 72, 18, Single)
 IF %0 = ^Z then %0 = "(nothing saved in record " & %A & "!)"
 Type left(%0,55)         |* show window's portion of this record
 Color( White on Blue)
 TYPE "  (Press < to continue..);"
 READ
 Goto -Reqst

*
* The third field in the main menu allows the user to Exit to DOS.
*
-Cmd.3  Exit


*
*       Errors that EBL-Plus finds will come here. In this case,
*       we will create the database file if it is not found. Other
*       errors will be unexpected and reported to the user before
*       ending this application.
*
-on.error-                      |* errors come here
 If %R = 33 then skip 1
 If %R <> 32 then goto -err2    |* on file not found:
    Type "Creating new database..."
    >%N                         |* create empty file
    >                           |*    (1st time only)
    Resume (%L-1)               |* return to open error
-err2
 IF %R = 7 then Resume -Top     |* Reset menu if user entry error
 Type "Unexpected error" %R "in line" %L
 Exit
