bat * Sample of advanced user interface features in EBL-Plus.......

	*
	* Define a window for text.
	*   Select both color and size (x/y coordinates).
	*
	color( white on blue )
	window( 20, 5, 70, 11)

	*
	* Put some text within the window
	*   Define a special character '#' to paint a color within
	*   the text. This color will be used later as a "Field"
	*   to allow user input
	*
	colorchar '#' as color(white on cyan)
	type "Welcome to another EBL-Plus Demo"
	type "This is a sample of an advanced user interface"
	type
	type "Enter your nickname and press "
	type "          #      #"

	*
	* Erase any association between the special character '#'
	*    and a color just in case we use the character for real
	*    text later.
	*
	colorchar

	*
	* Now allow user input in the painted "field".
	*    Note that the color name must match what was painted
	*    above for this to work. Also, the "enter" key can return
	*    to EBL in addition to any function key, ESC key, etc.
	*    If "enter" wasn't used here, that key would just move
	*    the cursor between fields if several were defined and
	*    never return back to EBL.
	*
	edit( color(white on cyan ),Enter)

	*
	* Now read the contents back from this first (and only) field.
	*    By default, it will look for text on the screen that is
	*    in the field color used within the last Edit() definition
	*    above.
	*
	%n = field(1)

	*
	* Use a few string functions to force first letter of nickname
	*    as upper case, and remainder as lower case.
	*
	%n = upper((%n $ 1 1)) & lower((%n $ 2))

	*
	* Now convert the simple menu on page 15 of the EBL manual
	*    to a "point and shoot" interface. That is, the cursor
	*    keys "points" a moving bar to the item to select and
	*    the enter key "shoots" that item and starts the selection.
	*    The previous interface only allowed numbers 1..4 to
	*    be entered to select each item.
	*
	* Start by simplifying the color scheme since we won't use
	*    windows here.
	*
BAT * Eva's EBL program...
	color( bright white on black )

	*
	* Again, we will use COLORCHAR to "paint" each field where
	*    the selection bar can be placed. For variety, we will
	*    use different colors than before. Also note that we have
	*    chosen the @ character to paint with because other characters
	*    may be in our text that we will show.
	*
-Menu	colorchar '@' as color(white on Blue)
	Cls
	Color( Black on Cyan )
	window( 50, 2, 79, 8, Single)
	Begtype
This is a variation
of an existing menu
shown on page 15 of
the printed EBL-Plus
manual.
END
	*
	* Now show the menu, carefully putting the @ character where
	*    we want each possible selection bar to go. This is called
	*    our "field color".
	*
	Color( Yellow on blue)
	window( 1, 1, 45, 11)
	Begtype 	      |* Show the menu
      \%n's Document Menu

  @1 - Create/Edit a document	      @
  @2 - Print a document 	      @
  @3 - Display directory of documents @
  @4 - Exit			      @

  Use arrow keys to select an option
      and press < to make choice.
END
	*
	* Now use the SELECT() function to show moving bar. Note that the
	*    "field color" here must again match what was painted on the
	*    screen above.
	*
	* When the SELECT() function ends, there are two important
	*    pieces of information available.
	*      1. The function itself will have a value of the key used
	*	  to make the selection. In our example here, it is not
	*	  necessary to know this. If it was needed, it is wise to
	*	  hold this value in a variable like:
	*		%A = SELECT( color(white on blue) )
	*      2. The %R return code variable will contain the "field
	*	  number" where the bar is positioned. For this example,
	*	  this is the easiest way to make a decision of what to do.
	*
    SELECT( color(white on Blue) )    |* Ask for selection

	*
	* Now we will hold the resulting "field number" in %0 to make the
	*    remainder of this example exactly like it already is on page 15
	*    of the EBL-Plus manual. (This step really isn't necessary)
	*
    %0 = %R

	*
	* Also, we will do a LOCATE command since the SELECT() function
	*    moved the cursor position to be the same as the bar position.
	*    Since we have some possible questions to ask the user below,
	*    we will move the cursor to a clear area away from the bar
	*    for clarity.
	*
    Locate 1 14
    Color( White )

	*
	* Now the remainder of the batch file is unchanged from page 15...
	*
    IF %0 <> 1 GOTO -N1 	|* If edit option..
    READ Enter document name> %1|* which file?
    Begtype

We will use EDLIN to edit your document.
If you want to use this batch file extensively,
   we suggest you change the name 'Edlin' within this
   batch file to the name of the editor you are
   familiar with.
To exit EDLIN, press 'Q' and Enter.
End
    Edlin %1
    Inkey Press any key to continue...
    GOTO -Menu			|* EDIT then return

-N1
    IF %0 <> 2 GOTO -N2 	|* If Print option...
    READ Which document to print> %1 |* Which file?
    LEAVE
    PRINT %1
    BAT
    GOTO -Menu			|* PRINT then return

-N2
    IF %0 <> 3 GOTO -N3 	|* If Directory...
    READ Which documents to show? %1 |* Which files?
    DIR  %1 /P
    PAUSE
    GOTO -Menu			|* DIR then return

-N3
    IF %0 = 4 EXIT		|* Exit this menu?
    BEEP			|* No, beep & return
    GOTO -Menu
