/*   qvremote.h    -- for QVRemote.exm
 *                                          Toshiki
 *                                          <toshiki@j.email.ne.jp>
 */

/* Control codes */
#define	STX	0x02
#define	ETX 0x03
#define	ENQ	0x05
#define	ACK	0x06
#define	DC2	0x12
#define	NAK	0x15
#define	ETB	0x17

#define ENTERKEY	0x0D
#define ESCKEY		0x1B

/* for COM I/O */

#define COM_BR_9600		0x0C
#define COM_BR_19200	0x06
#define COM_BR_38400	0x03
#define COM_BR_57600	0x02
#define COM_BR_115200	0x01

#define COM_RESET_TXB	0x02
#define COM_RESET_RXB	0x04


/* Misc additions */ 
#define XY_CENTER(w,h) ((640-w)/2),((200-h)/2),(w),(h)

/* Parameters for function DisplayPic() */
#define DISPLAY_NORMAL 0
#define DISPLAY_CUSTOM 1

/* Parameters for function NextScreen() */
#define NEXT_FORWARD 1
#define NEXT_BACKWARD 0

/* Bit mask for picture attribute */
#define PIC_PROTECT	1
#define PIC_FINE	2

/* Bit Mask for SaveFormat */
#define SAVE_THUMBNAIL	0x01
#define SAVE_JPEG		0x02
#define SAVE_JPEG_FINE	0x04
#define SAVE_YCC		0x10
#define SAVE_YCC_FINE	0x20

/* Constants: SaveAsOption */
#define SAVE_CURRENT 1
#define SAVE_ALL 2
#define SAVE_RANGE 3

/* Constants: LxPicOption */
#define VIEW_SINGLE 1
#define VIEW_VOLUME 2
#define VIEW_ALL 3

/* Constants: TransferBR */
#define QV_BR_9600  47
#define QV_BR_19200 23
#define QV_BR_38400 11
#define QV_BR_57600  7
#define QV_BR_115200 3

/* Parameters for DownToFIle() */
#define FIRST_PACKET 1
#define NORMAL_DOWN 2
#define BURST 3

/* Constants: DelPic */
#define DEL_CURRENT			1
#define DEL_ALL_UNPROTECT	2
#define DEL_ALL_ABSOLUTE	3

/* Bit mask for SwStat() */
#define RELEASE_BUTTON  0x0001
#define ZOOM_BUTTON     0x0002
#define MODE_BUTTON     0x0004
#define DISP_BUTTON     0x0008
#define DEL_BUTTON      0x0010
#define PROTECT_BUTTON  0x0020
#define SWITCH_POSITION 0x0040
#define LENS_DIRECTION  0x0080
#define PLUS_BUTTON     0x0400
#define MINUS_BUTTON    0x0800
#define TOO_BRIGHT      0x8000
#define TOO_DARK        0x4000

/* SnapSaveOption and DoSnapSaveAs */
#define DELELE_AFTER_SAVE 0x01
#define SAVE_TO_OTHER_FILE 0x02

#define SAVE_TO_NORMAL (0)
#define SAVE_TIMESTAMP (1)
#define SAVE_TO_FIXED_FILE (2)


/* misc labels */
#define	UNKNOWN	"" 
#define NOCONNECT "[ NO CONNECTION ]"
#define CONNECTING "Connecting ..."
#define CONNECT_SOUND "L64CE"
#define DISCONNECT_SOUND "L64EC"
#define FIXED_SAVE_FILENAME "SNAP.JPG"

/* misc settings */
#define DOWN_MAX_RETRY (8)
#define RCV_MAX_RETRY (60)
#define RCV_RETRY_INTERVAL (5)
#define DISP_CYCLE (12)
#define SNAP_SAVE_MAX_RETRY (5)
#define QV10_PRESNAP_IDLE (90)
#define QV10_POSTSNAP_IDLE (300)
#define QV100_PRESNAP_IDLE (200)
#define QV100_POSTSNAP_IDLE (250)
#define LOW_BATT 0x3E   /* 3.88 V */

/* USER COMMANDS */
#define CMD_DELETE (CMD_USER+0)

/* Error codes */
#define ERR_NOCONNECT	0x0100
#define ERR_PORTOPEN	0x0010
#define ERR_SENDBYTES	0X0020
#define ERR_RCVBYTES	0x0030
#define ERR_RCVTIMEOUT	0x0040
#define ERR_HELLO	0x0050
#define ERR_CHECKSUM	0x0060

/* return code from GetOneBlock */
#define ERR_STX (0x0070)
#define ERR_RETRY (0x0080)
#define TRANSFER_DONE (1)
#define GET_OK (0)

/* Picture sizes */
#define	THUMBNAIL_WIDTH		52
#define	THUMBNAIL_HEIGHT	36
#define	PICTURE_WIDTH		480
#define	PICTURE_HEIGHT		240
#define	PICTURE_WIDTH_FINE		640
#define	PICTURE_HEIGHT_FINE		480

/* === QV Commands === */

typedef struct QVCMDs {
 UCHAR	*CmdStr;
 int	ParamBytes;
 int	RcvBytes;
} QVCMD;

QVCMD QVResetNormal =		{ "QR",0,0 };
QVCMD QVResetNoCls = 		{ "QE",0,0 };
QVCMD HowManyPics = 		{ "MP",0,1 };
QVCMD ShowPicNormal  = 		{ "DA",1,0 };	/* frame no */
QVCMD PrepareDownload = 	{ "DL",0,0 };
QVCMD SendJpeg = 			{ "MG",0,0 };
QVCMD SendJpegFine = 		{ "Mg",0,0 };
QVCMD SendThumbnail = 		{ "MK",0,0 };
QVCMD SendBitmap = 			{ "ML",0,0 };
QVCMD SendBitmapFine = 		{ "Ml",0,0 };
QVCMD ReadJpeg = 			{ "MH",0,0 };
QVCMD ReadBitmap = 			{ "MM",0,0 };
QVCMD EndOfUpload = 		{ "DJ",0,0 };  /* ? */
QVCMD EndOfBitmapUpload = 	{ "DN",0,0 };
QVCMD DeleteFrame = 		{ "DF",2,0 };  /* (FRAME NO) 0xff */
QVCMD ReleaseButton = 		{ "DR",0,1 };  /* RESULT=15 (play pos) or 06 */
QVCMD ChangeBaud = 			{ "CB",1,0 };
QVCMD CopyToMoveBuf = 		{ "DI",1,0 };  /* Frame No */
QVCMD CopyToMoveBuf2 = 		{ "DY",2,0 };  /* (0x02) (Frame No) */
QVCMD InsertFromMoveBuf = 	{ "Dj",1,0 };
QVCMD QVExit = 				{ "QX",0,0 };
QVCMD GetBatteryVoltage = 	{ "RB",4,1 };  /* 05  FF  FE  E6 (READ BINARY?) */
QVCMD ShowColorBars = 		{ "DP",0,0 };
QVCMD ShowBlankScreen = 	{ "DO",0,0 };
QVCMD GetSwStatus = 		{ "DS",1,2 };  /* 0x02 */
QVCMD SetPicProtection = 	{ "DY",2,0 };  /* (0=NoProt or 1=Prot) (Frame) */
QVCMD GetPicAttribute = 	{ "DY",2,1 };  /* (2=REPORT) (Frame) */
QVCMD SetBlockSize = 		{ "PP",2,0 };
QVCMD SetDefaultPic = 		{ "DV",1,0 };
QVCMD GetMachineID = 		{ "SU",0,4 };
QVCMD GetRemain = 			{ "EB",0,1 };
QVCMD GetRemainFine = 		{ "Eb",0,1 };
QVCMD GetPicSize = 			{ "MQ",0,2 };  /* ? */
QVCMD GetPicSizeFine = 		{ "Mq",0,8 };  /* ? */
QVCMD ShowPicIn4 = 			{ "DB",4,0 };
QVCMD ShowPicIn9 = 			{ "DC",9,0 };
QVCMD HidePicNumber = 		{ "DM",0,0 };
QVCMD DeleteAll = 			{ "DD",0,0 };
QVCMD DeleteAllUnprotected =	{ "DE",0,0 };
QVCMD DisableAutoShutdown =	{ "DU",0,0 };

/* Command Parameters (offset=2 in TxBuf) */
#define PARAM(x) TxBuf[x+2]

/* === QV ID-Type Look-up Table === */

typedef struct QVTYPEs {
 long	IDMask;
 long	IDValue;
 UCHAR	*Name;
 BOOL	QV100;
} QVTYPE;

QVTYPE QVTypeList[] = {
 { 0xFFFFFF00, 0x00531700,"10",FALSE },
 { 0xFFFFFF00, 0x00538B00,"10",FALSE },
 { 0xFFFF0000, 0x01030000,"100",TRUE },
 { 0xFFFF0000, 0x01040000,"100",TRUE },
};
