/*
 * QVRemote.exm
 * Ver 0.9
 * written by Toshiki <toshiki@j.email.ne.jp>
 */

#define QVREMOTE_VERSION "0.9"

#include    "lxapi.h"
#include    "qvremote.h"
#include    "bmpjpeg.h"
#include    <stdlib.h>


/* === Global Variables === */

int SaveOrig=0;
BOOL SilentMode=FALSE;

int  TxLength,RxLength,ComHandle, ComPort=1;
int  SplitModeTmp, SplitMode=1; /* 1(=Normal), 4 or 9 */
UCHAR    RxBuf[128],TxBuf[128];
ComSettings_t  ComSettings;
BOOL ConnectOK=FALSE, ShowPicNumber=TRUE, IsQV100=FALSE,
     BatteryLow=FALSE, NoAutoPowerOff=FALSE;
char *ErrMsg;
char ConnectStatStr[20]=NOCONNECT,
     CameraIDStr[10]=UNKNOWN,SwStatStr[10]=UNKNOWN,
     SwStatStr1[40]=UNKNOWN, SwStatStr2[50]=UNKNOWN,
     FilmUsedStr[16]=UNKNOWN, RemainStr[16]=UNKNOWN,
     CameraType[8]=UNKNOWN,
     CurrentFrameStr[6],SplitModeStr[20],
     VoltageStr[16], PicSizeStr[30], GoToBuf[4],MoveToBuf[4],
     VolBuf[6], NoBuf[4], FromBuf[4], ToBuf[4], SetDefBuf[4],
     ViewVolBuf[6], FrameListStr[9][4], SaveDir[64],
     FileTransferNumStr[20], FileTransferStatusStr[30],
     FileTransferProgressStr[20], OutFileStr[80];
UCHAR L[THUMBNAIL_WIDTH];
char Cb[THUMBNAIL_WIDTH/2];
char Cr[THUMBNAIL_WIDTH/2];

int SwStatCode, MaxFrame, CurrentFrame, CameraTypeCode,
    VoltageInHex, PicAttributeCode, FrameList[9],
    SaveFormat=SAVE_JPEG, SaveAsOption=SAVE_CURRENT,
    LxPicOption=VIEW_SINGLE, TransferBR=QV_BR_9600, SaveFrame,
    DelPicAction=0, SetProtectTo, DisplayCycle=0, SnapSaveOption,
    SnapSaveFile, SnapSaveCycle;
long CameraIDCode, RcvBytes=0L;
FILE InFile, OutFile;

/* == Events == */
EVENT  app_event;
LHAPIBLOCK  LHAPIData;
BOOL  Done;

/* == FAR STRINGS === */
char far *msgnull=  "";
char far *msgAppName=   "QVRemote";
char far *msgTitle= 	"QVRemote " QVREMOTE_VERSION 
						"   \020 QV-10/100 Remote Console \021";
char far *msg_About=	"&About QVRemote";
char far *msgAbout=		"About This Program";
char far *msgAboutMsg=	"Built on " __TIME__ " " __DATE__ ".\n"
			"Copyright (c) Toshiki <toshiki@j.email.ne.jp>.\n"
			"Based on QVplay by Ken-ichi Hayashi and itojun. "
			"QVRemote is a copyrighted freeware. Please refer to "
			"QVREMOTE.DOC for its copyright notices and distribution policy.";
char far *msgMessage=   "Message";
char far *msgStatus=    "Status";
char far *msgStatus_=   "Status:";
char far *msgProgress_= "Progress:";
char far *msgQuit=      "Quit";
char far *msg_Quit=     "&Quit";
char far *msg_Help=     "&Help";
char far *msgE_xit=     "E&xit";
char far *msgSave_As=   "Save &As";
char far *msgSaveAs=    "Save As";
char far *msgRunLxPic=  "&Run LxPic";
char far *msg_File=     "&File";
char far *msg_View=     "&View";
char far *msg_Option=   "&Option";
char far *msg_Reset=    "&Reset";
char far *msg_Action=   "&Action";
char far *msg_Normal=   "&Normal";
char far *msgSplitIn_4= "Split in &4";
char far *msgSplitIn_9= "Split in &9";
char far *msg_Custom=   "&Custom";
char far *msg_ShowNumber=   "&Show Number";
char far *msg_Protection=   "&Protection";
char far *msg_Delete=   "&Delete";
char far *msg_Move=     "&Move";
char far *msg_Other=    "&Other";
char far *msgSet_Default=   "Set &Default";
char far *msgSetDefault=    "Set Default Frame";
char far *msgOtherOption=    "Other Options";
char far *msgSilentMode=    "&Suppress Connect Sound";
char far *msgMovePic=   "Move Current Picture to ...";
char far *msgDelete=    "Delete";
char far *msg_Directory=        "&Directory";
char far *msg_Communication=    "&Communication";
char far *msgEnterFrame =   "Enter Frame No.";
char far *msgDisp=      "DISP";
char far *msgMode=      "MODE";
char far *msgProtect=   "PROTECT";
char far *msgGoTo=      "GoTo";
char far *msgOK=        "OK";
char far *msgCancel=    "Cancel";
char far *msg_Cancel=   "&Cancel";
char far *msgNo=        "No.";
char far *msgConnect=   "Connect";
char far *msgDisconn=   "Disconn";
char far *msgSnap=      "Snap";
char far *msg_Snap=     "&Snap";
char far *msgSnap_Sa_ve=     "Snap+Sa&ve";
char far *msgDeleteAfterSave=    "&Delete after Snap+Save";
char far *msgSnapSaveFile= "Set Snap+Save filename to";
char far *msgSnapJpg= "&Fixed (" FIXED_SAVE_FILENAME ")";
char far *msgTimeStamp= "&Time Stamp";
char far *msgPower_Off= "Power &Off";
char far *msgNoPowerOff=	"Disable &Automatic Power Off";
char far *msgCameraID=  "Camera ID:";
char far *msgBattery=   "Battery:";
char far *msgSwitchCode="Switch Code:";
char far *msgUsed=      "Used:";
char far *msgRemain=    "Remain:";
char far *msgPictureSize=   "Picture Size:";
char far *msgCurrentFrame=  "Current:";
char far *msgProtectPic=    "Protection";
char far *msgSetProt=       "Set protection";
char far *msgClearProt=     "Clear protection";
char far *msgDelPic=        "Delete Image Data in QV";
char far *msgDelCurrent=    "Delete Current &Picture";
char far *msgDelAllUnprot=  "Delete All &Unprotected Pictures";
char far *msgDelAll=        "Delete &All Pictures";
char far *msg_Colorbar=     "&Color bars";
char far *msgVol=           "Vol:";
char far *msgThumb=     "Save &thumbnail image";
char far *msgJpeg=      "Save image in &JPEG format";
char far *msgSaveRaw=  		"Save &raw image data";
char far *msgSaveCurrent=   "Save &Current Picture";
char far *msgSaveAll=   "Save &All Pictures";
char far *msgSaveFrom=  "Save Pictures &from";
char far *msgTo=        "to";
char far *msgLaunchLxPic=   "Launch LxPic for viewing ...";
char far *msgSinglePicture="&Single Picture";
char far *msgCurrentVolume= "All Pictures in this &Volume";
char far *msgAllPicture=    "&All Pictures";
char far *msgStorageDirectory=  "Storage Directory";
char far *msgBaudRate   ="Baud Rate";
char far *msg9600   ="9600";
char far *msg19200  ="19200";
char far *msg38400  ="38400";
char far *msg57600  ="57600";
char far *CfgFile ="C:\\_DAT\\QVREMOTE.CFG";
char far *RxBufPtr=RxBuf;
char far *TxBufPtr=TxBuf;
char far *TxLengthPtr=(char *)&TxLength;
char far *RxLengthPtr=(char *)&RxLength;
char far *ComSetPtr=(char *)&ComSettings;

/* == END FAR STRINGS === */

/* === STRING TABLE === */
char far **StringTable[]={
  &msgnull,
  &msgAppName,
  &msgTitle,
  &msg_About,
  &msgAbout,
  &msgAboutMsg,
  &msgMessage,
  &msgStatus,
  &msgStatus_,
  &msgProgress_,
  &msgQuit,
  &msg_Quit,
  &msg_Help,
  &msgE_xit,
  &msgSave_As,
  &msgSaveAs,
  &msgRunLxPic,
  &msg_File,
  &msg_View,
  &msg_Option,
  &msg_Reset,
  &msg_Action,
  &msg_Normal,
  &msgSplitIn_4,
  &msgSplitIn_9,
  &msg_Custom,
  &msg_ShowNumber,
  &msg_Protection,
  &msg_Delete,
  &msg_Move,
  &msg_Other,
  &msgSet_Default,
  &msgSetDefault,
  &msgOtherOption,
  &msgSilentMode,
  &msgMovePic,
  &msgDelete,
  &msg_Directory,
  &msg_Communication,
  &msgEnterFrame,
  &msgDisp,
  &msgMode,
  &msgProtect,
  &msgGoTo,
  &msgOK,
  &msgCancel,
  &msg_Cancel,
  &msgNo,
  &msgConnect,
  &msgDisconn,
  &msgSnap,
  &msg_Snap,
  &msgSnap_Sa_ve,
  &msgDeleteAfterSave,
  &msgSnapSaveFile,
  &msgSnapJpg,
  &msgTimeStamp,
  &msgPower_Off,
  &msgNoPowerOff,
  &msgCameraID,
  &msgBattery,
  &msgSwitchCode,
  &msgUsed,
  &msgRemain,
  &msgPictureSize,
  &msgCurrentFrame,
  &msgProtectPic,
  &msgSetProt,
  &msgClearProt,
  &msgDelPic,
  &msgDelCurrent,
  &msgDelAllUnprot,
  &msgDelAll,
  &msg_Colorbar,
  &msgVol,
  &msgThumb,
  &msgJpeg,
  &msgSaveRaw,
  &msgSaveCurrent,
  &msgSaveAll,
  &msgSaveFrom,
  &msgTo,
  &msgLaunchLxPic,
  &msgSinglePicture,
  &msgCurrentVolume,
  &msgAllPicture,
  &msgStorageDirectory,
  &msgBaudRate,
  &msg9600,
  &msg19200,
  &msg38400,
  &msg57600,
  &CfgFile,
  &RxBufPtr,
  &TxBufPtr,
  &TxLengthPtr,
  &RxLengthPtr,
  &ComSetPtr
};
/* === END STRING TABLE === */


/* === PROTOTYPES === */

int far CustomViewHandler(PLHWINDOW, WORD, WORD, WORD,...);
void far Test(void);
void far DoAllReset(void);
void far DoQuit(void);
void far DoNothing(void);
void far DoSplit1(void);
void far DoSplit4(void);
void far DoSplit9(void);
void far SwitchMode(void);
void far SwitchProtect(void);
void far DoConnect(void);
void far Refresh(void);
void far DoDisconnect(void);
void far OpenGoToDialog(void);
void far DoCustomView(void);
void far OpenSaveAsDialog(void);
void far SetMenuFKey(void);
int far SnapShot(void);
void far SnapSave(void);
void far ShowStat(void);
void far GetStat(void);
void far ToggleShowNumber(void);
void far OpenSetDefaultDialog(void);
int far HelloQV(void);
void far OpenDelPicDialog(void);
void far OpenProtectPicDialog(void);
void far OpenLxPicDialog(void);
void far OpenDirOptionDialog(void);
void far DoComOption(void);
void far OpenMovePicDialog(void);
void far OpenFileTransferDialog(void);
void far CloseFileTransferDialog(void);
void far ShowFileTransferStat(void);
void far ToggleAutoPowerOff(void);
void far DoPowerOff(void);
void far DoColorBar(void);
void far OpenOtherOptionDialog(void);
void far OpenAboutDialog(void);
int far CloseOpen(PLHWINDOW, WORD, WORD, WORD,...);
int DownToFile (FILE *fd, int mode, long length);
int GetOneBlock(int *);
int Download(int,int);
void GetSaveFilename(char *, int, int);
UCHAR Norm(long);
int MakeThumbnail(char *, char *);
void SetConnectStatStr(void);
int far snd(int);
int far rcv(int);
int SndCmd(QVCMD);
int HowMany(void);
void GetAttribute(void);
void GetRemainFrames(void);
void WaitASecond(void);
void NextScreen(int);
void DisplayPic(int);
void SetFrameTo(int);
void UpdateFrameNumber(void);
void SetSplitModeTo(int);
void SetBoxSize(int);
void SetPicProtectionTo(int);
void DisconnectCleanUp(void);
void Pause(int);
void ComInit(void);
void ComSetDefault(void);
int ChangeBaudRate(int);
void GetPictureSize(void);
void BatteryCheck(void);
void DisableAutoPowerOff(void);
void TimeStamp(char *);

/* === END PROTOTYPES === */

/* LH Window structures */

/* Function Keys */

LHFKEY MainFKeys[]= {
 {(PLHRES)&msgnull,(PLHFUNC)Test,FKEY_SHIFT+1,0},
 {(PLHRES)&msgConnect,(PLHFUNC)DoConnect,9,0},
 {(PLHRES)&msgQuit,(PLHFUNC)DoQuit,10+FKEY_LAST,0}
};
LHFKEY MainFKeys2[]= {
 {(PLHRES)&msgGoTo,(PLHFUNC)OpenGoToDialog,4,0},
 {(PLHRES)&msgProtect,(PLHFUNC)SwitchProtect,5,0},
 {(PLHRES)&msgDisp,(PLHFUNC)ToggleShowNumber,6,0},
 {(PLHRES)&msgMode,(PLHFUNC)SwitchMode,7,0},
 {(PLHRES)&msgStatus,(PLHFUNC)Refresh,8,0},
 {(PLHRES)&msgDisconn,(PLHFUNC)DoDisconnect,9,0},
 {(PLHRES)&msgSnap,(PLHFUNC)SnapShot,10+FKEY_LAST,0}
};

LHFKEY OKCancelFKeys[]= {
 {(PLHRES)&msgCancel,(PLHFUNC)CMD_ESC,9,FKEY_SENDMSG},
 {(PLHRES)&msgOK,(PLHFUNC)CMD_DONE,10+FKEY_LAST,FKEY_SENDMSG}
};

LHFKEY DeleteFKeys[]= {
 {(PLHRES)&msgDelete,(PLHFUNC)CMD_DELETE,8,FKEY_SENDMSG},
 {(PLHRES)&msgCancel,(PLHFUNC)CMD_ESC,10+FKEY_LAST,FKEY_SENDMSG}
};

LHFKEY OKFKeys[]= {
 {(PLHRES)&msgOK,(PLHFUNC)CMD_DONE,10+FKEY_LAST,FKEY_SENDMSG}
};

/* === Menu === */

LHMENU ViewOtherMenu[]= {
 {(PLHRES)&msg_Colorbar,(PLHFUNC)DoColorBar,0,0},
 {0,0,0,0}
};


LHMENU FileMenu[]= {
 {(PLHRES)&msgSave_As,(PLHFUNC)OpenSaveAsDialog,0,MENU_ELLIPSIS},
 {(PLHRES)&msgRunLxPic,(PLHFUNC)OpenLxPicDialog,0,MENU_ELLIPSIS},
 {(PLHRES)&msgE_xit,(PLHFUNC)DoQuit,0},
 {0,0,0,0}
};

LHMENU ViewMenu[]= {
 {(PLHRES)&msg_Normal,(PLHFUNC)DoSplit1,0,0},
 {(PLHRES)&msgSplitIn_4,(PLHFUNC)DoSplit4,0,0},
 {(PLHRES)&msgSplitIn_9,(PLHFUNC)DoSplit9,0,0},
 {(PLHRES)&msg_Custom,(PLHFUNC)DoCustomView,0,MENU_ELLIPSIS},
 {(PLHRES)&msg_ShowNumber,(PLHFUNC)ToggleShowNumber,0,MENU_CHECKED},
 {(PLHRES)&msg_Protection,(PLHFUNC)OpenProtectPicDialog,0,
  MENU_BARBEFORE|MENU_ELLIPSIS},
 {(PLHRES)&msg_Move,(PLHFUNC)OpenMovePicDialog,0,MENU_ELLIPSIS},
 {(PLHRES)&msg_Delete,(PLHFUNC)OpenDelPicDialog,0,MENU_ELLIPSIS},
 {(PLHRES)&msg_Other,(PLHFUNC)ViewOtherMenu,0,
  MENU_BARBEFORE|MENU_PULLDOWN},
 {0,0,0,0}
};

LHMENU ActionMenu[]= {
 {(PLHRES)&msgSet_Default,(PLHFUNC)OpenSetDefaultDialog,0,MENU_ELLIPSIS},
 {(PLHRES)&msg_Snap,(PLHFUNC)SnapShot,0,0},
 {(PLHRES)&msgSnap_Sa_ve,(PLHFUNC)SnapSave,0,0},
 {(PLHRES)&msgPower_Off,(PLHFUNC)DoPowerOff,0,0},
 {(PLHRES)&msg_Reset,(PLHFUNC)DoAllReset,0,MENU_INVISIBLE},
 {0,0,0,0}
};

LHMENU OptionMenu[]= {
 {(PLHRES)&msg_Directory,(PLHFUNC)OpenDirOptionDialog,0,MENU_ELLIPSIS},
 {(PLHRES)&msg_Communication,(PLHFUNC)DoComOption,0,MENU_ELLIPSIS},
 {(PLHRES)&msg_Other,(PLHFUNC)OpenOtherOptionDialog,0,MENU_ELLIPSIS},
 {0,0,0,0}
};

LHMENU HelpMenu[]= {
 {(PLHRES)&msg_About,(PLHFUNC)OpenAboutDialog,0,MENU_ELLIPSIS},
 {0,0,0,0}
};


LHMENU MainMenu[]= {
 {(PLHRES)&msg_File,(PLHFUNC)FileMenu,0,MENU_PULLDOWN},
 {(PLHRES)&msg_View,(PLHFUNC)ViewMenu,0,MENU_PULLDOWN},
 {(PLHRES)&msg_Action,(PLHFUNC)ActionMenu,0,MENU_PULLDOWN},
 {(PLHRES)&msg_Option,(PLHFUNC)OptionMenu,0,MENU_PULLDOWN},
 {(PLHRES)&msg_Quit,(PLHFUNC)DoQuit,0},
 {(PLHRES)&msg_Help,(PLHFUNC)HelpMenu,0,MENU_PULLDOWN},
 {0,0,0,0}
};

/* Datetime & Title Windows */

LHWINDOW TDateTime = {
    DateTime,0,0,0,0,
    0,0,0,STYLE_DATETIME|STYLE_NOFOCUS,
    NULL,PARENT_FKEYS,PARENT_MENU,NO_HELP};

LHWINDOW MainTitle = {
    TitleBar,0,0,0,0,
    (PLHRES)&msgTitle,0,0,STYLE_NOFOCUS,
    NULL,PARENT_FKEYS,(PLHMENU)&TDateTime,NO_HELP};


/* === Main === */

int far MainHandler(PLHWINDOW, WORD, WORD, WORD,...);

LHWINDOW MainArray[]={
 {  StaticText, 15, 10, 20, 1,						/* 0 */
    (PLHRES)&msgStatus_, (PLHDATA)ConnectStatStr, 0,
    STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
 {  StaticText, 350, 10, 9, 1,						/* 1 */
    (PLHRES)&msgCameraID, (PLHDATA)CameraIDStr, 0,
    STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
 {  StaticText, 15, 27, 5, 1,						/* 2 */
    (PLHRES)&msgSwitchCode, (PLHDATA)SwStatStr, 0,
    STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
 {  StaticText, 350, 27, 15, 1,						/* 3 */
    (PLHRES)&msgBattery, (PLHDATA)VoltageStr, 0,
    STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
 {  StaticText, 65, 44, 40, 1,						/* 4 */
    (PLHRES)&msgnull, (PLHDATA)SwStatStr1, 0,
    STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
 {  StaticText, 65, 61, 50, 1,						/* 5 */
    (PLHRES)&msgnull, (PLHDATA)SwStatStr2, 0,
    STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
 {  StaticText, 15, 95, 20, 1,						/* 6 */
    (PLHRES)&msgUsed, (PLHDATA)FilmUsedStr, 0,
    STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
 {  StaticText, 15, 112, 20, 1,						/* 7 */
    (PLHRES)&msgRemain, (PLHDATA)RemainStr, 0,
    STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
 {  StaticText, 15, 129, 30, 1,						/* 8 */
    (PLHRES)&msgPictureSize, (PLHDATA)PicSizeStr, 0,
    STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
 {  StaticText, 15, 146, 6, 1,						/* 9 */
    (PLHRES)&msgCurrentFrame, (PLHDATA)CurrentFrameStr, 0,
    STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
 {  StaticText, 175, 146, 15, 1,						/* 10 */
    (PLHRES)&msgnull, (PLHDATA)SplitModeStr, 0,
    STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP }
};

LHWINDOW MainDialog={
    (PLHCLASS)MainHandler,0,9,640,182,
    (PLHRES)&msgnull,(PLHDATA)MainArray,countof(MainArray),
    STYLE_NOSHADOW,
    NULL,MainFKeys,MainMenu,NO_HELP
};

int far MainHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
  if(Msg==DESTROY) return TRUE; /* shouldn't be destroyed */

  if(ConnectOK && Msg==KEYSTROKE){
    switch (Data){
    case '+':
      NextScreen(NEXT_FORWARD);
      DisplayPic(DISPLAY_NORMAL);
      GetPictureSize();
      ShowStat();
      return TRUE;
    case '-':
      NextScreen(NEXT_BACKWARD);
      DisplayPic(DISPLAY_NORMAL);
      GetPictureSize();
      ShowStat();
      return TRUE;
    case DELKEY:
      OpenDelPicDialog();
      return TRUE;
    }
  }
  return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void far ShowStat(void)
{
 int i;
 for(i=0; i<countof(MainArray); i++)
  SendMsg( &MainArray[i], DRAW, DRAW_CLIENT, 0 );
}

/* === CustomView === */

LHWINDOW CustomViewArray[]={
 {  Edit, 10, 20, 4, 1,
    (PLHRES)&msgnull, (PLHDATA)FrameListStr[0], 5,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  Edit, 60, 20, 4, 1,
    (PLHRES)&msgnull, (PLHDATA)FrameListStr[1], 5,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  Edit, 110, 20, 4, 1,
    (PLHRES)&msgnull, (PLHDATA)FrameListStr[2], 5,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  Edit, 10, 35, 4, 1,
    (PLHRES)&msgnull, (PLHDATA)FrameListStr[3], 5,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  Edit, 60, 35, 4, 1,
    (PLHRES)&msgnull, (PLHDATA)FrameListStr[4], 5,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  Edit, 110, 35, 4, 1,
    (PLHRES)&msgnull, (PLHDATA)FrameListStr[5], 5,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  Edit, 10, 50, 4, 1,
    (PLHRES)&msgnull, (PLHDATA)FrameListStr[6], 5,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  Edit, 60, 50, 4, 1,
    (PLHRES)&msgnull, (PLHDATA)FrameListStr[7], 5,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  Edit, 110, 50, 4, 1,
    (PLHRES)&msgnull, (PLHDATA)FrameListStr[8], 5,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 165, 20, 0, 0,
    (PLHRES)&msgCancel, (PLHDATA)CMD_ESC, 0,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 165, 50, 0, 0,
    (PLHRES)&msgOK, (PLHDATA)CMD_DONE, ENTERKEY,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW CustomViewDialog={
    (PLHCLASS)CustomViewHandler,XY_CENTER(260,86),
    (PLHRES)&msgEnterFrame,
    (PLHDATA)CustomViewArray,countof(CustomViewArray),
    STYLE_PUSHB_WIDTH,
    NULL,OKCancelFKeys,NO_MENU,NO_HELP
};

int far CustomViewHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
 int i;
 if (Msg==CREATE) {
   SplitModeTmp=SplitMode;
   SetBoxSize(SplitModeTmp);
 }
 if (Msg==KEYSTROKE && Data==F10KEY ) {
   SetSplitModeTo(SplitModeTmp);
   switch(SplitMode) {
     case 9:
       for(i=0; i<9; i++)
         PARAM(i)=(UCHAR)atoi(FrameListStr[i]);
       break;
     case 4:
       PARAM(0)=(UCHAR)atoi(FrameListStr[0]);
       PARAM(1)=(UCHAR)atoi(FrameListStr[1]);
       PARAM(2)=(UCHAR)atoi(FrameListStr[3]);
       PARAM(3)=(UCHAR)atoi(FrameListStr[4]);
       break;
     case 1:
       PARAM(0)=(UCHAR)atoi(FrameListStr[4]);
       break;
   }
   DisplayPic(DISPLAY_CUSTOM);
   Msg=COMMAND; Data=CMD_ESC; /* EXIT */
 }
 return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void far DoCustomView(void)
{
 SendMsg(&CustomViewDialog, CREATE, CREATE_FOCUS, 0);
}

/* === GoTo === */
int far GoToHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);

LHWINDOW GoToArray[]={
 {  Edit, 0, 0, 4, 1,
    (PLHRES)&msgnull, (PLHDATA)GoToBuf, 5,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
};

LHWINDOW GoToDialog={
    (PLHCLASS)GoToHandler,104,153,55,11,
    (PLHRES)&msgnull,
    (PLHDATA)GoToArray,countof(GoToArray),
    STYLE_PUSHB_WIDTH|STYLE_NOBORDER,
    NULL,OKCancelFKeys,NO_MENU,NO_HELP
};

int far GoToHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
 if (Msg==KEYSTROKE && (Data==F10KEY || Data==ENTERKEY)) {
   SetFrameTo(atoi(GoToBuf));
   GetAttribute();
   UpdateFrameNumber();
   DisplayPic(DISPLAY_NORMAL);
   GetPictureSize();
   ShowStat();
   Msg=COMMAND; Data=CMD_ESC;
 }
 return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void far OpenGoToDialog(void)
{
 SendMsg( &GoToDialog, CREATE, CREATE_FOCUS, 0 );
}


/* === DelPic === */

int far DelPicHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);

LHWINDOW DelPicArray[]={
 {  GroupBox, 5, 15, 350, 70,
    (PLHRES)&msgnull, NULL, 0,
    STYLE_XYRELATIVE|STYLE_NOFOCUS|STYLE_NOBORDER,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 10, 20, 1,
    (PLHRES)&msgDelCurrent, (PLHDATA)&DelPicAction, DEL_CURRENT,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &DelPicArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 30, 20, 1,
    (PLHRES)&msgDelAllUnprot, (PLHDATA)&DelPicAction, DEL_ALL_UNPROTECT,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &DelPicArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 50, 20, 1,
    (PLHRES)&msgDelAll, (PLHDATA)&DelPicAction, DEL_ALL_ABSOLUTE,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &DelPicArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 375, 30, 0, 0,
    (PLHRES)&msg_Cancel, (PLHDATA)CMD_ESC, 0,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 375, 60, 0, 0,
    (PLHRES)&msg_Delete, (PLHDATA)CMD_DELETE, 0,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW DelPicDialog={
    (PLHCLASS)DelPicHandler,XY_CENTER(470,100),
    (PLHRES)&msgDelPic,
    (PLHDATA)DelPicArray,countof(DelPicArray),
    STYLE_PUSHB_WIDTH,
    NULL,DeleteFKeys,NO_MENU,NO_HELP
};

int far DelPicHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
 if (Msg==CREATE) {
   DelPicAction = DEL_CURRENT;  /* default */
   if (SplitMode!=1) {
     DoSplit1();
     Msg=COMMAND;
     Data=CMD_ESC;
   }
 }
 if (Msg==COMMAND && Data==CMD_DELETE) {
   switch(DelPicAction) {
     case DEL_CURRENT:
       PARAM(0)=(UCHAR)CurrentFrame;
       PARAM(1)=0xff;
       SndCmd(DeleteFrame);
       break;
     case DEL_ALL_UNPROTECT:
       SndCmd(DeleteAllUnprotected);
       Data=CMD_ESC;
       break;
     case DEL_ALL_ABSOLUTE:
       SndCmd(DeleteAll);
       SndCmd(QVResetNormal);
       DisconnectCleanUp();
       Data=CMD_ESC;
       break;
   }
   HowMany();
   GetRemainFrames();
   SetFrameTo(CurrentFrame);
   GetAttribute();
   UpdateFrameNumber();
   DisplayPic(DISPLAY_NORMAL);
   GetPictureSize();
   ShowStat();
   if (DelPicAction==DEL_CURRENT) {
     SendMsg( &DelPicDialog, DESTROY, DESTROY_NORMAL, 0);
     SendMsg( &DelPicDialog, CREATE, CREATE_FOCUS, 0);
     return TRUE;
   }
 }
 if (Msg==KEYSTROKE) {
   switch (Data) {
     case '+':
     case '-':
       CloseOpen(Wnd, Msg, Data, Extra);
       return TRUE;
   }
 }
 return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void far OpenDelPicDialog()
{
 SendMsg( &DelPicDialog, CREATE, CREATE_FOCUS, 0 );
}

/* === MovePic === */

int far MovePicHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);

LHWINDOW MovePicArray[]={
 {  Edit, 10, 34, 4, 1,
    (PLHRES)&msgNo, (PLHDATA)MoveToBuf, 4,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 200, 30, 0, 0,
    (PLHRES)&msgCancel, (PLHDATA)CMD_ESC, 0,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 200, 60, 0, 0,
    (PLHRES)&msgOK, (PLHDATA)CMD_DONE, ENTERKEY,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW MovePicDialog={
    (PLHCLASS)MovePicHandler,XY_CENTER(300,100),
    (PLHRES)&msgMovePic,
    (PLHDATA)MovePicArray,countof(MovePicArray),
    STYLE_PUSHB_WIDTH,
    NULL,OKCancelFKeys,NO_MENU,NO_HELP
};

int far MovePicHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
 int MoveTo;

 if (Msg==KEYSTROKE) {
   switch(Data) {
   case '+':
   case '-':
     CloseOpen(Wnd, Msg, Data, Extra);
     return TRUE;
   case F10KEY:					/* Done */
     MoveTo=atoi(MoveToBuf);
     if (MoveTo > MaxFrame) MoveTo=MaxFrame;
     if (MoveTo < 1) MoveTo=1;
     PARAM(0)=(UCHAR)CurrentFrame;
     SndCmd(CopyToMoveBuf);
     PARAM(0)=0x02;
     PARAM(1)=(UCHAR)CurrentFrame;
     SndCmd(CopyToMoveBuf2);
     PARAM(0)=(UCHAR)CurrentFrame;
     PARAM(1)=0xFF;
     SndCmd(DeleteFrame);
     PARAM(0)=(UCHAR)MoveTo;
     SndCmd(InsertFromMoveBuf);
     DisplayPic(DISPLAY_NORMAL);

     Msg=COMMAND; Data=CMD_ESC;
     break;
   }
 }
 return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void far OpenMovePicDialog()
{
 SendMsg( &MovePicDialog, CREATE, CREATE_FOCUS, 0 );
}


/* === ProtectPic === */

int far ProtectPicHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);

LHWINDOW ProtectPicArray[]={
 {  GroupBox, 5, 15, 200, 60,
    (PLHRES)&msgnull, NULL, 0,
    STYLE_XYRELATIVE|STYLE_NOFOCUS|STYLE_NOBORDER,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 10, 20, 1,
    (PLHRES)&msgSetProt, (PLHDATA)&SetProtectTo, 1,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &ProtectPicArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 30, 20, 1,
    (PLHRES)&msgClearProt, (PLHDATA)&SetProtectTo, 0,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &ProtectPicArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 225, 30, 0, 0,
    (PLHRES)&msgCancel, (PLHDATA)CMD_ESC, 0,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 225, 60, 0, 0,
    (PLHRES)&msgOK, (PLHDATA)CMD_DONE, ENTERKEY,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW ProtectPicDialog={
    (PLHCLASS)ProtectPicHandler,XY_CENTER(320,100),
    (PLHRES)&msgProtectPic,
    (PLHDATA)ProtectPicArray,countof(ProtectPicArray),
    STYLE_PUSHB_WIDTH,
    NULL,OKCancelFKeys,NO_MENU,NO_HELP
};

int far ProtectPicHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
 int i;

 if (Msg==CREATE) {
  if(PicAttributeCode&PIC_PROTECT)
    SetProtectTo=0;
  else
    SetProtectTo=1;
 }
 if (Msg==KEYSTROKE) {
   switch (Data) {
     case F10KEY:
         SetPicProtectionTo(SetProtectTo);
         Msg=COMMAND;
         Data=CMD_ESC;
         break;
     case '+':
     case '-':
       CloseOpen(Wnd, Msg, Data, Extra);
       return TRUE;
   }
 }
 return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void far OpenProtectPicDialog(void)
{
 SendMsg( &ProtectPicDialog, CREATE, CREATE_FOCUS, 0 );
}

/* === SaveAs === */

int far SaveAsHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);

LHWINDOW SaveAsArray[]={
 {  Edit, 10, 20, 4, 1,						/* 0 */
    (PLHRES)&msgVol, (PLHDATA)VolBuf, 5,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  Edit, 125, 20, 35, 1,					/* 1 */
    (PLHRES)&msgnull,
    (PLHDATA)"(Filename=Vol.+Frame No.+Ext.)", 35,
    STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER|STYLE_NOFOCUS,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  CheckBox, 10, 37, 20, 1,				/* 2 */
    (PLHRES)&msgThumb, (PLHDATA)&SaveFormat, SAVE_THUMBNAIL,
    STYLE_XYRELATIVE|STYLE_CHECKBOX,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  CheckBox, 10, 54, 20, 1,				/* 3 */
    (PLHRES)&msgJpeg, (PLHDATA)&SaveFormat, SAVE_JPEG,
    STYLE_XYRELATIVE|STYLE_CHECKBOX,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  GroupBox, 10, 71, 350, 65,				/* 4 */
    (PLHRES)&msgnull, NULL, 0,
    STYLE_XYRELATIVE|STYLE_NOFOCUS,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 10, 20, 1,				/* 5 */
    (PLHRES)&msgSaveCurrent, (PLHDATA)&SaveAsOption, SAVE_CURRENT,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &SaveAsArray[4], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 27, 20, 1,				/* 6 */
    (PLHRES)&msgSaveAll, (PLHDATA)&SaveAsOption, SAVE_ALL,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &SaveAsArray[4], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 44, 20, 1,				/* 7 */
    (PLHRES)&msgSaveFrom, (PLHDATA)&SaveAsOption, SAVE_RANGE,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &SaveAsArray[4], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  Edit, 235, 114, 3, 1,					/* 8 */
    (PLHRES)&msgnull, (PLHDATA)FromBuf, 4,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  Edit, 283, 114, 3, 1,					/* 9 */
    (PLHRES)&msgTo, (PLHDATA)ToBuf, 4,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 400, 85, 0, 0,
    (PLHRES)&msgCancel, (PLHDATA)CMD_ESC, 0,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 400, 115, 0, 0,
    (PLHRES)&msgOK, (PLHDATA)CMD_DONE, ENTERKEY,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW SaveAsDialog={
    (PLHCLASS)SaveAsHandler,XY_CENTER(504,160),
    (PLHRES)&msgSaveAs,
    (PLHDATA)SaveAsArray,countof(SaveAsArray),
    STYLE_PUSHB_WIDTH,
    NULL,OKCancelFKeys,NO_MENU,NO_HELP
};

int far SaveAsHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
 int i, from, to, result;

 if(Msg==CREATE) {
    BatteryCheck();
    if(BatteryLow) return TRUE;
 }
 if(Msg==KEYSTROKE) {
   if (SaveAsOption == SAVE_RANGE) {
    SaveAsArray[8].Style &= (~STYLE_NOFOCUS);
    SaveAsArray[9].Style &= (~STYLE_NOFOCUS);
   } else {
    SaveAsArray[8].Style |= (STYLE_NOFOCUS);
    SaveAsArray[9].Style |= (STYLE_NOFOCUS);
   }
   if (Data==F10KEY) {      /* Done */
     strupr(VolBuf);
     switch(SaveAsOption) {
       case SAVE_CURRENT:
         from=to=CurrentFrame;
         break;
       case SAVE_ALL:
         from=1;
         to=MaxFrame;
         break;
       case SAVE_RANGE:
         from=atoi(FromBuf);
         to=atoi(ToBuf);
       break;
     }
     SetSplitModeTo(1);
     SendMsg(Wnd,DESTROY,DESTROY_NORMAL,0);
     FileTransferNumStr[0]='\0';
     FileTransferStatusStr[0]='\0';
     FileTransferProgressStr[0]='\0';
     OutFileStr[0]='\0';
     OpenFileTransferDialog();
     ChangeBaudRate(TransferBR);
     for (i=from; i<=to; i++) {
       SetFrameTo(i);
       GetAttribute();
       UpdateFrameNumber();
       if (SaveFormat&SAVE_THUMBNAIL)
         result=Download(i,SAVE_THUMBNAIL);
       if (SaveFormat&SAVE_JPEG){
         if(PicAttributeCode&PIC_FINE)
           result=Download(i,SAVE_JPEG_FINE);
         else
           result=Download(i,SAVE_JPEG);
       }
       if(m_QuickKeyCheck()==0x011B) {	/* ESC */
         i=to+1;
         strcpy(FileTransferStatusStr,"Interrupt!");
         ShowFileTransferStat();
       }
       if (result!=TRANSFER_DONE) {
         i=to+1;
         sprintf(FileTransferStatusStr,"Error %d", result);
         ShowFileTransferStat();
       } 
       SendMsg(&TDateTime,DRAW,DRAW_ALL,0);
       Pause(10);
     }
     ChangeBaudRate(QV_BR_9600);
     CloseFileTransferDialog();
     return TRUE;
   }
 }
 return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void far OpenSaveAsDialog(void)
{
 SendMsg( &SaveAsDialog, CREATE, CREATE_FOCUS, 0 );
}

/* === LxPic === */

int far LxPicHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);

LHWINDOW LxPicArray[]={

 {  Edit, 15, 17, 4, 1,
    (PLHRES)&msgVol, (PLHDATA)ViewVolBuf, 5,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  Edit, 115, 17, 4, 1,
    (PLHRES)&msgNo, (PLHDATA)NoBuf, 4,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  GroupBox, 10, 35, 350, 65,
    (PLHRES)&msgnull, NULL, 0,
    STYLE_XYRELATIVE|STYLE_NOFOCUS,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 10, 20, 1,
    (PLHRES)&msgSinglePicture, (PLHDATA)&LxPicOption, VIEW_SINGLE,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &LxPicArray[2], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 27, 20, 1,
    (PLHRES)&msgCurrentVolume, (PLHDATA)&LxPicOption, VIEW_VOLUME,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &LxPicArray[2], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 44, 20, 1,
    (PLHRES)&msgAllPicture, (PLHDATA)&LxPicOption, VIEW_ALL,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &LxPicArray[2], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 385, 50, 0, 0,
    (PLHRES)&msgCancel, (PLHDATA)CMD_ESC, 0,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 385, 80, 0, 0,
    (PLHRES)&msgOK, (PLHDATA)CMD_DONE, ENTERKEY,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW LxPicDialog={
    (PLHCLASS)LxPicHandler,XY_CENTER(480,120),
    (PLHRES)&msgLaunchLxPic,
    (PLHDATA)LxPicArray,countof(LxPicArray),
    STYLE_PUSHB_WIDTH,
    NULL,OKCancelFKeys,NO_MENU,NO_HELP
};

int far LxPicHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
 char vol[5], cmd[80];
 int frame;
 EXEC_STRUCT st_exec;

 if(Msg==CREATE) {       /* Init */
  strcpy(ViewVolBuf,VolBuf);
  itoa(CurrentFrame,NoBuf,10);
 }
 if(Msg==KEYSTROKE && Data==F10KEY) {       /* Done */
   frame=atoi(NoBuf);
   strcpy(vol,ViewVolBuf);
   while(strlen(vol)<4) strcat(vol,"_");
   switch(LxPicOption) {
     case VIEW_SINGLE:
       sprintf(cmd,"/C LXPIC %s%4s%03d?.*",SaveDir,vol,frame);
       break;
     case VIEW_VOLUME:
       sprintf(cmd,"/C LXPIC %s%4s????.*",SaveDir,vol);
       break;
     case VIEW_ALL:
       sprintf(cmd,"/C LXPIC %s*.*",SaveDir);
       break;
   }

   SendMsg(Wnd, DESTROY, DESTROY_NORMAL,0);

   st_exec.ex_command_line = cmd;
   st_exec.ex_file_spec = "d:\\dos\\command.com";
   st_exec.ex_DOSsizek = 0xffff;
   st_exec.ex_pause = 0;
   st_exec.ex_lock = 0;

   DeactivateLHAPI();
   app_event.execf.exec_struc_ptr = &st_exec;
   app_event.norm.do_event = DO_EXEC_FULL;
   m_action( &app_event );
   ReactivateLHAPI( &LHAPIData );

   return TRUE;
 }
 return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void far OpenLxPicDialog(void)
{
 SendMsg( &LxPicDialog, CREATE, CREATE_FOCUS, 0 );
}

/* === DirOption === */

int far DirOptionHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);

LHWINDOW DirOptionArray[]={
 {  Edit, 10, 25, 30, 1,
    (PLHRES)&msgnull, (PLHDATA)SaveDir, 64,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 345, 30, 0, 0,
    (PLHRES)&msgCancel, (PLHDATA)CMD_ESC, 0,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 345, 60, 0, 0,
    (PLHRES)&msgOK, (PLHDATA)CMD_DONE, ENTERKEY,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW DirOptionDialog={
    (PLHCLASS)DirOptionHandler,XY_CENTER(440,100),
    (PLHRES)&msgStorageDirectory,
    (PLHDATA)DirOptionArray,countof(DirOptionArray),
    STYLE_PUSHB_WIDTH,
    NULL,OKCancelFKeys,NO_MENU,NO_HELP
};

int far DirOptionHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
 int n;
 if(Msg==KEYSTROKE && Data==F10KEY) {       /* Done */
   n=strlen(SaveDir);
   if (SaveDir[n-1] != '\\') {
    SaveDir[n]='\\';
    SaveDir[n+1]='\0';
   }
   Msg=COMMAND;
   Data=CMD_ESC;
 }
 return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void far OpenDirOptionDialog(void)
{
 SendMsg( &DirOptionDialog, CREATE, CREATE_FOCUS, 0 );
}


/* === ComOption === */

int far ComOptionHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);

LHWINDOW ComOptionArray[]={
 {  GroupBox, 10, 15, 100, 65,
    (PLHRES)&msgnull, NULL, 0,
    STYLE_XYRELATIVE|STYLE_NOFOCUS|STYLE_INVISIBLE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 10, 20, 1,
    (PLHRES)&msg9600, (PLHDATA)&TransferBR, QV_BR_9600,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &ComOptionArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 27, 20, 1,
    (PLHRES)&msg19200, (PLHDATA)&TransferBR, QV_BR_19200,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &ComOptionArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 44, 20, 1,
    (PLHRES)&msg38400, (PLHDATA)&TransferBR, QV_BR_38400,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &ComOptionArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 61, 20, 1,
    (PLHRES)&msg57600, (PLHDATA)&TransferBR, QV_BR_57600,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &ComOptionArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },
/*
 {  RadioButton, 10, 78, 20, 1,
    (PLHRES)&msg115200, (PLHDATA)&TransferBR, QV_BR_115200,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &ComOptionArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },
 */
 {  PushButton, 145, 45, 0, 0,
    (PLHRES)&msgCancel, (PLHDATA)CMD_ESC, 0,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 145, 75, 0, 0,
    (PLHRES)&msgOK, (PLHDATA)CMD_DONE, ENTERKEY,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW ComOptionDialog={
    (PLHCLASS)ComOptionHandler,XY_CENTER(240,115),
    (PLHRES)&msgBaudRate,
    (PLHDATA)ComOptionArray,countof(ComOptionArray),
    STYLE_PUSHB_WIDTH,
    NULL,OKCancelFKeys,NO_MENU,NO_HELP
};

int far ComOptionHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
 if(Msg==KEYSTROKE && Data==F10KEY) {       /* Done */
   Msg=COMMAND;
   Data=CMD_ESC;
 }
 return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void far DoComOption(void)
{
 SendMsg( &ComOptionDialog, CREATE, CREATE_FOCUS, 0 );
}

/* === FileTransfer === */

int far FileTransferHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);
LHWINDOW FileTransferArray[]={
 {  StaticText, 15, 15, 20, 1,
    (PLHRES)&msgNo, (PLHDATA)FileTransferNumStr, 20,
    STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  StaticText, 15, 32, 26, 1,
    (PLHRES)&msgStatus_, (PLHDATA)FileTransferStatusStr, 26,
    STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  StaticText, 15, 49, 20, 1,
    (PLHRES)&msgProgress_, (PLHDATA)FileTransferProgressStr, 20,
    STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  StaticText, 15, 66, 30, 1,
    (PLHRES)&msgnull, (PLHDATA)OutFileStr, 30,
    STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW FileTransferDialog={
    (PLHCLASS)FileTransferHandler,XY_CENTER(480,90),
    (PLHRES)&msgnull,
    (PLHDATA)FileTransferArray,countof(FileTransferArray),
    STYLE_PUSHB_WIDTH,
    NULL,NO_FKEYS,NO_MENU,NO_HELP
};

int far FileTransferHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
 if(Msg==COMMAND && Data==CMD_ESC) {        /* Interrupt */
  m_thud();
 }
 return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void far OpenFileTransferDialog(void)
{
 SendMsg( &FileTransferDialog, CREATE, CREATE_FOCUS, 0 );
}

/*P*/
void far CloseFileTransferDialog(void)
{
 SendMsg( &FileTransferDialog, DESTROY, DESTROY_NORMAL, 0 );
}

/*P*/
void far ShowFileTransferStat(void)
{
 SendMsg( &FileTransferArray[1], DRAW, DRAW_CLIENT, 0 );
}

/* === Set Default === */
int far SetDefaultHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);

LHWINDOW SetDefaultArray[]={
 {  Edit, 10, 25, 4, 1,
    (PLHRES)&msgEnterFrame, (PLHDATA)SetDefBuf, 4,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 230, 20, 0, 0,
    (PLHRES)&msgCancel, (PLHDATA)CMD_ESC, 0,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 230, 50, 0, 0,
    (PLHRES)&msgOK, (PLHDATA)CMD_DONE, ENTERKEY,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};


LHWINDOW SetDefaultDialog={
    (PLHCLASS)SetDefaultHandler,XY_CENTER(330,90),
    (PLHRES)&msgSetDefault,
    (PLHDATA)SetDefaultArray,countof(SetDefaultArray),
    STYLE_PUSHB_WIDTH,
    NULL,OKCancelFKeys,NO_MENU,NO_HELP
};

int far SetDefaultHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
 if(Msg==KEYSTROKE && Data==F10KEY) {       /* Done */
   Msg=COMMAND;
   Data=CMD_ESC;
   PARAM(0)=(UCHAR)atoi(SetDefBuf);
   SndCmd(SetDefaultPic);
 }
 return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void far OpenSetDefaultDialog(void)
{
 SendMsg( &SetDefaultDialog, CREATE, CREATE_FOCUS, 0 );
}


/* === Other Option === */
int far OtherOptionHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);

LHWINDOW OtherOptionArray[]={

 {  CheckBox, 10, 21, 20, 1,				/* 0 */
    (PLHRES)&msgSilentMode, (PLHDATA)&SilentMode, TRUE,
    STYLE_XYRELATIVE|STYLE_CHECKBOX,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  CheckBox, 10, 38, 20, 1,				/* 1 */
    (PLHRES)&msgNoPowerOff, (PLHDATA)&NoAutoPowerOff, 1,
    STYLE_XYRELATIVE|STYLE_CHECKBOX,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  CheckBox, 10, 55, 20, 1,				/* 2 */
    (PLHRES)&msgDeleteAfterSave, (PLHDATA)&SnapSaveOption, DELELE_AFTER_SAVE,
    STYLE_XYRELATIVE|STYLE_CHECKBOX,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  GroupBox, 20, 72, 330, 48,				/* 3 */
    (PLHRES)&msgSnapSaveFile, NULL, 0,
    STYLE_XYRELATIVE|STYLE_NOFOCUS, 
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 15, 14, 12, 1,				/* 4 */
    (PLHRES)&msg_Normal, (PLHDATA)&SnapSaveFile, SAVE_TO_NORMAL,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &OtherOptionArray[3], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 150, 14, 12, 1,				/* 5 */
    (PLHRES)&msgTimeStamp, (PLHDATA)&SnapSaveFile, SAVE_TIMESTAMP,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &OtherOptionArray[3], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 15, 31, 12, 1,				/* 6 */
    (PLHRES)&msgSnapJpg, (PLHDATA)&SnapSaveFile, SAVE_TO_FIXED_FILE,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
    &OtherOptionArray[3], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  CheckBox, 10, 127, 20, 1,				/* 7 */
    (PLHRES)&msgSaveRaw, (PLHDATA)&SaveOrig, 1,
    STYLE_XYRELATIVE|STYLE_CHECKBOX,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

 {  PushButton, 385, 80, 0, 0,
    (PLHRES)&msgCancel, (PLHDATA)CMD_ESC, 0,	
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 385, 110, 0, 0,
    (PLHRES)&msgOK, (PLHDATA)CMD_DONE, ENTERKEY,
    PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};


LHWINDOW OtherOptionDialog={
    (PLHCLASS)OtherOptionHandler,XY_CENTER(480,150),
    (PLHRES)&msgOtherOption,
    (PLHDATA)OtherOptionArray,countof(OtherOptionArray),
    STYLE_PUSHB_WIDTH,
    NULL,OKCancelFKeys,NO_MENU,NO_HELP
};

int far OtherOptionHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
 if(Msg==KEYSTROKE && Data==F10KEY) {       /* Done */
   if(ConnectOK && NoAutoPowerOff) 
      DisableAutoPowerOff();
   Msg=COMMAND;
   Data=CMD_ESC;
 }
 return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void far OpenOtherOptionDialog(void)
{
 SendMsg( &OtherOptionDialog, CREATE, CREATE_FOCUS, 0 );
}

/* === DispMsg === */
/*     (one line message display box) */

int far DispMsgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);
#define SET_DISPLAY_MESSAGE(x) DispMsgArray[0].Data=(PLHDATA)(x)

LHWINDOW DispMsgArray[] = {
  { StaticText, 10, 28, 32, 1,
    NULL, NULL, 32,
    STYLE_NOBORDER|STYLE_WHCHAR|STYLE_NOFOCUS|STYLE_XYRELATIVE|TEXT_CENTER,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
};

LHWINDOW DispMsgDialog = {
  (PLHCLASS)DispMsgHandler, XY_CENTER(340,60),
  (PLHRES)&msgMessage, (PLHDATA)&DispMsgArray, countof(DispMsgArray),
  0,
  NULL, NO_FKEYS, NO_MENU, NO_HELP
};

int far DispMsgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
  switch (Msg) {
  case KEYSTROKE:
    switch (Data) {
    case ENTERKEY: case F10KEY: case ESCKEY:
      Msg=COMMAND;
      Data=CMD_ESC;
    }
  }
  return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/* === About === */

int far AboutHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);

char far **AboutMsgArray[] = {
  &msgTitle,
  &msgAboutMsg
};

LHWINDOW AboutArray[] = {
  { MessageBox, 10, 17, 480, 80,
    NULL, (PLHDATA)&AboutMsgArray, countof(AboutMsgArray),
    STYLE_NOBORDER|STYLE_NOFOCUS|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};


LHWINDOW AboutDialog = {
  (PLHCLASS)AboutHandler, XY_CENTER(500,110),
  (PLHRES)&msgAbout, (PLHDATA)&AboutArray, countof(AboutArray),
  0,
  NULL, OKFKeys, NO_MENU, NO_HELP
};

int far AboutHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
  if(Msg==KEYSTROKE) { 		  /* any key to exit */
    Msg=COMMAND;
    Data=CMD_ESC;
  }
  return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}


/*P*/
void far OpenAboutDialog(void)
{
 SendMsg( &AboutDialog, CREATE, CREATE_FOCUS, 0 );
}


/* === Common functions === */

#define GetDataSeg()  _DS   /* for TC only */
/*P*/
void FixupFarPtrs(void)
{
  int i,dataseg;
  dataseg=GetDataSeg();
  for(i=0; i<countof(StringTable); i++)
    *(((int *)(StringTable[i]))+1) = dataseg;
}

/*P*/
void far DoQuit(void)
{
  Done = TRUE;
}

/* === End Common functions === */


/* === User Fuctions === */

/*P*/
void far Test(void)
{
/*
  char s[12];
  TimeStamp(s);
  strcpy(ConnectStatStr,s);
  SendMsg( &MainArray[0], DRAW, DRAW_CLIENT, 0 );
 */
   ;
}

/*P*/
void far DoAllReset(void)
{
 HelloQV();
 SndCmd(DeleteAll);
 SndCmd(QVResetNormal);
 DisconnectCleanUp();
}

/*P*/
void GetSaveFilename(char *filespec, int frame, int format)
{
 char vol[5], typeID, ext[4], tstamp[12];
 
 if (SnapSaveCycle & (SnapSaveFile == SAVE_TIMESTAMP) ) {
    TimeStamp(tstamp);
    sprintf(filespec,"%s%s.JPG",SaveDir,tstamp);
    SnapSaveCycle=FALSE;
 } else if (SnapSaveCycle & (SnapSaveFile == SAVE_TO_FIXED_FILE) ) {
    strcpy(filespec,SaveDir);
    strcat(filespec, FIXED_SAVE_FILENAME);
    SnapSaveCycle=FALSE;
 } else {
   switch(format) {
     case SAVE_THUMBNAIL:
       typeID='T';
       strcpy(ext,"BMP");
       break;
     case SAVE_JPEG:
       typeID='N';
       strcpy(ext,"JPG");
       break;
     case SAVE_JPEG_FINE:
       typeID='F';
       strcpy(ext,"JPG");
       break;
   }
   strcpy(vol,VolBuf);
   while(strlen(vol)<4) strcat(vol,"_");
   sprintf(filespec,"%s%4s%03d%c.%3s",SaveDir,vol,frame,typeID,ext);
 }
}

/*P*/
int Download(int frame, int format)
{
 int result=0,ysize,usize,vsize,i;
 char SaveFilespec[76], TmpFilespec[76], vol[5], TypeID, ext[4];
 UCHAR c=1;

 sprintf(FileTransferStatusStr,"Initializing");
 FileTransferProgressStr[0]='\0';
 switch(format) {
   case SAVE_THUMBNAIL:
     sprintf(FileTransferNumStr,"%3d (Thumbnail)",frame);
     break;
   case SAVE_JPEG:
     sprintf(FileTransferNumStr,"%3d (Normal)",frame);
     break;
   case SAVE_JPEG_FINE:
     sprintf(FileTransferNumStr,"%3d (Fine)",frame);
     break;
 }
 GetSaveFilename(SaveFilespec, frame, format);

 strcpy(TmpFilespec,SaveDir);
 strcat(TmpFilespec,"QVIMAGE.TMP");

 strcpy(OutFileStr,"Write to: ");
 strcat(OutFileStr, SaveFilespec+strlen(SaveDir));

 for(i=0; i<4; i++) SendMsg( &FileTransferArray[i],DRAW,DRAW_CLIENT,0);

 if (format==SAVE_THUMBNAIL)
   result=m_fcreat(&OutFile,TmpFilespec,strlen(TmpFilespec),0,0);
 else
   result=m_fcreat(&OutFile,SaveFilespec,strlen(SaveFilespec),0,0);
 if (result) {
    strcpy(FileTransferStatusStr,"File Open Error");
    ShowFileTransferStat();
    Pause(50);
    return result;
 }
 PARAM(0)=(UCHAR)frame;
 result = SndCmd(ShowPicNormal);
 result |= SndCmd(PrepareDownload);
 if (result) return result;
 RcvBytes=0L;
 switch(format) {
   case SAVE_THUMBNAIL:
     SndCmd(SendThumbnail);
     result=DownToFile(&OutFile,FIRST_PACKET,0);
     if(!result) result=DownToFile(&OutFile,BURST,0);
     m_close(&OutFile);
     if(result != TRANSFER_DONE) break;
     strcpy(FileTransferStatusStr,"Converting to BMP");
     ShowFileTransferStat();
     result=MakeThumbnail(SaveFilespec, TmpFilespec);
     break;
   case SAVE_JPEG:
     SndCmd(SendJpeg);
     if (SaveOrig==1) {
       result=DownToFile(&OutFile,FIRST_PACKET,0);
       if(!result) result=DownToFile(&OutFile,BURST,0);
     } else {
       result=DownToFile(&OutFile,FIRST_PACKET,8);
       ysize = ( (int)RxBuf[2] << 8 ) + RxBuf[3];
       usize = ( (int)RxBuf[4] << 8 ) + RxBuf[5];
       vsize = ( (int)RxBuf[6] << 8 ) + RxBuf[7];
       result=m_write(&OutFile,soi,sizeof(soi));
       if(!result) result=m_write(&OutFile,app0,sizeof(app0));
       if(!result) result=m_write(&OutFile,dqt0,sizeof(dqt0));
       if(!result) result=DownToFile(&OutFile,NORMAL_DOWN,64);
       if(!result) result=m_write(&OutFile,dqt1,sizeof(dqt1));
       if(!result) result=DownToFile(&OutFile,NORMAL_DOWN,64);
       if(!result) result=m_write(&OutFile,sof,sizeof(sof));
       if(!result) result=m_write(&OutFile,dht,sizeof(dht));
       if(!result) result=m_write(&OutFile,sos_y,sizeof(sos_y));
       if(!result) result=DownToFile(&OutFile,NORMAL_DOWN,(long)ysize);
       if(!result) result=m_write(&OutFile,sos_u,sizeof(sos_u));
       if(!result) result=DownToFile(&OutFile,NORMAL_DOWN,(long)usize);
       if(!result) result=m_write(&OutFile,sos_v,sizeof(sos_v));
       if(!result) result=DownToFile(&OutFile,NORMAL_DOWN,(long)vsize);
       m_write(&OutFile,eoi,sizeof(eoi));
     }
     m_close(&OutFile);
     break;
   case SAVE_JPEG_FINE:
     SndCmd(SendJpegFine);
     if (SaveOrig==1) {
       result=DownToFile(&OutFile,FIRST_PACKET,0);
       if(!result) result=DownToFile(&OutFile,BURST,0);
     } else {
       result=DownToFile(&OutFile,FIRST_PACKET,8);
       if(!result) result=m_write(&OutFile,soi,sizeof(soi));
       if(!result) result=m_write(&OutFile,app_f,sizeof(app_f));
       if(!result) result=m_write(&OutFile,dqt_f,sizeof(dqt_f));
       if(!result) result=DownToFile(&OutFile,NORMAL_DOWN,64);
       if(!result) result=m_write(&OutFile,&c,1);
       if(!result) result=DownToFile(&OutFile,NORMAL_DOWN,64);
       if(!result) result=m_write(&OutFile,sof_f,sizeof(sof_f));
       if(!result) result=m_write(&OutFile,dht_f,sizeof(dht_f));
       if(!result) result=m_write(&OutFile,sos_f,sizeof(sos_f));
       if(!result) result=DownToFile(&OutFile,BURST,0);
       m_write(&OutFile,eoi,sizeof(eoi));
     }
     m_close(&OutFile);
     break;
 }
 return result;
}

/*P*/
int DownToFile (FILE *fd, int mode, long length)
{
 static int BytesInBuf, BufPos,BlockSize;
 int result;
 switch (mode) {
   case FIRST_PACKET:
     TxBuf[0]=DC2;
     snd(1);        /* start downloading */
     result=GetOneBlock(&BlockSize);
     if (result != GET_OK) {
       return result;
     }
     BufPos=length;     /* skip length (for header)*/
     BytesInBuf=BlockSize-length;
     break;
   case NORMAL_DOWN:
     while (length >= BytesInBuf) {
       m_lock();
       result=m_write(fd, RxBuf+BufPos,BlockSize-BufPos);
       m_unlock();
       if (result) return result;
       length -= (BlockSize - BufPos);
       BufPos=0;
       result=GetOneBlock(&BlockSize);
       if (result) return result;
       BytesInBuf=BlockSize;
     }
     if (length > 0) {
       m_lock();
       result=m_write(fd, RxBuf+BufPos,length);
       m_unlock();
       if (result) return result;
       BufPos += length;
       BytesInBuf -= length;
     }
     break;
   case BURST:
     if (BytesInBuf >0 ) {
       m_lock();
       result=m_write(fd, RxBuf+BufPos,BytesInBuf);
       m_unlock();
       if (result) return result;
     }
     while(1) {
       result=GetOneBlock(&BlockSize);
       if (result != 0 )  {
         return result;
       }
       m_lock();
       result=m_write(fd, RxBuf,BlockSize);
       m_unlock();
       if (result) return result;
     }
     break;
 }
 return 0;
}

/*P*/
int GetOneBlock(int *BlockSizePtr)
{
 int result, i, sum=0, BlockSize, RetryCnt=0;

  while (1) {
   rcv(3);
   if (RxBuf[0] != STX ) {
     if (++RetryCnt > DOWN_MAX_RETRY) {
       ComReset(ComHandle,COM_RESET_RXB);
       return ERR_STX;
     } else {
       sprintf(FileTransferStatusStr,"Framing Error -- Retry %d", RetryCnt);
       ShowFileTransferStat();
       pause(25);
       ComReset(ComHandle,COM_RESET_RXB);
       TxBuf[0]=NAK;
       snd(1);      /* send again */
       continue;
     }
   }
   BlockSize=( (int)RxBuf[1] << 8 ) + RxBuf[2];
   sum=( (int)RxBuf[1] + (int) RxBuf[2] ) & 0xFF;
   result = rcv(BlockSize+2);
   if (result) {
     strcpy(FileTransferStatusStr,"Packet Recieve Error");
     ShowFileTransferStat();
     pause(20);
     return result;
   }
   for (i=0; i<BlockSize+1; i++ ) {
     sum += RxBuf[i];
     sum &= 0xff;
   }
   sum ^= 0xff ;

   if (( RxBuf[BlockSize+1] != sum ) ||
       ( BlockSize > 0  && RxBuf[BlockSize] != ETB ) ||
       ( BlockSize == 0 && RxBuf[0] != ETX ) )  {
     if ( ++RetryCnt > DOWN_MAX_RETRY ) {
       return ERR_RETRY;
     } else {
       sprintf(FileTransferStatusStr,"Checksum Error -- Retry %d",RetryCnt);
       ShowFileTransferStat();
       pause(10);
       TxBuf[0]=NAK;
       snd(1);      /* send again */
       continue;
     }
   }
   if ( BlockSize == 0 ) {      /* Last Packet */
     TxBuf[0]=ACK;
     snd(1);
     sprintf(FileTransferStatusStr,"Done");
     ShowFileTransferStat();
     return TRANSFER_DONE; /* Done */
   }
   RetryCnt=0;
   RcvBytes += BlockSize;
   if(--DisplayCycle<=0) {
     DisplayCycle=DISP_CYCLE;
     sprintf(FileTransferStatusStr,"Receiving");
     ShowFileTransferStat();
     sprintf(FileTransferProgressStr, "%6ld bytes", RcvBytes);
     SendMsg( &FileTransferArray[2], DRAW, DRAW_CLIENT, 0 );
   }
   *BlockSizePtr = BlockSize;
   TxBuf[0]=ACK; /* get next packet */
   snd(1);
   return GET_OK;
 }
}

/*
 * int far m_seek(*fp, int mode, long seek)
 *   mode
 *   seek offset
 * typedef enum m_seek_type {
 *  seek_beginning=0,
 *  seek_current=1,
 *  seek_end=2
 * } m_seek_type;
 */

/*P*/
int MakeThumbnail(char *out, char *in) {
 int line, pos, len;
 int result;
 UCHAR RGB[3];

 result=m_fcreat(&OutFile,out,strlen(out),0,0);
 if (result)  return result;
 result=m_openro(&InFile,in,strlen(in),0,0);
 if (result) {
  m_close(&OutFile);
  return result;
 }

 result = m_write(&OutFile, BmpHeader, sizeof(BmpHeader));

 for (line=0; line<THUMBNAIL_HEIGHT; line++) {
   sprintf(FileTransferProgressStr, "Line %3d", line);
   SendMsg( &FileTransferArray[2], DRAW, DRAW_CLIENT, 0 );
   m_seek(&InFile,0,(long)(THUMBNAIL_WIDTH*(THUMBNAIL_HEIGHT-line-1)));
   m_read(&InFile,L,THUMBNAIL_WIDTH,&len);
   if (line%2==0) {
     m_seek(&InFile,0,(long)(THUMBNAIL_WIDTH*THUMBNAIL_HEIGHT+
       (THUMBNAIL_WIDTH/2)*((THUMBNAIL_HEIGHT-line-1)/2)) );
     m_read(&InFile,Cb,THUMBNAIL_WIDTH/2,&len);
     m_seek(&InFile,0,(long)(THUMBNAIL_WIDTH*THUMBNAIL_HEIGHT+
       (THUMBNAIL_WIDTH/2)*(THUMBNAIL_HEIGHT/2)+
       (THUMBNAIL_WIDTH/2)*((THUMBNAIL_HEIGHT-line-1)/2)) );
     m_read(&InFile,Cr,THUMBNAIL_WIDTH/2,&len);
   }
   for (pos=0; pos<THUMBNAIL_WIDTH; pos++) {
     RGB[2] =  Norm( ( (long)L[pos]*100000L
                     + (long)(signed char)Cr[pos/2]*140200L ) / 100000L );
     RGB[1] =  Norm( ( (long)L[pos]*100000L
                     - (long)(signed char)Cb[pos/2]* 34414L
                     - (long)(signed char)Cr[pos/2]* 71414L ) / 100000L );
     RGB[0] =  Norm( ( (long)L[pos]*100000L
                     + (long)(signed char)Cb[pos/2]*177200L ) / 100000L );
     result=m_write(&OutFile, RGB, 3);
     if(result) break;
   }
 }
 m_close(&InFile);
 m_close(&OutFile);
 return result;
}


UCHAR Norm(long x)
{
 if (x<0) return 0x00;
 else if (x>0xFF) return 0xFF;
 else return (UCHAR)x;
}


/*P*/
void ReadConfig(void)
{
 int len;
 NBFILE infile;

 if ( !m_openro(&infile,CfgFile,strlen(CfgFile),0,1)) {
  m_read(&infile, SaveDir,sizeof(SaveDir), &len);
  m_read(&infile, &TransferBR,sizeof(TransferBR),&len);
  m_read(&infile, VolBuf,sizeof(VolBuf),&len);
  m_read(&infile, &SilentMode,sizeof(SilentMode),&len);
  m_read(&infile, &NoAutoPowerOff,sizeof(NoAutoPowerOff),&len);
  m_read(&infile, &SnapSaveOption,sizeof(SnapSaveOption),&len);
  m_read(&infile, &SnapSaveFile,sizeof(SnapSaveFile),&len);
  m_close(&infile);
 }
}

/*P*/
void WriteConfig(void)
{
 NBFILE outfile;

 if ( !m_fcreat(&outfile,CfgFile,strlen(CfgFile),0,1)) {
  m_write(&outfile, SaveDir,sizeof(SaveDir));
  m_write(&outfile, &TransferBR,sizeof(TransferBR));
  m_write(&outfile, VolBuf,sizeof(VolBuf));
  m_write(&outfile, &SilentMode,sizeof(SilentMode));
  m_write(&outfile, &NoAutoPowerOff,sizeof(NoAutoPowerOff));
  m_write(&outfile, &SnapSaveOption,sizeof(SnapSaveOption));
  m_write(&outfile, &SnapSaveFile,sizeof(SnapSaveFile));
  m_close(&outfile);
 }
}


/*P*/
void DisableAutoPowerOff(void)
{
 BOOL SaveConnectOK=ConnectOK;

 ConnectOK=TRUE;	/* Don't care about connect status */
 SndCmd(DisableAutoShutdown);
 SndCmd(QVResetNoCls);
 ConnectOK=SaveConnectOK;
 SetConnectStatStr();
}


/*P*/
void far DoPowerOff(void)
{
 SndCmd(QVExit);
 DisconnectCleanUp();
}


/*P*/
void far DoColorBar(void)
{
  SndCmd(ShowColorBars);
  DisconnectCleanUp();
}

/*P*/
void far ToggleShowNumber(void)
{
 if (ShowPicNumber) {
   ShowPicNumber=FALSE;
   ViewMenu[4].Style &= (~MENU_CHECKED);
 } else {
   ShowPicNumber=TRUE;
   ViewMenu[4].Style |= (MENU_CHECKED);
 }
 DisplayPic(DISPLAY_NORMAL);
}


/*P*/
void SetBoxSize(int Mode)
{
  int i;

  for (i=0;i<9;i++)
    CustomViewArray[i].Style &= (~STYLE_INVISIBLE);
  switch(Mode) {
    case 1:
      for (i=0;i<9;i++) {
        if(i==4) continue;
        CustomViewArray[i].Style |= (STYLE_INVISIBLE);
      }
      break;
    case 4:
      CustomViewArray[2].Style |= (STYLE_INVISIBLE);
      for (i=5;i<9;i++)
        CustomViewArray[i].Style |= (STYLE_INVISIBLE);
      break;
    case 9:
      break;
  }
 }

/*P*/
void far DoSplit1(void)
{
 SetSplitModeTo(1);
 DisplayPic(DISPLAY_NORMAL);
 ShowStat();
}

/*P*/
void far DoSplit4(void)
{
  SetSplitModeTo(4);
  DisplayPic(DISPLAY_NORMAL);
  ShowStat();
}

/*P*/
void far DoSplit9(void)
{
  SetSplitModeTo(9);
  DisplayPic(DISPLAY_NORMAL);
  ShowStat();
}


/*P*/
void SetSplitModeTo(int n)
{
  int i;
  for(i=0;i<3;i++) {
    if(n==(i+1)*(i+1))
      ViewMenu[i].Style |= (MENU_CHECKED);
    else
      ViewMenu[i].Style &= (~MENU_CHECKED);
  }
  SplitMode=n;
}


/*P*/
int far CloseOpen(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
  SendMsg( Wnd, DESTROY, DESTROY_NODRAW, 0);
  SendMsg( &MainDialog, Msg, Data, Extra);
  SendMsg( Wnd, CREATE, CREATE_FOCUS, 0);
  return TRUE;
}

/*P*/
void GetPictureSize(void)
{
 UINT n, n1, n2, n3, n4;

 if (ConnectOK&&IsQV100) {
  if (! SndCmd(GetPicSize)) {
    n = ((UINT)RxBuf[0] << 8) + (UINT)RxBuf[1];
  }
  if (! SndCmd(GetPicSizeFine)) {
    n1= ((UINT)RxBuf[0] << 8) + (UINT)RxBuf[1];
    n2= ((UINT)RxBuf[2] << 8) + (UINT)RxBuf[3];
    n3= ((UINT)RxBuf[4] << 8) + (UINT)RxBuf[5];
    n4= ((UINT)RxBuf[6] << 8) + (UINT)RxBuf[7];
  }
  sprintf(PicSizeStr,"%04x - %04x %04x %04x %04x",n, n1, n2, n3, n4);
 } else {
  strcpy(PicSizeStr, UNKNOWN);
 }
 SendMsg( &MainArray[8], DRAW, DRAW_CLIENT, 0 );
}

/*P*/
void GetRemainFrames(void)
{
 int Remain=0, RemainFine=0;

 if (ConnectOK&&IsQV100) {
  if (!SndCmd(GetRemain))
    Remain=(int)RxBuf[0];
  if (!SndCmd(GetRemainFine))
    RemainFine=(int)RxBuf[0];
  sprintf(RemainStr,"%3d(N) %3d(F)",Remain, RemainFine);
 } else {
  strcpy(RemainStr,UNKNOWN);
 }
 SendMsg( &MainArray[7], DRAW, DRAW_CLIENT, 0 );
}

/*P*/
void BatteryCheck(void)
{
 unsigned long n;
 if (ConnectOK) {
   PARAM(0)=0x05;
   PARAM(1)=0xFF;
   PARAM(2)=0xFE;
   PARAM(3)=0xE6;
   SndCmd(GetBatteryVoltage);
   VoltageInHex=(int)RxBuf[0];
   n=((long)RxBuf[0]*1000L)/16L+5L;  /* +5 for rounding */
   sprintf(VoltageStr,"%04ld V ",n);
   if (VoltageInHex < LOW_BATT) {
     BatteryLow=TRUE;
     strcat(VoltageStr,"LOW!!");
   } else { 
     BatteryLow=FALSE;
   } 
   VoltageStr[3]=VoltageStr[2];      /* add decimal point */
   VoltageStr[2]=VoltageStr[1];
   VoltageStr[1]='.';
 } else {
   strcpy(VoltageStr, UNKNOWN);
 }
 if (BatteryLow) {
   MainArray[3].Style |= DRAW_INVERT;
   m_thud();
 } else {
   MainArray[3].Style &= (~DRAW_INVERT);
 }
 SendMsg( &MainArray[3], DRAW, DRAW_CLIENT, 0 );
}

/*P*/
void NextScreen(int Mode) /* Mode 1: Forward, 0: Backward */
{
 int i=SplitMode;
 while(i--) {
  if (Mode) {
   CurrentFrame++;
   if(CurrentFrame > MaxFrame)
    CurrentFrame = 1;
  } else {
   CurrentFrame--;
   if(CurrentFrame < 1)
    CurrentFrame = MaxFrame;
  }
 }
 SetFrameTo(CurrentFrame);
 GetAttribute();
 UpdateFrameNumber();
 /* check here OK? */
 BatteryCheck();
}

/*P*/
void SetFrameTo(int n)
{
  if(n > MaxFrame)
    CurrentFrame = MaxFrame;
  else if(n < 1)
    CurrentFrame = 1;
  else
    CurrentFrame = n;
}

/*P*/
void GetAttribute(void)
{
 PARAM(0)=2;
 PARAM(1)=(UCHAR)CurrentFrame;
 SndCmd(GetPicAttribute);
 PicAttributeCode=RxBuf[0];
}

/*P*/
void UpdateFrameNumber(void)
{
 sprintf(CurrentFrameStr,"%03d  ",CurrentFrame);
 if(PicAttributeCode&PIC_PROTECT) CurrentFrameStr[3]='P';
 if(PicAttributeCode&PIC_FINE) CurrentFrameStr[4]='F';
 SendMsg( &MainArray[9], DRAW, DRAW_CLIENT, 0 );
}


/*P*/
void DisplayPic(int action)
{
 int i, n=CurrentFrame;
 if (action==DISPLAY_NORMAL) {
  for (i=0; i<SplitMode; i++) {
   PARAM(i)=(UCHAR)n;
   if(++n > MaxFrame) n=1;
  }
 }
 switch(SplitMode) {
 case 1:
  SndCmd(ShowPicNormal);
  if(!ShowPicNumber)
    SndCmd(HidePicNumber);
  break;
 case 4:
  SndCmd(ShowPicIn4); break;
 case 9:
  SndCmd(ShowPicIn9); break;
 }
 sprintf(SplitModeStr,"(Screen: 1/%d)",SplitMode);
 SendMsg( &MainArray[10], DRAW, DRAW_CLIENT, 0 );
}

/*P*/
void far SwitchMode(void) {
 switch(SplitMode) {
  case 1: SetSplitModeTo(4); break;
  case 4: SetSplitModeTo(9); break;
  case 9: SetSplitModeTo(1); break;
 }
 DisplayPic(DISPLAY_NORMAL);
}

/*P*/
void far SwitchProtect(void)
{
 if(PicAttributeCode&PIC_PROTECT)
  SetPicProtectionTo(0);
 else
  SetPicProtectionTo(1);
}

/*P*/
void SetPicProtectionTo(int n)
{
 PARAM(0)=(UCHAR)n;
 PARAM(1)=(UCHAR)CurrentFrame;
 SndCmd(SetPicProtection);
 SetFrameTo(CurrentFrame);
 GetAttribute();
 UpdateFrameNumber();
 DisplayPic(DISPLAY_NORMAL);
 ShowStat();
}


/*P*/
void far DoConnect(void)
{
 strcpy(ConnectStatStr,CONNECTING);
 SendMsg( &MainArray[0], DRAW, DRAW_CLIENT, 0 );
 HelloQV();
 SetMenuFKey();
 if (ConnectOK) {
  /* something is worng with this command for QV-100 :
   * SndCmd(ShowBlankScreen); 
   */
  GetStat();
  if (CurrentFrame<1 || CurrentFrame>MaxFrame)
    CurrentFrame=MaxFrame;
  GetAttribute();
  UpdateFrameNumber();
  DisplayPic(DISPLAY_NORMAL);
  GetPictureSize();
  if(!SilentMode)  m_play(CONNECT_SOUND);
 }
 ShowStat();
}

/*P*/
void far Refresh(void)
{
 int i;
 HelloQV();
 SetMenuFKey();
 SetConnectStatStr();
 if (ConnectOK) {
  GetStat();
  Pause(50);
  DisplayPic(DISPLAY_NORMAL);
  GetPictureSize();
 }
 ShowStat();
}

/*P*/
void far DoDisconnect(void)
{
  SndCmd(QVResetNormal);
  if (NoAutoPowerOff) DisableAutoPowerOff();
  DisconnectCleanUp();
}

/*P*/
void DisconnectCleanUp(void)
{
  ConnectOK=FALSE;
  SetMenuFKey();
  SetConnectStatStr();
  GetStat();
  ShowStat();
  if(!SilentMode)  m_play(DISCONNECT_SOUND);
}

/*P*/
void far SetMenuFKey(void)
{
 int i;
 if (ConnectOK) {
  MainDialog.Fkey=MainFKeys2;
  for(i=0; i<countof(ViewMenu); i++)
   ViewMenu[i].Style &= (~MENU_GRAY); /* make it visible */
  for(i=0; i<4; i++)
   ActionMenu[i].Style &= (~MENU_GRAY); /* make it visible */
  FileMenu[0].Style &= (~MENU_GRAY); /* SaveAs */
  SendFocusMsg(DRAW,DRAW_FKEYS,0);
 } else {
  MainDialog.Fkey=MainFKeys;
  for(i=0; i<countof(ViewMenu); i++)
   ViewMenu[i].Style |= (MENU_GRAY); /* make it gray */
  for(i=0; i<4; i++)
   ActionMenu[i].Style |= (MENU_GRAY); /* make it gray */
  FileMenu[0].Style |= (MENU_GRAY);
  SendFocusMsg(DRAW,DRAW_FKEYS,0);
 }
}

/*P*/
void far DoNothing(void)
{
 ;
}

/*P*/
int ChangeBaudRate(int QVBaud)
{
 int LXBaud=COM_BR_9600;

 switch(QVBaud) {
  case QV_BR_9600:  LXBaud=COM_BR_9600;  break;
  case QV_BR_19200: LXBaud=COM_BR_19200; break;
  case QV_BR_38400: LXBaud=COM_BR_38400; break;
  case QV_BR_57600: LXBaud=COM_BR_57600; break;
 }
 PARAM(0)=(UCHAR)QVBaud;
 SndCmd(ChangeBaud);

 ComRelease(ComHandle);
 ComSettings.Baud=LXBaud;
 ComInit();
}


/*P*/
int far PortInit(int PortID)
{
 if(ComOpen( &ComHandle, PortID )) {
  m_thud();
  return ERR_PORTOPEN;
 }
 return 0;
}

/*P*/
void ComSetDefault(void)
{
  ComSettings.Baud=COM_BR_9600;
  ComSettings.Data=0x03;    /* 3=8bit, 2=7bit */
  ComSettings.Flow=0x01;    /* 1=NONE 2=XONXOFF 10=RTS-CTS */
  ComSettings.InfraRed=0x01;    /* 1=OFF 2=ON */
}

/*P*/
void ComInit(void)
{
  ComSetParameters(ComHandle, (void far *)&ComSettings);
  ComAcquire(ComHandle,1);  /*Exclusive*/
  ComMdmSet(ComHandle,1);    /* Set DTR */
  ComMdmClr(ComHandle,2);   /* Clear RTS */
}

/*P*/
int far snd(int DataLength)
{
 TxLength=DataLength;
 if (!ComSendBytes(ComHandle,TxBufPtr,1,TxLengthPtr)) {
 while ( ComXmitting(ComHandle) )
   ;
 return 0;
 } else
 return ERR_SENDBYTES;
}

/*P*/
int far rcv(int DataLength)
{
 int Received, LoopCount=0;
 for (Received = 0; Received <DataLength ;  ) {
  RxLength = DataLength - Received;
  if (ComReceiveBytes(ComHandle,RxBufPtr+Received,RxLengthPtr))
   return ERR_RCVBYTES;
  Received += RxLength;
  if (!RxLength) {
    ++LoopCount;
    Pause(RCV_RETRY_INTERVAL);
  }
  if ( LoopCount > RCV_MAX_RETRY ) return ERR_RCVTIMEOUT;
 }
 return 0;
}

/*P*/
int far HelloQV(void)
{
 int result=0, repeat=5, interval=25;
 BOOL SaveConnectOK=ConnectOK;

 ConnectOK=FALSE;	/* default */
 while(repeat) {
  ComReset(ComHandle,COM_RESET_TXB|COM_RESET_RXB);
  TxBuf[0]=ENQ;
  if ( snd(1) || rcv(1) || ( RxBuf[0] != ACK ) ) {
   strcpy(ConnectStatStr,CONNECTING);
   SendMsg( &MainArray[0], DRAW, DRAW_CLIENT, 0 );
   Pause(interval);
   if(m_QuickKeyCheck()==0x011B) {	/* ESC */
     break;
   }
   repeat--;
   continue;
  }
  else {
   ConnectOK=TRUE; /* connected!! */
   result=0;
   Pause(10);
   break;
  }
 }
 if(ConnectOK==FALSE)  {
   result = ERR_HELLO;
   if (SaveConnectOK==TRUE) {
    DisconnectCleanUp();
   }
 }
 SetConnectStatStr();
 return result;
}

/*P*/
void SetConnectStatStr(void)
{
 if (ConnectOK)
  sprintf(ConnectStatStr,"Connected to %s",CameraType);
 else
  strcpy(ConnectStatStr,NOCONNECT);
 SendMsg( &MainArray[0], DRAW, DRAW_CLIENT, 0 );
}


/*P*/
int SndCmd(QVCMD Cmd)
{
 int i=2, sum=0, CmdLen=Cmd.ParamBytes+2, result=0;

 if(!ConnectOK) return ERR_NOCONNECT;   /* check on-line */

 sum=Cmd.CmdStr[0]+Cmd.CmdStr[1];
 while ( i<CmdLen ) {
  sum += TxBuf[i++];
  sum &= 0xff;
 }
 sum ^= 0xff ;
 result=HelloQV();
 if ( result ) return result;
  TxBuf[0]=Cmd.CmdStr[0];
  TxBuf[1]=Cmd.CmdStr[1];
 result=snd(CmdLen);
 if (result) return result;
 result=rcv(1);
 if (result) return result;
 sum -= RxBuf[0] ;
 TxBuf[0]=ACK;
 result=snd(1);
 if (result) return result;
 if(sum) {
  return ERR_CHECKSUM; /* checksum error */
 }
 if (Cmd.RcvBytes) {
  for (i=0; i<Cmd.RcvBytes; i++) RxBuf[i]=0;
  result=rcv(Cmd.RcvBytes);
  if (result) return result;
 }
 return 0;
}

/*P*/
int far SwStat(void)
{
 char *ReleaseB, *ZoomB, *ModeB, *DispB, *DelB,
      *ProtectB, *SwitchPos, *LensDir, *PlusB, *MinusB,
      *TooBright, *TooDark;
 int result;

 if (!ConnectOK) {
   result=ERR_NOCONNECT;
   SwStatCode = 0;
   strcpy(SwStatStr,UNKNOWN);
   strcpy(SwStatStr1,UNKNOWN);
   strcpy(SwStatStr2,UNKNOWN);
 } else {
   PARAM(0)=2;
   result=SndCmd(GetSwStatus);
   result=SndCmd(GetSwStatus);  /* somehow two commands are needed */
   SwStatCode = ((int)RxBuf[0] << 8) + (int)RxBuf[1];

   LensDir= (SwStatCode & LENS_DIRECTION)? "(Reverse)" : "(Normal)";
   SwitchPos=   (SwStatCode & SWITCH_POSITION)? "[PLAY]" : "[REC]" ;
   TooBright=   (SwStatCode & TOO_BRIGHT)? "(TOO BRIGHT)" :"" ;
   TooDark= (SwStatCode & TOO_DARK)? "(TOO DARK)" : "";
   ProtectB=    (SwStatCode & PROTECT_BUTTON)? "[PROTECT]" : "" ;
   ZoomB=   (SwStatCode & ZOOM_BUTTON)? "[ZOOM]" : "" ;
   DispB=   (SwStatCode & DISP_BUTTON)? "[DISP]" : "";
   ModeB=   (SwStatCode & MODE_BUTTON)? "[MODE]" : "";
   DelB=    (SwStatCode & DEL_BUTTON)? "[DEL]" : "";
   ReleaseB=    (SwStatCode & RELEASE_BUTTON)? "[::]" : "" ;
   MinusB=  (SwStatCode & MINUS_BUTTON)? "[-]" : "";
   PlusB=   (SwStatCode & PLUS_BUTTON)? "[+]" : "";

   sprintf(SwStatStr1,"%s %s %s%s", LensDir, SwitchPos, TooBright, TooDark);
   sprintf(SwStatStr2,"%9s %6s %6s %6s %5s %4s %3s %3s",
     ProtectB, ZoomB, DispB, ModeB, DelB, ReleaseB, MinusB, PlusB);
   sprintf(SwStatStr,"%04x", SwStatCode);
 }
 SendMsg( &MainArray[2], DRAW, DRAW_CLIENT, 0 );
 SendMsg( &MainArray[4], DRAW, DRAW_CLIENT, 0 );
 SendMsg( &MainArray[5], DRAW, DRAW_CLIENT, 0 );
 return result;
}

/*P*/
int far CameraID(void)
{
 int result,i;

 if (!ConnectOK) {
  result=ERR_NOCONNECT;
 } else {
  result=SndCmd(GetMachineID);
 }
 if (result) {
   CameraIDCode=0;
   strcpy(CameraIDStr,UNKNOWN);
   strcpy(CameraType,"");
 } else {
   CameraIDCode= ((long)RxBuf[0] << 24) + ((long)RxBuf[1]<<16) +
        ((long)RxBuf[2] << 8) + (long)RxBuf[3] ;
   sprintf(CameraIDStr,"%08lx", CameraIDCode );
 }
 for(i=0;i<countof(QVTypeList);i++) {
   if((CameraIDCode & QVTypeList[i].IDMask) == QVTypeList[i].IDValue) {
     CameraTypeCode=i;
     strcpy(CameraType,"QV");
     strcat(CameraType,QVTypeList[i].Name);
     IsQV100=QVTypeList[i].QV100;
     break;
   }
 }
 SendMsg( &MainArray[1], DRAW, DRAW_CLIENT, 0 );
 return result;
}

/*P*/
int HowMany(void)
{
 int result;

 if (!ConnectOK) {
  result=ERR_NOCONNECT;
  strcpy(FilmUsedStr,UNKNOWN);
 } else {
  result=SndCmd(HowManyPics);
  MaxFrame=(int)RxBuf[0];
  sprintf(FilmUsedStr,"%d frames",MaxFrame);
 }
 SendMsg( &MainArray[6], DRAW, DRAW_CLIENT, 0 );
 return result;
}

/*P*/
void far SnapSave(void)
{
 int SaveMaxFrame=MaxFrame, i, result=1;
 for(i=0; i<SNAP_SAVE_MAX_RETRY; i++) {
   if ( SnapShot() ) continue;
   Pause(100);
   if ((SaveMaxFrame+1)==MaxFrame) {
     result=0;
     break;
   }
 }
 if (result) return;
 
 SaveAsOption=SAVE_CURRENT;
 SaveFormat=SAVE_JPEG;
 SnapSaveCycle=TRUE;	/* set */
 OpenSaveAsDialog();
 SendMsg( &SaveAsDialog, COMMAND, CMD_DONE, 0 );
 if(SnapSaveOption&DELELE_AFTER_SAVE) {
   OpenDelPicDialog();
   DelPicAction=DEL_CURRENT;
   SendMsg( &DelPicDialog, COMMAND, CMD_DELETE, 0 );
   SendMsg( &DelPicDialog, COMMAND, CMD_DONE, 0 );
 }
}


/*P*/
int far SnapShot(void)
{
 int t1=QV10_PRESNAP_IDLE, t2=QV10_POSTSNAP_IDLE, result;
 char errmsgstr[16];

 if ( IsQV100 ) {
  t1=QV100_PRESNAP_IDLE;
  t2=QV100_POSTSNAP_IDLE;
 }
 
 BatteryCheck();
 if(BatteryLow) return 1;

 SndCmd(QVResetNormal);
 SET_DISPLAY_MESSAGE("Preparing...");
 SendMsg(&DispMsgDialog, CREATE, CREATE_FOCUS, 0);
 Pause(t1);
 SET_DISPLAY_MESSAGE("Storing...");
 SendMsg( &DispMsgArray[0], DRAW, DRAW_CLIENT, 0 );
 SndCmd(ReleaseButton);
 if(RxBuf[0] != ACK) {
   Pause(10);
   SndCmd(ReleaseButton);	/* MAX 2 tries */
 }
 switch(RxBuf[0]){
   case ACK:
     CurrentFrame=MaxFrame+1;
     Pause(t2);
     result=0;
     break;
   case 0x15:
     SET_DISPLAY_MESSAGE("Switch to [REC] !");
     SendMsg( &DispMsgArray[0], DRAW, DRAW_CLIENT, 0 );
     Pause(150);
     CurrentFrame=MaxFrame;
     result=1;
     break;
 }
 SET_DISPLAY_MESSAGE("Done.");
 SendMsg( &DispMsgArray[0], DRAW, DRAW_CLIENT, 0 );
 Pause(20);
 SendMsg(&DispMsgDialog, KEYSTROKE, ESCKEY, 0);
 DoConnect();
 return result;
}

/*P*/
void far GetStat(void) {
 SwStat();
 CameraID();
 HowMany();
 GetRemainFrames();
 GetPictureSize();
 BatteryCheck();
}

/*P*/
void Pause(int n)
	/* n: duration (unit 0.01 sec) */
{
 DTM mydtm;
 UINT start_time, stop_time, now_time;
 BOOL overflow;

 m_getdtm((DTM far*)&mydtm);
 start_time = mydtm.dt_second*100 + mydtm.dt_hundreth;
 stop_time = start_time + n;
 if (stop_time>5999) {
   overflow=TRUE;
   stop_time -= 6000;
 } else {
   overflow=FALSE;
 }

 while(TRUE) {
   m_getdtm((DTM far*)&mydtm);
   now_time = mydtm.dt_second*100 + mydtm.dt_hundreth;
   if (overflow) {
     if (now_time>stop_time && now_time <start_time)
       break;
   } else {
     if (now_time>stop_time || now_time <start_time)
       break;
   }
 }
}


/*P*/
void TimeStamp(char * s)
{
 DTM mydtm;

 m_getdtm((DTM far*)&mydtm);
 sprintf(s,"%02d%02d%02d%02d",
 		mydtm.dt_month, 
 		mydtm.dt_date,
 		mydtm.dt_hour,
 		mydtm.dt_minute);
}


/*P*/
void main(void)
{
  m_init_app(SYSTEM_MANAGER_VERSION);
  m_reg_app_name(msgAppName);
  InitializeLHAPI(&LHAPIData);
  SetDefaultFont(FONT_NORMAL);
  SetMenuFont(FONT_NORMAL);
  FixupFarPtrs();
  /* Initialize */
  SetSplitModeTo(1);
  SetMenuFKey();
  ReadConfig();

  /* Initial Display */
  SendMsg( &MainDialog, CREATE, CREATE_FOCUS, 0 );
  SendMsg( &MainTitle, CREATE, CREATE_NORMAL, 0 );
  PortInit(ComPort);
  ComSetDefault();
  ComInit();

  Done = FALSE;
  while(!Done) {
    app_event.norm.do_event = DO_EVENT;
    m_action(&app_event);
    switch(app_event.norm.kind) {
      case E_REFRESH:
      case E_ACTIV:
        FixupFarPtrs(); 
        PortInit(ComPort);
        ComInit();
        ReactivateLHAPI(&LHAPIData);
        break;
      case E_DEACT:
        ComRelease(ComHandle);
        ComClose(ComHandle);
        DeactivateLHAPI(); 
        break;
      case E_TERM:
        FixupFarPtrs(); Done = TRUE; break;
      case E_NONE:
        SendMsg(&TDateTime,DRAW,DRAW_ALL,0);
        break;
      case E_KEY:
        SendFocusMsg(KEYSTROKE,app_event.norm.data,app_event.norm.scan);
        break;
    }
  }
  if(ConnectOK) {
    SndCmd(QVResetNormal);
    if (NoAutoPowerOff) DisableAutoPowerOff();
    if(!SilentMode)  m_play(DISCONNECT_SOUND);
  }
  WriteConfig();
  ComRelease(ComHandle);
  ComClose(ComHandle);
  app_event.norm.do_event = DO_FINI;
  m_action(&app_event);
}