#if defined(LSI_C)
#define	LSIC
#endif

#if defined(__TURBOC__)
#define	TURBOC
#endif

#if defined(_MSC_VER)
#define	MSC
#endif

#if !defined(LSIC)
#pragma pack(1)	
#endif

#define		SYSTEM_MANAGER_VERSION	0x200

/* General Definitions */

typedef unsigned int WORD;
typedef unsigned char BYTE;
typedef long int LONG;
typedef int BOOL;
typedef unsigned char UCHAR;
typedef unsigned int UINT;
typedef unsigned long int ULONG;

#define	countof(x)	(sizeof(x)/(sizeof((x)[0])))

#define	NULL	(0)
#define	FALSE	(0)
#define	TRUE	(1)

typedef UCHAR near *PLHDATA;
typedef UCHAR far * near *PLHFARDATA;
typedef UCHAR far * near *PLHRES;

typedef UCHAR far *LPSTR;
typedef UCHAR far **HANDLE;

/* Class Definitions */

#if defined(MSC)

typedef void _far LHFUNC(void);
typedef LHFUNC *PLHFUNC;
typedef int _far LHCLASS (struct LHsWindow _near *Window, UINT Message, UINT Data, UINT Extra);
typedef LHCLASS *PLHCLASS;

#endif
#if defined(TURBOC)

typedef void LHFUNC(void);
typedef LHFUNC far *PLHFUNC;
typedef int LHCLASS (struct LHsWindow near *Window, UINT Message, UINT Data, UINT Extra,...);
typedef LHCLASS far *PLHCLASS;

#endif

#if defined(LSIC)

typedef void LHFUNC(void);
typedef void (far *PLHFUNC)(void);
typedef int LHCLASS (struct LHsWindow near *Window, UINT Message, UINT Data, UINT Extra,...);
typedef void (far *PLHCLASS)(void);

#endif


/* Function Key Defintions */

typedef struct LHsFKey {
	PLHRES Title;
	PLHFUNC Handler;
	UCHAR KeyNum;
	UCHAR Style;
} LHFKEY;

typedef LHFKEY near *PLHFKEYS;

#define	FKEY_SENDMSG	0x01
#define	FKEY_CREATEWND	0x02
#define	FKEY_ALONE		0x00
#define	FKEY_CTRL		0x10
#define	FKEY_ALT		0x20
#define	FKEY_SHIFT		0x40
#define	FKEY_LAST		0x80

/* Menu Definitions */

typedef struct LHsMenu {
	PLHRES Title;
	PLHFUNC Handler;
	UINT HotKey;
	UINT Style;
	UCHAR Help;
} LHMENU;

typedef LHMENU near *PLHMENU;

/* Window Definitions */

typedef struct LHsWindow {
	PLHCLASS Class;
	int x, y, w, h;
	PLHRES Title;
	PLHDATA Data;
	UINT LogicalSize;
	ULONG Style;
	struct LHsWindow near *Parent;
	PLHFKEYS Fkey;
	PLHMENU Menu;
	UCHAR Help;
	UCHAR Status;
	UINT Selection;
	UINT WindowTop;
	UINT Font;
	struct LHsWindow near *NextWnd;
	struct LHsWindow near *PrevWnd;
} LHWINDOW;

typedef LHWINDOW near *PLHWINDOW;

/* LHAPI Block Definitions */

typedef struct LHAPIsBlock {
	PLHWINDOW FirstWnd;
	PLHWINDOW LastWnd;
	PLHWINDOW FocusWnd;
	UINT BeginHighlight;
	UINT EndHighlight;
	UINT Status;
	UCHAR UndoBuffer[128];
	PLHFKEYS Fkey;
	UCHAR far *ScreenSave;
	UINT ScreenSaveStart;
	UINT ScreenSaveEnd;
	int ErrorNum;
	PLHFUNC ErrorHandler;
	UINT MenuFont;
	UINT DefaultFont;
	UINT HelpFkey;
	PLHWINDOW CurrentDialog;
	LHWINDOW TopMenuWnd;
	LHWINDOW PopMenuWnd1;
	LHWINDOW PopMenuWnd2;
	UINT Reserved;
} LHAPIBLOCK;

/* MultiEdit Data Definitions */

typedef struct LHsEditData {
	PLHFARDATA Buffer;
	PLHFARDATA SaveBuffer;
	UINT far * near *LineStarts;
	UINT MaxLines;
	UINT WrapLen;
	UINT CurrentCol;
	UINT CurrentLine;
	UINT NumLines;
	UINT TextLen;
} LHEDITDATA;

typedef LHEDITDATA near *PLHEDITDATA;

/* Constant Definitions */

#define	NO_FKEYS			((PLHFKEYS) -1)
#define	NO_MENU				((PLHMENU) -1)
#define	NO_HELP				((UCHAR) -1)
#define	PARENT_FKEYS		((PLHFKEYS) 0)
#define	PARENT_MENU			((PLHMENU) 0)
#define	CMD_DONE			0
#define	CMD_ESC				1
#define	CMD_DIALOGFOCUS		2
#define	CMD_PUSHB_ACTIVATE	3
#define	CMD_USER			256

/* Style Definitions */

#define	MENU_USER			0x0400
#define	MENU_GRAY			0x0080
#define	MENU_INVISIBLE		0x0040
#define	MENU_CHECKED		0x0020
#define	MENU_BARBEFORE		0x0010
#define	MENU_SENDMSG		0x0008
#define	MENU_PULLDOWN		0x0004
#define	MENU_CREATEWND		0x0002
#define	MENU_ELLIPSIS		0x0001

#define	STYLE_NOSHADOW		0x00004000L
#define	STYLE_COMBOEDIT		0x00008000L
#define	STYLE_DATETIME		0x00010000L
#define	STYLE_CHECKBOX		0x00020000L
#define	STYLE_NO_PARENT_KEY	0x00040000L
#define	STYLE_PUSHB_WIDTH	0x00080000L
#define	STYLE_PUSHBUTTON	0x00100000L
#define	STYLE_COMBOLIST		0x00200000L
#define	STYLE_RADIO			0x00400000L
#define	STYLE_GRAY			0x00800000L
#define	STYLE_XYRELATIVE	0x01000000L
#define	STYLE_WHCHAR		0x02000000L
#define	STYLE_NOBORDER		0x04000000L
#define	STYLE_LEAF			0x08000000L
#define	STYLE_NOTIFY		0x10000000L
#define	STYLE_NOFOCUS		0x20000000L
#define	STYLE_SAVEUNDER		0x40000000L
#define	STYLE_INVISIBLE		0x80000000L

/* Status Definitions */

#define	STATUS_INSERT		0x01
#define	STATUS_DEF_PUSHB	0x01
#define	STATUS_CURSORON		0x02
#define	STATUS_NOT_EDITED	0x04
#define	STATUS_INCREATE		0x08
#define	STATUS_WH_PIXEL		0x10
#define	STATUS_XY_ABS		0x20
#define	STATUS_SAVEUNDER	0x40
#define	STATUS_VISIBLE		0x80

/* Static Text Styles */

#define	DRAW_NORMAL			0x0000L
#define	DRAW_NORM			DRAW_NORMAL
#define	DRAW_INVERSE		0x0001L
#define	DRAW_INVERT			DRAW_INVERSE
#define	DRAW_UNDERLINE		0x0002L
#define	DRAW_GRAY			0x0004L
#define	DRAW_AMPERSAND		0x0010L
#define	DRAW_TAB_TERM		0x0020L
#define	TEXT_CENTER			0x0040L
#define	TEXT_RIGHT			0x0080L

/* StaticRect Styles */

#define	RECT_SHADOW			0x0001L

/* Edit Styles */

#define	EDIT_OVERWRITE		0x0000L
#define	EDIT_INSERT			0x0001L
#define	EDIT_NOCURSOR		0x0002L
#define	EDIT_MULTI			0x0004L
#define	EDIT_NOWRAP			0x0008L

/* ComboBox Styles */

#define	COMBO_EDIT			0x0000L
#define	COMBO_NOEDIT		0x0010L
#define	COMBO_AUTODROP		0x0020L

/* MessageBox Styles */

#define	MSG_CENTER_LINES	0x0010L

/* PushButton Styles */

#define	PUSHB_SENDMSG		0x0001L
#define	PUSHB_CREATEWND		0x0002L

/* DialogBox Styles	*/

#define	DLG_PRESELECT		0x0001L

/* FileOpenDialogBox Styles	*/

#define	FILEOPEN_NODEFAULT	0x0004L
#define	FILEOPEN_WILDCARDS_OK	0x0008L

/* TitleBar Styles */

#define	TITLE_NODATETIME	0x0001L

/* Date & Time Styles */

#define	DATETIME_BOTH		DATETIME_DATE | DATETIME_TIME
#define	DATETIME_INVERSE	0x0001L
#define	DATETIME_DATE		0x0002L
#define	DATETIME_TIME		0x0004L
#define	DATETIME_RIGHT		0x0008L

/* ProgressMeter styles	*/

#define	PROGRESS_NOPERCENT	0x0001L

/* BuiltInClass Definitions */

#define	BuiltInClass(x) ((PLHCLASS) x)

#define	Object				BuiltInClass(0)
#define	Edit				BuiltInClass(1)
#define	RadioButton			BuiltInClass(2)
#define	ListBox				BuiltInClass(3)
#define	ComboBox			BuiltInClass(4)
#define	CheckBox			BuiltInClass(5)
#define	StaticText			BuiltInClass(6)
#define	GroupBox			BuiltInClass(7)
#define	StaticRect			BuiltInClass(8)
#define	PushButton			BuiltInClass(9)
#define	MenuBar				BuiltInClass(10)
#define	MenuPopdown			BuiltInClass(11)
#define	DateEdit			BuiltInClass(12)
#define	TimeEdit			BuiltInClass(13)
#define	DirListBox			BuiltInClass(14)
#define	FileListBox			BuiltInClass(15)
#define	PathText			BuiltInClass(16)
#define	DialogBox			BuiltInClass(17)
#define	MessageBox			BuiltInClass(18)
#define	MultiEdit			BuiltInClass(19)
#define	FileOpenDialogBox	BuiltInClass(20)
#define	TitleBar			BuiltInClass(21)
#define	ProgressMeter		BuiltInClass(22)
#define	DateTime			BuiltInClass(23)

/* Message Definitions */

#define	KEYSTROKE			0
#define	DRAW				1
#define	CREATE				2
#define	DESTROY				3
#define	TERMINATE			4
#define	ACTIVATE			5
#define	DEACTIVATE			6
#define	SETFOCUS			7
#define	LOSEFOCUS			8
#define	NULLEVENT			9
#define	NOTIFY				10
#define	COMMAND				11
#define	APPEAR				12
#define	DISAPPEAR			13

/* CREATE SubMessages */

#define	CREATE_NORMAL		0
#define	CREATE_FOCUS		1

/* DESTROY SubMessages */

#define	DESTROY_NORMAL		0
#define	DESTROY_NODRAW		1

/* DISAPPEAR SubMessages */

#define	DISAPPEAR_NORMAL	0
#define	DISAPPEAR_NODRAW	1

/* NOTIFY SubMessages */

#define	NOTIFY_CHILDCHANGED	0
#define	NOTIFY_CHILDKILLED	1
#define	NOTIFY_UPDATE		2
#define	NOTIFY_SORT			3
#define	NOTIFY_USER			256

/* DRAW SubMessages */

#define	DRAW_TITLE			0x0001
#define	DRAW_FKEYS			0x0002
#define	DRAW_CLIENT			0x0004
#define	DRAW_CLIENT_UPDATE	0x0008
#define	DRAW_CLIENT_CHAR	0x0010
#define	DRAW_FRAME			0x0020
#define	DRAW_CURSOR			0x0040
#define	DRAW_USER			0x0100
#define	DRAW_ALL			0xFFE7

/* SETFOCUS SubMesssages */

#define	SETFOCUS_NORMAL		0
#define	SETFOCUS_NOLOSE		1
#define	SETFOCUS_SELECT		2

/* LOSEFOCUS SubMesssages */

#define	LOSEFOCUS_NORMAL	0
#define	LOSEFOCUS_MENU		1

/* FunctionKey ScanCode Definitions */

#define	UPKEY				0x4800
#define	DOWNKEY				0x5000
#define	LEFTKEY				0x4b00
#define	RIGHTKEY			0x4d00
#define	PAGEUPKEY			0x4900
#define	PAGEDOWNKEY			0x5100
#define	HOMEKEY				0x4700
#define	ENDKEY				0x4f00
#define	DELKEY				0x5300
#define	F1KEY				0x3b00
#define	F2KEY				0x3c00
#define	F3KEY				0x3d00
#define	F4KEY				0x3e00
#define	F5KEY				0x3f00
#define	F6KEY				0x4000
#define	F7KEY				0x4100
#define	F8KEY				0x4200
#define	F9KEY				0x4300
#define	F10KEY				0x4400
#define	SHIFTF1KEY			0x5400
#define	SHIFTF2KEY			0x5500
#define	SHIFTF3KEY			0x5600
#define	SHIFTF4KEY			0x5700
#define	SHIFTF5KEY			0x5800
#define	SHIFTF6KEY			0x5900
#define	SHIFTF7KEY			0x5A00
#define	SHIFTF8KEY			0x5B00
#define	SHIFTF9KEY			0x5C00
#define	SHIFTF10KEY			0x5D00
#define	MENUKEY				0xC800
#define	SHIFTMENUKEY		0xC900

/* Font Size Definitions */

#define	FONT_DEFAULT		0
#define	FONT_PARENT			1
#define	FONT_DEFAULTS		2
#define	FONT_SMALL			0x0808
#define	FONT_NORMAL			0x0a0b
#define	FONT_NORM			FONT_NORMAL
#define	FONT_LARGE			0x100c

/* Event Definitions */

enum event_kind {
	E_NONE,		E_KEY,		E_BREAK,	E_ACTIV,
	E_DEACT,	E_TERM,		E_BRIDGE,	E_GROW,
	E_SHRINK,	E_ALARM_EXP,E_ALARM_DAY,E_TIMECHANGE,
	E_SWAP,		E_IC_INIT,	E_IC_CLOSE,	E_REFRESH,
	E_RETURN,	E_SERVICE,	E_ALARM_EXP_NOT_CURRENT
};

enum edo_event {
	DO_EVENT,	DO_YIELD,	DO_FINI,	DO_NO_EVENT,
	DO_NO_FINI,	DO_BRIDGE,	DO_IC_INIT,	DO_IC_CLOSE,
	DO_SWAP,	DO_LAUNCH,	DO_EXEC,	DO_DOS_CLOSE,
	DO_REFRESH,	DO_RETURN,	DO_SERVICE_COMPLETE,
	DO_REQUEST_FOREGROUND,	DO_CLOSE_APP,
	DO_EXEC_FULL,			DO_EXIT_SYSMGR,
	DO_MOVE_TO_END
};

/* Standard Event Structures */

typedef struct {
	enum	event_kind kind;
#if defined(LSIC)
	UCHAR	dummy1;
#endif
	UINT	data;
	UCHAR	scan;
	UCHAR	shifts;
	UINT	lics;
	UINT	fkey_num;
	void far *bridge;
	enum edo_event do_event;
#if defined(LSIC)
	UCHAR	dummy2;
#endif
	UINT	return_status;
} EVENT_NORM;

/* Launch Event Structures */

typedef struct {
	enum	event_kind kindie;
#if defined(LSIC)
	UCHAR	dummy3;
#endif
	UINT	dummy4;
	UCHAR	e_launch_task;
	UCHAR	e_launch_type;
} EVENT_L;

typedef struct {
	enum	event_kind kindic;
#if defined(LSIC)
	UCHAR	dummy5;
#endif
	UINT	dummy6;
	void far	**e_icdata_ptr;
	UCHAR		e_link_task;
	void far	**e_slave_offset;
} EVENT_IC;

typedef struct {
	enum	event_kind kindex;
#if defined(LSIC)
	UCHAR	dummy7;
#endif
	UINT		dummy8;
	LPSTR		e_exec_file_ptr;
	LPSTR		e_cmd_tail_ptr;
	UCHAR		e_task_id;
} EVENT_EXEC;

typedef struct {
	LPSTR		ex_file_spec;
	LPSTR		ex_command_line;
	UINT		ex_DOSsizek;
	UINT		ex_pause;
	UINT		ex_lock;
} EXEC_STRUCT;

typedef struct {
	enum	event_kind kindsvc;
#if defined(LSIC)
	UCHAR	dummy9;
#endif
	UINT		dummy10;
	LPSTR		e_svc_user_ptr;
	UCHAR		e_svc_user_type;
} EVENT_SERVICE;

typedef struct {
	enum	event_kind kindalm;
#if defined(LSIC)
	UCHAR	dummy11;
#endif
	UINT	e_alm_special;
	UCHAR	e_almdummy[3];
	UCHAR	e_almcurtask;
	UINT	e_alm_extra[2];
} EVENT_ALARM;

typedef struct {
	enum	event_kind exec_kind;
#if defined(LSIC)
	UCHAR	dummy12;
#endif
	UINT	dummy13;
	void far	*exec_struc_ptr;
} EVENT_EXECF;

typedef union
{
	EVENT_NORM		norm;
	EVENT_L			l;
	EVENT_IC		ic;
	EVENT_EXEC		exec;
	EVENT_SERVICE	service;
	EVENT_ALARM		alarm;
	EVENT_EXECF		execf;
} EVENT;

/* Time & Date & Alarm Structures */

typedef struct {
	char	dt_order;
	char	dt_dsep;
	char	dt_tsep;
	char	dt_24hr;
} DTINFO;

/* dt_order constants */

#define	DATE_MDY	0
#define	DATE_DMY	1
#define	DATE_YMD	2

typedef struct {
	int		dt_year;
	char	dt_month;
	char	dt_date;
	char	dt_day;
	char	dt_hour;
	char	dt_minute;
	char	dt_second;
	char	dt_hundreth;
} DTM;

typedef struct {
	char	t_hundreth;
	char	t_second;
	char	t_minute;
	char	t_hour;
} TIME;

typedef struct {
	int		na_year;
	char	na_month;
	char	na_date;
	char	na_hour;
	char	na_minute;
	char	na_second;
	char	na_dummy;
	char	na_sound;
	char	na_message[36];
	char	na_special;
	char	na_extrac[4];
	char	na_old;
	ULONG	na_tot_secs;
	char	na_owner;
} NEWALARM;

/* Alarm Styles */

#define	ALARM_FORCE		1
#define	ALARM_IF_EARLY	2
#define	ALARM_IF_CLEAR	4

#define	DATE_ONLY		0
#define	TIME_ONLY		1
#define	DATE_N_TIME		2
#define	DAY_N_DATE		3
#define	SUPP_AMPM		0x10
#define	SUPP_SECOND		0x20
#define	SHOW_YEAR		0x40
#define	FOUR_DIGIT_YEAR	0x80

typedef struct {
	DTM		oldtime;
	DTM		newtime;
} TIMECHANGE;

/* File Attribute Constants */

#define	FA_NORMAL		0x00
#define	FA_READONLY		0x01
#define	FA_HIDDEN		0x02
#define	FA_SYSTEM		0x04
#define	FA_ARCHIVE		0x20

/* File Operation Constans */

#define	FUN_OPEN		0x3d
#define	FUN_CREATE		0x3c
#define	MODE_NO_TRUNC	0x0
#define	MODE_RO			0x00
#define	MODE_TRUNC		0x01
#define	MODE_RW			0x02

typedef struct {
	int		f_handle;
	int		f_flag;
	long	f_pseek;
	long	f_lseek;
	long	f_vseek;
	int		f_len;
	char	f_buf[512];
} FILE;

typedef struct {
	int		f_handle;
	int		f_flag;
	long	f_pseek;
	long	f_lseek;
	long	f_vseek;
	int		f_len;
} NBFILE;

/* Flag Constants */

#define	VALID	0x01
#define	DIRTY	0x02
#define	NOBUF	0x04
#define	DEVICE	0x08

/* File Match Structure */

typedef struct {
	char	m_reserved[21];
	char	m_attr;
	int		m_time;
	int		m_date;
	long	m_size;
	char	m_name[13];
	char	m_path[80];
	char	m_ofs;
	char	m_fn;
} MATCH;

typedef enum m_ident_type {
	ident_none=0,
	ident_file=1,
	ident_directory=2,
	ident_device=3
} m_ident_type;

typedef enum m_seek_type {
	seek_beginning=0,
	seek_current=1,
	seek_end=2
} m_seek_type;

/* Function Prototypes */

void far InitializeLHAPI(LHAPIBLOCK *LHAPIData,...);
void far DeactivateLHAPI(void);
void far ReactivateLHAPI(LHAPIBLOCK *LHAPIData,...);
void far UninitializeLHAPI(void);
LHAPIBLOCK * far GetLHAPIBlockPtr(void);
void far SyncLHAPIKeyState(void);
void far SendAllMsg(UINT Message, UINT Data, UINT Extra,...);
int far SendFocusMsg(UINT Message, UINT Data, UINT Extra,...);
int far SendMsg(PLHWINDOW Window, UINT Message, UINT Data, UINT Extra,...);
int far SubclassMsg(PLHCLASS Class, PLHWINDOW Window, UINT Message,UINT Data, UINT Extra,...);
void far ResetAlt(void);
PLHWINDOW far GetFocus(void);
int far SetError(int ErrorNum,...);
int far GetError(void);
void far ClearError(void);
void far SetErrorHandler(PLHFUNC Handler,...);
PLHFUNC far GetErrorHandler(void);
UINT far DrawText(int x, int y, char far *Buffer, UINT Style, UINT Font,...);
UINT far DrawNChars(int x, int y, char far *Buffer, UINT Style,UINT Font, UINT MaxChars,...);
UINT far DrawChar(int x, int y, UCHAR CharCode, UINT Style, UINT Font,...);
void far DrawFKeys(PLHWINDOW Window, UINT ShiftState,...);
void far Rectangle(int x, int y, int w, int h, UINT Color, UINT Flags,...);

/* Flags of Rectangle */
#define	G_OUTLINE		0
#define	G_SOLIDFILL		1
#define	G_PATTERNFILL	2

void far Panel(int x, int y, int w, int h,...);
void far Outline(int x, int y, int w, int h,...);
void far ShadowBox(int x, int y, int w, int h,...);
void far ClearRect(int x, int y, int w, int h,...);
void far Line(int x1, int y1, int x2, int y2, UINT Color,...);
void far RegisterFont(UINT Font,...);
void far SetDefaultFont(UINT Font,...);
UINT far GetDefaultFont(void);
void far SetCurrentFont(UINT Font,...);
UINT far GetCurrentFont(void);
void far SetMenuFont(UINT Font,...);
void far SetGlobalClipping(int x1, int y1, int x2, int y2,...);
void far SetLocalClipping(int x1, int y1, int x2, int y2,...);
void far GetLocalClipping(int *x1, int *y1, int *x2, int *y2,...);
void far IntersectLocalClipping(int x1, int y1, int x2, int y2,...);
void far ShowSymbol(int x, int y, UINT Symbol,...);
void far ResetVideo(void);
void far SetRepRule(UCHAR RepRule,...);
void far ResetRepRule(void);
void far SetHelpFkey(UINT HelpKeycode,...);

int far lstrlen(LPSTR farstr);
int far lstrcpy(LPSTR dest,LPSTR source);
int far lstrcat(LPSTR dest,LPSTR source);
int far lstrcpyto(LPSTR dest, LPSTR source, int maxsize);

/* Macro Functions Definitions */

int far			c_service2(UINT arg1,...);
void near * far	c_service2_near_ptr (UINT arg1,...);
void far * far	c_service2_far_ptr(UINT arg1,...);
int far			c_service2_based_ptr(UINT arg1,void *arg2,ULONG arg3,...);
int far			c_service2_far_mem(UINT arg1,void *arg2,ULONG arg3,...);
int far			c_service2_get_static(UINT arg1,void far *arg2,ULONG arg3,...);
void far		c_service2_reg_based(UINT arg1,void *arg2,UINT arg3,...);
int far			c_service2_long_based(UINT arg1,void *arg2,ULONG arg3,...);
int far			c_service2_long_far(UINT arg1,void *arg2,ULONG arg3,...);
void far		c_service2_reg_far(UINT arg1,void *arg2,UINT arg3,UINT arg4,...);
int far			c_service2_free_static(UINT arg1,void far *arg2,...);
ULONG far		c_service2_get_avail_mem(UINT arg1,...);

#define	m_get_class_tbl()					c_service2_far_ptr(0x4001)
#define	m_insert_fnct_tbl(Class,FnctTbl)	c_service2(0x4002,Class,(void far *)(FnctTbl))
#define	m_remove_fnct_tbl(Class,FnctTbl)	c_service2(0x4003,Class,(void far *)(FnctTbl))
#define	m_disable_fnct_tbl(ClassFnct)		c_service2(0x4004,ClassFnct)
#define	m_enable_fnct_tbl(ClassFnct)		c_service2(0x4005,ClassFnct)
#define	m_get_free_api_class(ClassType)		c_service2(0x4006,ClassType)
#define	m_search_api_class(ClassType,String,Len)	c_service2(0x4007,ClassType,(void far *)String,Len)
#define	m_get_api_error()					c_service2(0x4008)
#define	m_clear_api_error()					c_service2(0x4009)
#define	m_valid_api_fnct(ClassFnct)			c_service2(0x400a,ClassFnct)

#define	m_sh_status()		c_service2(0x4103)
#define	m_flush_kb()		c_service2(0x4106)
#define	m_yield(a)			c_service2(0x4107,(void far *)(a))
#define	m_no_fini(a)		c_service2(0x4108,(void far *)(a))
#define	m_action(a)			c_service2(0x4109,(void far *)(a))
#define	m_launch(a)			c_service2(0x410a,(void far *)(a))
#define	m_get_run_mode()	c_service2(0x410b)
#define	m_ic_init(a)		c_service2(0x410c,(void far *)(a))
#define	m_ic_close(a)		c_service2(0x410d,(void far *)(a))
#define	m_swap(a)			c_service2(0x410e,(void far *)(a))
#define	m_do_exec(a)		c_service2(0x410f,(void far *)(a))
#define	m_do_DOS_close(a)	c_service2(0x4110,(void far *)(a))

#define	m_open(a,b,c,d,e)	c_service2(0x4501,(void far *)(a),(void far *)(b),c,d,e)
#define	m_openro(a,b,c,d,e)	c_service2(0x4502,(void far *)(a),(void far *)(b),c,d,e)
#define	m_create(a,b,c,d,e)	c_service2(0x4503,(void far *)(a),(void far *)(b),c,d,e)
#define	m_fcreat(a,b,c,d,e)	c_service2(0x4504,(void far *)(a),(void far *)(b),c,d,e)
#define	m_read(a,b,c,d)			\
	c_service2(0x4505,(void far *)(a),(void far *)(b),c,(void far *)(d))
#define	m_write(a,b,c)		c_service2(0x4506,(void far *)(a),(void far *)(b),c)
#define	m_seek(a,b,c)		c_service2(0x4507,(void far *)(a),b,c)
#define	m_tell(a,b)			c_service2(0x4508,(void far *)(a),(void far *)(b))
#define	m_close(a)			c_service2(0x4509,(void far *)(a))
#define	m_setpat(a,b,c,d)	c_service2(0x450a,(void far *)(a),(void far *)(b),c,d)
#define	m_match(a,b)		c_service2(0x450b,(void far *)(a),(void far *)(b))
#define	m_ident(a,b,c,d)	c_service2(0x450c,(void far *)(a),b,c,(void far *)(d))
#define	m_delete(a,b,c)		c_service2(0x450d,(void far *)(a),b,c)
#define	m_rename(a,b,c,d,e,f)	\
	c_service2(0x450e,(void far *)(a),b,c,(void far *)(d),e,f)
#define	m_getdir(a,b,c)		c_service2(0x450f,a,(void far *)(b),(void far *)(c))
#define	m_setdir(a,b)		c_service2(0x4510,(void far *)(a),b)
#define	m_volume(a,b)		c_service2(0x4511,(void far *)(a),(void far *)(b))
#define	m_mkdir(a,b,c)		c_service2(0x4512,(void far *)(a),b,c)
#define	m_rmdir(a,b,c)		c_service2(0x4513,(void far *)(a),b,c)
#define	m_getdrv(a)			c_service2(0x4514,(void far *)(a))
#define	m_setdrv(a)			c_service2(0x4515,a)
#define	m_fdate(a,b)		c_service2(0x4516,(void far *)(a),(void far *)(b))
#define	m_get_sysdir(a)		c_service2(0x4517,(void far *)(a))
#define	m_getattr(a,b,c,d)	c_service2(0x4518,(void far *)(a),b,c,(void far *)(d))
#define	m_setattr(a,b,c,d)	c_service2(0x4519,(void far *)(a),b,c,d)
#define	m_copydt(a,b)		c_service2(0x451b,(void far *)(a),(void far *)(b))
#define	m_getfdt(a,b)		c_service2(0x451c,(void far *)(a),(void far *)(b))
#define	m_putfdt(a,b)		c_service2(0x451d,(void far *)(a),b)
#define	m_card_changes()	c_service2(0x451e)
#define	m_flush(a)			c_service2(0x451f,(void far *)(a))
#define	m_get_drive_list(a)	c_service2(0x4520,(void far *)(a))

#define	m_fini()			c_service2(0x4602)
#define	m_lock()			c_service2(0x4603)
#define	m_unlock()			c_service2(0x4604)
#define	m_spawn(a,b,c,d)	\
	c_service2(0x4605,(void far *)(a),b,c,(void far *)(d))
#define	m_appcount()		c_service2(0x4606)
#define	m_reg_app_name(a)	c_service2(0x4609,(void far *)(a))
#define	m_init_app(a)		c_service2(0x460b,a)
#define	m_keylock()			c_service2(0x460c)
#define	m_keyunlock()		c_service2(0x460d)

#define	m_open_cb()			c_service2(0x4701)
#define	m_close_cb()		c_service2(0x4702)
#define	m_reset_cb(a)		c_service2(0x4703,(void far *)(a))
#define	m_get_cb_info(count,author,cbsize,inuse)		\
	c_service2(0x4704,(void far *)(count), (void far *)(author),	\
						(void far *)(cbsize), (void far *)(inuse))
#define	m_new_rep(a)		c_service2(0x4705,(void far *)(a))
#define	m_fini_rep()		c_service2(0x4706)
#define	m_rep_index(a,b,c)		\
	c_service2(0x4708,(void far *)(a),(void far *)(b),(void far *)(c))
#define	m_cb_write(a,b)		c_service2(0x4709,(void far *)(a),b)
#define	m_cb_read(a,b,c,d)	c_service2(0x470a,a,b,(void far *)(c),d)

#define	m_beep()			c_service2(0x4801)
#define	m_thud()			c_service2(0x4802)
#define	m_asound(a)			c_service2(0x4803,a)
#define	m_soundoff()		c_service2(0x4804)
#define	m_play(a)			c_service2(0x4805,(void far *)(a))

#define	m_alloc(a)			c_service2_near_ptr(0x4901,a)
#define	m_free(a)			c_service2(0x4903,a)
#define	m_alloc_large(a)	c_service2_near_ptr(0x4904,a)
#define	m_free_large(a)		c_service2_near_ptr(0x4905,a)
#define	m_get_far_block(a,b)	c_service2_far_mem(0x4909,a,b)
#define	m_set_far_block(a,b)	c_service2_long_far(0x490a,a,b)
#define	m_reg_far(a,b,c)	c_service2_reg_far(0x490b,a,b,c)
#define	m_get_avail_mem()	c_service2_get_avail_mem(0x490c)
#define	m_get_TCB()			c_service2_far_ptr(0x490d)
#define	m_get_far_handle(a)	c_service2(0x490e,a)
#define	m_modify_hot_key(a)	c_service2_far_ptr(0x490f,a)
#define	m_task_info(a, b, c)	c_service2(0x4910,a,b,(void far *)(c))
#define	m_current_task()	c_service2(0x4911)
#define	m_QuickKeyCheck()	c_service2(0x4912)
#define	m_get_avail_static_mem()	c_service2_get_avail_mem(0x4913)
#define	m_get_static_block(a,b)	c_service2_long_far(0x4914,a,b)
#define	m_free_static_block(a)	c_service2_free_static(0x4915,(void far *)(a))
#define	m_get_SVC_entry(a,b)		\
	c_service2_free_static(0x4916,(void far *)(a),(void far *)(b))
#define	m_free_SVC_entry(a)	c_service2_free_static(0x4917,a)
#define	m_load_TSR(a)		c_service2(0x4918,(void far *)(a))
#define	m_locate_SVC(a)		c_service2_far_ptr(0x4919,(void far *)(a))
#define	m_get_static_size()	c_service2(0x491a)
#define	m_set_static_size(a)	c_service2(0x491b,a)
#define	m_get_static_used()	c_service2(0x491c)
#define	m_get_DOS_part_size()	c_service2(0x491d)
#define	m_set_DOS_part_size(a)	c_service2(0x491e,a)
#define	m_get_active_DOS_size()	c_service2(0x491f)
#define	m_get_DOS_hot_key()		c_service2(0x4920)
#define	m_set_DOS_hot_key(a)	c_service2(0x4921,a)
#define	m_get_avail_123_mem()	c_service2_get_avail_mem(0x4922)
#define	m_lock_out_app_key()	c_service2(0x4923)
#define	m_enable_app_key()		c_service2(0x4924)
#define	m_get_far_user_handle(a)	c_service2(0x4925,a)
#define	m_get_avail_init_mem()	c_service2_get_avail_mem(0x4926)
#define	m_load_client()			c_service2(0x4927)
#define	m_unload_client()		c_service2(0x4928)

#define	m_dtinfo(a)		c_service2(0x4b01,(void far *)(a))
#define	m_getdtm(a)		c_service2(0x4b02,(void far *)(a))
#define	m_setdtm(a)		c_service2(0x4b03,(void far *)(a))
#define	m_xalarm(a)		c_service2(0x4b04,a)
#define	m_start_sw(a)	c_service2(0x4b06,(void far *)(a))
#define	m_get_sw(a,b,c)	c_service2(0x4b07,(void far *)(a),(void far *)(b),(void far *)(c))
#define	m_stop_sw(a)	c_service2(0x4b08,(void far *)(a))
#define	m_telltime(a,b,c)	c_service2(0x4b09,a,b,c)
#define	m_start_timer(a)	c_service2(0x4b0c,(void far *)(a))
#define	m_stop_timer(a)		c_service2(0x4b0d,(void far *)(a))
#define	m_get_timer(a,b,c)	c_service2(0x4b0e,(void far *)(a),(void far *)(b),(void far *)(c))
#define	m_tell_anytime(a,b,c,d,e)		\
	c_service2_far_ptr(0x4b0f,a,b,c, (void far *)(d), (void far *)(e))
#define	m_parse_date(a,b,c)	c_service2(0x4b11,a,(void far *)(b),(void far *)(c))
#define	m_parse_time(a,b,c)	c_service2(0x4b12,a,(void far *)(b),(void far *)(c))
#define	m_nalarm(a,b)		c_service2(0x4b17,(void far *)(a),b)
#define	m_nfalarm(a,b)		c_service2(0x4b18,(void far *)(a),b)
#define	m_keybez()			c_service2(0x4b19)

#define	m_open_printer()		c_service2(0x4c01)
#define	m_close_printer()		c_service2(0x4c02)
#define	m_write_printer(a,b)	c_service2(0x4c03,(void far *)(a),b)
#define	m_init_printer()		c_service2(0x4c04)
#define	m_trans_printer(a,b)	c_service2(0x4c05,a,(void far *)(b))

#define	m_write_printer_atb(a)	c_service2(0x4c07,a)
#define	m_trans_printer_atb(a,b)	c_service2(0x4c08,a,(void far *)(b))

typedef struct COM_SETTINGS {
	char	UnusedDial;
	int		Baud;
	char	Parity;
	char	Stop;
	char	Data;
	char	Flow;
	char	InfraRed;
	char	UnusedDuplex;
	char	UnusedEcho;
} ComSettings_t;

#define	ComOpen(a,b)	c_service2(0x4e02,(int far *)(a),(int)(b))
#define	ComClose(a)		c_service2(0x4e03,(int)(a))
#define	ComReset(a,b)	c_service2(0x4e07,(int)(a),(int)(b))
#define	ComSendBytes(a,b,c,d)	\
	c_service2(0x4e09,(int)(a),(char far *)(b),(int)(c),(int far *)(d))
#define	ComQryTxQue(a,b,c)		\
	c_service2(0x4e0a,(int)(a),(int far *)(b),(int far *)(c))
#define	ComQryRxQue(a,b,c)		\
	c_service2(0x4e0b,(int)(a),(int far *)(b),(int far *)(c))
#define	ComReceiveBytes(a,b,c)	\
	c_service2(0x4e0c,(int)(a),(char far *)(b),(int far *)(c))
#define	ComHayesCommand(a,b,c)	\
	c_service2(0x4e0d,(int)(a),(char far *)(b),(int)(a))
#define	ComBreak(a,b)	c_service2(0x4e0f,(int)(a),(int)(b))
#define	ComForceXon(a)	c_service2(0x4e10,(int)(a))
#define	ComForceXoff(a)	c_service2(0x4e11,(int)(a))
#define	ComXmitting(a)	c_service2(0x4e13,(int)(a))
#define	ComQryErr(a)	c_service2(0x4e18,(int)(a))
#define	ComAcquire(a,b)	c_service2(0x4e19,(int)(a),(int)(b))
#define	ComRelease(a)	c_service2(0x4e1a,(int)(a))
#define	ComGetParameters(a,b) 	\
	c_service2(0x4e1b,(int)(a),(ComSettings_t far *)(b))
#define	ComSetParameters(a, b)	\
	c_service2(0x4e1c,(int)(a),(ComSettings_t far *)(b))
#define	ComMdmClr(a,b)	c_service2(0x4e1d,(int)(a),(int)(b))
#define	ComMdmSet(a,b)	c_service2(0x4e1e,(int)(a),(int)(b))
#define	ComMdmStatus(a,b,c)		\
	c_service2(0x4e1f,(int)(a),(int far *)(b),(int far *)(c))
#define	ComAcqReceiveBytes(a,b,c)	\
	c_service2(0x4e20,(int)(a),(char far *)(b),(int far *)(c),(int)(d))
#define	ComAcqSendBytes(a,b,c,d)	\
	c_service2(0x4e21,(int)(a),(char far *)(b),(int)(c),(int far *)(d))
#define	ComPower(a)		c_service2(0x4e22,(int)(a))

#define	m_sys_rsrc_addr()	c_service2_far_ptr(0x4f08)

#define	m_disable_macros()	c_service2(0x4f0b)
#define	m_enable_macros()	c_service2(0x4f0c)

#define	m_form_ft(a)		c_service2_far_ptr(0x4f0e,(void far *)(a))
#define	m_ram_iv_info(a)	c_service2(0x4f0f,(void far *)(a))
#define	m_get_sysver()		c_service2_far_ptr(0x4f10)
#define	m_start_record(a)	c_service2_far_ptr(0x4f11,a)
#define	m_stop_record()		c_service2_far_ptr(0x4f12)
#define	m_update_apname_list(a)	c_service2_far_ptr(0x4f13,(int)a)
#define	m_get_TCB_size()	c_service2_far_ptr(0x4f14)
#define	m_playback_macro(a)	c_service2(0x4f15,(int)a)

#define	map_resource_file(a)	c_service2(0x5401,(void far *)(a))
#define	get_resource_ptr(a)		c_service2_far_ptr(0x5402,a)
#define	get_rsrc_tab_ptr()		c_service2_far_ptr(0x5403)
#define	init_sysmgr_resources()	c_service2(0x5404)
#define	m_InitKeyLabels()		c_service2(0x5405)
#define	m_GetScanCode(a)		c_service2(0x5406,(void far *)(a))
#define	m_GetKeyLabel(a,b)		c_service2(0x5407,(void far *)(a),b)

#define	m_col_init()		c_service2(0x5601)
#define	m_col_cpstr(a,b,c,d)	c_service2(0x5602,(void far *)(a),b,(void far *)(c),d)
#define	m_col_tolower(a,b)	c_service2(0x5605,(void far *)(a),b)
#define	m_col_cpsearch(a,b,c,d,e)	\
	c_service2(0x5606,(void far *)(a),b,(void far *)(c),d,e)
#define	m_col_toupper(a,b)	c_service2(0x5607,(void far *)(a),b)
