
#include	"lxapi.h"

#include	<string.h>
#include	<stddef.h>

#define		LISTCOUNT		128
#define		DIRCOUNT		64	
#define		MLMAXLENGTH		256
#define		MLMAXLINE		20

char far	*msgnull =		"";
char far	*msgAppName =	"TestProgram";
char far	*msg2 =			"";
char far	*msg3 =			"";
char far	*msg4 =			"";
char far	*msg5 =			"";
char far	*msg6 =			"";
char far	*msg7 =			"";

char far	*msgF1 =		"Check";
char far	*msgF2 =		"Radio";
char far	*msgF3 =		"Combo";
char far	*msgF4 =		"ListBox";
char far	*msgF5 =		"Meter";
char far	*msgF6 =		"Message";
char far	*msgF7 =		"Multi";
char far	*msgF8 =		"Edit";
char far	*msgF9 =		"Open";
char far	*msgF10 =		"Quit";

char far	*msgCheck =		"&Check";
char far	*msgRadio =		"&Radio";
char far	*msgCombo =		"C&ombo";
char far	*msgList =		"&List";
char far	*msgMeter =		"&Meter";
char far	*msgMsgBox =	"M&sg";
char far	*msgMulti =		"Mul&t";
char far	*msgEdit =		"&Edit";
char far	*msgOpen =		"&Open";
char far	*msgQuit =		"&Quit";

char far	*msgCAN	=		"Cancel";
char far	*msgOK	=		"OK";

char far	*msgButton1 =	"12Dot";
char far	*msgButton2 =	"16Dot";
char far	*msgButton3 =	"24Dot";
char far	*msgButton4 =	"32Dot";

char far	*msgBox1 =	"Normal";
char far	*msgBox2 =	"UnderLine";
char far	*msgBox3 =	"Italic";
char far	*msgBox4 =	"Bold";

char far	*msgGroupBox =	"GroupBox";
char far	*msgCheckBox =	"CheckBox Class";
char far	*msgRadioBox =	"RadioButton Class";
char far	*msgComboBox =	"ComboBox Class";
char far	*msgListBox  =	"ListBox Class";
char far	*msgMeterBox =	"Progress Meter";
char far	*msgEditBox =	"Edit Class";
char far	*msgCheckOpen =	"FileOpen DialogBox";
char far	*msgMultiEdit =	"Multi Line Edit";

/*	-- original Japanese message -- 
 * char far	*msgBoxText  =	"MessageBoxNXŏo͂\n"
 *							"eLXgłBMessageBoxNXł\n"
 *							"s̏o͂ł܂̂ŃG[\n"
 *							"Ƃ̐is󋵂Ȃǂڂ|[g\n"
 *							"ۂɕ֗łB\n"
 *							"̃NX̓wvȂǂɂpo\n"
 *							"܂Bs̃|C^Ŏw\n"
 *							"ôŊȒPɂł܂ˁB"; 
 */

char far	*msgBoxText  =	"This text is an output example of\n"
							"MessageBox Class.  The ability to\n"
							"display more than one line makes\n"
							"MessageBox Class particularly\n"
							"useful for a detail progress\n"
							"report or for a HELP screen.\n"
							"   One pointer can specify the\n"
							"whole text with multiple lines.";

char far	**MsgBoxPtr	= 	&msgBoxText;

char far	*MLBuffer;
char far	*MLBufferSave;
int  far	*LNBufPtr;

char far	**StringTable[]={
	&msgnull, &msgAppName,
	&msgF1, &msgF2, &msgF3, &msgF4, &msgF5,
	&msgF6, &msgF7, &msgF8, &msgF9, &msgF10,
	&msgCheck, &msgRadio, &msgCombo, &msgList,
	&msgMeter, &msgMsgBox, &msgMulti, &msgEdit, &msgQuit,
	&msgOK, &msgCAN, &msgEditBox, &msgCheckOpen,
	&msgMultiEdit, &MLBuffer, &MLBufferSave,(char far **)&LNBufPtr,
	&msgBoxText, &msgMeterBox, &msgListBox, &msgComboBox,
	&msgRadioBox, &msgCheckBox,
	&msgGroupBox, &msgButton1, &msgButton2, &msgButton3,
	&msgButton4, &msgCheck, &msgBox1, &msgBox2, &msgBox3, &msgBox4
};

int			RadioWork;
int			CheckWork;
char near	FileNameBuffer[48];
char near	DirNameBuffer[48];
char near	DefaultFileName[16];
char near	EditString[20]=	"Test Strings\0";
char near	*ListDataArray[]={	"Application","Programming","Interface",
								"Reference","Development","Manual",
								"System","Manager"};

int far MainHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra,...);
int far MessageBoxHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);
int far MultiEditHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);
int far EditHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);
int far FileOpenHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra,...);
int far ListBoxHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra,...);
int far RadioBoxHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra,...);
int far CheckBoxHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra,...);

void far DoQuit( void );
void far DoFoDlg( void );
void far DoEdit( void );
void far DoMultiEdit( void );
void far DoMsgBox( void );
void far DoMeter( void );
void far DoList( void );
void far DoRadio( void );
void far DoCheck( void );
void far DoCombo( void );

BOOL		Done;
LHAPIBLOCK	CapData;
EVENT_NORM	app_event;

char far	*SysMgrPtrs[16];

LHFKEY OkFkeys[] = {
	{ (PLHRES)&msgOK,(PLHFUNC)CMD_ESC, 10+FKEY_LAST, FKEY_SENDMSG }
};

LHFKEY ChoseFkeys[] = {
	{ (PLHRES)&msgCAN, (PLHFUNC)CMD_ESC, 9, FKEY_SENDMSG },
	{ (PLHRES)&msgOK,(PLHFUNC)CMD_DONE, 10+FKEY_LAST, FKEY_SENDMSG }
};

LHFKEY MainFKeys[] = {
	{ (PLHRES)&msgF1, (PLHFUNC)DoCheck, 1, 0 },
	{ (PLHRES)&msgF2, (PLHFUNC)DoRadio, 2, 0 },
	{ (PLHRES)&msgF3, (PLHFUNC)DoCombo, 3, 0 },
	{ (PLHRES)&msgF4, (PLHFUNC)DoList,  4, 0 },
	{ (PLHRES)&msgF5, (PLHFUNC)DoMeter, 5, 0 },
	{ (PLHRES)&msgF6, (PLHFUNC)DoMsgBox,6, 0 },
	{ (PLHRES)&msgF7, (PLHFUNC)DoMultiEdit, 7, 0 },
	{ (PLHRES)&msgF8, (PLHFUNC)DoEdit , 8, 0 },
	{ (PLHRES)&msgF9, (PLHFUNC)DoFoDlg, 9, 0 },
	{ (PLHRES)&msgF10,(PLHFUNC)DoQuit , 10+FKEY_LAST, 0 }
};

LHMENU MainMenu[] = {
	{ (PLHRES)&msgCheck, (PLHFUNC)DoCheck, 0, 0, NO_HELP },
	{ (PLHRES)&msgRadio, (PLHFUNC)DoRadio, 0, 0, NO_HELP },
	{ (PLHRES)&msgCombo, (PLHFUNC)DoCombo, 0, 0, NO_HELP },
	{ (PLHRES)&msgList,  (PLHFUNC)DoList,  0, 0, NO_HELP },
	{ (PLHRES)&msgMeter, (PLHFUNC)DoMeter, 0, 0, NO_HELP },
	{ (PLHRES)&msgMsgBox,(PLHFUNC)DoMsgBox,0, 0, NO_HELP },
	{ (PLHRES)&msgMulti, (PLHFUNC)DoMultiEdit, 0, 0, NO_HELP },
	{ (PLHRES)&msgEdit,  (PLHFUNC)DoEdit,  0, 0, NO_HELP },
	{ (PLHRES)&msgOpen,  (PLHFUNC)DoFoDlg, 0, 0, NO_HELP },
	{ (PLHRES)&msgQuit,  (PLHFUNC)DoQuit,  0 },
	{ 0, 0, 0, 0 }
};

LHWINDOW MainView = {
		(PLHCLASS)MainHandler, 0, 0, 640, 190,
		(PLHRES)&msgnull, 0, 0, 0,
		NULL, MainFKeys, MainMenu, NO_HELP
};

LHWINDOW TDateTime = {
		DateTime, 0, 0, 0, 0,
		0, 0, 0, STYLE_DATETIME|STYLE_NOFOCUS,
		NULL, NO_FKEYS, NO_MENU, NO_HELP
};

LHWINDOW MainTitle = {
		TitleBar, 0, 0, 0, 0,
		(PLHRES)&msgAppName, 0, 0, STYLE_NOFOCUS,
		NULL, NO_FKEYS, (PLHMENU)&TDateTime, NO_HELP
};

LHWINDOW CheckArray[] = {
		{GroupBox, 180, 70, 27, 4,
		(PLHRES)&msgGroupBox, NULL, 0, STYLE_WHCHAR,
		NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
		{CheckBox, 200, 88, 10, 1,
		(PLHRES)&msgBox1, (PLHDATA)&CheckWork, 1, STYLE_WHCHAR,
		CheckArray, PARENT_FKEYS, NO_MENU, NO_HELP},
		{CheckBox, 200, 108, 10, 1,
		(PLHRES)&msgBox2, (PLHDATA)&CheckWork, 2, STYLE_WHCHAR,
		CheckArray, PARENT_FKEYS, NO_MENU, NO_HELP},
		{CheckBox, 316, 88, 10, 1,
		(PLHRES)&msgBox3, (PLHDATA)&CheckWork, 4, STYLE_WHCHAR,
		CheckArray, PARENT_FKEYS, NO_MENU, NO_HELP},
		{CheckBox, 316, 108, 10, 1,
		(PLHRES)&msgBox4, (PLHDATA)&CheckWork, 8, STYLE_WHCHAR,
		CheckArray, PARENT_FKEYS, NO_MENU, NO_HELP}
};

LHWINDOW CheckDlg = {
		(PLHCLASS)CheckBoxHandler, 160, 50, 320, 100,
		(PLHRES)&msgCheckBox, (PLHDATA)CheckArray,
		countof(CheckArray), 0,
		NULL, ChoseFkeys, NO_MENU, NO_HELP
};

LHWINDOW RadioArray[] = {
		{GroupBox, 180, 70, 27, 4,
		(PLHRES)&msgGroupBox, NULL, 0, STYLE_WHCHAR,
		NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
		{RadioButton, 200, 88, 10, 1,
		(PLHRES)&msgButton1, (PLHDATA)&RadioWork, 1, STYLE_WHCHAR,
		RadioArray, PARENT_FKEYS, NO_MENU, NO_HELP},
		{RadioButton, 200, 108, 10, 1,
		(PLHRES)&msgButton2, (PLHDATA)&RadioWork, 2, STYLE_WHCHAR,
		RadioArray, PARENT_FKEYS, NO_MENU, NO_HELP},
		{RadioButton, 316, 88, 10, 1,
		(PLHRES)&msgButton3, (PLHDATA)&RadioWork, 3, STYLE_WHCHAR,
		RadioArray, PARENT_FKEYS, NO_MENU, NO_HELP},
		{RadioButton, 316, 108, 10, 1,
		(PLHRES)&msgButton4, (PLHDATA)&RadioWork, 4, STYLE_WHCHAR,
		RadioArray, PARENT_FKEYS, NO_MENU, NO_HELP}
};

LHWINDOW RadioDlg = {
		(PLHCLASS)RadioBoxHandler, 160, 50, 320, 100,
		(PLHRES)&msgRadioBox, (PLHDATA)RadioArray, countof(RadioArray), 0,
		NULL, ChoseFkeys, NO_MENU, NO_HELP
};

LHWINDOW ListArray[] = {
		{(PLHCLASS)ListBoxHandler, 180, 74, 27, 5,
		(PLHRES)&msgnull, (PLHDATA)ListDataArray,
		countof(ListDataArray), STYLE_WHCHAR,
		NULL, PARENT_FKEYS, NO_MENU, NO_HELP}
};

LHWINDOW ListBoxDlg = {
		DialogBox, 160, 50, 320, 100,
		(PLHRES)&msgListBox,(PLHDATA)ListArray,
		countof(ListArray),0,
		NULL, OkFkeys, NO_MENU, NO_HELP
};

LHWINDOW ComboRefList = {
		(PLHCLASS)ListBoxHandler, 180, 74, 20, 5,
		(PLHRES)&msgnull, (PLHDATA)ListDataArray,
		countof(ListDataArray), STYLE_WHCHAR,
		NULL, PARENT_FKEYS, NO_MENU, NO_HELP
};

LHWINDOW ComboArray[] = {
		{ComboBox, 220, 80, 20, 1,
		(PLHRES)&msgnull, (PLHDATA)EditString, 20, STYLE_WHCHAR|COMBO_NOEDIT,
		NULL, PARENT_FKEYS, (PLHMENU)&ComboRefList, NO_HELP}
};

LHWINDOW ComboBoxDlg = {
		DialogBox, 160, 50, 320, 100,
		(PLHRES)&msgComboBox, (PLHDATA)ComboArray, countof(ComboArray), 0,
		NULL, OkFkeys, NO_MENU, NO_HELP
};

LHWINDOW MeterArray[] = {
		{ProgressMeter, 180, 74, 27, 2,
		(PLHRES)&msgnull, NULL, 100, STYLE_WHCHAR,
		NULL, NO_FKEYS, NO_MENU, NO_HELP}
};

LHWINDOW MeterDlg = {
		DialogBox, 160, 50, 320, 70,
		(PLHRES)&msgMeterBox, (PLHDATA)MeterArray, countof(MeterArray), 0,
		NULL, OkFkeys, NO_MENU, NO_HELP
};

LHWINDOW MsgBoxView = {
		(PLHCLASS)MessageBoxHandler, 144, 40, 35, 10,
		(PLHRES)&msgnull, (PLHDATA)&MsgBoxPtr, 1, STYLE_WHCHAR|STYLE_NOSHADOW,
		&MainView, OkFkeys, NO_MENU, NO_HELP
};

LHEDITDATA MLData = {
		(PLHFARDATA)&MLBuffer, (PLHFARDATA)&MLBufferSave,
		(UINT far * near *)&LNBufPtr, MLMAXLINE,
		 0, 0, 0, 1, 0
};


LHWINDOW MultiEditArray[] = {
		(PLHCLASS)MultiEditHandler, 10, 30, 60, 11,
		(PLHRES)&msgnull, (PLHDATA)&MLData,
		MLMAXLENGTH, STYLE_WHCHAR|EDIT_INSERT,
		NULL, PARENT_FKEYS, NO_MENU, NO_HELP
};

LHWINDOW MultiEditDlg = {
		DialogBox,0, 10, 640, 160,
		(PLHRES)&msgMultiEdit, (PLHDATA)MultiEditArray,
		countof(MultiEditArray), 0,
		NULL, ChoseFkeys, NO_MENU, NO_HELP
};

LHWINDOW EditArray[] = {
		{(PLHCLASS)EditHandler, 220, 80, 20, 1,
		(PLHRES)&msgnull, (PLHDATA)EditString, 20, STYLE_WHCHAR,
		NULL, PARENT_FKEYS, NO_MENU, NO_HELP}
};

LHWINDOW EditDlg = {
		DialogBox, 160, 50, 320, 70,
		(PLHRES)&msgEditBox, (PLHDATA)EditArray, countof(EditArray), 0,
		NULL, ChoseFkeys, NO_MENU, NO_HELP
};

LHWINDOW FoArray[] = {
		{PathText, 0, 0, 0, 0,
		(PLHRES)&msg3, (PLHDATA)FileNameBuffer, 48, STYLE_WHCHAR,
		NULL, PARENT_FKEYS, (PLHMENU)DefaultFileName, NO_HELP},
		{StaticText, 0, 0, 0, 0,
		(PLHRES)&msg7, (PLHDATA)DirNameBuffer,
		48, STYLE_NOBORDER|STYLE_WHCHAR,
		NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
		{FileListBox, 0, 0, 0, 0,
		(PLHRES)&msg4, NULL, LISTCOUNT, STYLE_WHCHAR|STYLE_NOTIFY,
		NULL, PARENT_FKEYS, (PLHMENU)LISTCOUNT, NO_HELP},
		{DirListBox, 0, 0, 0, 0,
		(PLHRES)&msg5, NULL, DIRCOUNT, STYLE_WHCHAR|STYLE_NOTIFY,
		NULL, PARENT_FKEYS, (PLHMENU)DIRCOUNT, NO_HELP},
		{PushButton, 0, 0, 0, 0,
		(PLHRES)&msg2, (PLHDATA)CMD_ESC, 0, PUSHB_SENDMSG|STYLE_PUSHBUTTON,
		NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
		{PushButton, 0, 0, 0, 0,
		(PLHRES)&msg6, (PLHDATA)CMD_ESC, 0, PUSHB_SENDMSG|STYLE_PUSHBUTTON,
		NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
};

LHWINDOW FopenDlg = {
		(PLHCLASS)FileOpenHandler, 0, 0, 0, 0,
		(PLHRES)&msgCheckOpen, (PLHDATA)FoArray, countof(FoArray), 0,
		NULL, ChoseFkeys, NO_MENU, NO_HELP
};

#if defined(TURBOC)
#define GetDataSeg()	_DS
#endif
#if defined(LSIC)
int _asm_(char *);
#define GetDataSeg()	_asm_(" mov ax,ds\n")
#endif

void FixupFarPtrs(void)
{
int i,dataseg;
#if defined(MSC)
	_asm {
		mov	ax,ds;
		mov	dataseg,ax;
		}
#else
	dataseg=GetDataSeg();
#endif
	for(i=0; i<countof(StringTable); i++)
		*(((int *)(StringTable[i]))+1) = dataseg;
}

int far CheckBoxHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...) {
	switch (Message) {
		case KEYSTROKE:
		switch(Data) {
			case 0x0d: case 0x1b: case F10KEY:
				return SendMsg(Window, COMMAND, CMD_ESC, 0);
		}
	}
	return SubclassMsg(DialogBox, Window, Message, Data, Extra);
}


int far RadioBoxHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...) {
	switch (Message) {
		case KEYSTROKE:
		switch(Data) {
			case 0x0d: case 0x1b: case F10KEY:
				return SendMsg(Window, COMMAND, CMD_ESC, 0);
		}
	}
	return SubclassMsg(DialogBox, Window, Message, Data, Extra);
}

int far ListBoxHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...) {
	switch (Message) {
		case KEYSTROKE:
		switch(Data) {
			case 0x0d: case 0x1b: case F10KEY:
				return SendMsg(Window, COMMAND, CMD_ESC, 0);
		}
	}
	return SubclassMsg(ListBox, Window, Message, Data, Extra);
}

int far MessageBoxHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...) {
	switch (Message) {
		case KEYSTROKE:
		switch(Data) {
			case 0x0d: case 0x1b: case F10KEY:
				SendMsg(Window, DESTROY, DESTROY_NORMAL, 0);
		break;
			case F1KEY:	case F2KEY:	case F3KEY:	case F4KEY:	case F5KEY:
			case F6KEY:	case F7KEY:	case F8KEY:	case F9KEY:
				Data=0;
		}
	}
	return SubclassMsg(MessageBox, Window, Message, Data, Extra);
}

int far MultiEditHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...) {
	switch (Message) {
		case KEYSTROKE:
			switch( Data ) {
		 		case F10KEY:
					return SendMsg(Window, COMMAND, CMD_ESC, 0);
			}
			break;
		case CREATE:
			LNBufPtr=m_alloc(MLMAXLINE*2);
			MLBufferSave=m_alloc(MLMAXLENGTH);
			break;
		case DESTROY:
			m_free((int )LNBufPtr);
	}
	return SubclassMsg(MultiEdit, Window, Message, Data, Extra);
}

int far FileOpenHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...)
{
int i;
int **TempPtr,**StorePtr;
	switch (Message) {
		case KEYSTROKE:
			switch( Data ) {
				case 0x001b:
					return SendMsg(Window, COMMAND, CMD_ESC, 0);
				case F10KEY:
					return SubclassMsg(FileOpenDialogBox, Window, Message, 0x0d, Extra);
			}
			break;

		case CREATE:
			strcpy( FileNameBuffer, "" );
			strcpy( DirNameBuffer, "c:\\" );
			strcpy( DefaultFileName,"*.exe");
				TempPtr=m_alloc((LISTCOUNT+DIRCOUNT)*(2+16));
				FoArray[2].Data=(PLHDATA)TempPtr;
				StorePtr=TempPtr+LISTCOUNT;
				for( i = 0; i < (LISTCOUNT); i++ )
					{*TempPtr++=(int *)StorePtr; StorePtr+=8;}
				FoArray[3].Data=(PLHDATA)StorePtr;
				TempPtr=StorePtr+DIRCOUNT;
				for( i = 0; i < (DIRCOUNT); i++ )
					{*StorePtr++=(int *)TempPtr; TempPtr+=8;}
			break;

		case DESTROY:
				m_free(FoArray[2].Data);
	}
	return SubclassMsg(FileOpenDialogBox, Window, Message, Data, Extra);
}

int far EditHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...) {
	switch (Message) {
		case KEYSTROKE:
			switch( Data ) {
		 		case 0x0d:
		 		case 0x1b:
		 		case F10KEY:
					return SendMsg(Window, COMMAND, CMD_ESC, 0);
			}
			break;
	}
	return SubclassMsg(Edit, Window, Message, Data, Extra);
}

int far MainHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra,...) {
	switch (Message) {
		case KEYSTROKE:
			break;
		case DRAW:
			if (Data&DRAW_FRAME)
				ClearRect(Wnd->x,Wnd->y,Wnd->w,Wnd->h);
			break;
	}
	return SubclassMsg(Object, Wnd, Message, Data, Extra);
}

void far DoQuit( void )
{
	Done = TRUE;
}

void far DoCombo( void )
{
	SendMsg( &ComboBoxDlg, CREATE, CREATE_FOCUS, 0 );
}

void far DoCheck( void )
{
	SendMsg( &CheckDlg, CREATE, CREATE_FOCUS, 0 );
}

void far DoRadio( void )
{
	SendMsg( &RadioDlg, CREATE, CREATE_FOCUS, 0 );
}

void far DoList( void )
{
	SendMsg( &ListBoxDlg, CREATE, CREATE_FOCUS, 0 );
}

void far DoMeter( void )
{
int	i;
	MeterArray[0].Selection=0;
	SendMsg( &MeterDlg,CREATE,CREATE_FOCUS, 0 );
	for(i=0;i<=100;i++) SendMsg( &MeterArray[0], DRAW, DRAW_CLIENT_UPDATE, i);
}

void far DoMsgBox( void )
{
	SendMsg( &MsgBoxView, CREATE, CREATE_FOCUS, 0 );
}

void far DoMultiEdit( void )
{
	SendMsg( &MultiEditDlg, CREATE, CREATE_FOCUS, 0 );
}

void far DoEdit( void )
{
	SendMsg( &EditDlg, CREATE, CREATE_FOCUS, 0 );
}

void far DoFoDlg( void )
{
	SendMsg( &FopenDlg, CREATE, CREATE_FOCUS, 0 );
}

void main( void )
{
	m_init_app( SYSTEM_MANAGER_VERSION );

	InitializeLHAPI( &CapData );
	m_reg_far( &SysMgrPtrs[0], countof( SysMgrPtrs ), 4 );

	SetDefaultFont(FONT_NORMAL);
	SetMenuFont(FONT_NORMAL);


	m_reg_app_name( msgAppName );

	MLBuffer=m_alloc(MLMAXLENGTH);
	*MLBuffer='\0';
	SendMsg( &MainView, CREATE, CREATE_FOCUS, 0 );
	SendMsg( &MainTitle, CREATE, CREATE_NORMAL, 0 );

	Done = FALSE;

	while( !Done ) {
		app_event.do_event = DO_EVENT;
		m_action( &app_event );
		switch( app_event.kind ) {
			case E_ACTIV:
			case E_REFRESH:
				FixupFarPtrs();
				ReactivateLHAPI( &CapData );
				break;
			case E_DEACT:
				DeactivateLHAPI();
				break;
			case E_TERM:
			case E_BREAK:
				FixupFarPtrs();
				Done = TRUE;
				break;
			case E_NONE:
				SendMsg(&TDateTime, DRAW, DRAW_ALL, 0);
				break;
			case E_KEY:
				SendMsg(GetFocus(), KEYSTROKE, app_event.data, app_event.scan);
				break;
		}
	}
	m_fini();
}
