#include	"lxapi.h"
#include	<ctype.h>
#include	<string.h>
#include	<stdlib.h>
#include	<signal.h>
#include	<math.h>

char NumABuf[22],NumBBuf[22];
char Cal1Buf[20];
char Cal2Buf[20];
char Cal3Buf[20];
char Cal4Buf[20];
char Cal5Buf[20];
char Cal6Buf[20];
char Cal7Buf[20];
char Cal8Buf[20];

char far	*msgnull =		"";
char far	*msgAppName =	"FloatTst";
char far	*msgTitle =		"Floating Point Demo";
char far	*msgQuit =		"&Quit";
char far	*msgOk =		"Calc";
char far	*msgCAN =		"Cancel";
char far	*msgNumA =		"Number A";
char far	*msgNumB =		"Number B";
char far	*msgCal1 =		"A / B   =";
char far	*msgCal2 =		"Sin(A/B)=";
char far	*msgCal3 =		"Cos(A/B)=";
char far	*msgCal4 =		"Tan(A/B)=";
char far	*msgCal5 =		"Log(A/B)=";
char far	*msgCal6 =		"Ln(A/B) =";
char far	*msgCal7 =		"Exp(A/B)=";
char far	*msgCal8 =		"Sqr(A/B)=";

char far	**StringTable[]={
	&msgnull, &msgTitle, &msgAppName, &msgQuit, &msgOk, &msgCAN,
	&msgNumA, &msgNumB,
	&msgCal1,&msgCal2,&msgCal3,&msgCal4,&msgCal5,&msgCal6,&msgCal7,&msgCal8,
};

int far MainHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);
int far DialogHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);

void far DoQuit( void );
void SetupScreen( void );
int sprintf(char *,char *,...);

BOOL		Done;
LHAPIBLOCK	CapData;
EVENT_NORM	app_event;

LHFKEY MainFKeys[] = {
	{(PLHRES)&msgCAN, (PLHFUNC)CMD_ESC, 9, FKEY_SENDMSG },
	{(PLHRES)&msgOk, (PLHFUNC)CMD_DONE, 10+FKEY_LAST, FKEY_SENDMSG }
};

LHMENU MainMenu[] = {
	{(PLHRES)&msgQuit, (PLHFUNC)DoQuit, 0 },
	{ 0, 0, 0, 0 }
};

LHWINDOW TDateTime = {
	DateTime,0,0,0,0,
	0,0,0,STYLE_DATETIME|STYLE_NOFOCUS,
	NULL,PARENT_FKEYS,PARENT_MENU,NO_HELP};

LHWINDOW MainTitle = {
	TitleBar,0,0,0,0,
	(PLHRES)&msgTitle,0,0,STYLE_NOFOCUS,
	NULL,PARENT_FKEYS,(PLHMENU)&TDateTime,NO_HELP};

LHWINDOW MainView = {
	(PLHCLASS)MainHandler, 0, 0, 640, 190,
	(PLHRES)&msgnull,NULL,0,0,NULL,
	MainFKeys, MainMenu, NO_HELP };

LHWINDOW MainArray[] = {
	{Edit, 10, 30, 20, 1,
	(PLHRES)&msgNumA, (PLHDATA)&NumABuf, 20, STYLE_WHCHAR,
	NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
	{Edit, 330, 30, 20, 1,
	(PLHRES)&msgNumB, (PLHDATA)&NumBBuf, 20, STYLE_WHCHAR,
	NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
	{StaticText, 20, 60, 20, 1,
	(PLHRES)&msgCal1, Cal1Buf, 20, STYLE_WHCHAR|STYLE_NOBORDER,
	NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
	{StaticText, 320, 60, 20, 1,
	(PLHRES)&msgCal2, Cal2Buf, 20, STYLE_WHCHAR|STYLE_NOBORDER,
	NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
	{StaticText, 20, 90, 20, 1,
	(PLHRES)&msgCal3, Cal3Buf, 20, STYLE_WHCHAR|STYLE_NOBORDER,
	NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
	{StaticText, 320, 90, 20, 1,
	(PLHRES)&msgCal4, Cal4Buf, 20, STYLE_WHCHAR|STYLE_NOBORDER,
	NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
	{StaticText, 20, 120, 20, 1,
	(PLHRES)&msgCal5, Cal5Buf, 20, STYLE_WHCHAR|STYLE_NOBORDER,
	NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
	{StaticText, 320, 120, 20, 1,
	(PLHRES)&msgCal6, Cal6Buf, 20, STYLE_WHCHAR|STYLE_NOBORDER,
	NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
	{StaticText, 20, 150, 20, 1,
	(PLHRES)&msgCal7, Cal7Buf, 20, STYLE_WHCHAR|STYLE_NOBORDER,
	NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
	{StaticText, 320, 150, 20, 1,
	(PLHRES)&msgCal8, Cal8Buf, 20, STYLE_WHCHAR|STYLE_NOBORDER,
	NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
};

LHWINDOW MainDlg = {
	(PLHCLASS)DialogHandler, 160, 30, 30, 11,
	(PLHRES)&msgnull, (PLHDATA)MainArray, countof(MainArray),
	STYLE_WHCHAR, NULL, MainFKeys, MainMenu, NO_HELP
};

void FixupFarPtrs( void )
{
	int i, dataseg;
	dataseg=_DS;
	for ( i = 0; i < countof( StringTable ); i++ )
		*((( int *)( StringTable[i] )) + 1 ) = dataseg;
}

int far DialogHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...)
{
double a,b;
char *dummy;
	switch(Message)
	{
	case COMMAND:
		switch(Data) {
		case CMD_DONE:
			a=strtod(NumABuf, &dummy); b=atof(NumBBuf);
			if(b == 0.0) {m_beep();return TRUE;}
			sprintf(Cal1Buf,"%18f",a/b);
			sprintf(Cal2Buf,"%18f",sin(a/b));
			sprintf(Cal3Buf,"%18f",cos(a/b));
			sprintf(Cal4Buf,"%18f",tan(a/b));
			if(a > 0.0) {
				sprintf(Cal5Buf,"%18f",log10(a/b));
				sprintf(Cal6Buf,"%18f",log(a/b));}
			else {
				strcpy(Cal5Buf,"");
				strcpy(Cal6Buf,"");}
			sprintf(Cal7Buf,"%18f",exp(a/b));
			if(a / b >= 0.0)
				sprintf(Cal8Buf,"%18f",sqrt(a/b));
			else
				strcpy(Cal8Buf,"");
			SendMsg(MainArray+2, DRAW, DRAW_CLIENT, 0);
			SendMsg(MainArray+3, DRAW, DRAW_CLIENT, 0);
			SendMsg(MainArray+4, DRAW, DRAW_CLIENT, 0);
			SendMsg(MainArray+5, DRAW, DRAW_CLIENT, 0);
			SendMsg(MainArray+6, DRAW, DRAW_CLIENT, 0);
			SendMsg(MainArray+7, DRAW, DRAW_CLIENT, 0);
			SendMsg(MainArray+8, DRAW, DRAW_CLIENT, 0);
			SendMsg(MainArray+9, DRAW, DRAW_CLIENT, 0);
			return TRUE;
		case CMD_ESC:
			strcpy(NumABuf,""); strcpy(NumBBuf,"");
			SendMsg(MainArray, DRAW, DRAW_CLIENT, 0);
			SendMsg(MainArray+1, DRAW, DRAW_CLIENT, 0);
			SendMsg(MainArray, SETFOCUS, SETFOCUS_NORMAL, 0);
			return TRUE;
		}
		break;
	case DRAW:
		return TRUE;
	}
	return SubclassMsg(DialogBox, Window, Message, Data, Extra);
}

void ClearScreen( void )
{
	ClearRect(0,10,640,180);
}

int far MainHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...) {
	switch (Message) {
		case DRAW:
			if (Data&DRAW_FRAME)
				ClearRect(Window->x,Window->y,Window->w,Window->h);
			break;
	}
	return SubclassMsg(Object, Window, Message, Data, Extra);
}

void far DoQuit( void )
{
	Done = TRUE;
}

void main( void )
{
	signal(SIGFPE,SIG_IGN);
	m_init_app( SYSTEM_MANAGER_VERSION );

	InitializeLHAPI( &CapData );

	SetDefaultFont(FONT_NORMAL);
	SetMenuFont(FONT_NORMAL);

	m_reg_app_name( msgAppName );

	SendMsg( &MainView, CREATE, CREATE_FOCUS, 0 );
	SendMsg( &MainTitle, CREATE, CREATE_NORMAL, 0 );

	SendMsg( &MainDlg, CREATE, CREATE_FOCUS, 0);

	Done = FALSE;

	while( !Done ) {
		app_event.do_event = DO_EVENT;
		m_action( &app_event );
		switch( app_event.kind ) {
			case E_ACTIV:
			case E_REFRESH:
				ActivateFloat();
				FixupFarPtrs();
				ReactivateLHAPI( &CapData );
				break;
			case E_DEACT:
				DeactivateFloat();
				DeactivateLHAPI();
				break;
			case E_TERM:
			case E_BREAK:
				FixupFarPtrs();
				Done = TRUE;
				break;
			case E_NONE:
				SendMsg(&TDateTime,DRAW,DRAW_ALL,0);
				break;
			case E_KEY:
				SendMsg(GetFocus(), KEYSTROKE, app_event.data,app_event.scan);
				break;
		}
	}
	DeactivateFloat();
	m_fini();
}
