#include  "lxapi.h"

char far *msgnull="";
char far *msgAppName="CalcDemo";
char far *msgTitle="Calculator Demo";
char far *msgMenuQuit="&Quit";
char far *msgQuit="Quit";

char far **StringTable[]={
  &msgnull, &msgAppName, &msgTitle, &msgMenuQuit, &msgQuit
};

int far MainHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra ,...);
void far DoQuit(void);
void DoChs(void);
void DoClear(void);
int sprintf(char *,char *,...);

EVENT_NORM  app_event;
LHAPIBLOCK  CapData;

BOOL  Done;
int   InputFlag;
char  Operation;
long  InputNum,Stack;

LHFKEY MainFKeys[]= {
  {(PLHRES)&msgQuit,(PLHFUNC)DoQuit,10+FKEY_LAST,0}
};

LHMENU MainMenu[] = {
  {(PLHRES)&msgMenuQuit,(PLHFUNC)DoQuit,0},
  { 0, 0, 0, 0}
};

LHWINDOW TDateTime = {
    DateTime,0,0,0,0,
    0,0,0,STYLE_DATETIME|STYLE_NOFOCUS,
    NULL,PARENT_FKEYS,PARENT_MENU,NO_HELP};

LHWINDOW MainTitle = {
    TitleBar,0,0,0,0,
    (PLHRES)&msgTitle,0,0,STYLE_NOFOCUS,
    NULL,PARENT_FKEYS,(PLHMENU)&TDateTime,NO_HELP};

LHWINDOW MainView={
    (PLHCLASS)MainHandler,0,0,640,190,
    (PLHRES)&msgnull,0,0,0,
    NULL,MainFKeys,MainMenu,NO_HELP};

#if defined(TURBOC)
#define GetDataSeg()  _DS
#endif
#if defined(LSIC)
int _asm_(char *);
#define GetDataSeg()  _asm_(" mov ax,ds\n")
#endif

void FixupFarPtrs(void)
{
int i,dataseg;
#if defined(MSC)
  _asm {
    mov  ax,ds;
    mov  dataseg,ax;
    }
#else
  dataseg=GetDataSeg();
#endif
  for(i=0; i<countof(StringTable); i++)
    *(((int *)(StringTable[i]))+1) = dataseg;
}

void far DoQuit(void)
{
  Done = TRUE;
}

void SetupScreen()
{
char temp[80];
  Panel(115,90,400,30);
  sprintf(temp,"%10ld",InputNum);
  DrawText(324,100,temp,DRAW_NORMAL,FONT_LARGE);
  if(Operation==' ') return;
  sprintf(temp,"%10ld",Stack);
  DrawText(120,100,temp,DRAW_NORMAL,FONT_LARGE);
  DrawChar(292,100,Operation,DRAW_NORMAL,FONT_LARGE);
}

void DoClear(void)
{
  InputNum=0; Stack=0; InputFlag=0; Operation=' '; SetupScreen();
}

void SaveOperand(void)
{
  if(Operation!=' ') return;
  Stack=InputNum; InputNum=0; InputFlag=0; SetupScreen();
}

int far MainHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...)
{
  switch(Message){
  case KEYSTROKE:
    switch (Data){
    case 'L':
    case 'l':
      InputNum=-InputNum;  SetupScreen(); return TRUE;
    case '*':
      SaveOperand(); Operation='*'; SetupScreen(); return TRUE;
    case '/':
      SaveOperand(); Operation='/'; SetupScreen(); return TRUE;
    case '-':
      SaveOperand(); Operation='-'; SetupScreen(); return TRUE;
    case '+':
      SaveOperand(); Operation='+'; SetupScreen(); return TRUE;
    case 27:
      if(InputFlag)
        { InputNum=0; InputFlag=0; SetupScreen();}
      else
        DoClear();
      return TRUE;
    case 8: case DELKEY:
      if(InputFlag)
        { InputNum/=10; if(InputNum==0) InputFlag=0; SetupScreen();}
      return TRUE;
    case 13: case '=':
      if (InputFlag&&Operation!=' '){
        switch(Operation){
        case '*':
          InputNum=Stack*InputNum;break;
        case '/':
          if(InputNum)
            InputNum=Stack/InputNum;
          break;
        case '-':
          InputNum=Stack-InputNum;break;
        case '+':
          InputNum=Stack+InputNum;break;
        }
        Stack=0; InputFlag=0; Operation=' '; SetupScreen();
      }
      return TRUE;
    case '0': case '1': case '2': case '3': case '4':
    case '5': case '6': case '7': case '8': case '9':
      if(InputFlag==0) {InputNum=0;}
      Data -= '0'; InputNum=InputNum*10+Data;
      SetupScreen(); InputFlag=1; return TRUE;
  case DRAW:
      ClearRect(Window->x,Window->y,Window->w,Window->h);
      SetupScreen();
    }
    break;
  }
  return SubclassMsg(Object, Window, Message, Data, Extra);
}

void main(void)
{
  m_init_app(SYSTEM_MANAGER_VERSION);
  InitializeLHAPI(&CapData);
  SetMenuFont(FONT_NORMAL);
  SetDefaultFont(FONT_NORMAL);
  FixupFarPtrs();
  m_reg_app_name(msgAppName);
  SendMsg( &MainView, CREATE, CREATE_FOCUS, 0 );
  SendMsg( &MainTitle, CREATE, CREATE_NORMAL, 0 );
  DoClear();
  Done = FALSE;
  while(!Done) {
    app_event.do_event = DO_EVENT;
    m_action(&app_event);
    switch(app_event.kind) {
      case E_REFRESH:
      case E_ACTIV:
        FixupFarPtrs(); ReactivateLHAPI(&CapData); break;
      case E_DEACT:
        DeactivateLHAPI(); break;
      case E_TERM:
        FixupFarPtrs(); Done = TRUE; break;
      case E_NONE:
        SendMsg(&TDateTime,DRAW,DRAW_ALL,0); break;
      case E_KEY:
        SendMsg(GetFocus(), KEYSTROKE,app_event.data,app_event.scan);
        break;
    }
  }
  m_fini();
}
