; Keystuff 1.0
; Assemble with ML (from MASM 6.0), not MASM
	.MODEL tiny

; Some of the logic in this program was lifted from KEY100.ASM by
; Andy Gryc of HP Corvallis.

; todo:
;	add @file option
;	syntax to change prompt in key-string for @file use?

promptMax equ 70

return    equ 13	; ASCII carrige return
lineFeed  equ 10	; ASCII line feed
escape    equ 27	; ASCII escape
backspace equ 8		; ASCII backspace

enterChar  equ '/'	; maps to ENTER key

prefix     equ '\'

pushedCtrl  equ 1
pushedShift equ 2
pushedAlt   equ 4
pushedFn    equ 8

ctrlScan  equ 1dh
altScan   equ 38h
shiftScan equ 2ah
fnScan    equ 80h	; dummy scan code to tag the Fn key

; Timer chip equates
timer2ModeCmd equ 0B6h
timer2LatchCmd equ 80h
timer2ReadBackStatusCmd equ 0E8h

timerModeReg equ 43h
timer0CountReg equ 40h
timer2CountReg equ 42h

timerOutputFlag equ 80h

portB equ 61h

; bits defined for reading and writing of port B
timer2gate equ 1
speaker2gate equ 2
gate2AndSpeaker2 equ timer2gate or speaker2gate

hiToneFreq equ 200
loToneFreq equ 100

hiToneDivisor equ (115200 / hiToneFreq)
loToneDivisor equ (115200 / loToneFreq)

hiToneClicks equ hiToneFreq / 2		; 1/2 second
loToneClicks equ loToneFreq / 2		; 1/2 second

video_int	equ	10h		;int for video output calls to bios
tty_out		equ	14		; put-char function # for video_int

; The BIOS variables at segment 40h
biosdata	segment at 40h		; rom bios data area
		org	17h
ShiftState	dw	?
		org	1ah
bufferHead	dw	?		; Head of keyboard buffer
bufferTail	dw	?		; Tail of keyboard buffer

		org	49h		; start of video data
crt_mode	db	?
crt_cols	dw	?
crt_len		dw	?
crt_start	dw	?
cursor_posn	dw	8 dup(?)
cursor_mode	dw	?
active_page	db	?
addr_6845	dw	?
crt_mode_set	db	?
crt_palette	db	?

      		org	80h
; These words contain offsets from an assumed segment of 40h
bufferStart	dw	?		; Start of keyboard buffer
bufferEnd	dw	?		; End+1 of keyboard buffer

biosdata	ends

       .CODE
       ORG 100h
Begin:
	jmp	Main

dTag	db "KS_DPROMPT",0

dPrompt	db "Press any digit: ", 0
	db promptMax - ($-dPrompt) dup (0)	; pad to promptMax size

lTag	db "KS_LPROMPT",0

lPrompt db "Type a line: ", 0
	db promptMax - ($-lPrompt) dup (0)	; pad to promptMax size

cTag	db "KS_KPROMPT",0

cPrompt db "Press any character: ", 0
	db promptMax - ($-cPrompt) dup (0)	; pad to promptMax size

nTag	db "KS_NPROMPT",0

nPrompt db "Type a number: ", 0
	db promptMax - ($-nPrompt) dup (0)	; pad to promptMax size


; Table to generate scan code from ASCII code.
; "+80h" for keys where shift must be active

AscTableBase equ " "

AscToScan label byte
	db	39h	; SPACE
	db	02h+80h	; "!"
	db	28h+80h	; Double Quote
	db	04h+80h	; "#"
	db	05h+80h	; "$"
	db	06h+80h	; "%"
	db	08h+80h	; "&"
	db	28h    	; "'"
	db	0ah+80h	; "("
	db	0bh+80h	; ")"
	db	09h+80h	; "*"
	db	0dh+80h	; "+"
	db	33h	; ","
	db	0ch	; "-"
	db	34h	; "."
	db	01ch	; "/" - Enter
	db	0bh	; "0"
	db	02h	; "1"
	db	03h	; "2"
	db	04h	; "3"
	db	05h	; "4"
	db	06h	; "5"
	db	07h	; "6"
	db	08h	; "7"
	db	09h	; "8"
	db	0ah	; "9"
	db	27h+80h	; ":"
	db	27h	; ";"
	db	33h+80h	; "<"
	db	0dh	; "="
	db	34h+80h	; ">"
	db	35h+80h	; "?"
	db	03h+80h	; "@"
	db	1eh+80h	; "A"
	db	30h+80h	; "B"
	db	2eh+80h	; "C"
	db	20h+80h	; "D"
	db	12h+80h	; "E"
	db	21h+80h	; "F"
	db	22h+80h	; "G"
	db	23h+80h	; "H"
	db	17h+80h	; "I"
	db	24h+80h	; "J"
	db	25h+80h	; "K"
	db	26h+80h	; "L"
	db	32h+80h	; "M"
	db	31h+80h	; "N"
	db	18h+80h	; "O"
	db	19h+80h	; "P"
	db	10h+80h	; "Q"
	db	13h+80h	; "R"
	db	1fh+80h	; "S"
	db	14h+80h	; "T"
	db	16h+80h	; "U"
	db	2fh+80h	; "V"
	db	11h+80h	; "W"
	db	2dh+80h	; "X"
	db	15h+80h	; "Y"
	db	2ch+80h	; "Z"
	db	1ah	; "["
	db	2bh	; "\"
	db	1bh	; "]"
	db	07h+80h	; "^"
	db	0ch+80h	; "_"
	db	29h	; "`"
	db	1eh	; "a"
	db	30h	; "b"
	db	2eh	; "c"
	db	20h	; "d"
	db	12h	; "e"
	db	21h	; "f"
	db	22h	; "g"
	db	23h	; "h"
	db	17h	; "i"
	db	24h	; "j"
	db	25h	; "k"
	db	26h	; "l"
	db	32h	; "m"
	db	31h	; "n"
	db	18h	; "o"
	db	19h	; "p"
	db	10h	; "q"
	db	13h	; "r"
	db	1fh	; "s"
	db	14h	; "t"
	db	16h	; "u"
	db	2fh	; "v"
	db	11h	; "w"
	db	2dh	; "x"
	db	15h	; "y"
	db	2ch	; "z"
	db	1ah+80h	; "{"
	db	2bh+80h	; "|"
	db	1bh+80h	; "}"
	db	29h+80h	; "~"

AscTabLen equ $-AscToScan
		
; Table to generate scan code from prefixed ASCII code, 0ffh marks ASCII codes
; for which a prefix is not allowed.

PreTableBase equ " "

PreToScan label byte
	db	0ffh	; SPACE
	db	072h	; "!" - Filer
	db	0ffh	; '"' - Prompt for a line of input
	db	074h	; "#" - Appt
	db	075h	; "$" - Phone
	db	0ffh	; "%" - prompt for a positive integer: 123
	db	077h	; "&" - Lotus 123
	db	0ffh	; "'"
	db	078h	; "(" - Calc
	db	071h	; ")" - "&..."
	db	0ffh	; "*" - Prompt for a single digit
	db	06fh	; "+" - PASTE
	db	06ah	; "," - DATE
	db	0ffh	; "-" - prompt for a signed real number: -3.1
	db	06dh	; "." - CUT
	db	035h	; "/" - Enter
	db	044h	; "0" - F10
	db	03bh	; "1" - F1
	db	03ch	; "2" - F2
	db	03dh	; "3" - F3
	db	03eh	; "4" - F4
	db	03fh	; "5" - F5
	db	040h	; "6" - F6
	db	041h	; "7" - F7
	db	042h	; "8" - F8
	db	043h	; "9" - F9
	db	0ffh	; ":"
	db	0ffh	; ";"
	db	0ffh	; "<"
	db	06eh	; "=" - COPY
	db	0ffh	; ">"
	db	0ffh	; "?" - Prompt for a single key
	db	073h	; "@" - cc:Mail
	db	038h	; "A" - Alt
	db	00eh	; "B" - Backspace
	db	01dh	; "C" - Ctrl
	db	050h	; "D" - Down cursor
	db	001h	; "E" - Esc
	db	080h	; "F" - Fn
	db	051h	; "G" - paGe down
	db	06bh	; "H" - Hour (TIME)
	db	052h	; "I" - Ins
	db	0ffh	; "J"
	db	053h	; "K" - Kill (del)
	db	04bh	; "L" - Left cursor
	db	07ah	; "M" - Menu
	db	04fh	; "N" - eNd
	db	047h	; "O" - hOme
	db	049h	; "P" - Page up
	db	0ffh	; "Q"
	db	04dh	; "R" - Right cursor
	db	02ah	; "S" - Shift
	db	00fh	; "T" - Tab
	db	048h	; "U" - Up cursor
	db	2bh+80h	; "V" - Vertical bar (|)
	db	0ffh	; "W"
	db	0ffh	; "X"
	db	0ffh	; "Y"
	db	069h	; "Z" - ZOOM
	db	33h+80h	; "[" - "<"
	db	02bh	; "\"
	db	34h+80h	; "]" - ">"
	db	076h	; "^" - Memo

PreTabLen equ $-PreToScan

;=======================================================================

ToUpper proc near
	cmp	al,'a'
	jb	NotLowerCase
	cmp	al,'z'
	ja	NotLowerCase
	sub	al,'a'-'A'		; convert to upper case
NotLowerCase:
	ret
ToUpper endp

; Copies null-terminated string from es:di to ds:si including null.
; Does no more than cx bytes including null.
StrCpy proc near
CpyLoop:
	mov	al,es:[di]
	mov	[si],al
	inc	di
	inc	si
	dec	cx
	cmp	cx,1
	jne	More
	mov	byte ptr [si],0		; ensure there is a final null
	jmp	short @@Exit

More:
	or	al,al
	jnz	CpyLoop
@@Exit:
	ret
StrCpy endp

; Search the environment for a tag and return a pointer its value.
; Call with:
;   ds:di - tag to match (must be in upper case)
; 
; On return:
;   es:di - points to value
;   the carry is set if the tag was not found
;
SearchEnv proc near
	push	si
	push	bx
	mov	si,di
	mov	ax,cs:[2ch]		; get the segment of our environment
	or	ax,ax			; no environment if zero
	jz	NotFound
	mov	es,ax
	mov	di,0			; scan env from 0
	mov	bx,si			; save start of tag to match
NextTag:
	cmp	byte ptr es:[di],0	; if the next tag starts with a null
	jz	NotFound		; then we are at the end of the env
CompareLoop:
	mov	ah,es:[di]		; grab a byte from the env
	mov	al,[si]			;  and a byte from the tag
	inc	di
	inc	si
	cmp	ah,al
	je	CompareLoop		; continue until strings don't match
	or	al,al			; a null in tag?
	jne	SkipToNext
	cmp	ah,'='
	jne	SkipToNext
	clc
	jmp	short @@Exit

SkipToNext:
	cmp	byte ptr es:[di],0	; scan for end of current string
	jz	TagStart
	inc	di
	jmp	short SkipToNext
TagStart:
	mov	si,bx			; start at front of tag to match
	inc	di			; move past null at end of string
	jmp	NextTag

	clc
	jmp	short @@Exit

NotFound:
	stc
@@Exit:
	pop	bx
	pop	si
	ret
SearchEnv endp

; Call with ds:di pointing tag to match, ds:si to buffer for
; prompt.
SetPrompt proc near
	push	es
	push	cx
	call	SearchEnv
	jc	@@Exit
	mov	cx,promptMax
	call	StrCpy
@@Exit:
	pop	cx
	pop	es
	ret
SetPrompt endp

; "Press" Fn and stuff scan code in al. This trick appears to
; only work with scan codes 3b..44, F1..f10
WithFn proc near
	assume ds:nothing,ss:nothing,es:nothing
	push	cx
	push	es
	mov	cl,al			; save scan code in cl
	mov	ax,seg biosdata		; set es to the BIOS data seg at 40h
	mov	es,ax
	assume	es:biosdata
	or	byte ptr es:[0F1h],16   ; Set BIOS flag to indicate next key is FN
	or	byte ptr es:[0FAh],16   ; Set Keyboard flag for FN active
	and	byte ptr es:[0FAh],0dfh ; And clear the FN Clear flag
	mov	byte ptr es:[0F8h],79h  ; Put the last key pressed to "Fn"
	mov	al,cl
	out	60h,al			; stuff the key into the KB i/o port
	int	9			; simulate a keyboard interrupt
	and	byte ptr es:[0FAh],0efh ; Clear Keyboard flag for FN active
	or	byte ptr es:[0FAh],20h  ; And set the FN Clear flag
	pop	es
	pop	cx
	assume es:nothing
	ret
WithFn endp

StartTone proc near
	push	bx
	mov	bx,ax			; save divide in bx
	cli				; disable interrupts

	mov	al,timer2ModeCmd
	out	timerModeReg,al
	mov	al,bl
	out	timer2CountReg,al
	mov	al,bh
	out	timer2CountReg,al

; enable speaker
	in	al,portB
	or	al,gate2AndSpeaker2
	out	portB,al

	sti				; enable interrupts
	pop	bx
	ret
StartTone endp

EndTone proc near
	push	ax
	cli				; disable interrupts

; disable speaker
	in	al,portB
	and	al, not gate2AndSpeaker2
	out	portB,al

	sti				; enable interrupts
	pop	ax
	ret
EndTone endp

; Delays for "ax" hi-lo transitions on the speaker. This gives us a
; period which is independent of the processor's speed
ToneDelay proc near
	push	ax
	push	bx
	push	cx

	mov	bx,ax			; save count in bx
ToneLoop:
; wait for hi
	sub	cx,cx			; reset timeout counter
HiLoop:
	cli				; disable interrupts
	mov	al,timer2ReadBackStatusCmd
	out	timerModeReg,al
	in	al,timer2CountReg
	sti				; enable interrupts
	and	al,timerOutputFlag
	jnz	LoWait
	loop	HiLoop
	jmp	short @@Exit		; exit early if we timeout

; wait for lo
LoWait:
	sub	cx,cx			; reset timeout counter
LoLoop:
	cli				; disable interrupts
	mov	al,timer2ReadBackStatusCmd
	out	timerModeReg,al
	in	al,timer2CountReg
	sti				; enable interrupts
	and	al,timerOutputFlag
	jz	DecClicks
	loop	LoLoop
	jmp	short @@Exit		; exit early if we timeout

DecClicks:
	dec	bx			; drop click count
	jnz	ToneLoop
@@Exit:
	pop	cx
	pop	bx
	pop	ax
	ret
ToneDelay endp

; ax = divisor, bx = duration in speaker clicks
Tone proc near
	call	StartTone
	mov	ax,bx
	call	ToneDelay
	jmp	EndTone
Tone endp

HiTone proc near
	push	ax
	push	bx
	mov	ax,hiToneDivisor
	mov	bx,hiToneClicks
	call	Tone
	pop	bx
	pop	ax
	ret
HiTone endp

LoTone proc near
	push	ax
	push	bx
	mov	ax,loToneDivisor
	mov	bx,loToneClicks
	call	Tone
	pop	bx
	pop	ax
	ret
LoTone endp

Tweedle proc near
	call	HiTone
	call	LoTone
	call	HiTone
	jmp	LoTone
Tweedle endp

; Returns with zero flag set if this is an HP 100LX.
Is100LX proc near
	assume ds:nothing,ss:nothing,es:nothing
	mov	ax,4dd4h		; check machine type
	int	15h
	cmp	bx,"HP"			; should return "H" in bh, "P" in bl
	jnz	@@Exit
	cmp	cx,102h			; ch=1 is palmtop family
					; cl=1 is 95LX, 2 is 100LX
@@Exit:
	ret
Is100LX endp

; Display a null-terminated string (can contain a "$").
StrOut proc near
	push	ax
	push	bx
	push	cx
StrLoop:
	mov	bx,dx
	cmp	byte ptr [bx],0
	je	@@Exit
	mov	ah,40h		; write file
	mov	bx,1		; StdOut
	mov	cx,1
	int	21h
	inc	dx
	jmp	StrLoop

@@Exit:
	pop	cx
	pop	bx
	pop	ax
	ret
StrOut endp

; Call with scan code in AL. If bit 7 of the scan code is on then
; Shift needs to be active before the key is "pressed". Send the
; Shift key scan code if needed. Register DH contains the set of
; ctrl/alt/shift keys that have been explicitly requested. If
; bit pushedShift in DH is on then the "auto shifting" logic is
; disabled.
PressRel proc near
	push	bx			; free a register
	mov	bl,al			; save scan code in bl
	test	dh,pushedShift		; explicit shift?
	jne	NoChange		; then don't change the shift state
	mov	ah,2			; get BIOS shift state
	int	16h
	test	al,3			; either bit 0 or 1 means shifted
	jnz	Shifted
NotShifted:
	test	bl,80h			; does the key need us to be shifted?
	jz	NoChange
	mov	al,2ah			; need shifted state,
					; load shift key scan code
	jmp	short ChangeShift

Shifted:
	test	bl,80h
	jnz	NoChange
	mov	al,0aah			; need unshifted state,
					; load shift key release scan code
; fall into ChangeShift...
ChangeShift:
	mov	bh,al			; save (un)shift code in bh
	out	60h,al			; send (un)shift code
	int	9
; Now send out the press/release of the passed scan code
; ZZZ try recursively calling PressRel
	mov	al,bl			; get the scan code
	and	al,7fh			; clear the "released" bit
	out	60h,al			; stuff the key into the KB i/o port
	int	9			; simulate a keyboard interrupt
	mov	al,bl			; get the scan code again
	or	al,80h			; turn on the "released" bit
	out	60h,al			; stuff the key into the KB i/o port
	int	9			; simulate a keyboard interrupt
; Return shift state to what it was
	mov	al,bh			; get the saved (un)shift scan code
	xor	al,80h			; invert the "released" bit
	out	60h,al			; send the scan code
	int	9
	jmp	short @@Exit

NoChange:
	mov	al,bl			; get the scan code
	and	al,7fh
	out	60h,al			; stuff the key into the KB i/o port
	int	9			; simulate a keyboard interrupt
	mov	al,bl			; get the scan code again
	or	al,80h			; turn on the "released" bit
	out	60h,al			; stuff the key into the KB i/o port
	int	9			; simulate a keyboard interrupt
@@Exit:
	pop	bx
	ret
PressRel endp

; dh contains the set of ctrl/alt/shift keys we have pressed
CleanUp proc near
	test	dh,pushedCtrl
	jz	NotCtrlRel
	mov	al,ctrlScan+80h		; "release" the ctrl key
	out	60h,al
	int	9
NotCtrlRel:
	test	dh,pushedAlt
	jz	NotAltRel
	mov	al,altScan+80h		; "release" the alt key
	out	60h,al
	int	9
NotAltRel:
	test	dh,pushedShift
	jz	@@Exit
	mov	al,shiftScan+80h	; "release" the shift key
	out	60h,al
	int	9
@@Exit:
	sub	dh,dh			; all shift keys are released
	ret
CleanUp endp

; Returns carry if al is not a digit, no carry if it is
IsDigit proc near
	cmp	al,"0"
	jb	NotDigit
	cmp	al,"9"
	ja	NotDigit
	clc
	ret

NotDigit:
	stc
	ret
IsDigit endp

; Display the character in al
PutChr proc near
	push	ax
	push	dx
	mov	dl,al		; char goes in dl
	mov	ah,2		; func 2, display out
	int	21h
	pop	dx
	pop	ax
	ret
PutChr endp

; Get a key in al without echo.
GetChr proc near
	mov	ah,7		; read a key without echo
	int	21h
	cmp	al,3		; Ctrl-C or Ctrl-break?
	je	Abort		; exit program on Ctrl-break
	or	al,al		; extended key?
	jnz	@@Exit
	mov	ah,7		; read the extended part of code
	int	21h
	sub	al,al		; colapse all extended to zero
@@Exit:
	ret
GetChr endp

; Get and echo a printable character.
; Call with bl == integerMode to only accept 0..9
GetPrintable proc near
PrintableLoop:
	call	GetChr
	cmp	al," "		; only accept printable characters
	jb	BadGet
	cmp	al,7fh		; don't accept ASCII delete (Alt backspace)
	je	BadGet
	cmp	bl,integerMode
	jne	GoodGet
	call	IsDigit
	jnc	GoodGet
BadGet:
	call	LoTone		; beep on error
	jmp	PrintableLoop

GoodGet:
	call	PutChr		; echo printable char
	ret
GetPrintable endp

; Get printable characters and store them at di. Exit on <return> or
; <escape>. Allow corrections with <backspace>. At exit di points to
; next free character.
; Call with bl == 0 to accept all printable characters
; Call with bl == integerMode to only accept 0..9
; Call with bl == realMode to only accept 0..9, ".", "-"

integerMode equ 1
realMode equ 2

GetLine proc near
	push	si		; free si
	push	bx
	sub	bh,bh		; have not seen decimal point yet
	mov	si,di		; remember start of buffer
GetLineLoop:
	call	GetChr
	cmp	al,escape
	je	EscExit
	cmp	al,return
	je	@@Exit
	cmp	al,backspace
	jne	NotBS
	cmp	si,di		; can't backspace beyond start of buffer
	je	BadChr
	call	PutChr		; else echo backspace
	mov	al," "
	call	PutChr
	mov	al,backspace
	call	PutChr
	dec	di
	cmp	byte ptr [di],"."
	jne	DontForgetDP
	sub	bh,bh		; forget the decimal point we are backing over
DontForgetDP:

	jmp	GetLineLoop

NotBS:
	cmp	al," "		; only accept printable characters
	jb	BadChr
	cmp	al,7fh		; don't accept ASCII delete (Alt backspace)
	je	BadChr
	or	bl,bl		; integer or real mode ?
	jz	StoreChar
	call	IsDigit		; valid digit?
	jnc	StoreChar
	cmp	bl,realMode
	jne	BadChr
	cmp	al,"."		; allow decimal point
	jne	NotDP
	or	bh,bh		; first DP?
	jnz	BadChr
	inc	bh
	jmp	short StoreChar

NotDP:
	cmp	al,"-"		; allow minus sign
	jne	BadChr
	cmp	si,di		; only allow minus as first char
	jne	BadChr
StoreChar:
	mov	[di],al
	inc	di
	call	PutChr		; echo the printable char
	jmp	GetLineLoop

BadChr:
	call	LoTone
	jmp	GetLineLoop

@@Exit:
	mov	al,return
	call	PutChr
	mov	al,lineFeed
	call	PutChr
	pop	bx
	pop	si
	ret

EscExit:
	mov	di,si		; return nothing when escape pressed
	jmp	@@Exit
GetLine endp

NotHpMess db "This program only works on an HP 100LX palmtop",13,10,0

HelpMess label byte					 
db "KeyStuff v1.0   Usage: ks <keys to press>",13,10
db "ͻ",13,10
db "Esc  \  F1  F2  F3  F4  F5  F6  F7  F8  F9  F10 Up  On  ",13,10
db " \E  \\  \1  \2  \3  \4  \5  \6  \7  \8  \9  \0  \U     ",13,10
db "͹",13,10
db "Tab Filecc:mApptPhonMemo123 CalcMoreBspcDel LeftDownRght",13,10
db " \T  \!  \@  \#  \$  \^  \&  \(  \)  \B  \K  \L  \D  \R ",13,10
db "͹",13,10
db " Q   W   E   R   T   Y   U   I   O   P   7   8   9   /  ",13,10
db "                                                     // ",13,10
db "͹",13,10
db "    A   S   D   F   G   H   J   K   L   4   5   6   *  ",13,10
db "                                                       ",13,10
db "͹",13,10
db "Ctrl Z   X   C   V   B   N   M   Enter    1   2   3   -  ",13,10
db " \C                               /                      ",13,10
db "͹",13,10
db "ShftAlt  Fn  Space         ,   .  MenuShft 0   .   =   +  ",13,10
db " \S  \A  \F                        \M  \S                 ",13,10
db "ͼ",13,10
db "Green keys: ZOOM \Z   DATE \,   TIME \H   CUT  \.  COPY  \=   PASTE \+",13,10
db "            HOME \O   END  \N   PGUP \P   PGDN \G  INS   \I",13,10
db 'Other:      "|"  \V   "<"  \[   ">"  \]   "/"  \/  "\"   \\',13,10
db 'Prompt:     Line \"   Key  \?   Num  \-   Int  \%  Digit \*'
db 0

;  Char  Key   Mnemonic
;  
;   /    Enter
;  
;   \A   Alt   Alt
;   \B   Bspc  Backspace
;   \C   Ctrl  Ctrl
;   \D   Down  Down
;   \E   Esc   Esc
;   \F   Fn    Function (only works before F1..F10)
;   \G   PgDn  paGe down
;   \I   Ins   Ins
;   \K   Del   Kill
;   \L   Left  Left
;   \M   Menu  Menu
;   \N   End   eNd
;   \O   Home  hOme
;   \P   PgUp  Page up
;   \R   Right Right
;   \S   Shift Shift
;   \T   Tab   Tab
;   \U   Up    Up
;   \V   |     Vertical bar
;   \[   <     less-than
;   \]   >     greater-than
;   \/   /     slash
;   \\   \     backslash
;
; available: jqwxy
;
;  Green keys
;   \Z   ZOOM
;   \,   DATE
;   \H   TIME  Hour
;   \.   CUT
;   \=   COPY
;   \+   PASTE
;  
;   \1   F1
;   \2   F2
;   \3   F3
;   \4   F4
;   \5   F5
;   \6   F6
;   \7   F7
;   \8   F8
;   \9   F9
;   \0   F10
;  
;   \!   FILER   
;   \@   cc:MAIL 
;   \#   APPT    
;   \$   PHONE   
;   \^   MEMO    
;   \&   LOTUS   
;   \(   HPCALC  
;   \)   MORE
;

;   \"   Prompt for a line of input
;   \%   Prompt for a positive integer
;   \*   Prompt for a single digit
;   \-   Prompt for a signed real number
;   \?   Prompt for a single key

;    
  
;=======================================================================
Main proc near
	assume ds:_TEXT,ss:_TEXT,es:_TEXT
	call	Is100LX
	jz	WeAreA100
	lea	dx,NotHpMess
	jmp	ExitWithMess

WeAreA100:
	lea	di,dTag			; Get optional digit prompt
	lea	si,dPrompt
	call	SetPrompt
	lea	di,nTag			; Get optional number prompt
	lea	si,nPrompt
	call	SetPrompt
	lea	di,lTag			; Get optional line prompt
	lea	si,lPrompt
	call	SetPrompt
	lea	di,cTag			; Get optional character prompt
	lea	si,cPrompt
	call	SetPrompt

	mov	si,80h			; point di at start of string
	cld				; autoincrement goes forward
	lodsb				; get param string length and advance
	mov	cl,al			; keep length in cl
	sub	ch,ch			; convert to word
	jcxz	HelpX			; display 'help' message if no parms
SkipLeading:
	lodsb				; fetch a char and advance
	cmp	al," "
	jne	CopyCmdLine
	loop	SkipLeading
HelpX:
	jmp	Help			; display 'help' message if nothing
					; but spaces
; Copy the command line to KeyBuf, prompting and inserting responses along
; the way.
CopyCmdLine:
	lea	di,KeyBuf
	jmp	short CopyStart

CopyLoop:
	lodsb			; fetch a char and advance
CopyStart:
	cmp	al,prefix
	jne	CopyChar
	dec	cx
	jz	BadKey		; error if nothing after prefix
	lodsb			; fetch a char and advance
	call	ToUpper
	cmp	al,"?"		; single-key mode?
	je	DoKey
	cmp	al,'"'		; line-mode?
	je	DoLine
	cmp	al,"%"		; positive integer mode?
	je	DoInteger
	cmp	al,"-"		; real number mode?
	je	DoReal
	cmp	al,"*"		; single-digit mode?
	je	DoDigit
	mov	byte ptr [di],prefix
	inc	di
	jmp	short CopyChar

DoDigit:
	mov	bl,integerMode
	lea	dx,dPrompt
	jmp	short DoSingle

DoLine:
	sub	bl,bl		; not integer or real mode
	lea	dx,lPrompt
DoMulti:
	call	StrOut
	call	GetLine
	jmp	short CopyTerm

DoInteger:
	mov	bl,integerMode
DoNumber:
	lea	dx,nPrompt
	jmp	DoMulti

DoReal:
	mov	bl,RealMode
	jmp	DoNumber

DoKey:
	sub	bl,bl		; not integer mode
	lea	dx,cPrompt
DoSingle:
	call	StrOut
	call	GetPrintable
	mov	[di],al
	inc	di
CopyTerm:
	mov	al,return
	call	PutChr
	mov	al,lineFeed
	call	PutChr
	jmp	short CopyNext

CopyChar:
	mov	[di],al
	inc	di
CopyNext:
	loop	CopyLoop		; loop for char-count loops
	mov	byte ptr [di],0		; cap the string with a null
	lea	si,KeyBuf
	sub	dh,dh			; no keys to release
ParseLoop:
	lodsb				; fetch a char and advance
	or	al,al
	jz	Exit
	cmp	al,enterChar
	jne	NotEnter
	mov	al,1ch			; scan code for the ENTER key
	jmp	short DoPressRel

NotEnter:
	cmp	al,prefix
	jne	NotPrefix
	lodsb				; fetch a char and advance
					; chars after prefix were upcased
					; when copied.
	sub	al,PreTableBase
	jb	BadKey
	cmp	al,PreTabLen
	jae	BadKey
	lea	bx,PreToScan
	xlat	PreToScan
	cmp	al,0ffh
	je	BadKey
	cmp	al,ctrlScan
	jne	NotCtrl
	or	dh,pushedCtrl
	jmp	short DoPress

NotCtrl:
	cmp	al,fnScan
	jne	NotFn
	or	dh,pushedFn		; remember to process the next real
					; key as Fn'ed
	jmp	short NextChar

NotFn:
	cmp	al,altScan
	jne	NotAlt
	or	dh,pushedAlt
	jmp	short DoPress

NotAlt:
	cmp	al,shiftScan
	jne	DoPressRel
	or	dh,pushedShift
DoPress:
	out	60h,al			; sent the "press" of ctrl/alt/shift
	int	9
	jmp	short NextChar

NotPrefix:
	sub	al,AscTableBase
	jb	BadKey
	cmp	al,AscTabLen
	jae	BadKey
	lea	bx,AscToScan
	xlat	AscToScan
	cmp	al,0ffh
	je	BadKey
; fall into DoPressRel...
DoPressRel:
	test	dh,pushedFn
	jz	NormalPush
	call	WithFn
	jmp	short DoCleanUp

NormalPush:
	call	PressRel		; press and release the key
DoCleanUp:
	call	CleanUp
; fall into NextChar...
NextChar:
	jmp	ParseLoop

BadKey:
	call	Tweedle
	jmp	Exit

Help:
	lea	dx,HelpMess
ExitWithMess:
	call	StrOut
; Fall into exit...
Exit:

Abort	proc near
Abort	endp
	mov	ax,4c00h
	int	21h

Main endp

KeyBuf label byte

	end Begin
