/*
 * Capture SysMgr's Screen
 * CAPSYS Version 1.00
 * Copyright (C) 1995 Hiroyuki Sekiya
 */

#include <lxapi.h>
#include <string.h>

#define ENTERKEY		0x0D
#define ESCKEY			0x1B

#define SCREEN_HEIGHT	200
#define SCREEN_WIDTH	80

char far *msgAppName	= "CAPSYS";
char far *msgTitle		= "CAPSYS Version 1.00";
char far *msgOk			= "OK";
char far *msgCancel		= "Cancel";
char far *msgSaveAs		= "Save &As";
char far *msgFiles		= "&Files";
char far *msgDirs		= "&Directories";
char far *msgDir		= "Directry:";
char far *msgNega		= "&Nega";
char far *msgError		= "Error";
char far *msgSaveErr	= "File creation error.";
char far **ptrSaveErr	= &msgSaveErr;

LHAPIBLOCK LHAPIData;
EVENT_NORM app_event;
BOOL done = FALSE;
FILE fp;

char EnvPath[]			= "a:\\_dat\\capsys.env";

#define POSITIVE		0x00
#define NEGATIVE		0xFF
UINT ImageMask 			= POSITIVE;			/* negative= */
BOOL UpdateEnv			= TRUE;				/* update= */
char SoundStr[20]		= "L24O3CO4C";		/* sound= */

char Directory[128];						/* defaultdir= */
char FileSpec[128];
char WildCard[]			= "*.pcx";

#define FILECOUNT	128
#define FILELENGTH	13
char *FileList[FILECOUNT];
char FileSpace[FILECOUNT][FILELENGTH];

#define DIRCOUNT	64
#define DIRLENGTH	13
char *DirList[DIRCOUNT];
char DirSpace[DIRCOUNT][DIRLENGTH];


/***************************************************************************
* File Save Dialog
***************************************************************************/

LHWINDOW SaveDlgArray[] = {
	{ Edit, 14, 17, 18, 1,
	  (PLHRES)&msgSaveAs, (PLHDATA)FileSpec, sizeof(FileSpec),
	  STYLE_WHCHAR|EDIT_INSERT|STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, (PLHMENU)&WildCard, NO_HELP },

	{ PathText, 14, 37, 24, 1,
	  (PLHRES)&msgDir, (PLHDATA)Directory, sizeof(Directory),
	  STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

	{ FileListBox, 14, 54, 12, 6,
	  (PLHRES)&msgFiles, (PLHDATA)&FileList, countof(FileList),
	  STYLE_WHCHAR|STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, (PLHMENU)countof(FileList), NO_HELP },

	{ DirListBox, 150, 54, 12, 6,
	  (PLHRES)&msgDirs, (PLHDATA)&DirList, countof(DirList),
	  STYLE_WHCHAR|STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, (PLHMENU)countof(DirList), NO_HELP },

	{ CheckBox, 290, 18, 5, 1,
	  (PLHRES)&msgNega, (PLHDATA)&ImageMask, NEGATIVE,
	  STYLE_WHCHAR|STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

	{ PushButton, 286, 68, 40, 20,
	  (PLHRES)&msgOk, (PLHDATA)CMD_DONE, ENTERKEY,
	  PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

	{ PushButton, 286, 104, 80, 20,
	  (PLHRES)&msgCancel, (PLHDATA)CMD_ESC, 0,
	  PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

int far SaveDlgHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);

LHWINDOW FileSaveDialog = {
	(PLHCLASS)SaveDlgHandler, 134, 24, 376, 150,
	(PLHRES)&msgTitle, (PLHDATA)SaveDlgArray, countof(SaveDlgArray),
	STYLE_SAVEUNDER|STYLE_PUSHB_WIDTH|FILEOPEN_NODEFAULT,
	NULL, NULL, NO_MENU, NO_HELP
};

void InitFileDialog(void)
{
	UINT i;

	for (i=0; i<FILECOUNT; ++i) FileList[i] = &FileSpace[i][0];
	for (i=0; i<DIRCOUNT; ++i)  DirList[i]  = &DirSpace[i][0];
}


/***************************************************************************
* Error Message Dialog
***************************************************************************/

LHWINDOW ErrorDlgArray[] = {
	{ MessageBox, 20, 28, 300, 40,
	  NULL, (PLHDATA)&ptrSaveErr, 1,
	  STYLE_NOBORDER|STYLE_NOSHADOW|STYLE_NOFOCUS|STYLE_XYRELATIVE|MSG_CENTER_LINES,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
	{ PushButton, (340-70)/2, 60, 70, 0,
	  (PLHRES)&msgOk, (PLHDATA)CMD_DONE, ENTERKEY,
	  PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

int far ErrorDlgHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);

LHWINDOW ErrorDialog = {
	(PLHCLASS)ErrorDlgHandler, 150, 50, 340, 100,
	(PLHRES)&msgError, (PLHDATA)&ErrorDlgArray, countof(ErrorDlgArray),
	0,
	NULL, NULL, NO_MENU, NO_HELP
};


/***************************************************************************
* PCX Encoding
***************************************************************************/

typedef struct sPCX {
	BYTE	id;
	BYTE	version;
	BYTE	encoding;
	BYTE	bits;
	WORD	Window[4];
	WORD	hdpi;
	WORD	vdpi;
	BYTE	colmap[48];
	BYTE	reserved;
	BYTE	nplanes;
	WORD	linelen;
	WORD	palette;
	WORD	hsize;
	WORD	vsize;
	BYTE	filler[54];
} PCX;

PCX PcxHeader = {
	0x0A, 5, TRUE, 1, {0,0,SCREEN_WIDTH*8-1,SCREEN_HEIGHT-1},
	SCREEN_WIDTH*8, SCREEN_HEIGHT, {0,0,0, 0xFF,0xFF,0xFF},
	0, 1, SCREEN_WIDTH, 1, 0, 0
};

UINT EncodeLine(BYTE *dst, BYTE far *src, UINT width)
{
	UINT i, j;
	BYTE runlen;
	BYTE this, last;

	j = 0;
	last = *src ^ ImageMask;
	runlen = 1;
	for (i=1; i<width; i++) {
		this = *(++src) ^ ImageMask;
		if (this == last) {
			runlen++;
			if (runlen == 63) {
				dst[j++] = 0xC0 | 63;
				dst[j++] = last;
				runlen = 0;
			}
		} else {
			if (runlen) {
				if (runlen>1 || ((last & 0xC0) == 0xC0))
					dst[j++] = runlen | 0xC0;
				dst[j++] = last;
			}
			last = this;
			runlen = 1;
		}
	}
	if (runlen) {
		if (runlen>1 || ((last & 0xC0) == 0xC0))
			dst[j++] = runlen | 0xC0;
		dst[j++] = last;
	}
	return j;
}

BOOL SavePCX(char *filename)
{
	static BYTE linebuf[SCREEN_WIDTH*2];
	BYTE far *vram = (BYTE far *)0xB8000000L;
	UINT enclen;
	UINT y;

	if (m_fcreat(&fp, filename, strlen(filename), 0, 0) != 0)
		return FALSE;
	if (m_write(&fp, &PcxHeader, sizeof(PcxHeader)) != 0) {
		m_close(&fp);
		return FALSE;
	}
	for (y=0; y<SCREEN_HEIGHT/2; y++) {
		enclen = EncodeLine(linebuf, vram, SCREEN_WIDTH);
		if (m_write(&fp, linebuf, enclen) != 0) {
			m_close(&fp);
			return FALSE;
		}
		enclen = EncodeLine(linebuf, vram+0x2000, SCREEN_WIDTH);
		if (m_write(&fp, linebuf, enclen) != 0) {
			m_close(&fp);
			return FALSE;
		}
		vram += SCREEN_WIDTH;
	}
	m_close(&fp);
	return TRUE;
}

/***************************************************************************
* Text File I/O
***************************************************************************/

#define EOF		(-1)

char *fgets(char *s, int len, FILE *fp)
{
	int lenp;
	char *top;

	lenp = 0;
	top = s;
	while (--len && m_read(fp, s, 1, &lenp)==0 && *s!='\r')
		++s;
	if (*s == '\r')
		m_read(fp, s, 1, &lenp);
	*s = '\0';
	if (lenp==0)
		return NULL;
	else
		return top;
}

int fputs(const char *s, FILE *fp)
{
	if (m_write(fp, s, strlen(s)) == 0) return s[strlen(s)-1];
	else return EOF;
}


/***************************************************************************
* Read/Write environment file
***************************************************************************/

const char envUpdate[]	= "UPDATE=";
const char envNega[]	= "NEGATIVE=";
const char envDefDir[]	= "DEFAULTDIR=";
const char envSound[]	= "SOUND=";

BOOL ReadEnvFile(char *filename)
{
	char s[80];

	Directory[0] = FileSpec[0] = '\0';
	if (m_openro(&fp, filename, strlen(filename), 0, 0) != 0)
		return FALSE;
	while (fgets(s, sizeof(s), &fp)) {
		strupr(s);
		if (strncmp(s, envUpdate, strlen(envUpdate))==0) {
			UpdateEnv = (*(s+strlen(envUpdate)) == 'Y');
		} else if (strncmp(s, envNega, strlen(envNega))==0) {
			if (*(s+strlen(envNega)) == 'Y')
				ImageMask = NEGATIVE;
			else
				ImageMask = POSITIVE;
		} else if (strncmp(s, envDefDir, strlen(envDefDir))==0) {
			strncpy(Directory, s+strlen(envDefDir), sizeof(Directory));
			Directory[sizeof(Directory)-1] = '\0';
		} else if (strncmp(s, envSound, strlen(envSound))==0) {
			strncpy(SoundStr, s+strlen(envSound), sizeof(SoundStr));
			SoundStr[sizeof(SoundStr)-1] = '\0';
		}
	}
	m_close(&fp);
	return TRUE;
}

BOOL WriteEnvFile(char *filename)
{
	const char CrLf[] = "\r\n";

	if (m_fcreat(&fp, filename, strlen(filename), 0, 0) != 0)
		return FALSE;

	if (fputs(envUpdate, &fp) == EOF)	return FALSE;
	if (UpdateEnv) {
		if (fputs("Y", &fp) == EOF)		return FALSE;
	} else {
		if (fputs("N", &fp) == EOF)		return FALSE;
	}
	if (fputs(CrLf, &fp) == EOF)		return FALSE;

	if (fputs(envNega, &fp) == EOF)		return FALSE;
	if (ImageMask == NEGATIVE) {
		if (fputs("Y", &fp) == EOF)		return FALSE;
	} else {
		if (fputs("N", &fp) == EOF)		return FALSE;
	}
	if (fputs(CrLf, &fp) == EOF)		return FALSE;

	if (fputs(envDefDir, &fp) == EOF)	return FALSE;
	if (fputs(Directory, &fp) == EOF)	return FALSE;
	if (fputs(CrLf, &fp) == EOF)		return FALSE;

	if (fputs(envSound, &fp) == EOF)	return FALSE;
	if (fputs(SoundStr, &fp) == EOF) 	return FALSE;
	if (fputs(CrLf, &fp) == EOF)		return FALSE;

	m_close(&fp);
	return TRUE;
}


/***************************************************************************
* Event Handler
***************************************************************************/

int far SaveDlgHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...) {
	char PathName[128];

	switch (Message) {
	case KEYSTROKE:
		if (Data == F10KEY) Data = ENTERKEY;
		break;
	case COMMAND:
		switch (Data) {
		case CMD_DONE:
			SendMsg(Window, DESTROY, DESTROY_NORMAL, 0);
			if (strchr(FileSpec, '.') == NULL)
				strcat(FileSpec, WildCard+1);
			strcpy(PathName, Directory);
			if (strlen(PathName) != 3)			/* 3 is strlen("d:\\") */
				strcat(PathName, "\\");
			strcat(PathName, FileSpec);
			if (SavePCX(PathName)) {
				if (UpdateEnv) WriteEnvFile(EnvPath);
				m_play(SoundStr);
				done = TRUE;
			} else {
				m_beep();
				SendMsg(&ErrorDialog, CREATE, CREATE_FOCUS, 0);
			}
			return TRUE;
		case CMD_ESC:
			done = TRUE;
			break;
		}
		break;
	}
	return SubclassMsg(FileOpenDialogBox, Window, Message, Data, Extra);
}

int far ErrorDlgHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...)
{
	switch (Message) {
	case KEYSTROKE:
		switch (Data) {
		case ENTERKEY: case F10KEY: case ESCKEY:
			done = TRUE;
			return SendMsg(Window, DESTROY, DESTROY_NORMAL, 0);
		}
	}
	return SubclassMsg(DialogBox, Window, Message, Data, Extra);
}


/***************************************************************************
* Main
***************************************************************************/

void main(void)
{
	m_init_app(SYSTEM_MANAGER_VERSION);
	m_reg_app_name(msgAppName);
	InitializeLHAPI(&LHAPIData);
	SetDefaultFont(FONT_NORMAL);

	EnvPath[0] = 'a';
	if (!ReadEnvFile(EnvPath)) {
		EnvPath[0] = 'c';
		ReadEnvFile(EnvPath);
	}

	InitFileDialog();
	SendMsg(&FileSaveDialog, CREATE, CREATE_FOCUS, 0);

	m_keylock();

	do {
		app_event.do_event = DO_EVENT;
		m_action(&app_event);
		switch(app_event.kind) {
		case E_KEY:
			SendFocusMsg(KEYSTROKE, app_event.data, app_event.scan);
			break;
		case E_DEACT: case E_TERM: case E_BREAK:
			done = TRUE;
			break;
		}
	} while (!done);

	app_event.do_event = DO_FINI;
	m_action(&app_event);
}
