Program Amateur;
{
  Written by Norman Newman, Kibbutz Mishmar David, Israel.
  Version 1.5.2 - 23 October 1988.

  Permission is granted to use this program, or portions thereof,
  for non-commercial purposes. All other rights are reserved to
  the original author.

  This program is an expert system shell. For more help, see the file
  'syntax.txt'.
}
uses CRT;

const
 word_len = 16;
 version = 'V1.5.2';
 prog_name = 'The Amateur Reasoner';
 hash_max = 126;
 hash_max_plus = 127;

type
 word = packed array [1..16] of char;
 num_ptr = ^num_rec;
 num_rec = record
            n: integer;
            next: num_ptr
           end;

 name_ptr = ^name_rec;
 name_rec = record
             name: word;
             next: name_ptr
         end;

 prem_ptr = ^prem_rec;
 prem_rec = record
             object, value: integer;
             next: prem_ptr
            end;

 rule_ptr = ^rule_rec;
 rule_rec = record
             num: integer;
             prem, conc: prem_ptr;
             next: rule_ptr
            end;

 object_ptr = ^object_rec;
 object_rec = record
               name: integer;
               key, sought: boolean;
               legal, value, question: num_ptr;
               next: object_ptr
              end;


var
 last_try, top_fact: object_ptr;
 top_rule, last_rule: rule_ptr;
 goal: integer;
 trail, trail_r, intro: num_ptr;
 ch: char;
 hash_list: array [0..hash_max] of name_ptr;
 intro_flag, top, bottom: boolean;

 procedure box (left, top, right, bottom: integer);
  var
   i: integer;

  begin
   highvideo;
   for i:= left + 1 to right - 1 do
    begin
     gotoxy (i, top); write (chr(205));
     gotoxy (i, bottom); write (chr(205));
    end;

   for i:= top + 1 to bottom - 1 do
    begin
     gotoxy (left, i); write (chr(186));
     gotoxy (right, i); write (chr(186))
    end;

   gotoxy (left, top); write (chr(201));
   gotoxy (right, top); write (chr (187));
   gotoxy (right, bottom); write (chr(188));
   gotoxy (left, bottom); write (chr(200));
   lowvideo;
  end;

 function hash (var token: word): integer;
  var
   old, list: name_ptr;
   i, j: integer;
   c: char;
   found: boolean;

  begin
   i:= (ord(token[1])*100 + ord(token[2])*10 + ord(token[3]))
        mod hash_max_plus;
   list:= hash_list[i];
   if list = nil
    then
     begin
      new (list);
      list^.name:= token;
      list^.next:= nil;
      hash_list[i]:= list;
      hash:= 128 + i
     end
    else
     begin
      j:= 0;
      found:= false;
      while list <> nil do
       begin
        j:= j + 1;
        if list^.name = token then
         begin
          found:= true;
          list:= nil
         end
        else
         begin
          old:= list;
          list:= list^.next
         end
       end;

      if not found then
       begin
        j:= j + 1;
        new (old^.next);
        with old^.next^ do
         begin
          name:= token;
          next:= nil
         end
       end;
      hash:= 128*j + i
     end
   end { hash };

 procedure write_word (place: integer);
  var
   token: word;
   list: name_ptr;
   i: integer;

  begin
   list:= hash_list[place mod 128];
   place:= place div 128;
   if place = 1 then token:= list^.name
   else
    begin
     for i:= 1 to place - 1 do list:= list^.next;
     token:= list^.name
    end;
   i:= 0;
   repeat
    i:= i + 1;
    write (token[i])
   until (i = word_len) or (token[i] = ' ');
   if i = word_len then write (' ');
  end;


 function make_obj (index: integer): object_ptr;
  var
   obj: object_ptr;

  begin
   new (obj);
   with obj^ do
    begin
     name:= index;
     key:= false;
     sought:= false;
     legal:= nil;
     value:= nil;
     question:= nil;
     next:= top_fact { push onto stack }
    end;
  top_fact:= obj;
  make_obj:= obj
 end;

 function find_obj (index: integer; flag: boolean): object_ptr;
  var
   obj: object_ptr;
   found: boolean;

  begin
   found:= false;
   if last_try <> nil then
    if last_try^.name = index then
     begin
      find_obj:= last_try;
      found:= true
     end;

   if not found then
    begin
     obj:= top_fact;
     find_obj:= nil;
     while obj <> nil do
      if obj^.name = index then
       begin
        find_obj:= obj;
        last_try:= obj;
        found:= true;
        obj:= nil
       end
     else obj:= obj^.next
   end;
   if flag and not found then find_obj:= make_obj(index)
  end;

 function test (obj, val: integer): num_ptr;
  var
   cur_obj: object_ptr;
   cur_val: num_ptr;

  begin
   cur_obj:= find_obj (obj, false);
   test:= nil;
   if cur_obj <> nil then
    begin
     cur_val:= cur_obj^.value;
     while cur_val <> nil do
      if cur_val^.n = val then
       begin
        test:= cur_val;
        cur_val:= nil
       end
      else cur_val:= cur_val^.next
    end
  end;

 procedure parse;
  var
   buffer: string[80];
   file_name: string[23];
   rules: text;
   ending, goal_stmt: boolean;
   c: char;
   rule_num, i, line_count, char_count, len: integer;
   token: word;

  procedure check (c: char);
   begin
    if token[1] <> c then
     begin
      write ('Parsing error: ', c, ' expected, not "');
      write (token);
      writeln ('"');
      writeln ('Error occurred at line ', line_count);
      halt
     end
   end;

  function get_char: char;
   begin
    if char_count > len then
     begin
      repeat
       line_count:= line_count + 1;
       readln (rules, buffer);
       len:= length (buffer)
      until len <> 0;
      char_count:= 1;
     end;
    get_char:= buffer[char_count];
    inc (char_count)
   end;

  procedure next_token;
   label
    1, 2;

   var
    i: integer;
    c, d: char;

   begin
  1:;
    c:= get_char;
    while c = ' ' do c:= get_char;
    if c = '!' then
     begin
      repeat
       c:= get_char
      until c = '!';
      goto 1
     end;

    case c of
    '(',')',',','.','&','?','=','#': token[1]:= c;
     else
      begin
       token:= '                ';
       i:= 0;
       if c = '\' then
        begin
         d:= get_char;
         if d = 'n' then
          begin
           token[1]:= '\';
           token[2]:= 'n';
           goto 2
          end
         else dec (char_count)
        end;

       while (c <> '(') and (c <> ')') and (c <> ',') and (c <>'.')
        and (c <> '&') and (c <> '?') and (c <> '=') and (c <> '#')
         and (c <> ' ') and (i < word_len) do
          begin
           i:= i + 1;
           token[i]:= c;
           c:= get_char
          end
       end;
      if c <> ' ' then dec (char_count)
     end;
  2:;
    end;


procedure add_rule;
    var
     new_rule: rule_ptr;

    function make_prem: prem_ptr;
     var
      p: prem_ptr;

     begin
      new (p);
      with p^ do
       begin
        next_token;
        object:= hash(token);
        next_token;
        check ('=');
        next_token;
        value:= hash(token);
        next:= nil
       end;
      make_prem:= p
     end;

    function add_prem: prem_ptr;
     var
      p, front, rear: prem_ptr;

     begin
      front:= nil;
      repeat
       p:= make_prem;
       if front = nil
        then front:= p
        else rear^.next:= p;
       rear:= p;
       next_token;
       if token[1] <> 't' then check ('&')
      until token = 'then            ';
      add_prem:= front
     end;

    function add_conc: prem_ptr;
     var
      p, front, rear: prem_ptr;
      obj: object_ptr;

     begin
      front:= nil;
      repeat
       p:= make_prem;
       obj:= find_obj(p^.object, true);
       obj^.key:= true;
       if front = nil
        then front:= p
        else rear^.next:= p;
       rear:= p;
       next_token;
       if token[1] <> '.' then check ('&')
      until token[1] = '.';
      add_conc:= front
     end;

    begin { add_rule }
     new (new_rule);
     with new_rule^ do
      begin
       rule_num:= rule_num + 1;
       num:= rule_num;
       prem:= add_prem;
       conc:= add_conc;
       next:= nil
      end;
     if top_rule = nil
      then top_rule:= new_rule
      else last_rule^.next:= new_rule;
     last_rule:= new_rule
    end; { add_rule }

   procedure add_question;
    var
     obj: object_ptr;
     p, front, rear: num_ptr;

    begin
     next_token;
     check ('(');
     next_token;
     obj:= find_obj(hash(token), true);
     next_token;
     check (')');
     next_token;
     check ('=');
     front:= nil;

     next_token;
     while token[1] <> '?' do
      begin
       new (p);
       with p^ do
        begin
         n:= hash(token);
         next:= nil
        end;
       if front = nil
        then front:= p
        else rear^.next:= p;
       rear:= p;
       next_token
       end;
     obj^.question:= front
    end;

   procedure add_legal;
    var
     obj: object_ptr;
     p, front, rear: num_ptr;

    begin
     next_token;
     check ('(');
     next_token;
     obj:= find_obj(hash(token), true);
     next_token;
     check (')');
     next_token;
     check ('=');
     front:= nil;

     repeat
      next_token;
      new (p);
      with p^ do
       begin
        n:= hash(token);
        next:= nil
       end;
      if front = nil
       then front:= p
       else rear^.next:= p;
      rear:= p;
      next_token;
      if token[1] <> '.' then check (',')
     until token[1] = '.';
     obj^.legal:= front
    end;

  procedure add_goal;
   begin
    next_token;
    check ('(');
    next_token;
    if not goal_stmt
     then goal:= hash(token)
     else writeln ('Warning: duplicate goal statement!');
    goal_stmt:= true;
    next_token;
    check (')')
   end;

   procedure add_intro;
    var
     rear, np: num_ptr;

    begin
     if intro_flag then
      begin
       writeln (chr(7), 'Error: introduction already defined');
       halt
      end
     else
      begin
       intro_flag:= true;
       next_token;
       check ('=');
       next_token;
       while token[1] <> '.' do
        begin
         new (np);
         with np^ do
          begin
           n:= hash (token);
           next:= nil
          end;
         if intro = nil
          then intro:= np
          else rear^.next:= np;
         rear:= np;
         next_token
        end
      end
    end;

   procedure command_string;
    var
     flag: boolean;
     i: integer;

    begin
      if paramcount = 1 then
       begin
        file_name:= paramstr(1);
        flag:= true;
       end
      else flag:= false;

     repeat
      if not flag
       then
        begin
         gotoxy (14,16);
         clreol;
         write ('What is the name of the rule file? ');
         readln (file_name);
         flag:= true
        end;

      {$I-}
      assign (rules, file_name);
      reset (rules);
      if ioresult <> 0
       then
        begin
         gotoxy (14,17);
         write ('I can''t find the file you want!');
         flag:= false;
        end;
      {$I+}
     until flag;
     gotoxy (14, 17);
     write ('Loading file ', file_name);
     clreol;

    end;

  begin { parse }
   char_count:= 1;
   len:= 0;
   line_count:= 0;
   rule_num:= 0;
   for i:= 0 to hash_max do hash_list[i]:= nil;

   token:= 'if              ';
   i:= hash (token);
   token:= 'prompt          ';
   i:= hash(token);
   token:= 'values          ';
   i:= hash(token);
   token:= 'goal            ';
   i:= hash(token);
   token:= 'intro           ';
   i:= hash (token);
   token:= '\n              ';
   i:= hash (token);
   goal_stmt:= false;
   last_try:= nil;
   top_fact:= nil;
   top_rule:= nil;
   trail:= nil;
   intro:= nil;
   intro_flag:= false;

   command_string;
   repeat
    next_token;
    for i:= 1 to 6 do
     begin
      c:= token[i];
      if (c >= 'A') and (c <= 'Z')
       then token[i]:= chr(ord(c) + 32);
     end;

    case hash(token) of
     250: add_rule;
     133: add_question;
     179: add_legal;
     205: add_goal;
     160: add_intro;
     else
    end
   until token[1] = '#';
   if not goal_stmt then
    begin
     writeln ('No goal statement found!');
     halt
    end
  end { parse };

 procedure add_object (obj, val: integer);
  var
   cur_obj: object_ptr;
   list, head: num_ptr;

  begin
   cur_obj:= find_obj(obj, true);
   cur_obj^.sought:= true;
   list:= test (obj, val);
   if list = nil then
    begin
     head:= cur_obj^.value;
     new (list);
     with list^ do
      begin
       next:= head;
       n:= val
      end;
     cur_obj^.value:= list
    end
  end;

 procedure show_prem (p: prem_ptr);
  begin
   while p <> nil do
    begin
     with p^ do
      begin
       write_word (object);
       write ('= ');
       write_word (value)
      end;
     p:= p^.next;
     if p <> nil then writeln ('and')
     else writeln
    end
  end;

 procedure explain_why (index, number: integer);
  var
   cur_rule: rule_ptr;

  begin
   bottom:= true;
   window (3,15,78,21);
   clrscr;
   write ('I am asking you for the value of ');
   write_word (index);
   writeln ('in order to solve the rule:');
   cur_rule:= top_rule;
   while cur_rule^.num <> number do
    cur_rule:= cur_rule^.next;
   write ('If ');
   show_prem (cur_rule^.prem);
   write ('then ');
   show_prem (cur_rule^.conc);
  end;

 function ask (obj, number: integer): integer;
  var
   cur_obj: object_ptr;
   list: num_ptr;
   found: boolean;
   i, ans: integer;
   tok: string[16];
   token: word;

   procedure enquire (index: integer; cur_obj: object_ptr);
    var
     ques: num_ptr;
     i: integer;

    begin
     top:= true;
     window (3,3,78,9);
     clrscr;
     if cur_obj <> nil then
      with cur_obj^ do
       if question = nil then
        begin
         write ('What is the value of ');
         write_word (index);
         writeln ('?')
        end
       else
        begin
         ques:= question;
         while ques <> nil do
          with ques^ do
           begin
            write_word (n);
            ques:= next
           end;
         writeln ('?')
        end
     else
      begin
       write ('What is the value of ');
       write_word (index);
       writeln ('?')
      end
    end;

  begin { ask }
   if top then
    begin
     clrscr;
     top:= false;
    end;
   cur_obj:= find_obj (obj, false);
   enquire (obj, cur_obj);
   found:= cur_obj <> nil;
   if found then found:= cur_obj^.legal <> nil;

   if not found then
    begin
     readln (tok);
     token:= '                ';
     for i:= 1 to length(tok) do
      token[i]:= tok[i];
     ask:= hash(token)
    end
   else
    begin
     list:= cur_obj^.legal;
     i:= 0;
     while list <> nil do
      begin
       i:= i + 1;
       write (i:1, ' - ');
       write_word(list^.n);
       writeln;
       list:= list^.next
      end;

     repeat
      write ('Enter a number between 1 and ', i:1,
             ' (0 = explanation) - ');
      readln (ans);
      if ans = 0 then explain_why (obj, number)
     until (ans > 0) and (ans <= i);

     if bottom then
      begin
       window (3,15,78,21);
       clrscr;
       bottom:= false
      end;

     if ans = 1 then ask:= cur_obj^.legal^.n
     else
      begin
       list:= cur_obj^.legal;
       for i:= 1 to ans - 1 do list:= list^.next;
       ask:= list^.n
      end
    end
  end;

 function find_rule (index: integer; cur_rule: rule_ptr): rule_ptr;
  var
   found: boolean;
   concl: prem_ptr;

  begin
   found:= false;
   find_rule:= nil;
   while (cur_rule <> nil) and not found do
    begin
     concl:= cur_rule^.conc;
     while concl <> nil do
      if concl^.object = index then
       begin
        found:= true;
        find_rule:= cur_rule;
        concl:= nil
       end
      else concl:= concl^.next;
     cur_rule:= cur_rule^.next
    end
  end;

 procedure conclude (cur_rule: rule_ptr);
  var
   concl: prem_ptr;
   np: num_ptr;

  begin
   new (np);
   with np^ do
    begin
     n:= cur_rule^.num;
     next:= nil
    end;
   if trail = nil
    then trail:= np
    else trail_r^.next:= np;
   trail_r:= np;

   concl:= cur_rule^.conc;
   while concl <> nil do
    with concl^ do
     begin
      add_object (object, value);
      concl:= next
     end
  end;

 procedure pursue (index, number: integer);
  var
   val: integer;
   cur_obj: object_ptr;
   cur_rule: rule_ptr;
   cur_prem: prem_ptr;
   bad, solved: boolean;

  begin
   cur_obj:= find_obj (index, true);
   if not cur_obj^.sought then
    begin
     solved:= false;
     cur_obj^.sought:= true;
     cur_rule:= find_rule (index, top_rule);

     while (cur_rule <> nil) and cur_obj^.key and not solved do
      begin
       cur_prem:= cur_rule^.prem;
       bad:= false;
       while (cur_prem <> nil) and not bad do
        begin
         pursue (cur_prem^.object, cur_rule^.num);
         with cur_prem^ do
          begin
           bad:= test (object, value) = nil;
           cur_prem:= next
          end
        end;

       if not bad then
        begin
         conclude (cur_rule);
         solved:= true
        end
       else cur_rule:= find_rule(index, cur_rule^.next)
      end;

     if not solved then add_object (index, ask(index,number))
    end
  end;

 procedure explain_how;

  procedure explain (n: integer);
   var
    cur_rule: rule_ptr;
    ch: char;

   begin
    clrscr;
    cur_rule:= top_rule;
    while cur_rule^.num <> n do cur_rule:= cur_rule^.next;
    write ('If ');
    with cur_rule^ do
     begin
      show_prem (prem);
      write ('then ');
      show_prem (conc)
     end;
    writeln;
    write ('Press any key to continue ... ');
    ch:= readkey;
    writeln;
   end;

  begin { explain_how }
   writeln ('I made my conclusions using the rule(s)');
   while trail <> nil do
    with trail^ do
     begin
      explain (n);
      trail:= next
     end;
  end;

 procedure result (obj: object_ptr);
  var
   val: num_ptr;

  begin
   val:= obj^.value;
   write_word (obj^.name);
   write ('= ');
   if val = nil then write ('undefined');
   while val <> nil do
    with val^ do
     begin
      write_word (n);
      val:= next;
      if val <> nil then write (', ')
     end;
   writeln
  end;

 procedure clear;
  var
   obj: object_ptr;
   np: num_ptr;

  begin
   obj:= top_fact;
   while obj <> nil do
    with obj^ do
     begin
      sought:= false;
      while value <> nil do
       begin
        np:= value;
        value:= value^.next;
        dispose (np)
       end;
      obj:= next
     end;

   while trail <> nil do
    begin
     np:= trail;
     trail:= trail^.next;
     dispose (np)
    end
  end;

 procedure display_intro_text (intro: num_ptr);
  var
   ch: char;

  begin
   clrscr;
   window (3,3,78,22);
   while intro <> nil do
    begin
     if intro^.n = 173
      then writeln
      else write_word (intro^.n);
     intro:= intro^.next
    end;
   writeln(chr(8), '.');
   gotoxy (1,17);
   write ('Press any key to continue ... ');
   ch:= readkey;
   clrscr;
   window (1,1,80,24);
  end;

 procedure announcement;
  var
   ch: char;

  begin
   clrscr;
   box (10,2,70,14);
   highvideo;
   gotoxy (25,4);
   write ('Welcome to ', prog_name);
   gotoxy (20,6);
   write ('Version ', version, ' copyright Norman Newman 1988');
   gotoxy (14,10);
   write ('Help can be found in the accompanying file Syntax.txt');
   normvideo;
   gotoxy (14,12);
   write ('Press any key to continue ... ', ' ':22);
   ch:= readkey;
  end;

begin { main }
 announcement;
 parse;
 repeat
  display_intro_text (intro);
  box (1, 1, 80, 11);
  box (1, 13, 80, 23);
  top:= false;
  bottom:= false;
  pursue (goal, 0);

  window (3,15,78,22);
  clrscr;
  write ('Result ==> ');
  result (find_obj(goal, false));
  write ('Do you want to see my reasoning <y/n> ? ');
  readln (ch);
  if ch = 'y' then explain_how;
  write ('Do you want another consultation <y/n> ? ');
  readln (ch);
  if ch = 'y' then clear
 until ch <> 'y';
 writeln ('Goodbye from ', prog_name);
 window (1,1,80,25);
 delay (1000);
 clrscr;
end.
