#define PRGNAME "WTOP.C  WAV->X68K PCM converter  Test Version"

/* 
    94/04/16  Ver0.1
    95/05/05  Ver0.1+  500KBȏ̃f[^ƌӂꂷ̂ɑΏ */

#define LITTLE_ENDIAN 1     /* x86 -> 1 , 680x0 -> 0 */

#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <string.h>

#define UCHAR  unsigned char
#define USHORT unsigned short
#define ULONG  unsigned long
#define ADPTABLESIZE 49
#define BUFFMAX 10000

UCHAR  sbuf[BUFFMAX];               /* source file buffer */
UCHAR  dbuf[BUFFMAX];               /* destination file buffer */
USHORT adp_table[ADPTABLESIZE];     /* adpcm delta table */
short  step_table[16]={             /* adpcm step table */
	-1, -1, -1, -1, 2, 4, 6, 8,
	-1, -1, -1, -1, 2, 4, 6, 8};
ULONG  datasize,sfreq,dfreq;        /* source pcm datasize,source frequency,destination frequency */
USHORT channel,perbyte,bitlen;      /* source channel,data bytes per sampling,bit length per sampling */
short  shft;                        /* shift-left bits from source to destination */
FILE   *infp,*outfp;                /* source file,destination file */
UCHAR usage[]="\
usage:\n\
wtop <source> <destination> [-f=<freq>]\n\
   <freq> : destination data frequency(default:15600)\n\
Example:\n\
wtop dowk016.wav maido.pcm\n";

USHORT ptoi(UCHAR *dat)    /* (*pointer) to USHORT */
{
#if LITTLE_ENDIAN
    USHORT *ret;
    ret=(USHORT *)dat;
    return((USHORT)(*ret));
#else
    USHORT ret;
    UCHAR  *d;
    d=dat;
    ret =(USHORT)(*d);    d++;
    ret+=(USHORT)(*d)<<8;
    return(ret);
#endif
}

ULONG ptol(UCHAR *dat)   /* (*pointer) to ULONG */
{
#if LITTLE_ENDIAN
    ULONG *ret;
    ret=(ULONG *)dat;
    return((ULONG)(*ret));
#else
    ULONG ret;
    UCHAR *d;
    d=dat;
    ret =(ULONG)(*d);    d++;   /* against XC's mysterious code */
    ret+=(ULONG)(*d)<<8; d++;
    ret+=(ULONG)(*d)<<16;d++;
    ret+=(ULONG)(*d)<<24;
    return(ret);
#endif
}

void make_table(void)  /* make adpcm delta table */
{
    int i;
    long l,p;

    l = p = 1L;
    for(i=0;i<ADPTABLESIZE;i++)
    {
        adp_table[i]=(int)(l*16/p);
        l*=11L;p*=10L;
        if (p>100000L)
        {
            l/=10L;
            p/=10L;
        }
    }
}

void check_infp(void)  /* WAV file format check */
{
    ULONG work;

    fread(sbuf,1,0x2c,infp);
    datasize = ptol(&sbuf[0x04])-0x24;
    channel  = ptoi(&sbuf[0x16]);
    sfreq    = ptol(&sbuf[0x18]);
    perbyte  = ptoi(&sbuf[0x20]);
    bitlen   = ptoi(&sbuf[0x22]);
    shft     = 12-bitlen;

    if ((strncmp(&sbuf[0x00],"RIFF",4))     ||
        (strncmp(&sbuf[0x08],"WAVEfmt ",8)) ||
        (strncmp(&sbuf[0x24],"data",4))     ||
        (ptol(&sbuf[0x10])!=0x00000010L)    ||
        (ptoi(&sbuf[0x14])!=0x0001)         ||
        ((sfreq * perbyte)!=ptol(&sbuf[0x1c])) ||
        (datasize != ptol(&sbuf[0x28]))     ||
        ((bitlen!=8) && (bitlen!=16))       ||
        ((perbyte < (USHORT)(bitlen / 8))))
    {
        printf("Unexpected data format\n");
        exit(1);
    }
    printf("                        Source        Destination\n");
    work=datasize;
    work/=2; work/=perbyte;
    work*=dfreq;
    work/=sfreq;
    printf("Data size           :%6ld bytes     %6ld bytes\n",datasize,work);
    printf("Frequency           :%6ld Hz        %6ld Hz\n",sfreq,dfreq);
    printf("Sample bits length  :%6d               12(%d bits %s)\n",bitlen,(shft>0)?shft:-shft,(shft>0)?"shl":"shr");
    printf("Bytes per sample    :%6d              0.5\n",perbyte);
    printf("Channel             :%6d                1\n\n",channel);
    if (channel!=1)
    {
        printf("Can't treat multi-channel data\n");
        exit(1);
    }
    if (datasize>500000L) /* 0.1+ ULONǦӂΏ */
    {
        sfreq/=100;dfreq/=100;
    }
}

void filt_exec(void)  /* filter main */
{
    short snow,dnow,del_t;
    UCHAR ans;
    short adp;
    USHORT i,bytesread,byteswrite;
    ULONG sdata,ddata,bufsize;

    /* decide buffer size */
    bufsize=((sfreq/2/perbyte) < dfreq) ? (ULONG)BUFFMAX:(dfreq*BUFFMAX*2*perbyte/sfreq);
    if ((bufsize % perbyte)!=0) bufsize-=(bufsize % perbyte);

    printf("converting.");
    adp = 0;
    dnow = 2047;
    sdata = ddata = 0L;
    while (!feof(infp))
    {
        bytesread=fread(sbuf,1,(USHORT)bufsize,infp);
        if (bytesread==0) break;
        byteswrite=0;
        for (i=0;i<bytesread;i+=perbyte)
        {
            if (bitlen>8) snow=ptoi(&sbuf[i]);
            else snow=(USHORT)sbuf[i];
            if (shft>0) snow <<= shft; else snow >>= (-shft);
            if (snow>0x0fff) snow=0x0fff;
            while ((sdata * dfreq / sfreq) >= ddata)
            {
                del_t=adp_table[adp];
                if (snow>=dnow)
                {
                    ans=0;
                    dnow += del_t/8;
                    if (snow>= (dnow+del_t  ))
                    {
                        ans += 4;
                        dnow+=del_t  ;
                    }
                    if (snow>= (dnow+del_t/2))
                    {
                        ans += 2;
                        dnow+=del_t/2;
                    }
                    if (snow>= (dnow+del_t/4))
                    {
                        ans += 1;
                        dnow+=del_t/4;
                    }
                }
                else
                {
                    ans=8;
                    dnow -= del_t/8;
                    if (snow<= (dnow-del_t  ))
                    {
                        ans += 4;
                        dnow-=del_t  ;
                    }
                    if (snow<= (dnow-del_t/2))
                    {
                        ans += 2;
                        dnow-=del_t/2;
                    }
                    if (snow<= (dnow-del_t/4))
                    {
                        ans += 1;
                        dnow-=del_t/4;
                    }
                }
                if (ddata & 1)
                {
                    dbuf[byteswrite]|=ans<<4;
                    byteswrite++;
                }
                else
                    dbuf[byteswrite]=ans;
                adp += step_table[ans];
                if (adp<0) adp=0; else if (adp>=ADPTABLESIZE) adp=ADPTABLESIZE-1;
                ddata++;
            }
            sdata++;
        }
        fwrite(dbuf,1,byteswrite,outfp);
        printf(".");
    }
    printf("End\n");
}


void main(argc,argv)
int  argc;
char **argv;
{
    int i;

    printf("%s\n",PRGNAME);
    if ((argc<3) || (argc>5))
    {
       printf("%s",usage);
       exit(1);
    }
    dfreq = 15600L;
    infp = outfp = NULL;
    for (i=1;i<argc;i++)
    {
        switch(argv[i][0])
        {
            case '-':
            case '/':
                switch (argv[i][1])
                {
                    case 'f':
                    case 'F':
                        dfreq=atol(&argv[i][3]);
                        break;
                    default:
                        printf("%s",usage);
                        exit(1);
                }
                break;
            default:
                if (infp==NULL)
                {
                    if ((infp=fopen(argv[i],"rb"))==NULL)
                    {
                        printf("Can't open %s\n",argv[i]);
                        exit(1);
                    }
                    break;
                }
                else if (outfp==NULL)
                {
                    if ((outfp=fopen(argv[i],"wb"))==NULL)
                    {
                        printf("Can't create %s\n",argv[i]);
                        fclose(infp);
                        exit(1);
                    }
                    break;
                }
                else
                {
                    printf("%s",usage);
                    exit(1);
                }
        }
    }
    if ((infp==NULL) || (outfp==NULL))
    {
        printf("%s",usage);
        exit(1);
    }
    check_infp();
    make_table();
    filt_exec();
    fclose(infp);
    fclose(outfp);
}
