#define PRGNAME "BTOE.C  BMP->EVA1 converter  Test Version"

/* 192~184̃mNBMP̃t@CgEVA1`ɕϊ */
/* 
   95/05/05  Ver0.1   */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define UCHAR  unsigned char
#define USHORT unsigned short
#define ULONG  unsigned long
#define XSIZE 96
#define YSIZE 92
#define DSIZE 2208

FILE *src,*dst;              /* ΏBMPt@C, o͐EVAt@C */
UCHAR obuff[DSIZE];          /* 1t@C̏o̓obt@ */
USHORT off=0;                /* t@Cϊp[N */
UCHAR ytable[5]={0,0,1,2,3}; /* 邳ϊe[u */


void usage(void)
{
    printf("usage:\n");
    printf("btoe <list file> <output file> <frame rate> [option]\n");
    printf("    <list file>: ϊBMPt@C񋓂eLXgt@C\n");
    printf("  <output file>: o̓t@C\n");
    printf("   <frame rate>: b̃t[\n");
    printf("       [option]: -0(Â) ` -3(邭)  ftHg 1\n"); 
    printf(":\n");
    printf("btoe kukuri.lst kukuri.eva 10 -0\n");
    exit(1);
}

void do_line(void)   /* y1Cϊ */
{
    USHORT i,x,y,ptr;
    UCHAR indat,outdat,w1;
    UCHAR image[XSIZE*2][2],wbuff[XSIZE/4];

    /* imageɌBMPhbgWJ */
    for (y=0;y<2;y++)
        for (x=0;x<XSIZE*2;x+=8)
        {
            fread(&indat,1,1,src);
            for (i=0;i<8;i++)
            {
                image[7-i+x][y]=((indat & (1<<i)) != 0) ? 1:0;
            }
        }
    /* imagewbuffɕϊf[^ */
    /* BMP 2*2hbgEVA 1hbg̃f[^ɕϊ */
    ptr=0;
    for (x=0;x<XSIZE;x+=4)
    {
        outdat=0;
        for (i=0;i<4;i++)
        {
            w1 = image[x*2+i*2][0]
                +image[x*2+1+i*2][0]
                +image[x*2+i*2][1]
                +image[x*2+1+i*2][1];
            outdat |= ytable[w1] << ((3-i)*2);
        }
        wbuff[ptr++]=outdat;
    }
    /* BMP̃CтEVÃCт𒲐 */
    memcpy(&obuff[DSIZE-XSIZE/4-off],wbuff,XSIZE/4);
    off+=XSIZE/4;
}

void do_file(unsigned char *fname) /* 1t@Cϊ */
{
    USHORT i;

    if ((src=fopen(fname,"rb"))==NULL)
    {
        printf("Cannot read source file[%s]\n",fname);
        exit(1);
    }
    printf("processing %s ... ",fname);
    fseek(src,62L,0); /* BMP̃wb_XLbv */
    off=0;
    for (i=0;i<YSIZE;i++) do_line(); /* y92CJԂ */
    fclose(src);
    fwrite(obuff,1,DSIZE,dst); /* 1t@Co */
    printf("done.\n");
}

main(int argc,char **argv)
{
    UCHAR filename[128];
    USHORT frame;
    FILE *list;

    printf("%s\n",PRGNAME);
    if ((argc!=4) && (argc!=5))  usage();
    if((list=fopen(argv[1],"rt"))==NULL)
    {
        printf("Cannot open list file[%s]\n",argv[1]);
        exit(1);
    }
    if((dst=fopen(argv[2],"wb"))==NULL)
    {
        printf("Cannot create destination file[%s]\n",argv[2]);
        exit(1);
    }
    /* 邳 */
    if (argc==5)
        switch (argv[4][1])
        {
        case '3': ytable[3]+=1;
        case '2': ytable[2]+=1;
        case '1': ytable[1]+=1;
        }
    else  ytable[1]+=1;
    /* wb_쐬 */
    strcpy(obuff,"EVA3");
    obuff[4]=0x1a;
    obuff[5]=0;
    obuff[6]=0;
    obuff[7]=atoi(argv[3]) & 0xff;
    obuff[8]=(atoi(argv[3]) & 0xff00) >> 8;
    fwrite(obuff,1,9,dst);
    /* ϊC */
    for (frame=0;;frame++)
    {
        fgets(filename,sizeof(filename),list);
        filename[strlen(filename)-1]=0;
        if (feof(list)) break;
        if ((filename[0]!=0)
            && (filename[0]!=';')
            && (filename[0]!='#'))
           do_file(filename);
        else
           frame--;
    }
    fclose(list);
    /* t[ */
    fseek(dst,5L,0);
    fwrite(&frame,1,2,dst);
    fclose(dst);
}
