/* DIALCFG.EXM  v.1.1		1997-03-08  Toshiki		*/

#include  "lxapi.h"
#include <string.h>

#define CFGFILESPEC "C:\\_DAT\\DIAL.CFG"
#define CFGFILELEN  (16)
#define CFGDEFAULT  "COM1:AT&FD:;:ATH0"
#define CFGDEFLEN   (17)
#define ENTERKEY	0x0d
#define ESCKEY		0x1b

char far *msgnull   = "";
char far *msgAppName= "DialCfg";
char far *msgPort   = "Port";
char far *msgPort1  = "Com1";
char far *msgPort2  = "Com2";
char far *msgOK     = "OK";
char far *msgCan    = "Cancel";
char far *msgFile   = "&File";
char far *msgQuit   = "&Quit";
char far *msgSave   = "&Save";
char far *msgExit   = "E&xit";
char far *msgPrefix = "Prefix";
char far *msgSuffix = "Suffix";
char far *msgReset  = "Reset ";
char far *msgConfig = "Configuration for DIAL.EXM";

char	CfgBuffer[80];
unsigned int	PortID=1;
char	ModemPrefix[80], ModemSuffix[40], ModemReset[40];

char far *CfgBufferPtr=CfgBuffer;
char far *PortIDPtr=(char *)&PortID;
char far *ModemPrefixPtr=ModemPrefix;
char far *ModemSuffixPtr=ModemSuffix;
char far *ModemResetPtr=ModemReset;

void far ReadCfg( void );
void far WriteCfg( void );
void far DoQuit( void );
int far CfgDialogHandler(PLHWINDOW, WORD, WORD, WORD) ;

char far **StringTable[]={
  &msgnull, &msgAppName, &msgPort, &msgPort1, &msgPort2, &msgOK, 
  &msgCan, &msgFile, &msgQuit, &msgSave, &msgExit, &msgPrefix, 
  &msgSuffix, &msgReset, &msgConfig,&CfgBufferPtr, &PortIDPtr,
  &ModemPrefixPtr, &ModemSuffixPtr, &ModemResetPtr
};

EVENT_NORM	app_event;
LHAPIBLOCK	LHAPIData;
BOOL  Done;

LHWINDOW CfgArray[] = {
	{	Edit, 80, 37, 26, 1,
		(PLHRES)&msgPrefix, (PLHDATA)&ModemPrefix, 79, 
		STYLE_WHCHAR|EDIT_INSERT,
		NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
	{	Edit, 80, 54, 26, 1,
		(PLHRES)&msgSuffix, (PLHDATA)&ModemSuffix, 79, 
		STYLE_WHCHAR|EDIT_INSERT,
		NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
	{	Edit, 80, 71, 26, 1,
		(PLHRES)&msgReset, (PLHDATA)&ModemReset, 79,
		STYLE_WHCHAR|EDIT_INSERT,
		NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
	{	GroupBox, 450, 37, 100, 50,
		(PLHRES)&msgPort, NULL, 0, STYLE_NOFOCUS,
		NULL, PARENT_FKEYS, NO_MENU, NO_HELP	},
	{   RadioButton, 460, 52, 1, 1,
		(PLHRES)&msgPort1, (PLHDATA)&PortID, 1, STYLE_WHCHAR,
		&CfgArray[3], PARENT_FKEYS, NO_MENU, NO_HELP	},
	{   RadioButton, 460, 69, 1, 1,
		(PLHRES)&msgPort2, (PLHDATA)&PortID, 2, STYLE_WHCHAR,
		&CfgArray[3], PARENT_FKEYS, NO_MENU, NO_HELP	},
	{	PushButton, 350, 100, 1, 5,
		(PLHRES)&msgOK, (PLHDATA)CMD_DONE, ENTERKEY,
		0|PUSHB_SENDMSG|STYLE_PUSHBUTTON,
		0, 0, 0, NO_HELP, STATUS_DEF_PUSHB },
	{	PushButton, 450, 100, 1, 5,
		(PLHRES)&msgCan, (PLHDATA)CMD_ESC, ESCKEY,
		0|PUSHB_SENDMSG|STYLE_PUSHBUTTON,
		0, 0, 0, NO_HELP, STATUS_DEF_PUSHB }
};

LHFKEY CfgFKeys[] = {
	{ (PLHRES)&msgCan, (PLHFUNC)CMD_ESC, 9, FKEY_SENDMSG },
	{ (PLHRES)&msgOK, (PLHFUNC)CMD_DONE, 10+FKEY_LAST, FKEY_SENDMSG }
};

LHMENU CfgFileMenu[] = {
  { (PLHRES)&msgSave, (PLHFUNC)WriteCfg, 0, 0 },
  { (PLHRES)&msgExit, (PLHFUNC)DoQuit, 0, 0 },
  { 0, 0, 0, 0}
};

LHMENU CfgMenu[] = {
  { (PLHRES)&msgFile, (PLHFUNC)CfgFileMenu, 0, MENU_PULLDOWN },
  { (PLHRES)&msgQuit, (PLHFUNC)DoQuit, 0, 0 },
  { 0, 0, 0, 0}
};

LHWINDOW CfgDialog = {
	(PLHCLASS)&CfgDialogHandler, 70, 20, 500, 120,
	(PLHRES)&msgConfig, (PLHDATA)CfgArray, countof(CfgArray),
	STYLE_PUSHB_WIDTH,
	NULL, CfgFKeys, CfgMenu, NO_HELP
};

#define GetDataSeg()  _DS

void FixupFarPtrs(void)
{
int i,dataseg;
  dataseg=GetDataSeg();
  for(i=0; i<countof(StringTable); i++)
    *(((int *)(StringTable[i]))+1) = dataseg;
}


int far CfgDialogHandler(PLHWINDOW Wnd, WORD Message, WORD Data, \
                            WORD Extra) {
	if( Message == COMMAND && ( Data == CMD_DONE || Data == CMD_ESC )) {
		if ( Data == CMD_DONE ) 
			WriteCfg();
		Done = TRUE;
		return 0;
	} else 
		return SubclassMsg( DialogBox, Wnd, Message, Data, Extra );
}

void far ReadCfg( void )		/* Read Configuration File */
{
	FILE fd;
	int lenp, s, d;
	unsigned char c;

	m_lock();
	if(m_open(&fd, CFGFILESPEC, CFGFILELEN, 0, 0)) {
	/* if not exist, then create and write default configuration */
		if(!m_create(&fd, CFGFILESPEC, CFGFILELEN, 0, 0)) {
			m_write(&fd, CFGDEFAULT, CFGDEFLEN );
			m_close(&fd);
		}
	} else {
		if(m_read(&fd, CfgBuffer, 80, &lenp)) {
		/* if can't read, then use default config */
			strcpy(CfgBuffer,CFGDEFAULT);
		}
		m_close(&fd);
	}
	m_unlock();
	/* Should begin with COM?:  If not use default config */
	if ( CfgBuffer[0]=='C' && CfgBuffer[1]=='O'
	  && CfgBuffer[2]=='M' && CfgBuffer[4]==':' ) {
		PortID=CfgBuffer[3]-'0';
	} else {
		strcpy(CfgBuffer,CFGDEFAULT);
		PortID=1;
	}
	s=5;
	d=0;
	while( (c=CfgBuffer[s++])!=':' ) 		/* Prefix */
		ModemPrefix[d++]=c;
	ModemPrefix[d]='\0';
	d=0;
	while( (c=CfgBuffer[s++])!=':' )		/* Suffix */
		ModemSuffix[d++]=c;
	ModemSuffix[d]='\0';
	d=0;
	while( (c=CfgBuffer[s++])!='\0')		/* Reset Command */
		ModemReset[d++]=c;
	ModemReset[d]='\0';
	return;
}

void far WriteCfg( void )		/* Write Configuration File */
{
	FILE fd;
	int s, d;
	char c;

	CfgBuffer[0]='C';
	CfgBuffer[1]='O';
	CfgBuffer[2]='M';
	CfgBuffer[3]='0' + PortID;
	CfgBuffer[4]=':';
	d=5; s=0;
	while( (c=ModemPrefix[s++])!='\0' ) 	/* Prefix */
		CfgBuffer[d++]=c;
	CfgBuffer[d++]=':';
	s=0;
	while( (c=ModemSuffix[s++])!='\0' )		/* Suffix */
		CfgBuffer[d++]=c;
	CfgBuffer[d++]=':';
	s=0;
	while( (c=ModemReset[s++])!='\0')		/* Reset Command */
		CfgBuffer[d++]=c;
	CfgBuffer[d]='\0';				/* d = destination ptr = length */

	m_lock();
	if( !m_fcreat(&fd, CFGFILESPEC, CFGFILELEN, 0, 0 ) ) {
		m_open(&fd, CFGFILESPEC, CFGFILELEN, 0, 0 );
		m_write(&fd, CfgBuffer, d );
		m_close(&fd);
	}
	m_unlock();
	return;
}

void far DoQuit(void)
{
  Done = TRUE;
}

void main(void)
{
	m_init_app( SYSTEM_MANAGER_VERSION );
	InitializeLHAPI( &LHAPIData );
	FixupFarPtrs();
	SetMenuFont( FONT_NORMAL );
	SetDefaultFont( FONT_NORMAL );
	m_reg_app_name( msgAppName );

	ReadCfg();
	SendMsg( &CfgDialog, CREATE, CREATE_FOCUS, 0 );

	Done = FALSE;

	while( !Done ) {
		app_event.do_event = DO_EVENT;
		m_action( &app_event );
		switch( app_event.kind ) {
			case E_ACTIV:
			case E_REFRESH:
				FixupFarPtrs();
				ReactivateLHAPI( &LHAPIData );
				break;
			case E_DEACT:
				DeactivateLHAPI();
				break;
			case E_TERM:
			case E_BREAK:
				FixupFarPtrs();
				Done = TRUE;
				break;
			case E_KEY:
         		SendFocusMsg( KEYSTROKE, app_event.data, app_event.scan);
				break;
			case E_NONE:
				break;
		 }
	}
	app_event.do_event = DO_FINI;
	m_action( &app_event );
}
