/* SYSLOG
 *
 * (c) 2002 by Daniel Hertrich. http://www.daniel-hertrich.de
 *
 * SYSLOG writes messages into a system-wide central logfile.
 * The filename of the log file defaults to c:\syslog.txt. If
 * you need another filename, change the constant LOGFILE below
 * and recompile the C code. Also if you need another date and time
 * format than the default, change it in the strftime line and 
 * recompile.
 *
 * If the logfile does not yet exist, syslog creates it and adds as
 * the first line something like "Starting syslog...".
 *
 * If the logfile exists, just the line with time stamp and given string
 * is appended.
 *
 *
 */
 
#define VERSION "1.2"
#define LOGFILE "c:\\syslog.txt"

#include <stdlib.h>
#include <stdio.h>
#include <time.h>

void usage (void);


time_t jetzt;
struct tm *ptr;
char zeit[40];
FILE *fp;

int main(int argc, char *argv[])
{
  int i;
  if (argc < 2) usage();

  time(&jetzt);
  ptr = localtime(&jetzt);

//  International ISO date format:
    strftime(zeit, sizeof(zeit), "%Y-%m-%d %H:%M:%S",ptr);  
//  German version
//  strftime(zeit, sizeof(zeit), "%d.%m.%Y %H:%M:%S",ptr); 

  fp=fopen(LOGFILE,"r");
  if (fp == NULL)
  {
    fp=fopen(LOGFILE,"w");
    fprintf(fp,"*** Syslog started: %s\n*** Using SYSLOG.EXE v%s by D.Hertrich http://www.daniel-hertrich.de\n\n",zeit,VERSION);
  }

  else 
  {
    fclose(fp);
    fp=fopen(LOGFILE,"a");
    if (fp == NULL)
    {
      printf("\a\nSYSLOG.EXE: ERROR OPENING FILE %s FOR APPENDING!\n\n",LOGFILE); 
      return(1);
    }
  }  
  fprintf(fp,"%s",zeit);
  for (i = 1; i < argc; i++)
    fprintf(fp," %s", argv[i]);
  fprintf(fp, "\n");
  fclose(fp);
  return(0);
}



void usage (void)
{
  printf("\a\n\nSYSLOG version %s by Daniel Hertrich http://www.daniel-hertrich.de\n\
Use SYSLOG this way:\n\n\
SYSLOG message\n\nmessage is written with a time stamp into the file %s.\nIt may be \
a string with spaces and numbers and some special characters.\n\n",VERSION,LOGFILE);
  exit(1);
}


