; $Header$
		page	,132
		title	KILLMSG - short-circuits bios messages on an HP100/200LX
comment	$

Written by Mack Baggette of Times2 Tech
  Web address: www.times2tech.com
Email address: mack@times2tech.com

This program short-circuits the BIOS messages such as battery low and also
charging related messages.  It also allows you to turn the palmtop off/on
during the charging cycle.

$

dos_int	equ	21h
disp_mess	equ	9

.MODEL	tiny
cseg		segment
		assume	cs:cseg, ds:cseg, es:nothing
		org	100h
; Resident portion of device driver

init:		jmp	exe_start

HardwI	dd	0
SleepI	dd	0

ONChk		db	0
ONSeq		db	0
InMsg		dw	0
LowChk	dw	0c07h

BatLow	db	0ffh
BckLow	db	0ffh
CardLow	db	0ffh
BatErr	db	0ffh
VeryLow	db	0ffh
ChgMsg	db	0


; This routine is a custom off/on routine used while the palmtop is charging
CheckON	proc	near
		pushf
		push	ax
		push	es
		mov	ax,40h
		mov	es,ax
		cli
		; Test to make sure the charging mode is on
		test	byte ptr es:[0d4h],10h
		jz	CheckON_s1
		; See if the ON key is being pressed
		cmp	byte ptr es:[0dfh],01h
		jnz	CheckON_3
		mov	cs:ONChk,1
		; See if an ON key combination such as ON - is being pressed
		test	byte ptr es:[0fah],01h
		jz	CheckON_s1
		mov	cs:ONSeq,1
		jmp	CheckON_s1
		; If the ON key has been released and no ON key combinations
		; have been pressed then we have a true OFF situation
CheckON_3:	cmp	cs:ONChk,0
		jz	CheckON_s1
		mov	cs:ONChk,0
		cmp	cs:ONSeq,0
		jz	CheckON_4
		mov	cs:ONSeq,0
		jmp	CheckON_s1
		; Stop charging and call the Deep Sleep routine
CheckON_4:	and	byte ptr es:[0d4h],0f7h
		mov	ax,4200h
		int	15h
		cli
		; Start charging again
		mov	byte ptr es:[0d4h],0b8h
CheckON_s1:	sti
		pop	es
		pop	ax
		popf
		retn
CheckON	endp

; This routine does the actual charging messages short-circuiting
KillMsg	proc	near
		pushf
		push	ax
		push	es
		cli
		cmp	cs:ChgMsg,1
		jnz	KillM_end
		mov	ax,40h
		mov	es,ax

		; See if we are processing Timer 1
		cmp	byte ptr es:[0f6h],4
		jnz	KillM_end
		; Turn message beeps on
		mov	byte ptr es:[98h],0
		; See if any of the allowed Battery message conditions exist
		mov	ax,cs:LowChk
		test	word ptr es:[0d4h],ax
		jnz	KillM_end

		; Turn message beeps off
		mov	byte ptr es:[98h],0ffh
		; Check for a message being present on the screen
		test	byte ptr es:[0cdh],02h
		jz	KillM_1
		; Create an ESC key toggle to short-circuit the message
		inc	cs:InMsg
		test	cs:InMsg,01h
		jz	KillM_end
		xor	byte ptr es:[0dfh],20h
		jmp	KillM_end
KillM_1:	cmp	cs:InMsg,0
		jz	KillM_end
		mov	cs:InMsg,0
		mov	byte ptr es:[0dfh],00h

KillM_end:	sti
		pop	es
		pop	ax
		popf
		retn
KillMsg	endp

; This hardware interrupt allows us to short-circuit the charging related
; messages as well as kill the beginning beep.
Hardw		proc	far
		call	KillMsg
		pushf
		call	dword ptr cs:HardwI
		call	CheckON
		iret
Hardw		endp


; This software interrupt allows us to kill the battery related messages
Sleep		proc far
		pushf
Sleep_s1:	cmp	cs:BatLow,ah
		jz	Sleep_ret
		cmp	cs:BckLow,ah
		jz	Sleep_ret
		cmp	cs:CardLow,ah
		jz	Sleep_ret
		cmp	cs:BatErr,ah
		jz	Sleep_ret
		cmp	cs:VeryLow,ah
		jz	Sleep_ret
		jmp	Sleep_end
Sleep_ret:	mov	al,01h
		popf
		iret
Sleep_end:	popf
		jmp	[cs:SleepI]
Sleep		endp

; end of resident portion of driver


start:
EnvSeg	dw	?

exe_start: 	
		push	ds
		push	si
		mov	si,81h
scan:		mov	cx,80			;80 characters in line
scan_l1:	call	scan_for		;scan for next character.
 		or	ah,ah			;see if found
		jne	cont1			;not found, skip remainder
		cmp	al,'/'
		jne	cont1
		lodsb
		and	al,5fh

		cmp	al,'B'
		jne	scan_s1
		mov	BatLow,06h
		and	LowChk,0c06h
		jmp	scan_end

scan_s1:	cmp	al,'U'
		jne	scan_s2
		mov	BckLow,07h
		and	LowChk,0c05h
		jmp	scan_end

scan_s2:	cmp	al,'C'
		jne	scan_s3
		mov	CardLow,08h
		and	LowChk,0c03h
		jmp	scan_end

scan_s3:	cmp	al,'E'
		jne	scan_s4
		mov	BatErr,09h
		and	LowChk,0407h
		jmp	scan_end

scan_s4:	cmp	al,'V'
		jne	scan_s5
		mov	VeryLow,0ah
		and	LowChk,0807h
		jmp	scan_end

scan_s5:	cmp	al,'M'
		jne	scan_end
		mov	ChgMsg,1
scan_end:	loop	scan_l1

cont1:	pop	si
		pop	ds
		push	cs
		pop	ds
		mov	ax,word ptr es:[002ch]
		mov	EnvSeg,ax

		lea	dx,inst_mess
		mov	ah,disp_mess		;pump out the message in dx
		int	dos_int

		assume ds:cseg

		mov	ax,350ah
		int	dos_int
		mov	word ptr HardwI,bx
		mov	word ptr HardwI+2,es
		mov	dx,Hardw
		mov	ax,250ah
		int	dos_int

		mov	ax,3506h
		int	dos_int
		mov	word ptr SleepI,bx
		mov	word ptr SleepI+2,es
		mov	ax,2506h
		mov	dx,Sleep
		int	dos_int

exit:		push	cs
		pop	ds
		mov	es,word ptr EnvSeg
		mov	ah,49h
		int	dos_int
		mov	ax,start
		mov	cl,04h
		shr	ax,cl
		inc	ax
		mov	dx,ax
		mov	ax,3100h
		int	dos_int

; Find the next available switch setting in the command line
scan_for	proc	near
		xor	ah,ah			;clear found flag
scan_loop1:	lodsb				;get character
		cmp	al,20h     		;check for space
		ja	scan_sk2
		jb	scan_sk1
		loop	scan_loop1
scan_sk1:	inc	ah			;valid char not found
scan_sk2:	ret
scan_for	endp

inst_mess	db	0dh, 0ah, "BIOS Messages Killer", 0dh, 0ah,
			"Version 1.0d", 0dh, 0ah, 
			"Written by Mack Baggette", 0dh, 0ah,
			0dh, 0ah, "$"

cseg		ends
		end	init
