/*
  Revision 1.0    written by steve grotheer 03-12-96

  Revision 1.1    03-14-99 - Updated to add forward slash path option in
                  addition to back slash to support unix and kermit
                  applciations.

	bldzcmd will create a batch file called zcmd.bat that has the
	following format:

	command file|path more_command file|path .....

  Its purpose is to disect a full path into its path and filename parts and
  then place them into a batch file with various options so they can be used
  with other commands.  It was written because DOS did not have any good
  string parsing algorythms.

	Usage:
    bldzcmd full_file_name [command] | [-[qpf][snba]]  ....

      full_file_name - will be split into path and filename parts

      -q        will use the UNIX forward slash path convention
                (last / in path is not included)
      -p        will use the DOS backslash convention
                (last / in path is not included)
      -f        will generate the filename part
                Each of the above options can have up to 4 modifiers
                  b will place a space before the item and no space after
                  a will palce a space after the item and no space before
                  s will place a space before and after the item
                  n will not put any space before or after the item

      command   this is any string and will be placed in the batch file as
                is.

		i.e. bldzcmd a:\tmp\test.doc zip -ns /p /[ -pn ]
		will create zcmd.bat with following format
      zip test.doc /p /[a:\tmp]

*/

#define MAXNAME 80

char main(argc,argv)
	int  argc;
	char *argv[];
{
	int i, len, mark;
  char file[MAXNAME], name[MAXNAME], path[MAXNAME], forpath[MAXNAME];
	unsigned outfile;
	char *s, *t;
  int flag;

	if (argc<4) { 										/* check initial arguments */
		printf("Too few command line arguments\n");
		usage();
		exit(1);
	}
/* get either path or filename to use */
  strcpy(file,argv[1]);             /* get file and path info */
	len = strlen(file); 							/* get length of file argument */
	i=len;
  flag=0;
	while ( i > 0 && file[i-1] !='\\') { /* look for last backslash */
			i--;
	}
  mark=i;                           /* mark start of file name in string */
  if (i != 0) {                     /* path included in file */
    for (i=0;i<mark-1;i++) {
      path[i]=file[i];
    }
    path[i]='\0';                   /* close string w/ null */

    strcpy(forpath,path);           /* copy to convert to forward slashes */
    for (i=0;i<mark;i++) {          /* replace backslashes with for slash */
      if (forpath[i] == '\\') forpath[i]='/';
    }
  }
  else {
    path[0]='\0'; }                 /* no path in command */

  for (i=0;mark<len;i++) {          /* get filename portion */
		name[i]=file[mark];
		mark++;
	}
	name[i]='\0';                     /* close the string w/ null */

/* create and open the zcmd file */
	if ((outfile=creat("zcmd.bat")) == -1) {
		printf("Cannot open zcmd.bat for write.\n");
		exit(1);
	}

	argc--; argv++; 									/* next argument */

  flag=1;                           /* skip space before command */
  while (--argc > 0) {
		if ( (*++argv)[0] == '-' ) {    /* start command line option */
			/* get all command line args of form -xy */
      flag=1;                       /* skip space before command */
      s = argv[0]+1;
			t = argv[0]+2;
			switch (*s) {
				case 'p' :                  /* use file path only */
					switch (*t) {
            case 's' :                /* space before and after name */
              fprintf(outfile," %s ",path); break;
            case 'b' :                /* space before name */
              fprintf(outfile," %s",path);  break;
            case 'a' :                /* space after name */
              fprintf(outfile,"%s ",path);  break;
            case 'n' :                /* no space before or after name */
              fprintf(outfile,"%s",path);   break;
						default:
              printf("Illegal command line option use -ps|-pn|-pb|-pa\n");
							usage(); fclose(outfile); exit(1);
					}
					break;
        case 'u' :                  /* use UNIX type file path only */
					switch (*t) {
            case 's' :                /* space before and after name */
              fprintf(outfile," %s ",forpath); break;
            case 'b' :                /* space before name */
              fprintf(outfile," %s",forpath);  break;
            case 'a' :                /* space after name */
              fprintf(outfile,"%s ",forpath);  break;
            case 'n' :                /* no space before or after name */
              fprintf(outfile,"%s",forpath);   break;
						default:
              printf("Illegal command line option use -us|-un|-ub|-ua\n");
							usage(); fclose(outfile); exit(1);
					}
          break;
        case 'f' :                /* use filename */
					switch (*t) {
						case 's' :
              fprintf(outfile," %s ",name); break;
            case 'b' :
              fprintf(outfile," %s",name); break;
            case 'a' :
              fprintf(outfile,"%s ",name); break;
            case 'n' :
              fprintf(outfile,"%s",name);   break;
						default:
              printf("Illegal command line option use -fs|-fn|-fb|-fa\n");
							usage(); fclose(outfile); exit(1);
					}
					break;
				default:
          /* assume that other '-' options are part of command */
          fprintf(outfile," %s",argv[0]);
          flag=0;                   /* use space next time */
      }
		}
		else {													/* commands should be copied direct */
      if (!flag) {
				fprintf(outfile," ");       /* put space before next command */
      }
      fprintf(outfile,"%s",argv[0]);
      flag=0;                       /* use space next time */
    }
	}
	fclose(outfile);
}

usage()
{
  printf("Usage: bldzcmd filename command -[f|p|q][n|s|b|a] ...\n");
}

