'/* XSEG.BAS Extract a file segment from a binary file */
'/*          By: Dale Thorn                            */
'/*          Rev. 02.03.2001                           */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'

ccmd = rtrim$(command$)                    'get the DOS command-line parameters
if ccmd = "" then                              'a command line was NOT supplied
   i = ifn.msgs("Usage:  XSEG  filename  begin  length", 5, 24, 79, 0, 1)
end if                              'display the usage message [above] and exit

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") then
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)          'invalid filename
end if                              'display the error message [above] and exit

if iprm < 0 or iprm > 1 then              'no. of parameters must be one or two
   i = ifn.msgs("Invalid number of parameters", 5, 24, 79, 1, 1)
elseif iprm = 0 then                       'user did NOT enter a segment length
   iprm = 1                                 'increment the number of parameters
   lsegbeg = pdqvall&(cprm(0))              'begin byte to extract file segment
   lseglen = 2147483647& - (lsegbeg - 1)     'default segment length to maximum
   cprm(iprm) = ltrim$(str$(lseglen))       'save segment len.into params array
else                                   'user entered both segment begin and len.
   lsegbeg = pdqvall&(cprm(0))        'posn. from which to extract file segment
   lseglen = pdqvall&(cprm(1))      'get length of file segment to be extracted
end if                              'display the error message [above] and exit

if lsegbeg < 1 then                      'begin byte parameter must be non-zero
   i = ifn.msgs("Invalid begin byte parameter", 5, 24, 79, 1, 1)
end if                              'display the error message [above] and exit
if lseglen < 1 then                  'segment length parameter must be non-zero
   i = ifn.msgs("Invalid segment length parameter", 5, 24, 79, 1, 1)
end if                              'display the error message [above] and exit

i = ifn.open(1, cfil, "B", llof)           'open the source file in binary mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)             'beep and exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)            'beep and exit
end if

if (lsegbeg - 1) + lseglen > llof then    'specified segment extends beyond EOF
   lseglen = llof - (lsegbeg - 1)        'default the segment length to maximum
end if
lsegend = (lsegbeg - 1) + lseglen    'last segment byte position in source file

if cext = "out" then                       'source filename extension is ".out"
   cdst = cnam + ".tmp"                          'set dest. extension to ".tmp"
else                                   'source filename extension is NOT ".out"
   cdst = cnam + ".out"                          'set dest. extension to ".out"
end if
i = ifn.kill(2, cdst)                      'kill any previous matching filename
open cdst for binary as 2                  'open the output file in binary mode

ibuflen = 8192                       'initialize the file segment buffer length
if ibuflen > lseglen then            'buffer length is g.t. file segment length
   ibuflen = lseglen                'reset buffer length to file segment length
end if
cbuf = space$(ibuflen)            'initialize the read/write binary file buffer
ldst = 1                               'initialize the destination file pointer
for lptr = lsegbeg to lsegend step ibuflen    'process file in ibuflen segments
   lspn = lptr + ibuflen - lsegend - 1       'buffer overlap at end of segment?
   if lspn > 0 then                          'buffer overlap at end of segment!
      cbuf = ""                         'deallocate the original process buffer
      cbuf = space$(ibuflen - lspn)     'reallocate the original process buffer
   end if
   get 1, lptr, cbuf                 'get next segment portion from source file
   put 2, ldst, cbuf              'put next segment portion to destination file
   ldst = ldst + ibuflen                'increment the destination file pointer
next

i = ifn.msgs("File segment extracted to: " + cdst, 5, 24, 79, 0, 1)'msg. & exit
close                                 'close all files in case not closed above
system                                       'exit to DOS in case no exit above
