'/* XDUP.BAS Extract duplicate lines from a sorted text file */
'/*          By: Dale Thorn                                  */
'/*          Rev. 07.01.2000                                 */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'scrnparm.bas'

ccmd = ucase$(rtrim$(command$))         'get the user's command-line parameters
if ccmd = "" then                              'a command line was NOT supplied
   i = ifn.msgs("Usage:  XDUP  filename  offset  comparelen", _
                iofs, irow, icol, 0, 1)
end if                              'display the usage message [above] and exit

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse the command-line params
if iprm < 0 or iprm > 1 then            'no. of parameters should be one or two
   i = ifn.msgs("Invalid number of parameters", iofs, irow, icol, 1, 1)
end if                      'display no.-of-parameters message [above] and exit
if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") then
   i = ifn.msgs("Invalid filename", iofs, irow, icol, 1, 1)   'invalid filename
end if                       'display invalid-filename message [above] and exit

ioffset = pdqvali(cprm(0)) + 1                     'get the text-compare offset
if ioffset < 1 then                              'text-compare offset NOT valid
   i = ifn.msgs("Invalid compare offset", iofs, irow, icol, 1, 1)
end if                         'display compare-offset message [above] and exit
if iprm = 1 then                           'a text-compare length was specified
   icmplen = pdqvali(cprm(1))                      'get the text-compare length
   if icmplen < 1 then                           'text-compare length NOT valid
      i = ifn.msgs("Invalid comparelen", iofs, irow, icol, 1, 1)
   end if                      'display compare-length message [above] and exit
else                                   'a text-compare length was NOT specified
   icmplen = 999                        'default the text-compare length to 999
end if

i = ifn.open(1, cfil, "S", llof)       'open the source file in sequential mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", iofs, irow, icol, 1, 1)      'beep and exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", iofs, irow, icol, 1, 1)     'beep and exit
end if

if cext = "out" then                            'source file extension == "OUT"
   cdst = cnam + ".tmp"                       'set dest.file extension to "TMP"
else                                            'source file extension != "OUT"
   cdst = cnam + ".out"                       'set dest.file extension to "OUT"
end if

i = ifn.msgs("Please standby", iofs, irow, icol, 0, 0)        'OK to proceed...

open cdst for output as 2                   'open the destination (output) file

init = 0                                           'initialize the compare flag
isep = 0                                          'init.the separator line flag
csav = ""                                         'initialize dupl.compare line
cdup = ""                                          'initialize the compare line
while not eof(1)                               'loop until destination file EOF
   line input #1, clin                         'get a line from the source file
   ctst = ucase$(mid$(clin, ioffset, icmplen))   'get uppercased target segment
   if ctst = cdup then                       'current line == the previous line
      if not init then                         'a duplicate line was NOT output
         if not isep then                      'separator line flag NOT yet set
            isep = not 0                      'just set the separator line flag
         else                                 'separator line flag has been set
            print #2, string$(len(csav), "-")  'print duplicates separator line
         end if
         print #2, csav                        'output the first duplicate line
         init = not 0                                  'set the compare flag ON
      end if
      print #2, clin                         'output the current duplicate line
   else                                      'current line != the previous line
      csav = clin                               'save line from the source file
      cdup = ctst                                'save the first duplicate line
      init = 0                                        'set the compare flag OFF
   end if
wend

close                            'close all files prior to calling BROW program
shell "brow " + cdst                      'browse the destination (output) file

close                                 'close all files in case not closed above
system                                      'return control to operating system
