'/* WTOT.BAS  Display the total no. of words in a text file */
'/*           By: Dale Thorn                                */
'/*           Rev. 11.05.2000                               */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'scrnparm.bas'
'$include: 'string.bas'

ccmd = ucase$(rtrim$(command$))         'get the user's command-line parameters
if ccmd = "" then                              'a command line was NOT supplied
   i = ifn.msgs("Usage:  WTOT  filename", iofs, irow, icol, 0, 1)
end if                              'display the usage message [above] and exit

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") _
or iprm >= 0 then                    'invalid filename or additional parameters
   i = ifn.msgs("Invalid filename", iofs, irow, icol, 1, 1)
end if                       'display invalid-filename message [above] and exit

i = ifn.open(1, cfil, "B", llof)           'open the source file in binary mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", iofs, irow, icol, 1, 1)      'beep and exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", iofs, irow, icol, 1, 1)     'beep and exit
end if

i = ifn.msgs("Please standby", iofs, irow, icol, 0, 0)         'standby message
ltot = 0                          'initialize the total words found in the file
close 1                                   'close the binary-access file channel
open cfil for input as 1                                  'open the source file
do while not eof(1)                            'loop thru the source-file lines
   iwrd = 0                           'initialize valid-word flag at line-begin
   line input #1, clin                        'read a line from the source file
   for ipos = 1 to len(clin)              'loop thru the characters in the line
      if midchar(clin, ipos) <> 32 then         'current character is a non-' '
         if not iwrd then                 'the valid-word flag is currently OFF
            iwrd = not 0                           'turn the valid-word flag ON
            ltot = ltot + 1                    'increment the total words found
         end if
      else                                          'current character is a ' '
         iwrd = 0                                 'turn the valid-word flag OFF
      end if
   next
loop

i = ifn.msgs("Total words in " + cfil + ": " + ltrim$(str$(ltot)), _
iofs, irow, icol, 0, 1)
close                                 'close all files in case not closed above
system                                              'return to operating system
