'/* WRAP.BAS Wrap text in source file to [wrapsize] columns */
'/*               By: Dale Thorn                            */
'/*               Rev. 23.02.2001                           */

'NOTE: Originally created using MS-Basic 3.0, with no "binary" file
'      processing capability, hence the buffer "segment" processing.

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'

declare function ifn.procbuff(cbuf, clin, ilen, iptr, iseglen, itab, iwrp)

'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'

ccmd = rtrim$(command$)                     'get user's command-line parameters
if ccmd = "" then                            'user did NOT enter any parameters
   i = ifn.msgs("Usage:  WRAP  filename  [wrapsize]", 5, 24, 79, 0, 1)
end if                                  'display usage message and exit [above]

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") then
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)  'invalid filename message
end if                              'display the error message [above] and exit
if iprm > 0 then                      'parameter count must be <= one parameter
   i = ifn.msgs("Invalid number of parameters", 5, 24, 79, 1, 1)
end if                              'display the error message [above] and exit

if iprm = 0 then                         'user entered maximum text-wrap length
   iwrp = pdqvali(cprm(0))               'get the user-entered text-wrap length
   if iwrp = 0 then                   'user entered an invalid text-wrap length
      iwrp = 80                      'default the maximum text-wrap line length
   elseif iwrp < 40 then              'user entered an invalid text-wrap length
      iwrp = 40                      'default the minimum text-wrap line length
   end if
else                               'user did NOT enter maximum text-wrap length
   iwrp = 80                         'default the maximum text-wrap line length
end if

i = ifn.open(1, cfil, "B", llof)               'open source file as binary/text
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)      'error: beep and exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)     'error: beep and exit
end if
if cext = "out" then                            'user's file extension is 'out'
   cout = cnam + ".tmp"                     'set output file extension to 'tmp'
else                                        'user's file extension is NOT 'out'
   cout = cnam + ".out"                     'set output file extension to 'out'
end if

i = ifn.msgs("Processing: " + cfil, 5, 24, 79, 0, 0) 'OK to continue processing

ibuflen = 8000                          'set standard file-access buffer length
iseglen = 4000                         'buffer segment length (overlap process)
itab = 8                              'equivalent number of spaces per hard tab

cbuf = space$(ibuflen)                        'allocate the text process buffer
crcd = space$(ibuflen)                          'allocate main text file buffer
clin = space$(320)                                'output file text line buffer

ibuf = llof \ ibuflen                          'no. of whole buffers to process
imod = llof mod ibuflen                        'no. of bytes in leftover buffer
imax = ibuf + abs(imod > 0)                 'total buffers incl.leftover buffer
open cout for output as 2                     'open destination file for output
ircd = 0                                      'current "record" being processed
while ircd <= imax                           'loop until current "record" > EOF
   if ircd = 0 then                       'this is the beginning of the process
      ircd = 1                            'set current "record" to first record
      get 1, clng(1), crcd                'load first "record" into file buffer
      lset cbuf = crcd                    'copy file buffer into process buffer
      iptr = 0                           'initialize the process buffer pointer
      if llof < ibuflen then              'source file smaller than file buffer
         ilen = llof                      'set process length to length of file
      else                                'source file >= length of file buffer
         ilen = ibuflen                    'set process length to buffer length
      end if
   end if        'process the buffer [below] and write lines to the output file
   i = ifn.procbuff(cbuf, clin, ilen, iptr, iseglen, itab, iwrp)
   if ircd < imax then                        'current "record" number is < EOF
      get 1, clng(ircd) * ibuflen + 1, crcd 'get next "record" from source file
      mid$(cbuf, iseglen + 1) = crcd        'put next "record" into file buffer
   end if
   if ircd + 1 = imax then                     'next "record" is final "record"
      if imod >= iseglen then               'leftover bytes fill buffer segment
         ilen = ilen + iseglen            'add segment length to process length
         imod = imod - iseglen               'subtract segment length from imod
      else                                 'leftover bytes are < buffer segment
         ilen = ilen + imod              'add leftover length to process length
         imod = 0                        'leftover bytes complete - set to zero
      end if
   else                                       'next "record" NOT final "record"
      if ircd + 1 < imax then                'next "record" is < final "record"
         ilen = ilen + iseglen            'add segment length to process length
      end if
   end if
   if ilen > 0 then                         'text still remains to be processed
      i = ifn.procbuff(cbuf, clin, ilen, iptr, iseglen, itab, iwrp)
   end if        'process the buffer [above] and write lines to the output file
   mid$(cbuf, iseglen + 1) = mid$(crcd, iseglen + 1)'"record" segment -> buffer
   ircd = ircd + 1                              'increment the current "record"
   if ircd = imax then                      'current "record" is final "record"
      if imod >= iseglen then              'leftover bytes >= buffer seg.length
         ilen = ilen + iseglen             'add 'iseglen' # bytes to processing
         imod = imod - iseglen             'subtract seglen bytes from leftover
      else                                  'leftover bytes < buffer seg.length
         ilen = ilen + imod                 'add leftover # bytes to processing
         imod = 0                          'no more leftover bytes; set to zero
      end if
   else                                    'current "record" NOT final "record"
      ilen = ilen + iseglen                'add 'iseglen' # bytes to processing
   end if
wend

close                                   'close open files before showing result
shell "brow " + cout                       'browse the text-wrapped output file
close                                 'close all files in case not closed above
system                                  'return control to the operating system

function ifn.procbuff(cbuf, clin, ilen, iptr, iseglen, itab, iwrp)
   while iptr < ilen and iptr < iseglen      'buffer posn.pointer within bounds
      lset clin = ""                          'clear text line buffer to blanks
      iext = 0                                'set the inner-loop exit flag OFF
      ipos1 = 0                             'initialize the saved-bytes pointer
      while iptr < ilen and not iext         'loop while pointer OK and no exit
         iptr = iptr + 1                     'increment the buffer posn.pointer
         ichr = midchar(cbuf, iptr)           'buffer character at current posn.
         select case ichr                      'select on char. at current posn.
            case 10, 13                        'current character is c/r or l/f
               print #2, rtrim$(clin)        'write current line to output file
               lset clin = ""                 'clear text line buffer to blanks
               ipos1 = 0                         'reset the saved-bytes pointer
               if iptr < ilen then                'buffer pointer within bounds
                  ichr = midchar(cbuf, iptr + 1)   'get next character f/buffer
                  if ichr = 10 or ichr = 13 then   'next character also c/r-l/f
                     iptr = iptr + 1             'increment buffer posn.pointer
                  end if
               end if
               if iptr >= iseglen then         'buffer pointer >= segment bound
                  iext = not 0                 'set the inner-loop exit flag ON
               end if
            case 26                          'current character is DOS EOF byte
            case 33 to 255                   'current character is "plain" text
               ipos1 = ipos1 + 1             'increment the saved-bytes pointer
               mid$(clin, ipos1) = char(ichr)  'save curr.char.in output buffer
            case else                       'NOT plain text or end-of-line char.
               if ichr = 9 then              'current character is a "hard" tab
                  if itab > 0 then           'replace tabs with 'itab' # spaces
                     ipos1 = ipos1 + itab    'increment the saved-bytes pointer
                  else                      'replace with blank space if needed
                     if ipos1 > 0 then       'buffer has at least one character
                        if midchar(clin, ipos1) <> 32 then 'curr.char.NOT space
                           ipos1 = ipos1 + 1     'increment saved-bytes pointer
                        end if
                     end if
                  end if
               else                            'current character is < ASCII 32
                  ipos1 = ipos1 + 1          'increment the saved-bytes pointer
               end if
         end select
         if ipos1 > iwrp then                'saved-bytes pointer > wrap length
            for ipos2 = iwrp + 1 to 1 step -1     'loop until blank space found
               if midchar(clin, ipos2) = 32 then   'blank space at current posn.
                  exit for                        'blank space found; exit loop
               end if
            next
            if ipos2 = 0 then              'no blank spaces found in saved text
               ipos2 = iwrp + 1              'set position to trim line at wrap
            end if
            print #2, left$(clin, ipos2 - 1)       'print text up to set length
            lset clin = mid$(clin, ipos2)       'left-justify remainder of text
            ipos1 = ipos1 - ipos2 + 1            'adjust pointer to end of text
            if midchar(clin, 1) = 32 then        'new line begins w/blank space
               if midchar(clin, 2) <> 32 then    '2nd char.in line is NOT blank
                  lset clin = mid$(clin, 2)    'left-justify from 2nd character
                  ipos1 = ipos1 - 1              'adjust pointer to end of text
               end if
            end if
         end if
      wend
      if ipos1 > 0 then                       'some text remaining on last line
         print #2, rtrim$(clin)              'print text remaining on last line
      end if
   wend
   mid$(cbuf, 1) = mid$(cbuf, iseglen + 1)    'move 2nd buffer segment to front
   iptr = iptr - iseglen                   'reset buffer pointer to 1st segment
   ilen = ilen - iseglen              'reset saved-bytes pointer to 1st segment
end function
