'/* MASC.BAS Create a text output file from a binary source file */
'/*          By: Dale Thorn                                      */
'/*          Rev. 01.11.2001                                     */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'

cls                                                'clear the DOS window screen
ccmd = ucase$(rtrim$(command$))             'get user's command-line parameters
if ccmd = "" then                            'user did NOT enter a command line
   cmsg = "Usage:  MASC  filename    "            'set the initial message text
   ctmp = space$(4)                                 'set the left margin spaces
   locate 5, 1, 1                                   'locate cursor for messages
   print ctmp; cmsg                                 'display first user message
   mid$(cmsg, 1) = space$(6)                      'blank 'Usage:' in msg.string
   mid$(cmsg, len(cmsg) - 2) = "/N"                'insert '/N' into msg.string
   print                                           'blank line between messages
   print ctmp; cmsg                                'display second user message
   mid$(cmsg, len(cmsg) - 2) = "/X"                'insert '/X' into msg.string
   print                                           'blank line between messages
   print ctmp; cmsg                                 'display third user message
   print                                           'blank line between messages
   print                                           'blank line between messages
   print ctmp; "If '/N' specified, do not allow blank spaces in output file"
   print                                           'blank line between messages
   print ctmp; "If '/X' specified, allow extended ASCII data in output file"
   close                                                  'close all open files
   system                                           'return to operating system
end if

ipos1 = instr(ccmd, "/N")            'check selection to NOT allow blank spaces
if ipos1 then                          'user selected to NOT allow blank spaces
   ccmd = rtrim$(left$(ccmd, ipos1 - 1) + mid$(ccmd, ipos1 + 2))   'remove '/N'
   ispaces = 0                        'set the blank-spaces-allowed flag to OFF
else                                  'user selected to allow some blank spaces
   ispaces = not 0                     'set the blank-spaces-allowed flag to ON
end if
ipos1 = instr(ccmd, "/X")              'check selection to allow extended ASCII
if ipos1 then                            'user selected to allow extended ASCII
   ccmd = rtrim$(left$(ccmd, ipos1 - 1) + mid$(ccmd, ipos1 + 2))   'remove '/X'
   iasciix = not 0                   'set the extended ASCII characters flag ON
else                                 'user selected to NOT allow extended ASCII
   iasciix = 0                      'set the extended ASCII characters flag OFF
end if

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") _
or iprm >= 0 then        'user gave an invalid filename or supplied a parameter
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)
end if                       'display invalid-filename message [above] and exit

i = ifn.open(1, cfil, "B", llof)           'open the source file in binary mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)             'beep and exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)            'beep and exit
end if

if cext = "out" then                           'source file extension is '.OUT'
   cout = cnam + ".tmp"                     'set dest.-file extension to '.TMP'
else                                       'source file extension is NOT '.OUT'
   cout = cnam + ".out"                     'set dest.-file extension to '.OUT'
end if

i = ifn.msgs("Please standby", 5, 24, 79, 0, 0)        'hide cursor and proceed

i = ifn.kill(1, cout)                       'kill any existing destination file
i = ifn.open(1, cfil, "B", llof)           'open the source file in binary mode
open cout for binary as 2                   'open the dest. file in binary mode

ibuf = (fre("") - 4096) \ 2                    'initialize the copy-buffer size
if ibuf > llof then                             'buffer length is > file length
   ibuf = llof                                 'set buffer length = file length
end if
imod = llof mod ibuf                  'bytes left over after full-buffer copies
csrc = space$(ibuf)                      'allocate the source/dest. copy buffer

ldst = 1                             'initialize the destination write position
ispc = not 0                          'initialize the last-byte-is-a-space flag
for lsrc = 1 to llof step ibuf        'loop thru the number of buffer "records"
   if lsrc + ibuf - 1 > llof then     'the final source "record" spans past EOF
      csrc = ""                        'deallocate the source/dest. copy buffer
      csrc = space$(imod)              'reallocate the source/dest. copy buffer
   end if
   get 1, lsrc, csrc                 'load the copy buffer from the source file
   ipos2 = 0                           'initialize last character posn. written
   for ipos1 = 1 to len(csrc)          'loop thru source file buffer characters
      ichr = midchar(csrc, ipos1)         'current source file buffer character
      if ichr <= 32 then                  'current char. is space or equivalent
         if ispaces and (not ispc) then     'spaces allowed & curr.char. != ' '
            ipos2 = ipos2 + 1               'increment last char. posn. written
            mid$(csrc, ipos2) = char(32)   'put space character to dest. buffer
            ispc = not 0                      'set last-byte-is-a-space flag ON
         end if
      elseif ichr >= 123 then              'current character is extended ASCII
         if iasciix then                     'extended ASCII characters allowed
            ipos2 = ipos2 + 1               'increment last char. posn. written
            mid$(csrc, ipos2) = char(ichr) 'put 8-bit character to dest. buffer
            ispc = 0                         'set last-byte-is-a-space flag OFF
         end if
      else                                  'current character is standard text
         ipos2 = ipos2 + 1                  'increment last char. posn. written
         mid$(csrc, ipos2) = char(ichr)     'put text character to dest. buffer
         ispc = 0                            'set last-byte-is-a-space flag OFF
      end if
   next
   if ipos2 then                            'valid character(s) found in source
      cdst = ""                              'deallocate the destination buffer
      cdst = left$(csrc, ipos2)              'reallocate the destination buffer
      put 2, ldst, cdst                     'write copy buffer to the dest.file
      ldst = ldst + ipos2                   'increment to next dest. write posn.
      if midchar(cdst, ipos2) = 32 then      'last char.in dest.buffer is space
         ispc = not 0                         'set last-byte-is-a-space flag ON
      else                                  'last char.in dest.buffer NOT space
         ispc = 0                            'set last-byte-is-a-space flag OFF
      end if
   end if
next

close                                 'close files prior to viewing output file
shell "view " + cout                    'perform binary view on the output file
close                                 'close all files in case not closed above
system                                  'return control to the operating system
