'/* LSORT.H  23.03.1994 */


type ncnf                                          'sort-options pass structure
   dptr as integer                         'internal data output record pointer
   dtot as integer                         'internal data output record counter
   gptr as integer               'sort group record pointer/sort buffer pointer
   gtot as integer                                    'internal sort group size
   init as integer            'internal sort operation data initialization flag
   mndx as integer                                    'internal index-load flag
   ndno as integer               'file channel/unit number for sort index files
   nlen as integer                             'internal index file record size
   ntot as integer                    'internal index file group record counter
   offs as long                        'internal group-to-record offset counter
   oper as integer                                    'sort operation (0 to -3)
   rcnt as integer           'internal sort data record counter (group records)
   rmax as integer                            'internal maximum sort group size
   rptr as long                'internal sort data record counter (all records)
   rtot as long                  'internal sort data record total (final count)
   sdno as integer          'file channel/unit number for sort data file (.sdx)
   slen as integer                       'length of sort data buffer [cnc.sdat]
   sseq as integer          'internal sort sequence (ascending/descending) flag
   stot as integer      'internal partial group data record total (final count)
end type

declare function psort(nc as ncnf, cnc.data, cnc.indx, cnc.lng,_
cnc.nbuf, cnc.sdat, insbeg(), inslen(), insseq(), lnsptr())
declare function ips.fill(nc as ncnf, cnc.data, cnc.indx,_
cnc.lng, cnc.sdat, insbeg(), inslen(), insseq())
declare function ips.rget(ifno, ilen, lrcd, cbuf)
declare function ips.rput(ifno, ilen, ircd, cbuf)
declare function ips.ssav(nc as ncnf, cnc.data,_
cnc.indx, insbeg(), inslen(), insseq())
declare function lps.free(iexc, lmax)
