'/* LONGNAME.BAS Parse long (Win95) filename to DOS filename */
'/*              By: Dale Thorn                              */
'/*              Rev. 13.07.1998                             */

function ifn.longname(cfnm, cnam, cext) 'translate Win95 filename to DOS format
   iwin = 0                              'initialize Win95 (long) filename flag
   while cfnm <> "" and instr(". ", left$(cfnm, 1)) 'kill leading '.'s and ' 's
      cfnm = mid$(cfnm, 2)             'remove leading '.' or ' ' from filename
      iwin = not 0                           'set Win95 (long) filename flag ON
   wend
   while cfnm <> "" and instr(". ", right$(cfnm, 1)) 'kill trailing '.'s & ' 's
      cfnm = left$(cfnm, len(cfnm) - 1)  'remove trailing '.' or ' ' f/filename
   wend
   do                                        'loop to remove ' 's from filename
      ipos = instr(cfnm, " ")                 'blank space position in filename
      if ipos then                           'blank space was found in filename
         cfnm = left$(cfnm, ipos - 1) + mid$(cfnm, ipos + 1) 'remove ' ' f/name
         iwin = not 0                        'set Win95 (long) filename flag ON
      end if
   loop while ipos                   'loop until no more ' 's found in filename
   for ipos = len(cfnm) to 1 step -1    'loop to get ('.') position in filename
      if mid$(cfnm, ipos, 1) = "." then   'extension ('.') position in filename
         exit for                    'extension ('.') position found; exit loop
      end if
   next
   if ipos = 0 then                      'extension ('.') NOT found in filename
      ipos = len(cfnm) + 1                 'set '.' position to end of filename
   end if
   cnam = left$(cfnm, ipos - 1)                'get the filename-less-extension
   cext = mid$(cfnm, ipos + 1)                 'get the filename extension only
   ipos = instr(cnam, ".")                     'non-extn. '.' posn. in filename
   if len(cnam) > 8 or len(cext) > 3 or ipos > 0 or cnam <> "" and iwin then
      while ipos                     'loop to remove non-extn. '.'s in filename
         cnam = left$(cnam, ipos - 1) + mid$(cnam, ipos + 1)   'remove the '.'s
         ipos = instr(cnam, ".")               'non-extn. '.' posn. in filename
      wend
      if cnam <> "" then                      'filename-less-extension is valid
         cnam = left$(cnam, 6) + "~1"         'make DOS filename-less-extension
      end if
      if cext <> "" then                         'the filename has an extension
         cext = left$(cext, 3)                  'limit DOS extension to 3 bytes
         cfnm = cnam + "." + cext             'make DOS filename-with-extension
      else                                 'filename does NOT have an extension
         cfnm = cnam                   'set filename to filename-less-extension
      end if
   end if
end function
