'/* GETNAME.BAS Parse long (Win95) filename, formatted/unformatted DOS */
'/*             filename, or DOS filespec, into formatted DOS filename */
'/*             By: Dale Thorn                                         */
'/*             Rev. 28.07.2000                                        */

function ifn.getfname(cfsp, cfnm, cnam, cext)   'get DOS filename from filespec
   cfnm = lcase$(ltrim$(rtrim$(cfsp)))           'trim & lowercase the filename
   if cfnm = "" then                             'invalid (blank) filespec sent
      cnam = ""                                  'clear DOS name-less-extension
      cext = ""                                   'clear DOS filename extension
   else                                          'valid non-blank filespec sent
      if instr(cfnm, "\") = 0 then                 'filespec does NOT have path
         ilen1 = len(cfnm)                       'total trimmed filename length
         ilen2 = len(rtrim$(left$(cfnm, 9)))     'length of name-less-extension
         ilen3 = len(rtrim$(left$(cfnm, 10)))    'length w/1 char. of extension
         if instr(cfnm, ":") or instr(cfnm, "<dir>") then'probable DOS filespec
            cfnm = rtrim$(left$(cfnm, 12))       'trim off data beyond filename
            ilen1 = len(cfnm)                    'total trimmed filename length
         end if
         if ilen1 <= 12 and ilen2 <= 8 and instr(cfnm, ".") = 0 then  'DOS file
            if ilen3 = 10 then                          'filename has extension
               cfnm = left$(cfnm, ilen2) + "." + mid$(cfnm, 10, 3)'parse flname.
            else                                     'filename has NO extension
               cfnm = left$(cfnm, ilen2)              'filename <= 8 characters
            end if
         end if
      end if
      i = ifn.longname(cfnm, cnam, cext)         'change Win95 name to DOS name
      mid$(cfnm, 1) = ucase$(left$(cfnm, 1))    'uppercase 1st char.of filename
   end if
end function
