'/* DIRM9X.BAS Compare two filespecs and copy files from source to dest */
'/*            By: Dale Thorn                                           */
'/*            Rev. 24.09.2001                                          */

'$include: 'basdef.h'
'$include: 'basio.h'
'$include: 'bitops.h'
'$include: 'celledit.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'getdir.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'string.h'

type cpas                               'variables passed to set-color function
   clrno1 as integer                           'color #1 for set-color function
   clrno2 as integer                           'color #2 for set-color function
   clrno3 as integer                           'color #3 for set-color function
   clrno4 as integer                           'color #4 for set-color function
   clrno5 as integer                           'color #5 for set-color function
   clrno6 as integer                           'color #6 for set-color function
   clrno7 as integer                           'color #7 for set-color function
   colbeg as integer                             'begin window column on screen
   coltot as integer                            'total window columns on screen
   datcol as integer                                 'begin data display column
   datlen as integer                                  'data display text length
   ms1max as integer                                  'max. color area messages
   ms2max as integer                                'max. color select messages
   rowbeg as integer                                  'begin data row on screen
   rowend as integer                                  'final data row on screen
   filnam as string * 13                        'filename of system colors file
   sepchr as string * 1                         'source/dest.filespec separator
end type

type dpas                                        'variables passed to functions
   arrmax as integer                                'maximum size of fs() array
   begndx as integer                                 '1st element in fs() array
   begrow as integer                                  'first data row on screen
   clrbar as integer                                    'scroll-bar fg/bg color
   clrbrt as integer                                   'msgs.hilite fg/bg color
   clrdat as integer                                  'data display fg/bg color
   clrftr as integer                                   'footer area fg/bg color
   clrhdr as integer                                   'dir. header fg/bg color
   clrhlt as integer                                   'data hilite fg/bg color
   clrlin as integer                                  'line drawing fg/bg color
   clrstd as integer                                  'DOS standard fg/bg color
   diftim as integer                                 '1_hour/1_minute diff.flag
   dspdif as integer                                 'show-different-files flag
   dspofs as integer                                 'filename displayed offset
   dspsam as integer                                 'show-same-files-only flag
   dstcnt as integer                                 'no. of dest.files in fs()
   dstend as integer                                 'end dest. element in fs()
   dstndx as integer                               'current dest. index in fs()
   excmax as integer                                'no. of filespec exclusions
   fsplen as integer                                'length of a filespec entry
   ptrmax as integer                                 'max.pointer to valid data
   srccnt as integer                                'no.of source files in fs()
   srcend as integer                                'end source element in fs()
   srcndx as integer                              'current source index in fs()
   tagcnt as integer                                'current no.of items marked
   topndx as integer                                 'current (top) display row
   wrnmsg as integer                                  'copy/delete warning flag
   ftrln1 as string * 80                          'scroll-screen footer line #1
   ftrln2 as string * 80                          'scroll-screen footer line #2
   ftrln3 as string * 80                          'scroll-screen footer line #3
   ftrln4 as string * 80                          'scroll-screen footer line #4
   hdrln1 as string * 80                          'scroll-screen header line #1
   hdrln2 as string * 80                          'scroll-screen header line #2
   hdrln3 as string * 80                          'scroll-screen header line #3
   sepchr as string * 1                         'data ("") separator character
end type

type filespec              'structure for source and destination file list data
   s as string * 64        'set length=64 for complete filename directory entry
end type

declare function ifn.scroll(fs() as filespec, dm as dpas, iptr(), _
                            itag(), cexc2(), csrchdr, cdsthdr)
declare function cfn.fmtext(cfsp, cfmt, iofs)
declare function cfn.fmtint(cfsp)
declare function cfn.fmtprt(cfsp, cfmt)
declare function ifn.cltags(dm as dpas, iptr(), itag())
declare function ifn.compfs(cstr1, cstr2, imode, iyear)
declare function ifn.dispfs(fs() as filespec, dm as dpas, _
                            iptr(), itag(), cbuf, cfmt)
declare function ifn.disphf(dm as dpas)
declare function ifn.fsptyp(cfsp)
declare function ifn.getfsp(fs() as filespec, dm as dpas, _
                            cexc1(), cexc2(), cusr, cfsp, chdr)
declare function ifn.packfs(fs() as filespec, dm as dpas, icnt, indx)
declare function ifn.setclr(cp as cpas, dm as dpas, cmsg0(), cmsg1())
declare function ifn.setdir(fs() as filespec, dm as dpas, iptr(), _
                            itag(), cexc1(), cexc2(), cusr, csrchdr)
declare function ifn.setfsp(fs() as filespec, dm as dpas)
declare function ifn.setptr(fs() as filespec, dm as dpas, iptr())
declare function ifn.sortfs(fs() as filespec, indx, itot)
declare function ifn.usrmsg(dm as dpas, cprompt, cdspmsg)
declare function ifn.wrnmsg(dm as dpas, cprompt, cdspmsg, ckeypos, ckeyneg)

dim dm as dpas                           'variables passed to various functions
dm.arrmax = 2048                           'initialize file list array max.size
dim fs(dm.arrmax, 1) as filespec             'source and destination file lists
dim iptr(dm.arrmax)                              'pointers to source/dest.files
dim itag(dm.arrmax)                               'marks (tags) for copy/delete

'$include: 'basdef.bas'
'$include: 'bitops.bas'
'$include: 'celledit.bas'
'$include: 'clrparm.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'getdirw.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'string.bas'

dim cexc1(9), cexc2(9)                         'user's exclusion specifications

call nosnow(0)            'turns off snow suppression when linking with PDQ.LIB
dm.clrstd = iclr                           'initialize standard fg/bg DOS color
dm.clrbrt = dm.clrstd                   'initialize default DOS highlight color
dm.clrbar = (dm.clrstd mod 8) * 16 + dm.clrstd \ 16  'default DOS inverse color
color dm.clrbrt mod 16, dm.clrstd \ 16  'set DOS color for various screen calls
ccmd = ucase$(rtrim$(command$))         'get the user's command-line parameters
if ccmd = "" then                              'a command line was NOT supplied
   cls                                                'clear the display screen
   cmsg = "Usage:  DIRM9X  source  dest  [/Espec]  [/Espec...]    "
   ctmp = space$(4)                        'initialize the messages left margin
   locate 4, 1, 1                         'move display cursor to screen row #5
   print ctmp; cmsg                            'display the first usage message
   ipos1 = len(cmsg) - 2                           'position for '/P' parameter
   mid$(cmsg, ipos1) = "/P"                     'add '/P' spec to usage message
   print ctmp; cmsg                                'display third usage message
   mid$(cmsg, ipos1) = "/S"                     'add '/S' spec to usage message
   print ctmp; cmsg                                'display third usage message
   mid$(cmsg, ipos1) = "/D"                     'add '/D' spec to usage message
   print ctmp; cmsg                               'display fourth usage message
   mid$(cmsg, ipos1) = "/M"                     'add '/M' spec to usage message
   print ctmp; cmsg                                'display fifth usage message
   mid$(cmsg, ipos1) = "/N"                     'add '/N' spec to usage message
   print ctmp; cmsg                                'display sixth usage message
   print                                           'blank line between messages
   print ctmp; "If '/Espec' specified, exclude files matching 'spec'"
   print ctmp; "Up to 10 '/Espec' exclusions may be specified"
   print                                           'blank line between messages
   print ctmp; "If '/P' specified, don't prompt on single file copy/delete"
   print ctmp; "If '/S' specified, show the matching filenames/directories"
   print ctmp; "If '/D' specified, show the differences for all files/dirs"
   print ctmp; "If '/M' specified, show differences between matching files"
   print ctmp; "If '/N' specified, show differences for non-matching files"
   print                                           'blank line between messages
   print ctmp; "NOTE: Alt-F1 toggles '/D', '/M', and '/N' difference modes"
   print ctmp; "      Ctrl-F1 toggles 1-hour and 1-minute difference modes"
   close                              'close all files in case not closed above
   system                                   'return control to operating system
end if

dm.dspdif = 0                      'initialize the show-differences flag to OFF
dm.dspsam = 0                       'initialize the show-same-files flag to OFF
dm.wrnmsg = not 0                   'initialize the warning-messages flag to ON
cmsg = "/S, /D, /M, or /N options cannot be used simultaneously" '/S' error msg.
do                                'loop to process user's command-line switches
   if right$(ccmd, 2) = "/P" then        'no warning on single-file copy/delete
      dm.wrnmsg = 0                          'set the warning-messages flag OFF
   elseif right$(ccmd, 2) = "/S" then   'user said show matching filenames only
      if dm.dspdif then                 'user input /S and /D, /M, or /N switch
         i = ifn.msgs(cmsg, 5, 24, 79, 1, 1)'display the error message and exit
      end if
      dm.dspsam = not 0                        'set the show-same-files flag ON
   elseif right$(ccmd, 2) = "/D" then       'user said to show differences only
      if dm.dspsam or dm.dspdif = 2 or dm.dspdif = 3 then    'too many switches
         i = ifn.msgs(cmsg, 5, 24, 79, 1, 1)'display the error message and exit
      end if
      dm.dspdif = 1                           'set show-all-differences flag ON
   elseif right$(ccmd, 2) = "/M" then      'show differences for matching files
      if dm.dspsam or dm.dspdif = 1 or dm.dspdif = 3 then    'too many switches
         i = ifn.msgs(cmsg, 5, 24, 79, 1, 1)'display the error message and exit
      end if
      dm.dspdif = 2                         'set show-match-differences flag ON
   elseif right$(ccmd, 2) = "/N" then       'differences for non-matching files
      if dm.dspsam or dm.dspdif = 1 or dm.dspdif = 2 then    'too many switches
         i = ifn.msgs(cmsg, 5, 24, 79, 1, 1)'display the error message and exit
      end if
      dm.dspdif = 3                          'set non-match-differences flag ON
   else                                       'end of all command-line switches
      exit do                          'end of command-line switches; exit loop
   end if
   ccmd = rtrim$(left$(ccmd, len(ccmd) - 2))    'remove the command-line switch
loop

ipos1 = instr(ccmd, "/E")                    'check for exclusion specification
dm.excmax = -1                                    'initialize no. of exclusions
while ipos1 > 0                                    'exclusion(s) were specified
   dm.excmax = dm.excmax + 1                       'increment no. of exclusions
   if dm.excmax > 9 then                      'maximum exclusions (10) exceeded
      i = ifn.msgs("Maximum no. of exclusions (10) exceeded.", 5, 24, 79, 1, 1)
   end if                           'display the error message [above] and exit
   ipos2 = istr.lcsp(ipos1 + 2, ccmd, " ") 'get 1st position of exclusion spec.
   ipos3 = istr.lcfn(ipos2, ccmd, " ")     'get end position of exclusion spec.
   ipos4 = istr.lcfn(ipos2, ccmd, "/")     'get end position of exclusion spec.
   if ipos3 > 0 and (ipos3 < ipos4 or ipos4 = 0) then  'blank position is valid
      ipos4 = ipos3                       'set slash position to blank position
   end if                     '...else slash position is the valid end position
   cexc2(dm.excmax) = mid$(ccmd, ipos2, ipos4 - ipos2) 'exclusion specification
   ccmd = rtrim$(left$(ccmd, ipos1 - 1) + mid$(ccmd, ipos4)) 'remove excl.spec.
   ipos1 = instr(ccmd, "/E")                 'check for exclusion specification
wend

ipos1 = instr(ccmd, " ")     'separator between source and destination filespec
if ipos1 = 0 then          'separator NOT found (source or dest. not specified)
   ipos1 = len(ccmd) + 1   'set the separator position to the about-to-be space
   ccmd = ccmd + " " + ccmd  'show the filespec entries as both source and dest
end if
csrcusr = rtrim$(left$(ccmd, ipos1 - 1))        'user-specified source filespec
cdstusr = ltrim$(mid$(ccmd, ipos1 + 1))    'user-specified destination filespec

i = ifn.msgs("Checking source and dest files", 5, 24, 79, 0, 0)'display message

idmfile = freefile                               'get system colors file handle
open "\dirm.clr" for binary as idmfile             'open the system colors file
llof = lof(idmfile)                           'get length of system colors file
cbuf = string$(9, 0)                            'allocate the color-file buffer
if llof = 9 then                                  'system colors file was found
   get idmfile, 1, cbuf                          'load the color specifications
else                                              'system colors file NOT found
   mid$(cbuf, 1) = char(dm.clrbar)                   'default header dirs.color
   mid$(cbuf, 2) = char(dm.clrbar)                   'default footer area color
   mid$(cbuf, 3) = char(dm.clrbar)                    'default scroll-bar color
   mid$(cbuf, 4) = char(dm.clrstd)                  'default data display color
   mid$(cbuf, 5) = char(dm.clrbrt)                   'default data hilite color
   mid$(cbuf, 6) = char(dm.clrbrt)                  'default line drawing color
   put idmfile, 1, cbuf                              'save colors to 'dirm.clr'
end if
dm.clrhdr = midchar(cbuf, 1)                             'set header dirs.color
dm.clrftr = midchar(cbuf, 2)                             'set footer area color
dm.clrbar = midchar(cbuf, 3)                              'set scroll-bar color
dm.clrdat = midchar(cbuf, 4)                            'set data display color
dm.clrhlt = midchar(cbuf, 5)                             'set data hilite color
dm.clrlin = midchar(cbuf, 6)                            'set line drawing color
close idmfile                                     'close the system colors file

shell "mode con > mode.nol"                          'generate screen-mode file
open "mode.nol" for binary as idmfile                'open the screen-mode file
llof = lof(idmfile)                                 'length of screen-mode file
irowcnt = 25                                         'global no. of screen rows
if llof > 0 then                                    'screen-mode file opened OK
   ctmp = space$(llof)                             'allocate screen-mode buffer
   get idmfile, 1, ctmp                           'load file contents to buffer
   ipos1 = instr(ucase$(ctmp), "LINES")           'position of #lines specifier
   ipos2 = instr(ipos1 + 5, ctmp, ":")            '":" position following ipos1
   ipos3 = instr(ipos1 + 5, ctmp, "=")            '"=" position following ipos1
   if ipos2 < ipos3 then                          '"=" found screen-mode buffer
      ipos2 = ipos3                               'set position to "=" position
   end if
   if ipos1 > 0 and ipos2 > 0 then                'no. of lines specifier found
      irowcnt = pdqvali(mid$(ctmp, ipos2 + 1))   'get the available no. of rows
      if irowcnt < 25 then                     'available no. of rows NOT valid
         irowcnt = 25                        'reset no.of rows to default count
      elseif irowcnt > 50 then                 'available no. of rows NOT valid
         irowcnt = 50                        'reset no.of rows to default count
      end if
   end if
   ctmp = ""                                 'deallocate the screen-mode buffer
end if
i = ifn.kill(idmfile, "mode.nol")          'close and kill the screen-mode file

dm.srcndx = 1                 'pointer to dest.index of fs(nn, dm.dstndx) array
i = ifn.getfsp(fs(), dm, cexc1(), cexc2(), cdstusr, cdstfsp, cdsthdr)'get fsp's
swap dm.srccnt, dm.dstcnt            'swap no. of source and dest.files in fs()
swap dm.srcndx, dm.dstndx           'swap pointers to source/dest.index of fs()
i = ifn.getfsp(fs(), dm, cexc1(), cexc2(), csrcusr, csrcfsp, csrchdr)'get fsp's
i = ifn.setfsp(fs(), dm)      'move source/dest. filespecs into array positions
i = ifn.setptr(fs(), dm, iptr())        'set pointers according to display mode

dm.begrow = 4                                 'first display data row on screen
dm.fsplen = 39                                 'length of a filespec/name entry
ctmp = string$(dm.fsplen, "")                      'header/footer line segment
dm.hdrln1 = " Source: " + csrcfsp                        'screen header line #1
dm.hdrln2 = " Target: " + cdstfsp                        'screen header line #2
dm.hdrln3 = ctmp + "" + ctmp                           'screen header line #3
dm.ftrln1 = ctmp + "" + ctmp                           'screen footer line #1
dm.ftrln2 = " F1=All/Diff./Same;   F2=Swap;        F3=Copy;      F4=Browse;   F5=Move        "
dm.ftrln3 = " F6=DOS Shell;        F7=Rename;      F8=Delete;    F9=Print;    F10=Comp(Diff) "
dm.ftrln4 = " Enter=ChgDir;       ^Enter=PrvDir;  ^D=ChgDrive;  ^O=Colors;   ^T=Compare Text "

i = ifn.scroll(fs(), dm, iptr(), itag(), cexc2(), csrchdr, cdsthdr)'call scroll

color dm.clrbrt mod 16, dm.clrstd \ 16     'set DOS color for clear-screen call
i = ifn.msgs("", 5, 24, 79, 0, 1)          'all done; clear the screen and exit
close                                 'close all files in case not closed above
system                                      'return control to operating system

function ifn.scroll(fs() as filespec, dm as dpas, iptr(), itag(), cexc2(), _
                    csrchdr, cdsthdr)       'filespec scrolling-screen function
   dim cp as cpas                            'vars.passed to set-color function
   dim cexc1(9)                               'reallocate work exclusions array
   dim cmsg0(9)                                   'allocate color area messages
   dim cmsg1(9)                                 'allocate color select messages
   dm.topndx = 0                              'set top row iptr() begin element
   dm.sepchr = ""                           'source/dest screen data separator
   cbufd = space$(80)                       'initialize the display data buffer
   cbufp = space$(127)                     'initialize the printing data buffer
   cfmtd = space$(dm.fsplen)              'initialize the display format buffer
   cfmtp = space$(62)                    'initialize the printing format buffer
   cquot = char(34)                    'initialize the single double-quote char.
   idispdiff = dm.dspdif + abs(dm.dspdif = 0) 'save show-differences flag value
   cmsg0(0) = "1. Directory headers color"
   cmsg0(1) = "2. Footer messages color"
   cmsg0(2) = "3. Scroll bar color"
   cmsg0(3) = "4. Data display color"
   cmsg0(4) = "5. Data highlight color"
   cmsg0(5) = "6. Line drawing color"
   cmsg0(6) = "** Select the color area to be changed **"
   cmsg0(7) = "** Press Esc to exit the color changes **"
   cmsg1(0) = " Filespec data line for color selections"
   cmsg1(1) = "** Press left/right arrows to toggle FG colors **"
   cmsg1(2) = "** Press left/right tabkey to toggle BG colors **"
   cmsg1(3) = "** Press Esc to redisplay the color selections **"
   cmsg2 = "Copy all newer files to target directory ? (y/n)"
   cmsg3 = "Delete all files from source directory ? (y/n)"
   cmsg4 = "Move all newer files to target directory ? (y/n)"
   cmsg5 = " marked file(s) to target directory ? (y/n)"
   cmsg6 = " marked file(s) from source directory ? (y/n)"
   cmsg7 = "Please wait while files are being processed"
   cwrd = " !#$%&'()+-.0123456789@abcdefghijklmnopqrstuvwxyz[]^_`{}~"
   i = ifn.disphf(dm)                'display scroll-screen headers and footers
   ibypass = 0                        'initialize key used to bypass user input
   do                                  'loop until user presses Enter or Escape
      i = ifn.dispfs(fs(), dm, iptr(), itag(), cbufd, cfmtd)'display scroll data
      cfil = rtrim$(left$(fs(iptr(dm.topndx), dm.srcndx).s, 43))  'get filename
      ilen = len(cfil)                    'length of top-row (current) filename
      if not ibypass then                             'user-input bypass is OFF
         ikey = io.kget(0)                            'get the user-entered key
      end if
      ibypass = 0                                  'clear the user-input bypass
      if dm.tagcnt then                           'file(s) are currently marked
         if ikey = KEY.F3 then                     'user chose to copy one file
            ikey = KEY.ALTF3                    'reset to copy all marked files
         elseif ikey = KEY.F5 then                 'user chose to move one file
            ikey = KEY.ALTF5                    'reset to move all marked files
         elseif ikey = KEY.F8 then               'user chose to delete one file
            ikey = KEY.ALTF8                  'reset to delete all marked files
         end if
      end if
      select case ikey                                 'select user-entered key
         case KEY.CSRDN                                'case is cursor-down key
            if dm.topndx < dm.ptrmax then             'buffer position is < end
               dm.topndx = dm.topndx + 1             'increment buffer position
            end if
         case KEY.CSRLT                                'case is cursor-left key
            if dm.dspofs > 0 then                     'display offset is g.t. 1
               dm.dspofs = dm.dspofs - 1             'scroll left one character
            end if
         case KEY.CSRRT                               'case is cursor-right key
            if dm.dspofs < 28 then                  'display offset is l.t. max.
               dm.dspofs = dm.dspofs + 1            'scroll right one character
            end if
         case KEY.CSRUP                                  'case is cursor-up key
            if dm.topndx > 0 then                  'buffer position > beginning
               dm.topndx = dm.topndx - 1             'decrement buffer position
            end if
         case KEY.CTCLR                               'case is Ctrl-c(O)lor key
            cp.clrno1 = dm.clrhdr                            'header dirs.color
            cp.clrno2 = dm.clrftr                            'footer msgs.color
            cp.clrno3 = dm.clrbar                             'scroll-bar color
            cp.clrno4 = dm.clrdat                           'data display color
            cp.clrno5 = dm.clrhlt                            'data hilite color
            cp.clrno6 = dm.clrlin                           'line drawing color
            cp.clrno7 = dm.clrstd                          'DOS std.fg/bg color
            cp.colbeg = 1                                  'begin window column
            cp.coltot = 80                                'total window columns
            cp.datcol = 1                            'begin data display column
            cp.datlen = dm.fsplen                     'data display text length
            cp.ms1max = 8                             'max. color area messages
            cp.ms2max = 5                           'max. color select messages
            cp.rowbeg = dm.begrow                     'begin data row on screen
            cp.rowend = irowcnt - 4                   'final data row on screen
            cp.filnam = "\dirm.clr"             'filename of system colors file
            cp.sepchr = dm.sepchr               'source/dest.filespec separator
            i = ifn.setclr(cp, dm, cmsg0(), cmsg1())  'get new color selections
            dm.clrhdr = cp.clrno1                            'header dirs.color
            dm.clrftr = cp.clrno2                            'footer msgs.color
            dm.clrbar = cp.clrno3                             'scroll-bar color
            dm.clrdat = cp.clrno4                           'data display color
            dm.clrhlt = cp.clrno5                            'data hilite color
            dm.clrlin = cp.clrno6                           'line drawing color
            i = ifn.disphf(dm)       'display scroll-screen headers and footers
         case KEY.CTLF1                'case is ctrl-F1 (time-diff.comparisons)
            dm.diftim = not dm.diftim         'invert the time-differences flag
         case KEY.CTLLT                           'case is ctrl-cursor-left key
            dm.dspofs = 0                            'move to leftmost position
         case KEY.CTLRT                          'case is ctrl-cursor-right key
            dm.dspofs = ilen - 15                   'move to rightmost position
            if dm.dspofs < 0 then                   'calculated position < zero
               dm.dspofs = 0                      'move to column position zero
            end if
'         case KEY.CTDRV                               'case is Ctrl-D(rive) key
'            i = ifn.usrmsg(dm, "Enter new drive letter (a-z):  ", "")'usrPrompt
'            ctmp = left$(csrchdr, 1)              'default to the current drive
'            do                                    'loop to get the response key
'               i = io.vdsp(ctmp, 13, 55, dm.clrhlt)   'display the drive letter
'               ikey = io.kget(0)                   'get the user's drive letter
'               if ikey >= 97 and ikey <= 122 then    'user pressed 'a' thru 'z'
'                  ikey = ikey - 32                     'a' to 'z' -> 'A' to 'Z'
'               end if
'               if ikey = KEY.ENTER then            'user selected the new drive
'                  i = ifn.setdir(fs(), dm, iptr(), itag(), cexc1(), cexc2(), _
'                                 ctmp + ":\", csrchdr)  'set new directory/path
'                  dm.topndx = 0            'set top-row element to iptr() begin
'                  exit do                      'drive changed OK; abort process
'               elseif ikey = KEY.ESC then             'user pressed the ESC key
'                  exit do                      'user pressed ESC; abort process
'               elseif ikey < 65 or ikey > 90 then  'user pressed non-letter key
'                  beep                      'beep user and wait for another key
'               else                            'user entered a new drive letter
'                  ctmp = char(ikey)          'set display drive to user's entry
'               end if
'            loop
'         case KEY.CTENT                                 'case is Ctrl-Enter key
'            if len(csrchdr) > 3 then   'current directory is NOT root directory
'               ipos1 = istr.rcfn(len(csrchdr) - 1, csrchdr, "\") 'last '\' pos.
'               if ipos1 = 3 then            'parent directory is root directory
'                  ipos1 = 4                 'set position so cusr becomes 'x:\'
'               end if                           'set new directory/path [below]
'               i = ifn.setdir(fs(), dm, iptr(), itag(), cexc1(), cexc2(), _
'                              left$(csrchdr, ipos1 - 1), csrchdr) 'set new path
'               dm.topndx = 0               'set top-row element to iptr() begin
'            end if
'         case KEY.ENTER                                      'case is Enter key
'            if ifn.fsptyp(fs(iptr(dm.topndx), dm.srcndx).s) = 2 then'dir. entry
'               if right$(cfil, 1) = "." then   'directory name has no extension
'                  ctmp = csrchdr + left$(cfil, len(cfil) - 1)'set new path/name
'               else                      'directory name does have an extension
'                  ctmp = csrchdr + cfil                  'set the new path/name
'               end if
'               i = ifn.setdir(fs(), dm, iptr(), itag(), cexc1(), cexc2(), _
'                              ctmp, csrchdr)      'change to new directory/path
'               dm.topndx = 0               'set top-row element to iptr() begin
'            end if
         case KEY.CTMIN                                 'case is Ctrl-Minus key
            i = ifn.cltags(dm, iptr(), itag())          'clear all marked files
         case KEY.CTTXT                                'case is Ctrl-T(ext) key
            if ifn.fsptyp(fs(iptr(dm.topndx), dm.srcndx).s) = 1 then'valid file
               i = ifn.longname(cfil, "", "")     'change long name to DOS name
               shell "vd " + csrchdr + cfil + " " + cdsthdr + cfil + " > dirm.prt"
               shell "stripdif dirm.prt"            'browse the difference file
               i = ifn.disphf(dm)    'display scroll-screen headers and footers
            end if
         case KEY.END                                          'case is End key
            dm.dspofs = 0                     'set display to leftmost position
            dm.topndx = dm.ptrmax                   'set buffer position to end
         case KEY.ESC                                       'case is Escape key
            exit do                  'exit processing and terminate the program
         case KEY.F1                   'case is toggle All/Different/Same modes
            if dm.dspdif then            'current mode is show differences only
               dm.dspdif = 0            'set the show-differences-only flag OFF
               dm.dspsam = not 0          'set the show-same-files-only flag ON
            elseif dm.dspsam then         'current mode is show same files only
               dm.dspsam = 0             'set the show-same-files-only flag OFF
            else                         'current mode is set to show all files
               dm.dspdif = idispdiff      'set the show-all-differences flag ON
            end if
            dm.diftim = 0                    'set the time-differences flag OFF
            i = ifn.setptr(fs(), dm, iptr())      'reset pointers to valid rows
            i = ifn.cltags(dm, iptr(), itag())   'clear all of the marked files
            dm.dspofs = 0                     'set display to leftmost position
            dm.topndx = 0                  'set top-row element to iptr() begin
         case KEY.ALTF1                   'case is toggle Diff./Excl.Diff modes
            idispdiff = idispdiff + 1     'increment diff.flag to next mode set
            if idispdiff > 3 then         'diff's. flag setting is out of range
               idispdiff = 1               'set the flag to the minimum setting
            end if
            dm.dspdif = idispdiff         'save the show-differences flag value
            dm.dspsam = 0                'set the show-same-files-only flag OFF
            dm.diftim = 0                    'set the time-differences flag OFF
            i = ifn.setptr(fs(), dm, iptr())      'reset pointers to valid rows
            i = ifn.cltags(dm, iptr(), itag())   'clear all of the marked files
            dm.dspofs = 0                     'set display to leftmost position
            dm.topndx = 0                  'set top-row element to iptr() begin
         case KEY.F2                            'case is swap source/dest. data
            swap csrchdr, cdsthdr         'swap the source/dest. filespec paths
            swap dm.srccnt, dm.dstcnt 'swap no.of source and dest.files in fs()
            swap dm.srcend, dm.dstend  'swap pointers to final elements of fs()
            swap dm.srcndx, dm.dstndx  'swap pointers to source/dest.fs() index
            swap dm.hdrln1, dm.hdrln2   'swap the source/dest. filespec headers
            mid$(dm.hdrln1, 2) = "Source"   'insert the source header specifier
            mid$(dm.hdrln2, 2) = "Target"    'insert the dest. header specifier
            i = ifn.cltags(dm, iptr(), itag())          'clear all marked files
            dm.ftrln1 = mid$(dm.ftrln1, dm.fsplen + 3) + "" + _
                        mid$(dm.ftrln1, 1, dm.fsplen)  'swap the 'files' counts
            i = io.vdsp(dm.hdrln1, 1, 1, dm.clrhdr)   'display screen header #1
            i = io.vdsp(dm.hdrln2, 2, 1, dm.clrhdr)   'display screen header #2
         case KEY.F3                    'case is copy source file to dest. file
            if ifn.fsptyp(fs(iptr(dm.topndx), dm.srcndx).s) = 1 then'valid file
               if dm.wrnmsg then         'user said to warn on single-file copy
                  ctmp = "Copy " + cfil + " to target directory ? (y/n)"
                  ikey = ifn.wrnmsg(dm, ctmp, cmsg7, "Yy", "Nn" + char(KEY.ESC))
               else               'user did NOT say to warn on single-file copy
                  ikey = 0                   'set ikey to a non-rejection value
               end if
               if ikey <> KEY.ESC then               'user said OK to copy file
                  shell "copy " + cquot + csrchdr + cfil + cquot + _
                        "     " + cquot + cdsthdr + cfil + cquot + " > nul"
                  fs(iptr(dm.topndx), dm.dstndx).s = _'copy source file to dest
                  fs(iptr(dm.topndx), dm.srcndx).s  'and set dest.fsp to source
                  i = ifn.setptr(fs(), dm, iptr())      'reset the row pointers
                  if dm.topndx > dm.ptrmax then  'current row now out of bounds
                     dm.topndx = dm.ptrmax   'set current row to last valid row
                  end if
               end if
            end if
         case KEY.ALTF3                          'case is copy all source files
            if dm.srccnt then              'source files are available for copy
               if dm.tagcnt then                  'file(s) are currently marked
                  ctmp = "Copy " + ltrim$(str$(dm.tagcnt)) + cmsg5
               else                           'file(s) are NOT currently marked
                  ctmp = cmsg2                   'Copy all newer files' message
               end if
               ikey = ifn.wrnmsg(dm, ctmp, cmsg7, "Yy", "Nn" + char(KEY.ESC))
               if ikey <> KEY.ESC then              'user said OK to copy files
                  for indx = 0 to dm.srcend         'loop thru the source files
                     ctmp1 = mid$(fs(iptr(indx), dm.srcndx).s, 53, 8) + "|" + _
                             mid$(fs(iptr(indx), dm.srcndx).s, 61, 4) + "|" + _
                             mid$(fs(iptr(indx), dm.srcndx).s, 44, 9)'set source
                     ctmp2 = mid$(fs(iptr(indx), dm.dstndx).s, 53, 8) + "|" + _
                             mid$(fs(iptr(indx), dm.dstndx).s, 61, 4) + "|" + _
                             mid$(fs(iptr(indx), dm.dstndx).s, 44, 9) 'set dest.
                     icmp = ifn.compfs(ctmp1, ctmp2, dm.diftim, 0)  'do compare
                     if itag(iptr(indx)) or dm.tagcnt = 0 and icmp = 1 then
                        cfil = rtrim$(left$(fs(iptr(indx), dm.srcndx).s, 43))
                        shell "copy " + cquot + csrchdr + cfil + cquot + _
                              "     " + cquot + cdsthdr + cfil + cquot + " > nul"
                        fs(iptr(indx), dm.dstndx).s = fs(iptr(indx), dm.srcndx).s
                     end if      'set dest. filespec to source filespec [above]
                     if io.ktst(0) = KEY.ESC then             'user pressed ESC
                        exit for          'ESC key selected; abort copy process
                     end if
                  next
                  i = ifn.setptr(fs(), dm, iptr())      'reset the row pointers
                  i = ifn.cltags(dm, iptr(), itag())    'clear all marked files
                  dm.topndx = 0            'set top-row element to iptr() begin
               end if
            end if
         case KEY.F4                       'case is browse text or picture file
            if ifn.fsptyp(fs(iptr(dm.topndx), dm.srcndx).s) = 1 then'valid file
               i = ifn.longname(cfil, "", cext)   'change long name to DOS name
               if instr("|.bmp|.gif|.jpg", cext) > 1 then    'picture file type
                  screen 12                           'set graphic display mode
                  shell "lxpic " + csrchdr + cfil    'browse selected text file
                  shell "mode co80," + ltrim$(str$(irowcnt))'restore 80x50 mode
               else                        'browse target is a non-picture file
                  shell "brow " + csrchdr + cfil 'browse the selected text file
               end if
               i = ifn.disphf(dm)    'display scroll-screen headers and footers
            end if
         case KEY.ALTF4                             'case is browse binary file
            if ifn.fsptyp(fs(iptr(dm.topndx), dm.srcndx).s) = 1 then'valid file
               i = ifn.longname(cfil, "", "")     'change long name to DOS name
               shell "view " + csrchdr + cfil         'browse the selected file
               i = ifn.disphf(dm)    'display scroll-screen headers and footers
            end if
         case KEY.F5                    'case is move source file to dest. file
            if ifn.fsptyp(fs(iptr(dm.topndx), dm.srcndx).s) = 1 then'valid file
               if dm.wrnmsg then         'user said to warn on single-file move
                  ctmp = "Move " + cfil + " to target directory ? (y/n)"
                  ikey = ifn.wrnmsg(dm, ctmp, cmsg7, "Yy", "Nn" + char(KEY.ESC))
               else               'user did NOT say to warn on single-file move
                  ikey = 0                   'set ikey to a non-rejection value
               end if
               if ikey <> KEY.ESC then               'user said OK to move file
                  shell "move " + cquot + csrchdr + cfil + cquot + _
                        "     " + cquot + cdsthdr + cfil + cquot + " > nul"
                  fs(iptr(dm.topndx), dm.dstndx).s = _'move source file to dest
                  fs(iptr(dm.topndx), dm.srcndx).s  'and set dest.fsp to source
                  fs(iptr(dm.topndx), dm.srcndx).s = ""  'clear source filespec
                  i = ifn.setptr(fs(), dm, iptr())      'reset the row pointers
                  if dm.topndx > dm.ptrmax then  'current row now out of bounds
                     dm.topndx = dm.ptrmax   'set current row to last valid row
                  end if
               end if
            end if
         case KEY.ALTF5                  'case is move all source files to dest.
            if dm.srccnt then            'source files are available for moving
               if dm.tagcnt then                  'file(s) are currently marked
                  ctmp = "Move " + ltrim$(str$(dm.tagcnt)) + cmsg5
               else                           'file(s) are NOT currently marked
                  ctmp = cmsg4                   'Move all newer files' message
               end if
               ikey = ifn.wrnmsg(dm, ctmp, cmsg7, "Yy", "Nn" + char(KEY.ESC))
               if ikey <> KEY.ESC then 'user said OK to moving all source files
                  for indx = 0 to dm.srcend         'loop thru the source files
                     ctmp1 = mid$(fs(iptr(indx), dm.srcndx).s, 53, 8) + "|" + _
                             mid$(fs(iptr(indx), dm.srcndx).s, 61, 4) + "|" + _
                             mid$(fs(iptr(indx), dm.srcndx).s, 44, 9)'set source
                     ctmp2 = mid$(fs(iptr(indx), dm.dstndx).s, 53, 8) + "|" + _
                             mid$(fs(iptr(indx), dm.dstndx).s, 61, 4) + "|" + _
                             mid$(fs(iptr(indx), dm.dstndx).s, 44, 9) 'set dest.
                     icmp = ifn.compfs(ctmp1, ctmp2, dm.diftim, 0)  'do compare
                     if itag(iptr(indx)) or dm.tagcnt = 0 and icmp = 1 then
                        cfil = rtrim$(left$(fs(iptr(indx), dm.srcndx).s, 43))
                        shell "move " + cquot + csrchdr + cfil + cquot + _
                              "     " + cquot + cdsthdr + cfil + cquot + " > nul"
                        fs(iptr(indx), dm.dstndx).s = fs(iptr(indx), dm.srcndx).s
                        fs(iptr(indx), dm.srcndx).s = ""
                     end if          'blank out current source filespec [above]
                     if io.ktst(0) = KEY.ESC then             'user pressed ESC
                        exit for          'ESC key selected; abort move process
                     end if
                  next
                  i = ifn.setptr(fs(), dm, iptr())      'reset the row pointers
                  i = ifn.cltags(dm, iptr(), itag())    'clear all marked files
                  dm.topndx = 0            'set top-row element to iptr() begin
               end if
            end if
         case KEY.F6                                 'case is execute DOS shell
            locate 1, 1, 1                                  'un-hide the cursor
            cls                      'clear screen prior to executing DOS shell
            shell                                        'execute the DOS shell
            i = ifn.disphf(dm)       'display scroll-screen headers and footers
         case KEY.F7                                   'case is rename-file key
            if ifn.fsptyp(fs(iptr(dm.topndx), dm.srcndx).s) = 1 then'valid file
               i = ifn.usrmsg(dm, "Enter new filename:" + space$(44), "")
               ctmp = cfil + space$(43 - len(cfil))     'filename to be renamed
               csav = lcase$(cfil)        'save filename for comparison [below]
               i = io.vdsp(ctmp, 13, 29, dm.clrbrt)   'display current filename
               ioffset = 0                'set to beginning of data entry field
               icursor = 0                'set to allow strikeover (not insert)
               do                 'loop until user presses Enter or Esc [below]
                  itxtkey = iedt.cell(char(3) + char(0), ctmp, 13, 29, _
                                      dm.clrbrt, ioffset, icursor)'get exit key
                  if itxtkey = KEY.ESC then           'user pressed the ESC key
                     exit do                            'ESC pressed; exit loop
                  elseif itxtkey = KEY.ENTER then 'user pressed ENTER (process)
                     lset ctmp = lcase$(ltrim$(ctmp)) 'left-justify edit buffer
                     if rtrim$(ctmp) = csav then    'a new name was NOT entered
                        itxtkey = KEY.ESC     'set to skip rename process below
                        exit do               'no new filename input; exit loop
                     end if
                     do                           'loop to remove trailing dots
                        ilen = len(rtrim$(ctmp)) 'actual length of entered name
                        idot = istr.rcfn(ilen, ctmp, ".")  'file extn. position
                        if ilen > 0 and idot = ilen then   'trailing dot found!
                           mid$(ctmp, idot) = " "      'remove the trailing dot
                        else                        'trailing dot was NOT found
                           exit do                    'dot NOT found; exit loop
                        end if
                     loop
                     if idot then                  'extension position is valid
                        cdot = ""               'dot already found in extension
                     else                         'extension position NOT valid
                        cdot = "."                  'set the extension test dot
                        idot = ilen + 1        'set ext.posn.to end of filename
                     end if
                     ispc = not 0               'set to uppercase 1st character
                     for i = 1 to idot - 1       'loop thru filename characters
                        ichr = midchar(ctmp, i)  'current character of filename
                        if instr(cwrd, char(ichr)) = 0 then  'invalid character
                           exit for    'invalid character found; exit char.loop
                        elseif ichr = 32 or ichr = 40 or ichr = 45 then 'space!
                           ispc = not 0         'set the blank-space flag to ON
                        elseif ispc then        'previous char. was blank space
                           ispc = 0            'set the blank-space flag to OFF
                           if ichr >= 97 and ichr <= 122 then 'lowercase char.!
                              mid$(ctmp, i) = char(ichr - 32) 'set to uppercase
                           end if
                        end if
                     next
                     if i < idot or ilen = 0 then  'user input invalid filename
                        beep                    'sound error and resume editing
                     else                          'user input a valid filename
                        ctst = cquot + csrchdr + rtrim$(ctmp) + cdot + cquot
                        shell "dir " + ctst + " > dirm.prt"  'test new filename
                        ifil = freefile         'get next available file handle
                        open "dirm.prt" for binary as ifil  'open the test file
                        llof = lof(ifil)               'get length of test file
                        i = ifn.kill(ifil, "dirm.prt")      'kill the test file
                        if llof > 188 then         'new filename already exists
                           beep                   'sound alert & resume editing
                        else                       'new filename does NOT exist
                           exit do                'no editing errors; exit loop
                        end if                'does new filename already exist?
                     end if                   'are filename's characters valid?
                  end if                      'did user press ENTER to process?
               loop
               if itxtkey = KEY.ENTER then         'user entered a new filename
                  mid$(ctmp, 1) = ucase$(left$(ctmp, 1))  'uprc. filename begin
                  shell "ren " + cquot + csrchdr + csav + cquot + _
                        "    " + cquot + rtrim$(ctmp) + cquot + " > nul"
                  mid$(fs(iptr(dm.topndx), dm.srcndx).s, 1) = ctmp'new filename
                  i = ifn.packfs(fs(), dm, dm.srccnt, dm.srcndx)'pack source fsp
                  i = ifn.packfs(fs(), dm, dm.dstcnt, dm.dstndx)'pack dest. fsp
                  i = ifn.sortfs(fs(), dm.srcndx, dm.srccnt)'sort filespec list
                  i = ifn.setfsp(fs(), dm)   'move filespecs to array positions
                  i = ifn.setptr(fs(), dm, iptr())      'reset the row pointers
                  i = ifn.cltags(dm, iptr(), itag())    'clear all marked files
                  ikey = midchar(ctmp, 1)    'set for alpha key process [below]
                  ibypass = not 0              'set bypass to process alpha key
                  dm.dspofs = 0               'set display to leftmost position
                  dm.topndx = 0                    'set buffer position to home
               end if
               i = ifn.disphf(dm)    'display scroll-screen headers and footers
            end if
         case KEY.F8                                'case is delete source file
            if ifn.fsptyp(fs(iptr(dm.topndx), dm.srcndx).s) = 1 then'valid file
               if dm.wrnmsg then       'user said to warn on single-file delete
                  ctmp = "Delete " + cfil + " from source directory ? (y/n)"
                  ikey = ifn.wrnmsg(dm, ctmp, "", "Yy", "Nn" + char(KEY.ESC))
               else             'user did NOT say to warn on single-file delete
                  ikey = 0                   'set ikey to a non-rejection value
               end if
               if ikey <> KEY.ESC then             'user said OK to delete file
                  shell "del " + cquot + csrchdr + cfil + cquot + " > nul"
                  fs(iptr(dm.topndx), dm.srcndx).s = ""  'remove file from list
                  i = ifn.setptr(fs(), dm, iptr())      'reset pointers to data
                  if dm.topndx > dm.ptrmax then  'current row now out of bounds
                     dm.topndx = dm.ptrmax   'set current row to last valid row
                  end if
               end if
            end if
         case KEY.ALTF8                        'case is delete all source files
            if dm.srccnt then            'source files are available for delete
               if dm.tagcnt then                  'file(s) are currently marked
                  ctmp = "Delete " + ltrim$(str$(dm.tagcnt)) + cmsg6
               else                           'file(s) are NOT currently marked
                  ctmp = cmsg3                       'Delete all files' message
               end if
               ikey = ifn.wrnmsg(dm, ctmp, cmsg7, "Yy", "Nn" + char(KEY.ESC))
               if ikey <> KEY.ESC then 'user said OK to delete all source files
                  for indx = 0 to dm.srcend         'loop thru the source files
                     if itag(iptr(indx)) or dm.tagcnt = 0 _'current file tagged
                     and ifn.fsptyp(fs(iptr(indx), dm.srcndx).s) = 1 then'or...
                        cfil = rtrim$(left$(fs(iptr(indx), dm.srcndx).s, 43))
                        shell "del " + cquot + csrchdr + cfil + cquot + " > nul"
                        fs(iptr(indx), dm.srcndx).s = ""
                     end if          'blank out current source filespec [above]
                     if io.ktst(0) = KEY.ESC then             'user pressed ESC
                        exit for          'ESC key selected; abort copy process
                     end if
                  next
                  i = ifn.setptr(fs(), dm, iptr())      'reset the row pointers
                  i = ifn.cltags(dm, iptr(), itag())    'clear all marked files
                  dm.topndx = 0            'set top-row element to iptr() begin
               end if
            end if
         case KEY.F9, _                         'case is print the current list
              KEY.ALTF9                          'case is print list to printer
            i = ifn.usrmsg(dm, "Printing...", "")'display print standby message
            ifil = freefile                 'get next available DOS file handle
            open "dirm.prt" for output as ifil      'open the print output file
            lset cbufp = ""                  'pre-clear the print output buffer
            mid$(cbufp,  2) = left$(ltrim$(dm.hdrln1), 62)'print header line #1
            mid$(cbufp, 66) = left$(ltrim$(dm.hdrln2), 62)'print header line #2
            print #ifil, cbufp               'print source/dest.headers to disk
            mid$(cbufp,  2) = string$(62, "-")         'print separator line #1
            mid$(cbufp, 66) = string$(62, "-")         'print separator line #2
            print #ifil, cbufp            'print source/dest.separators to disk
            for indx = 0 to dm.ptrmax             'loop from first item to last
               lset cbufp = ""               'pre-clear the print output buffer
               mid$(cbufp,  2) = cfn.fmtprt(fs(iptr(indx), dm.srcndx).s, cfmtp)
               mid$(cbufp, 66) = cfn.fmtprt(fs(iptr(indx), dm.dstndx).s, cfmtp)
               if midchar(cbufp, 2) <> 32 and midchar(cbufp, 66) <> 32 then
                  ctmp1 = mid$(fs(iptr(indx), dm.srcndx).s, 53, 8) + "|" + _
                          mid$(fs(iptr(indx), dm.srcndx).s, 61, 4) + "|" + _
                          mid$(fs(iptr(indx), dm.srcndx).s, 44, 9)'set source
                  ctmp2 = mid$(fs(iptr(indx), dm.dstndx).s, 53, 8) + "|" + _
                          mid$(fs(iptr(indx), dm.dstndx).s, 61, 4) + "|" + _
                          mid$(fs(iptr(indx), dm.dstndx).s, 44, 9) 'set dest.
                  icmp = ifn.compfs(ctmp1, ctmp2, dm.diftim, 1) 'comp.filespecs
                  if icmp = 1 then             'source filespec > dest.filespec
                     mid$(cbufp,  1) = char(254)'insert flag/show filespec diff.
                  elseif icmp = -1 then        'source filespec < dest.filespec
                     mid$(cbufp, 65) = char(254)'insert flag/show filespec diff.
                  end if
               end if
               if ifn.fsptyp(fs(iptr(indx), dm.srcndx).s) = 1 then 'source=file
                  mid$(cbufp,  50) = mid$(cbufp,  53, 5) + "/" + mid$(cbufp,  50, 2)
               end if
               if ifn.fsptyp(fs(iptr(indx), dm.dstndx).s) = 1 then  'dest.=file
                  mid$(cbufp, 114) = mid$(cbufp, 117, 5) + "/" + mid$(cbufp, 114, 2)
               end if
               print #ifil, cbufp     'print source and dest. filespecs to disk
            next
            close ifil                             'close the print output file
            if ikey = KEY.ALTF9 then                'user says print to printer
               shell "pset dirm.prt > nul"          'call pset for print output
            end if
         case KEY.F10                              'case is compare file (DIFF)
            if ifn.fsptyp(fs(iptr(dm.topndx), dm.srcndx).s) = 1 then'valid file
               i = ifn.longname(cfil, "", "")     'change long name to DOS name
               shell "diff " + csrchdr + cfil + " " + cdsthdr + cfil'comp.files
               i = ifn.disphf(dm)    'display scroll-screen headers and footers
            end if
         case KEY.ALTF10                      'case is compare all files (DIFF)
            for indx = 0 to dm.srcend           'loop thru the source filespecs
               if itag(iptr(indx)) or dm.tagcnt = 0 _'current file tagged or...
               and ifn.fsptyp(fs(iptr(indx), dm.srcndx).s) = 1 then 'valid file
                  cfil = rtrim$(left$(fs(iptr(indx), dm.srcndx).s, 43))
                  i = ifn.longname(cfil, "", "")  'change long name to DOS name
                  shell "diff " + csrchdr + cfil + " " + cdsthdr + cfil
               end if                       'compare source/dest. files [above]
            next
            i = ifn.cltags(dm, iptr(), itag())          'clear all marked files
            i = ifn.disphf(dm)       'display scroll-screen headers and footers
         case KEY.HOME                                        'case is Home key
            dm.dspofs = 0                     'set display to leftmost position
            dm.topndx = 0                          'set buffer position to home
         case KEY.MINUS                                  'case is Minus (-) key
            if itag(iptr(dm.topndx)) then           'current filespec is marked
               itag(iptr(dm.topndx)) = 0           'unmark the current filespec
               dm.tagcnt = dm.tagcnt - 1         'decrement no. of files marked
            end if
            if dm.topndx < dm.srcend then  'current row < last valid source row
               dm.topndx = dm.topndx + 1      'move scroll position to next row
            end if
         case KEY.PGDN                                   'case is Page-down key
            if dm.topndx < dm.ptrmax - irowcnt + 7 then'element# < end-pagesize
               dm.topndx = dm.topndx + irowcnt - 7 'incr.buffer pos.by pagesize
            else                             'buffer position is > end-pagesize
               dm.topndx = dm.ptrmax                'set buffer position to end
            end if
         case KEY.PGUP                                     'case is Page-up key
            if dm.topndx > irowcnt - 7 then         'buffer position > pagesize
               dm.topndx = dm.topndx - irowcnt + 7 'decr.buffer pos.by pagesize
            else                                 'buffer position is < pagesize
               dm.topndx = 0                       'set buffer position to home
            end if
         case KEY.PLUS                                    'case is Plus (+) key
            if not itag(iptr(dm.topndx)) then     'current filespec is unmarked
               if ifn.fsptyp(fs(iptr(dm.topndx), dm.srcndx).s) = 1 then 'valid!
                  itag(iptr(dm.topndx)) = not 0      'mark the current filespec
                  dm.tagcnt = dm.tagcnt + 1       'increment no.of files marked
               end if
            end if
            if dm.topndx < dm.srcend then  'current row < last valid source row
               dm.topndx = dm.topndx + 1      'move scroll position to next row
            end if
         case else                                    'case is (possibly) alpha
            if ikey >= 97 and ikey <= 122 then          'user key is 'a' to 'z'
               ikey = ikey - 32                     'set user key to 'A' to 'Z'
            end if
            if ikey >= 33 and ikey <= 127 then          'user key is '!' to 'z'
               indx = dm.topndx                'beginning data position in fs()
               do                             'loop to find next filename match
                  for i = indx to 0 step -1         'loop current line to prev.
                     iprv = midchar(fs(iptr(i), dm.srcndx).s, 1)'prev.file char
                     if iprv > 32 then        'non-blank data in prev. filename
                        exit for               'non-blank data found; exit loop
                     end if
                  next
                  indx = indx + 1             'increment to next match-position
                  if indx > dm.srcend then   'current position is > end of list
                     indx = 0            'set current pos. to beginning of list
                  end if
                  ichr = midchar(fs(iptr(indx), dm.srcndx).s, 1)'curr.file char
                  if ichr = ikey or indx = dm.topndx then'find/no-find complete
                     dm.topndx = indx 'set current pos.to find/no-find position
                     exit do                 'search complete; exit search loop
                  elseif ichr < ikey then     'current filename is < search key
                     if indx >= dm.srcend then 'current position at end of list
                        dm.topndx = dm.srcend   'search key > all names in list
                        exit do               '....so just exit the search loop
                     end if
                  elseif indx = 0 then         'search key < all array names...
                     dm.topndx = 0          '...so set current pos.to top of...
                     exit do                 '....list and exit the search loop
                  elseif iprv < ikey then         'search key is between two...
                     dm.topndx = indx            '...filename values, so set...
                     exit do                    '...the current position and...
                  end if                               '...exit the search loop
               loop   'Note: final test above assures that when search falls...
            end if    '      between 2 names (i.e. 'e' between 'c' and 'f'),...
      end select      '      the search will remain on the first g.t. name only
   loop                                'loop until user presses Enter or Escape
end function

function cfn.fmtext(cfsp, cfmt, iofs) static       'expand/format filespec text
   if ifn.fsptyp(cfsp) = 1 then                      'the filespec is non-blank
      lset cfmt = mid$(cfsp, 1 + iofs, 17)             'filename-plus-extension
      mid$(cfmt, 19) = mid$(cfsp, 44, 9)                    'file size in bytes
      mid$(cfmt, 29) = mid$(cfsp, 55, 6)                         'date yyyymmdd
      mid$(cfmt, 36) = mid$(cfsp, 61, 4)                             'time hhmm
   else                          'current filespec is blank or a directory name
      lset cfmt = cfsp         'set formatted output to blank or directory name
   end if
   cfn.fmtext = cfmt                'return formatted output to calling routine
end function

function cfn.fmtint(cfsp) static               'compress/deformat filespec text
   cfn.fmtint = mid$(cfsp, 1, 43) + _                  'filename-less-extension
                mid$(cfsp, 45, 9) + _                       'file size in bytes
                mid$(cfsp, 55, 4) + _                        'date segment yyyy
                mid$(cfsp, 60, 2) + _                          'date segment mm
                mid$(cfsp, 63, 2) + _                          'date segment dd
                mid$(cfsp, 66, 2) + _                          'time segment hh
                mid$(cfsp, 69, 2)                              'time segment mm
end function

function cfn.fmtprt(cfsp, cfmt) static            'format filespec for printing
   if ifn.fsptyp(cfsp) = 1 then                      'the filespec is non-blank
      lset cfmt = mid$(cfsp, 1, 37)                    'filename-plus-extension
      mid$(cfmt, 39) = mid$(cfsp, 44, 9)                    'file size in bytes
      mid$(cfmt, 49) = mid$(cfsp, 55, 2) + "/" + _
                       mid$(cfsp, 57, 2) + "/" + _
                       mid$(cfsp, 59, 2)                         'date yy/mm/dd
      mid$(cfmt, 58) = mid$(cfsp, 61, 2) + ":" + _
                       mid$(cfsp, 63, 2)                            'time hh:mm
   else                          'current filespec is blank or a directory name
      lset cfmt = cfsp         'set formatted output to blank or directory name
   end if
   cfn.fmtprt = cfmt                'return formatted output to calling routine
end function

function ifn.cltags(dm as dpas, iptr(), itag())'clear all marked (tagged) items
   for indx = 0 to dm.arrmax                  'loop thru the marked-items array
       itag(indx) = 0                        'unmark the filespec at this index
   next
   dm.tagcnt = 0                           'set the no. of marked items to zero
end function

function ifn.compfs(cstr1, cstr2, imode, iyear) 'comp. date/time/size filespecs
   if iyear then                              'date in yymmdd format; do adjust
      if left$(cstr1, 2) <= "49" then         'date indicates century is '2000'
         cstr1 = "20" + cstr1                 'set the century prefix to '2000'
      else                                    'date indicates century is '1900'
         cstr1 = "19" + cstr1                 'set the century prefix to '2000'
      end if
      if left$(cstr2, 2) <= "49" then         'date indicates century is '2000'
         cstr2 = "20" + cstr2                 'set the century prefix to '2000'
      else                                    'date indicates century is '1900'
         cstr2 = "19" + cstr2                 'set the century prefix to '2000'
      end if
   end if
   ipos1 = instr(cstr1, "|")                   'separator between date and time
   ipos2 = instr(ipos1 + 1, cstr1, "|")        'separator between time and size
   cdat1 = left$(cstr1, ipos1 - 1)           'extract source date from filespec
   cdat2 = left$(cstr2, ipos1 - 1)            'extract dest. date from filespec
   ctim1 = mid$(cstr1, ipos1 + 1, ipos2 - ipos1 - 1)   'extract the source time
   ctim2 = mid$(cstr2, ipos1 + 1, ipos2 - ipos1 - 1)    'extract the dest. time
   if imode then                                   'time differences flag is ON
      ilen = len(cdat1)                            'length of date 6 or 8 chars.
      iyrs1 = pdqvali(left$(cdat1, ilen - 4))       'get years value from cdat1
      iyrs2 = pdqvali(left$(cdat2, ilen - 4))       'get years value from cdat2
      if iyrs1 < iyrs2 then                           'year1 is less than year2
         icmp = -1                                  'return value iyrs1 < iyrs2
      elseif iyrs1 > iyrs2 then                    'year1 is greater than year2
         icmp = 1                                   'return value iyrs1 > iyrs2
      else
         imon1 = pdqvali(mid$(cdat1, ilen - 3, 2)) 'get months value from cdat1
         imon2 = pdqvali(mid$(cdat2, ilen - 3, 2)) 'get months value from cdat2
         if imon1 < imon2 then                      'month1 is less than month2
            icmp = -1                               'return value imon1 < imon2
         elseif imon1 > imon2 then                  'month1 greater than month2
            icmp = 1                                'return value imon1 > imon2
         else                                        'month1 is equal to month2
            icmp = 0                                'return value imon1 = imon2
         end if
      end if
      if icmp = 0 then                              'years and months are equal
         iday1 = pdqvali(right$(cdat1, 2))        'get the day value from cdat1
         iday2 = pdqvali(right$(cdat2, 2))        'get the day value from cdat2
         ihrs1 = pdqvali(left$(ctim1, 2))       'get the hours value from ctim1
         ihrs2 = pdqvali(left$(ctim2, 2))       'get the hours value from ctim2
         imin1 = pdqvali(right$(ctim1, 2))        'get minutes value from ctim1
         imin2 = pdqvali(right$(ctim2, 2))        'get minutes value from ctim2
         idif1 = iday1 - iday2                       'difference in days values
         idif2 = ihrs1 - ihrs2                      'difference in hours values
         idif3 = imin1 - imin2                    'difference in minutes values
         icmp1 = (idif1 = 0 and idif2 = 0 and idif3 = 0)     'days&times match?
         icmp2 = (idif1 = 0 and abs(idif2) <= 1 and abs(idif3) <= 1)'WinNT diff.
         icmp3 = (abs(idif1) = 1 and abs(idif2) = 23 and _
                 abs(idif3) <= 1 and sgn(idif1) <> sgn(idif2))'WinNT difference
         if not(icmp1 or icmp2 or icmp3) then  'dates and/or times do NOT match
            if iday1 < iday2 then                'source day less than dest.day
               icmp = -1                        'return the value (day1 < day2)
            elseif iday1 > iday2 then         'source day greater than dest.day
               icmp = 1                         'return the value (day1 > day2)
            elseif ctim1 < ctim2 then         'source time less than dest. time
               icmp = -1                      'return the value (time1 < time2)
            else                            'source time greater than dest.time
               icmp = 1                       'return the value (time1 > time2)
            end if
         end if
      end if
   else                                       'the time differences flag is OFF
      if cdat1 < cdat2 then                 'source date is less than dest.date
         icmp = -1                            'return the value (date1 < date2)
      elseif cdat1 > cdat2 then             'source date greater than dest.date
         icmp = 1                             'return the value (date1 > date2)
      elseif ctim1 < ctim2 then               'source time less than dest. time
         icmp = -1                            'return the value (time1 < time2)
      elseif ctim1 > ctim2 then             'source time greater than dest.time
         icmp = 1                             'return the value (time1 > time2)
      else                                   'times equal; return compare value
         icmp = 0                             'return the value (time1 = time2)
      end if
   end if
   if icmp then                               'the dates and times do NOT match
      ifn.compfs = icmp                      'return (date/time1 <> date/time2)
   else                                       'the dates and times are a match!
      lsiz1 = pdqvall&(mid$(cstr1, ipos2 + 1))   'get source size from filespec
      lsiz2 = pdqvall&(mid$(cstr2, ipos2 + 1))    'get dest. size from filespec
      if lsiz1 < lsiz2 then                 'source size is less than dest.size
         ifn.compfs = -1                      'return the value (size1 < size2)
      elseif lsiz1 > lsiz2 then             'source size greater than dest.size
         ifn.compfs = 1                       'return the value (size1 > size2)
      else                                   'source size is equal to dest.size
         ifn.compfs = 0                         'return dates/times-match value
      end if
   end if
end function

function ifn.dispfs(fs() as filespec, dm as dpas, iptr(), itag(), cbuf, cfmt)
   for indx = dm.topndx to dm.topndx + irowcnt - 8 'loop thru the data elements
      lset cbuf = ""                      'clear display buffer to blank spaces
      if indx <= dm.ptrmax then       'current element position <= end of array
         if itag(iptr(indx)) then               'the current filespec is marked
            mid$(cbuf, 1) = char(26)         'set mark/unmark display character
         end if
         mid$(cbuf,  2) = cfn.fmtext(fs(iptr(indx), dm.srcndx).s, cfmt, dm.dspofs)
         mid$(cbuf, 42) = cfn.fmtext(fs(iptr(indx), dm.dstndx).s, cfmt, dm.dspofs)
      end if             'copy source/dest. filespecs to display buffer [above]
      idsprow = indx + dm.begrow - dm.topndx        'current screen display row
      if midchar(cbuf, 2) = 32 or midchar(cbuf, 42) = 32 then 'src.or dst.blank
         i = io.vdsp(cbuf, idsprow, 1, dm.clrdat)'blank string; display 1 color
      else                       'both source and dest. filespecs are non-blank
         ctmp1 = mid$(cbuf, 30, 6) + "|" + _
                 mid$(cbuf, 37, 4) + "|" + _
                 mid$(cbuf, 20, 9)             'set source filespec for compare
         ctmp2 = mid$(cbuf, 70, 6) + "|" + _
                 mid$(cbuf, 77, 4) + "|" + _
                 mid$(cbuf, 60, 9)              'set dest. filespec for compare
         icmp = ifn.compfs(ctmp1, ctmp2, dm.diftim, 1)   'compare the filespecs
         if icmp = 0 then                'source/dest.specs match on all fields
            i = io.vdsp(cbuf, idsprow, 1, dm.clrdat)'src = dst; display 1 color
         elseif icmp = 1 then               'source filespec is > dest.filespec
            i = io.vdsp(mid$(cbuf,  1, 40), idsprow,  1, dm.clrhlt)'disp.src.fsp
            i = io.vdsp(mid$(cbuf, 42, 39), idsprow, 42, dm.clrdat)'disp.dst.fsp
         else                               'source filespec is < dest.filespec
            i = io.vdsp(mid$(cbuf,  1, 40), idsprow,  1, dm.clrdat)'disp.src.fsp
            i = io.vdsp(mid$(cbuf, 42, 39), idsprow, 42, dm.clrhlt)'disp.dst.fsp
         end if
      end if
      i = io.vdsp(dm.sepchr, idsprow, 41, dm.clrlin)'display src/dest.separator
      if indx = dm.topndx then                   'current display row = top row
         i = io.vdsp(mid$(cbuf, 1, 13), idsprow, 1, dm.clrbar) 'current row=top
      end if      '...so use inverse color to highlight top-row source filename
   next
   mid$(dm.ftrln1, 16) = " " + ltrim$(str$(dm.srccnt)) + " files "
   mid$(dm.ftrln1, 57) = " " + ltrim$(str$(dm.dstcnt)) + " files "
   iftrinv = (dm.clrftr mod 8) * 16 + dm.clrftr \ 16      'footer inverse color
   i = io.vdsp(dm.ftrln1, irowcnt - 3, 1, dm.clrlin)     'draw the 'files' line
   i = io.vdsp("All/Diff./Same", irowcnt - 2, 5, dm.clrftr) 'display mode flags
   if dm.dspdif then                          'show-differences-only flag is ON
      i = io.vdsp("Diff.", irowcnt - 2, 9, iftrinv)     'highlight 'Diff.' mode
   elseif dm.dspsam then                        'the show-same-files flag is ON
      i = io.vdsp("Same", irowcnt - 2, 15, iftrinv)      'highlight 'Same' mode
   else                                      'neither flag is ON; just show ALL
      i = io.vdsp("All", irowcnt - 2, 5, iftrinv)         'highlight 'All' mode
   end if
end function

function ifn.disphf(dm as dpas)      'display scroll-screen headers and footers
   i = io.vdsp(dm.hdrln1, 1, 1, dm.clrhdr)     'display scroll-screen header #1
   i = io.vdsp(dm.hdrln2, 2, 1, dm.clrhdr)     'display scroll-screen header #2
   i = io.vdsp(dm.hdrln3, 3, 1, dm.clrlin)     'display scroll-screen header #3
   i = io.vdsp(dm.ftrln2, irowcnt - 2, 1, dm.clrftr)   'scroll-screen footer #2
   i = io.vdsp(dm.ftrln3, irowcnt - 1, 1, dm.clrftr)   'scroll-screen footer #3
   i = io.vdsp(dm.ftrln4, irowcnt - 0, 1, dm.clrftr)   'scroll-screen footer #4
   locate irowcnt - 1, 79, 0                                   'hide the cursor
end function

function ifn.fsptyp(cfsp)                       'get filespec type (0, 1, or 2)
   if left$(cfsp, 1) = " " then                          'the filespec is blank
      ifn.fsptyp = 0                                     'set blank return type
   elseif instr(cfsp, "<") = 0 then                      'the filespec is valid
      ifn.fsptyp = 1                                     'set valid return type
   else                                           'filespec is a directory name
      ifn.fsptyp = 2                            'set directory name return type
   end if
end function

function ifn.getfsp(fs() as filespec, dm as dpas, cexc1(), cexc2(), _
                    cusr, cfsp, chdr)                   'load the new filespecs
   dim cxdr(9), cxfl(9), cxsp(9), cxhd(9), ixno(9), lxsz(9)'get-dirnames params
   ipos1 = istr.rcfn(len(cusr), cusr, "\")       'last '\' position in filespec
   ipos2 = instr(cusr, ":")                        'position of ':' in filespec
   if ipos1 = 0 then                                  '\' not found in filespec
      ipos1 = ipos2                                 'use ':' position (or zero)
   end if
   cfsp = mid$(cusr, ipos1 + 1)                     'extract filespec-less-path
   if cfsp = "." or cfsp = ".." then               'user input path '.' or '..'
      cfsp = ""                                   'clear the filespec-less-path
   elseif instr(cfsp, "*") = 0 and instr(cfsp, "?") = 0 then  'filename/dirname
      i = ifn.longname(cfsp, "", "")         'change poss.long name to DOS name
   end if
   cdir = "dsrc.dir"                    'initialize tempfile name for file list
   i = ifn.gdir(cdir, cfil, csp1, chdr, cusr, ifno, lsiz, 1)    'get first file
   if chdr = "" then                                  'directory/path NOT found
      i = ifn.kill(ifno, cdir)                         'kill the temp file list
      i = ifn.msgs("Invalid directory/path: " + cusr, 5, 24, 79, 1, 1)
   end if                           'display the error message [above] and exit
   ihdrlen = len(chdr)                          'length of actual filespec path
   ioptlen = len(cfsp)                            'length of filespec-less-path
   if ihdrlen <= ioptlen or ihdrlen = 3 then  'header too short to contain cfsp
      cfsp = chdr + cfsp                 'add actual path to filespec-less-path
   elseif cfsp = "" or _              'filespec is null or already part of path
   ucase$(cfsp) = ucase$(mid$(chdr, ihdrlen - ioptlen, ioptlen)) then
      cfsp = left$(chdr, ihdrlen - 1)            'actual path less trailing '\'
   else                            'filespec-less-path NOT already part of path
      cfsp = chdr + cfsp                 'add actual path to filespec-less-path
   end if
   for iexc = 0 to dm.excmax                'loop thru the specified exclusions
      cexc1(iexc) = cexc2(iexc)             'copy saved element to work element
      if cexc1(iexc) <> "" then               'the exclusion parameter is valid
         cexc1(iexc) = chdr + cexc1(iexc)      'add path to exclusion parameter
         cxdr(iexc) = "dexc.dx" + ltrim$(str$(iexc))  'initialize excl. dirname
         i = ifn.gdir(cxdr(iexc), cxfl(iexc), cxsp(iexc), cxhd(iexc), _
                      cexc1(iexc), ixno(iexc), lxsz(iexc), 0)
      end if  'get first filespec (if any) for current exclusion param. [above]
   next
   dm.srccnt = 0                               'no. of filespecs loaded counter
   while dm.srccnt <= dm.arrmax and cfil <> ""     'begin loading the filespecs
      iexcfnd = 0                          'initialize the exclusion-found flag
      for iexc = 0 to dm.excmax             'loop thru the specified exclusions
         if cxsp(iexc) = csp1 then      'a matching excluded-filespec was found
            iexcfnd = not 0          'exclusion found; set exclusion-found flag
            i = ifn.gdir(cxdr(iexc), cxfl(iexc), cxsp(iexc), cxhd(iexc), _
                         "", ixno(iexc), lxsz(iexc), 0)
         end if      'remain in loop above in case of duplicate excl. filespecs
      next
      if io.ktst(0) = KEY.ESC then                     'test for user-keyed ESC
         i = ifn.msgs("ESC key selected - program aborted", 5, 24, 79, 0, 1)
      end if                    'display abort message [above] and exit program
      if not iexcfnd then                      'matching exclude-spec NOT found
         if dm.srccnt = dm.arrmax then      'maximum no.files already processed
            cmsg = "Maximum no. of unique files (" + _
                   ltrim$(str$(dm.arrmax)) + ") exceeded" 'create error message
            i = ifn.msgs(cmsg, 5, 24, 79, 1, 1) 'display error message and exit
         end if
         if instr(csp1, "<dir>") then     'current filespec is a directory name
            fs(dm.srccnt, dm.srcndx).s = left$(csp1, 12) + " <DIR>"'add to list
         else                              'current filespec is NOT a directory
            fs(dm.srccnt, dm.srcndx).s = cfn.fmtint(csp1) 'add filespec to list
         end if
         dm.srccnt = dm.srccnt + 1     'increment # of filespecs loaded counter
      end if
      i = ifn.gdir(cdir, cfil, csp1, chdr, "", ifno, lsiz, 1)
   wend                                  'get next filespec to be added [above]
   i = ifn.sortfs(fs(), dm.srcndx, dm.srccnt)           'sort the filespec list
   close                                  'close all files before killing files
   i = ifn.kill(ifno, cdir)                           'kill the 'dsrc.dir' file
   for iexc = 0 to dm.excmax                'loop thru the specified exclusions
      i = ifn.kill(ixno(iexc), cxdr(iexc))            'kill the 'dexc.dxn' file
   next
end function

function ifn.packfs(fs() as filespec, dm as dpas, isrccnt, isrcndx)'compress fs
   isrccnt = 0                                 'initialize the no. of filespecs
   for indx = dm.begndx to dm.arrmax            'loop thru the target filespecs
      if ifn.fsptyp(fs(indx, isrcndx).s) then    'the current filespec is valid
         fs(isrccnt, isrcndx).s = fs(indx, isrcndx).s   'move the filespec down
         isrccnt = isrccnt + 1                      'increment total file count
      end if
   next
end function

function ifn.setclr(cp as cpas, dm as dpas, cmsg0(), cmsg1()) 'color selections
   cbuf = space$(9)                             'allocate the color-file buffer
   iclrfil = freefile                            'get system colors file handle
   open rtrim$(cp.filnam) for binary as iclrfil    'open the system colors file
   get iclrfil, 1, cbuf                          'load the color specifications
   ikey = 0                                  'initialize user-entered key value
   while ikey <> KEY.ESC                 'loop to display color area selections
      color cp.clrno7 mod 16, cp.clrno7 \ 16   'set color for clear-screen call
      cls                                             'clear the display screen
      for indx = 0 to cp.ms1max - 3          'loop thru the color area messages
         i = io.vdsp(cmsg0(indx), cp.rowbeg + indx * 2, cp.colbeg + 1, cp.clrno7)
      next                             'display the color area messages [above]
      imsgcol = cp.colbeg + (cp.coltot - len(cmsg0(indx))) \ 2  'message column
      i = io.vdsp(cmsg0(indx + 0), cp.rowbeg + indx * 2 + 1, imsgcol, cp.clrno7)
      i = io.vdsp(cmsg0(indx + 1), cp.rowbeg + indx * 2 + 3, imsgcol, cp.clrno7)
      ikey = io.kget(0)                            'get the selection-key value
      iseq = ikey - 48                            'get select-sequence from key
      if iseq >= 1 and iseq <= cp.ms1max - 2 then'color-area selection 1 - max.
         iclr = midchar(cbuf, iseq)                   'get existing color value
         ifgd = iclr mod 16                           'set the foreground color
         ibgd = iclr \ 16                             'set the background color
         while ikey <> KEY.ESC                   'loop to process color changes
'------------------------------ Non-Generic Code ------------------------------
            dm.clrhdr = cp.clrno1                  'reset the header dirs.color
            dm.clrftr = cp.clrno2                  'reset the footer msgs.color
            dm.clrlin = cp.clrno6                 'reset the line drawing color
            i = ifn.disphf(dm)                        'display the basic screen
'------------------------------------------------------------------------------
            for irow = cp.rowbeg to cp.rowend - 4      'loop thru the data rows
               if irow = cp.rowend - 6 _
               or irow = cp.rowend - 8 _
               or irow = cp.rowend - 11 then       'hilite this source filespec
                  i = io.vdsp(cmsg1(0), irow, cp.datcol, cp.clrno5)
               else                            'show normal color this filespec
                  i = io.vdsp(cmsg1(0), irow, cp.datcol, cp.clrno4)
               end if                 'display separator [below] and dest. data
               i = io.vdsp(rtrim$(cp.sepchr), irow, cp.datlen + 2, cp.clrno6)
               i = io.vdsp(mid$(cmsg1(0), 2), irow, cp.datlen + 3, cp.clrno4)
            next                         'display normal color this row [above]
            i = io.vdsp(cmsg1(0), cp.rowbeg, cp.datcol, cp.clrno3)'scroll color
            imsgcol = cp.colbeg + (cp.coltot - len(cmsg1(1))) \ 2 'message col.
            for indx = 1 to cp.ms2max - 2  'loop thru the color select messages
               i = io.vdsp(cmsg1(indx), cp.rowend + indx - 3, imsgcol, cp.clrno7)
            next                     'display the color select messages [above]
            i = io.vdsp(cmsg1(indx), cp.rowend + 3, cp.colbeg + 2, cp.clrno6)
            ikey = io.kget(0)                         'get the toggle-key value
            select case ikey                        'select on toggle-key value
               case KEY.CSRLT                'user toggled a FG color decrement
                  ifgd = (ifgd - 1) mod 8 + 8   'decrement the foreground color
                  if ifgd = ibgd + 8 then        'foreground matches background
                     ibgd = (ibgd + 1) mod 8    'increment the background color
                  end if
               case KEY.CSRRT                'user toggled a FG color increment
                  ifgd = (ifgd + 1) mod 8 + 8   'increment the foreground color
                  if ifgd = ibgd + 8 then        'foreground matches background
                     ibgd = (ibgd + 7) mod 8    'decrement the background color
                  end if
               case KEY.TABLT                'user toggled a BG color decrement
                  ibgd = (ibgd + 7) mod 8       'decrement the background color
                  if ifgd = ibgd + 8 then        'foreground matches background
                     ifgd = (ifgd + 1) mod 8 + 8    'increment foreground color
                  end if
               case KEY.TABRT                'user toggled a BG color increment
                  ibgd = (ibgd + 1) mod 8       'increment the background color
                  if ifgd = ibgd + 8 then        'foreground matches background
                     ifgd = (ifgd - 1) mod 8 + 8    'decrement foreground color
                  end if
               case else                         'user pressed a non-toggle key
                  if ikey <> KEY.ESC then          'user pressed an invalid key
                     ikey = 0                 'clear key to skip color settings
                     beep                    'warn user and get next toggle key
                  end if
            end select
            if ikey then                             'user toggled to new color
               iclr = ifgd + ibgd * 16                  'set single-value color
               select case iseq                          'select on color areas
                  case 1                                         'color area #1
                     cp.clrno1 = iclr                    'set new area #1 color
                  case 2                                         'color area #2
                     cp.clrno2 = iclr                    'set new area #2 color
                  case 3                                         'color area #3
                     cp.clrno3 = iclr                    'set new area #3 color
                  case 4                                         'color area #4
                     cp.clrno4 = iclr                    'set new area #4 color
                  case 5                                         'color area #5
                     cp.clrno5 = iclr                    'set new area #5 color
                  case 6                                         'color area #6
                     cp.clrno6 = iclr                    'set new area #6 color
                  case else
               end select
               mid$(cbuf, iseq) = char(iclr)      'put new color to file buffer
            end if
         wend
         ikey = 0                'clear ESC key so we don't exit the outer loop
      elseif ikey <> KEY.ESC then        'user did invalid color-area selection
         beep                                'warn and get next color selection
      end if
   wend
   put iclrfil, 1, cbuf                          'save the color specifications
   close iclrfil                               'close color specifications file
end function

'function ifn.setdir(fs() as filespec, dm as dpas, iptr(), itag(), cexc1(), _
'                    cexc2(), cusr, csrchdr)       'change to new drive/filepath
'   i = ifn.packfs(fs(), dm, dm.dstcnt, dm.dstndx)'pack filespecs for reindexing
'   i = ifn.getfsp(fs(), dm, cexc1(), cexc2(), cusr, cfsp, csrchdr)  'load fsp's
'   i = ifn.setfsp(fs(), dm)                  'move filespecs to array positions
'   i = ifn.setptr(fs(), dm, iptr())                  'set display mode pointers
'   i = ifn.cltags(dm, iptr(), itag())                   'clear all marked files
'   dm.hdrln1 = " Source: " + cfsp                  'insert source path+filespec
'   i = ifn.disphf(dm)                'display scroll-screen headers and footers
'end function

function ifn.setfsp(fs() as filespec, dm as dpas)      'set fs() data positions
   isrcptr = dm.srccnt - 1          'set source pointer to final source element
   idstptr = dm.dstcnt - 1            'set dest. pointer to final dest. element
   indx = dm.arrmax + 1                'begin loop at the end of the data array
   do                                     'loop until data completely processed
      indx = indx - 1                     'decrement to-index/main loop counter
      if indx = isrcptr or indx = idstptr then  'max.no.files already processed
         cmsg = "Maximum no. of unique files (" + _
                ltrim$(str$(dm.arrmax)) + ") exceeded"    'create error message
         i = ifn.msgs(cmsg, 5, 24, 79, 1, 1)    'display error message and exit
      end if
      fs(indx, dm.srcndx).s = ""          'pre-clear the current source element
      fs(indx, dm.dstndx).s = ""           'pre-clear the current dest. element
      if isrcptr < 0 then         'all source data elements have been processed
         isrcndx = indx         'set temp pointer to current index (blank data)
      else                    'all source data elements have NOT been processed
         isrcndx = isrcptr     'set the temp pointer to the actual source index
      end if
      if idstptr < 0 then          'all dest. data elements have been processed
         idstndx = indx         'set temp pointer to current index (blank data)
      else                     'all dest. data elements have NOT been processed
         idstndx = idstptr      'set the temp pointer to the actual dest. index
      end if
      isrctyp = 0              'initialize source element type to blank element
      idsttyp = 0               'initialize dest. element type to blank element
      if left$(fs(isrcndx, dm.srcndx).s, 43) _
      >= left$(fs(idstndx, dm.dstndx).s, 43) then     'source filespec is valid
         isrctyp = ifn.fsptyp(fs(isrcndx, dm.srcndx).s)'get source element type
         fs(indx, dm.srcndx).s = fs(isrcndx, dm.srcndx).s 'OK to process source
      end if
      if left$(fs(idstndx, dm.dstndx).s, 43) _
      >= left$(fs(isrcndx, dm.srcndx).s, 43) then      'dest. filespec is valid
         idsttyp = ifn.fsptyp(fs(idstndx, dm.dstndx).s) 'get dest. element type
         if isrctyp + idsttyp = 3 then 'source/dest. are file/directory entries
            idsttyp = 0              'skip dest. side of file/directory entries
         else                      'source/dest. are NOT file/directory entries
            fs(indx, dm.dstndx).s = fs(idstndx, dm.dstndx).s'OK to process dest
         end if
      end if
      if isrctyp then                          'valid source data element found
         isrcptr = isrcptr - 1        'decrement source pointer to next element
      end if
      if idsttyp then                           'valid dest. data element found
         idstptr = idstptr - 1         'decrement dest. pointer to next element
      end if
   loop while indx > 0 and (isrcptr >= 0 or idstptr >= 0)'until all data proc'd
   dm.begndx = indx                          'first valid element in fs() array
end function

function ifn.setptr(fs() as filespec, dm as dpas, iptr())    'set data pointers
   dm.srccnt = 0                     'initialize the no.of source files in fs()
   dm.dstcnt = 0                      'initialize the no. of dest.files in fs()
   dm.srcend = 0                     'initialize the end source element in fs()
   dm.dstend = 0                      'initialize the end dest. element in fs()
   dm.ptrmax = -1                   'initialize the maximum pointer array index
   for indx = dm.begndx to dm.arrmax  'loop from beginning to end of valid data
      isrctyp = ifn.fsptyp(fs(indx, dm.srcndx).s) 'see if src.element non-blank
      idsttyp = ifn.fsptyp(fs(indx, dm.dstndx).s)'see if dest.element non-blank
      if isrctyp or idsttyp then               'data in source or dest. element
         iptrset = 0                            'initialize set-valid-data flag
         if dm.dspdif = 1 then                 'show-all-differences flag is ON
            if fs(indx, dm.srcndx).s <> fs(indx, dm.dstndx).s then 'difference!
               iptrset = not 0                  'set the set-valid-data flag ON
            end if
         elseif dm.dspdif = 2 then           'show-match-differences flag is ON
            if fs(indx, dm.srcndx).s <> fs(indx, dm.dstndx).s then 'difference!
               if left$(fs(indx, dm.srcndx).s, 43) _   'source/dest.filenames..
                = left$(fs(indx, dm.dstndx).s, 43) then'...........are the same
                  iptrset = not 0               'set the set-valid-data flag ON
               end if
            end if
         elseif dm.dspdif = 3 then          'show-non-match-differences flag=ON
            if isrctyp + idsttyp = 1 then    'source/dest.filenames are a match
               iptrset = not 0                  'set the set-valid-data flag ON
            end if
         elseif dm.dspsam then                 'show-same-files-only flag is ON
            if left$(fs(indx, dm.srcndx).s, 43) _
             = left$(fs(indx, dm.dstndx).s, 43) then'source/dest.filenames same
               iptrset = not 0                  'set the set-valid-data flag ON
            end if
         else                                   'user said to display all files
            iptrset = not 0                     'set the set-valid-data flag ON
         end if
         if iptrset then                   'valid data; increment data pointers
            dm.ptrmax = dm.ptrmax + 1       'increment max. pointer array index
            iptr(dm.ptrmax) = indx          'set pointer to current valid index
            if isrctyp then            'valid data found in fs() source element
               dm.srcend = dm.ptrmax     'initialize end source element in fs()
               dm.srccnt = dm.srccnt + 1   'increment # of source files in fs()
            end if
            if idsttyp then             'valid data found in fs() dest. element
               dm.dstend = dm.ptrmax      'initialize end dest. element in fs()
               dm.dstcnt = dm.dstcnt + 1    'increment # of dest. files in fs()
            end if
         end if
      end if
   next
   if dm.ptrmax = -1 then      'no data found; max. pointer array index NOT set
      dm.ptrmax = 0           'set max. pointer array index to first fs() index
      iptr(0) = 0            'set first pointer array value to first fs() index
      fs(0, dm.srcndx).s = ""             'blank out first fs() source filespec
      fs(0, dm.dstndx).s = ""              'blank out first fs() dest. filespec
   end if
end function

function ifn.sortfs(fs() as filespec, indx, itot)'0-based array; itot=#elements
   irdx = itot \ 2                               'set sort radix for Shell sort
   while irdx > 0                                      'loop while radix > zero
      for itap = irdx - 1 to itot - 2                   'top-array-pointer loop
         for ilap = (itap - irdx + 1) to 0 step -irdx   'low-array-pointer loop
            if fs(ilap, indx).s > fs(ilap + irdx, indx).s then 'low value > top
               swap fs(ilap, indx), fs(ilap + irdx, indx)  'swap low/top values
            else                            'low array value <= top array value
               exit for                 'compare sequence done; exit inner loop
            end if
         next
      next
      irdx = irdx \ 2           'move radix down; when == zero, exit radix loop
   wend
end function

function ifn.usrmsg(dm as dpas, cprompt, cdspmsg)   'display user prompt in box
   iprmlen = len(cprompt)                 'get the length of the warning prompt
   imsglen = len(cdspmsg)                'get the length of the standby message
   if imsglen < iprmlen then             'prompt-msg. length > disp.-msg length
      imaxlen = iprmlen                  'set max. length to prompt-msg. length
   else                                  'disp.-msg. length > prompt-msg length
      imaxlen = imsglen                   'set max. length to disp.-msg. length
   end if
   iprmcol = (82 - iprmlen) \ 2           'beginning column for prompt messages
   imsgcol = (82 - imsglen) \ 2          'beginning column for standby messages
   imaxcol = (82 - imaxlen) \ 2          'maximum beginning column for messages
   for indx = 11 to 15                    'loop to clear 5-line block on screen
      i = io.vdsp(space$(imaxlen + 2), indx, imaxcol - 1, dm.clrbar)'clear line
   next
   i = io.vdsp(cprompt, 13, iprmcol, dm.clrhlt)     'prompt for user's response
end function

function ifn.wrnmsg(dm as dpas, cprompt, cdspmsg, ckeypos, ckeyneg)
   i = ifn.usrmsg(dm, cprompt, cdspmsg)             'display user prompt in box
   do                                             'loop to get the response key
      ikey = io.kget(0)                            'get the user's response key
      if instr(ckeypos, char(ikey)) then        'user hit positive-response key
         i = ifn.usrmsg(dm, cdspmsg, cprompt)  'display the user message in box
         ifn.wrnmsg = ikey                  'return response to calling routine
         exit do                             'user pressed valid key; exit loop
      elseif instr(ckeyneg, char(ikey)) then    'user hit negative-response key
         ifn.wrnmsg = KEY.ESC                'return ESC key to calling routine
         exit do                             'user pressed valid key; exit loop
      else                                   'response key NOT found in ckeyopt
         beep                               'beep user and wait for another key
      end if
   loop
end function

function io.kget(inop)                 ' get key value (don't strip key buffer)
   do                                          ' begin loop to strip key buffer
   loop while inkey$ <> ""               ' loop while key buffer contains a key
   do                                         ' loop to get key from key buffer
      ckey = inkey$                                   ' get key from key buffer
   loop while ckey = ""                               ' loop until a key is hit
   if asc(ckey) then                                  ' key value in first byte
      io.kget = asc(ckey)                 ' return key value to calling program
   else                                           ' zero value ("extended" key)
      io.kget = asc(mid$(ckey, 2)) + 128           ' add 128 to 2nd byte of key
   end if
end function

function io.ktst(inop)                              ' return last key (no wait)
   ckey = inkey$                                      ' get key from key buffer
   if ckey <> "" then                               ' key buffer contains a key
      if asc(ckey) then                               ' key value in first byte
         inop = asc(ckey)                                 ' key value to return
      else                                        ' zero value ("extended" key)
         inop = asc(mid$(ckey, 2)) + 128           ' add 128 to 2nd byte of key
      end if
   else                                     ' key buffer does NOT contain a key
      inop = 0                                   ' set return key value to zero
   end if
   io.ktst = inop                         ' return key value to calling program
end function

function io.vcsr(irow, icol, icsr)              'set cursor position [and size]
   if icsr then                                          'cursor-size specified
      locate irow, icol, 1                             'turn the edit cursor ON
   else                                              'cursor-size NOT specified
      locate irow, icol, 0                            'turn the edit cursor OFF
   end if
end function                                         'return to calling program

function io.vdsp(cdat, irow, icol, iclr)                'display data on screen
   call pdqprint(cdat, irow, icol, iclr)  'set color/locate cursor/display data
end function
