'/* CTST.BAS  Display the sum of all bytes in a DOS file  */
'/*           By: Dale Thorn                              */
'/*           Rev. 11.05.2000                             */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'scrnparm.bas'
'$include: 'string.bas'

ccmd = ucase$(rtrim$(command$))         'get the user's command-line parameters
if ccmd = "" then                    'command-line parameters were NOT supplied
   i = ifn.msgs("Usage:  CTST  filename", iofs, irow, icol, 0, 1)
end if                              'display the usage message [above] and exit

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") _
or iprm >= 0 then        'user gave an invalid filename or supplied a parameter
   i = ifn.msgs("Invalid filename", iofs, irow, icol, 1, 1)   'invalid filename
end if                       'display invalid-filename message [above] and exit

i = ifn.open(1, cfil, "B", llof)           'open the source file in binary mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", iofs, irow, icol, 1, 1)      'beep and exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", iofs, irow, icol, 1, 1)     'beep and exit
end if

iseg = 32766                         'maximum possible buffer size/file segment
if iseg > fre("") - 4096 then         'maximum available memory for file buffer
   iseg = fre("") - 4096           'set buffer size/file segment to max. memory
end if
if iseg > llof then                          'buffer length is > length of file
   iseg = llof                              'set buffer length = length of file
end if
imod = llof mod iseg       'left-over bytes at end of buffer-size file segments

i = ifn.msgs("Please standby", iofs, irow, icol, 0, 0) 'hide cursor and proceed
cbuf = space$(iseg)                                 'initialize the file buffer
ltot = 0                                         'initialize the byte-sum total
for lrcd = 1 to llof step iseg      'loop thru the file in buffer-size segments
   if lrcd + iseg > llof and imod > 0 then   'last file "record" and imod is ON
      cbuf = ""                                     'deallocate the file buffer
      cbuf = space$(imod)                         'reinitialize the file buffer
   end if
   get 1, lrcd, cbuf                            'load the file buffer with data
   for ichr = 1 to len(cbuf)              'loop thru the file-buffer characters
      ltot = ltot + midchar(cbuf, ichr)        'add this character to the total
   next
next

if ltot < 0 then                       'signed long integer overflow; adjust up
   dtot = 4294967296# + ltot            'add 4 gigabytes to signed long integer
else                                       'signed long integer OK; no overflow
   dtot = ltot                              'add nothing to signed long integer
end if
i = ifn.msgs("Total count: " + ltrim$(str$(dtot)), iofs, irow, icol, 0, 1)
close                                 'close all files in case not closed above
system                                   'exit program in case not exited above
