' BITOPS.BAS  02.04.2003

function bitget(cstr1, ibit)                     'get a bit-value from a string
   select case ibit mod 8                      'switch on bit# within character
      case 0                                        'bit #0 in target character
         ival = 1                                              'value of bit #0
      case 1                                        'bit #1 in target character
         ival = 2                                              'value of bit #1
      case 2                                        'bit #2 in target character
         ival = 4                                              'value of bit #2
      case 3                                        'bit #3 in target character
         ival = 8                                              'value of bit #3
      case 4                                        'bit #4 in target character
         ival = 16                                             'value of bit #4
      case 5                                        'bit #5 in target character
         ival = 32                                             'value of bit #5
      case 6                                        'bit #6 in target character
         ival = 64                                             'value of bit #6
      case 7                                        'bit #7 in target character
         ival = 128                                            'value of bit #7
      case else
   end select
   bitget = (midchar(cstr1, ibit \ 8 + 1) and ival) \ ival 'value of target bit
end function

function bitput(cstr1, ibit, iput)                 'put a bit-value to a string
   select case ibit mod 8                      'switch on bit# within character
      case 0                                        'bit #0 in target character
         ival = 1                                              'value of bit #0
      case 1                                        'bit #1 in target character
         ival = 2                                              'value of bit #1
      case 2                                        'bit #2 in target character
         ival = 4                                              'value of bit #2
      case 3                                        'bit #3 in target character
         ival = 8                                              'value of bit #3
      case 4                                        'bit #4 in target character
         ival = 16                                             'value of bit #4
      case 5                                        'bit #5 in target character
         ival = 32                                             'value of bit #5
      case 6                                        'bit #6 in target character
         ival = 64                                             'value of bit #6
      case 7                                        'bit #7 in target character
         ival = 128                                            'value of bit #7
      case else
   end select
   ipos = ibit \ 8 + 1                        'position of 8-bit char. in cstr1
   ichr = midchar(cstr1, ipos)                    '8-bit char. at position ipos
   if iput then                                           'OK to set the bit ON
      if (ichr and ival) = 0 then                        'bit is NOT already ON
         mid$(cstr1, ipos) = char(ichr + ival)       'set bit ON by adding ival
      end if
   else                                                  'OK to set the bit OFF
      if (ichr and ival) then                           'bit is NOT already OFF
         mid$(cstr1, ipos) = char(ichr - ival)       'set bit OFF by subt. ival
      end if
   end if
end function
