'/* BCRP.BAS Encrypt files using bit moves (w/one XOR layer */
'/*          By: Dale Thorn                                 */
'/*          Rev. 02.04.2003                                */
'/*          Version 4.3                                    */

'$include: 'basdef.h'
'$include: 'bcrp.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'midchar.bas'
'$include: 'parmstr2.bas'

main:                                  '/* get user's command-line arguments */
   cmsg = ""                          '/* initialize the User message string */
   cwrd = "!#$%&'()+-.0123456789@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_`{}~"
   cwrx = "                                                         "
   ibeg = 0                           '/* initialize the loop-begin variable */
   ibuf = 2048                        '/* set the maximum file buffer length */
   ichr = 0                    '/* initialize a temporary character variable */
   idot = 0                  '/* initialize the filename extension separator */
   idx2 = 0                         '/* initialize a temporary loop variable */
   iend = 0                          '/* initialize the loop-ending variable */
   ilen = 0                       '/* initialize a temporary length variable */
   incr = 0                       '/* initialize the loop-increment variable */
   indx = 0                         '/* initialize a temporary loop variable */
   iopr = 0                                '/* initialize the operation code */
   iwrd = len(cwrd)                  '/* initialize length of filename chars */
   llof = 0                          '/* initialize the file length variable */
   lrnd = 0                        '/* initialize the randomizer accumulator */
   ifil = freefile                    '/* get next available DOS file handle */
   iprm = parmstr1(rtrim$(command$), cfil, cnam, cext, cprm()) '/* cmnd args */
   dim int1(57)                       '/* allocate filename sort index array */
   dim lnt2(57)                       '/* allocate filename sort PRN's array */
   dim istk(57)                       '/* allocate filename sort stack array */

   if command$ = "" then                 '/* a command line was not supplied */
      cmsg = "Usage:  BCRP(v4.3)  filename  [/e /d]  [key1  key2  ....]"
      i = ifn.msgs(cmsg, 5, 24, 79, 0, 1) '/* display usage message and exit */
   end if
   if iprm < 1 or iprm > 12 then    '/* no. of seed keys should be one to 12 */
      i = ifn.msgs("Invalid number of parameters", 5, 24, 79, 1, 1)
   end if                         '/* display error message [above] and exit */
   if instr(command$, "/") = 0 then '/* slash preceding opcode param missing */
      i = ifn.msgs("Invalid operation parameter", 5, 24, 79, 1, 1)
   end if                         '/* display error message [above] and exit */
   lset cfil = ucase$(cfil)                '/* uppercase the target filename */
   lset cprm(0) = ucase$(cprm(0))           '/* uppercase the operation code */
   if instr("ED", cprm(0)) = 0 then             '/* invalid opcode parameter */
      i = ifn.msgs("Invalid operation parameter", 5, 24, 79, 1, 1)
   end if                         '/* display error message [above] and exit */
   idot = instr(1, cfil, ".")   '/* position of filename extension separator */
   ilen = len(cfil)                            '/* length of target filename */
   if idot > 9 or (idot = 0 and ilen > 8) or (idot > 0 and ilen - idot > 3) then
      i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)  '/* filename is bad */
   end if                         '/* display error message [above] and exit */
   if idot then                      '/* filename extension separator found! */
      if instr(idot + 1, cfil, ".") then              '/* 2nd '.' was found! */
         i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)
      end if                      '/* display error message [above] and exit */
      if idot = ilen then         '/* extension separator at end of filename */
         ilen = ilen - 1             '/* decrement length of target filename */
         cfil = left$(cfil, ilen)    '/* decrement length of target filename */
      end if
   end if
   i = ifn.open(ifil, cfil, "b", llof)            '/* open the selected file */
                                             '/* get length of selected file */
   if llof <= 0 then                             '/* length=0 or call failed */
      close ifil                                 '/* close the selected file */
      i = ifn.kill(ifil, cfil)                 '/* kill the zero-length file */
      cmsg = cfil                               '/* copy filename to message */
      cmsg = cmsg + " not found"              '/* add "not found" to message */
      i = ifn.msgs(cmsg, 5, 24, 79, 1, 1)       '/* display message and exit */
   end if
   iopr = asc(cprm(0)) - 68                '/* opcode (1=encrypt, 0=decrypt) */
   if iopr = 1 then                        '/* this is the encrypt operation */
      ibeg = 1                               '/* set the loop-begin variable */
      iend = iprm                           '/* set the loop-ending variable */
      incr = 1                           '/* set the loop-increment variable */
   else                                    '/* this is the decrypt operation */
      ibeg = iprm                            '/* set the loop-begin variable */
      iend = 1                              '/* set the loop-ending variable */
      incr = -1                          '/* set the loop-increment variable */
   end if
   for indx = ibeg to iend step incr             '/* loop thru #of seed keys */
      lrnd = pdqvall&(cprm(indx)) mod 1048576&   '/* get randomizer seed key */
      for idx2 = 0 to iwrd - 1               '/* loop through array elements */
         int1(idx2) = idx2              '/* offsets from current byte offset */
         l = lfn.rand(lrnd)              '/* get the next pseudorandom value */
         lnt2(idx2) = lrnd                '/* put random value to sort array */
      next
      i = ifn.sort(int1(), lnt2(), istk(), iwrd - 1)   '/* sort random array */
      for idx2 = 0 to iwrd - 1                  '/* loop thru filename chars */
         mid$(cwrx, int1(idx2) + 1) = mid$(cwrd, idx2 + 1, 1)
      next                 '/* shuffle bytes in valid filename chars [above] */
      lrnd = pdqvall&(cprm(indx)) mod 1048576&   '/* get randomizer seed key */
      for idx2 = 1 to ilen                      '/* loop thru filename chars */
         ichr = instr(cwrx, mid$(cfil, idx2, 1)) '/* filename char. position */
         if ichr = 0 then                '/* character not found in filename */
            i = ifn.msgs("Invalid character in filename", 5, 24, 79, 1, 1)
         end if                   '/* display error message [above] and exit */
         lrnd = (lrnd + ichr) mod 1048576&             '/* add value to seed */
         l = lfn.rand(lrnd)                  '/* reiterate value of seed key */
      next
      if iopr = 1 then                       '/* encrypt operation specified */
         if indx = ibeg then                  '/* 1st key - perform file XOR */
            i = ifn.msgs("Applying bitmask", 5, 24, 79, 0, 0) '/* apply mask */
            l = lfn.fxor((ibuf), ifil, (lrnd), llof)  '/* XOR f/1st seed key */
         end if
         i = ifn.msgs("Encrypting layer", 5, 24, 79, 0, 0)  '/* encrypt msg. */
      else                                   '/* decrypt operation specified */
         i = ifn.msgs("Decrypting layer", 5, 24, 79, 0, 0)  '/* decrypt msg. */
      end if
      cmsg = ltrim$(str$(indx))                 '/* convert 'indx' to string */
      i = ifn.msgs(cmsg, -22, 24, 79, 0, 0)    '/* show layer number message */
      i = ifn.cryp((ibuf), ifil, iopr, llof, (lrnd))  '/* encrypt or decrypt */
      if iopr = 0 and indx = iend then    '/* decrypt operation and last key */
         i = ifn.msgs("Removing bitmask", 5, 24, 79, 0, 0)   '/* remove mask */
         l = lfn.fxor((ibuf), ifil, (lrnd), llof)'/* XOR file f/1st seed key */
      end if
   next
   i = ifn.msgs("Translation complete", 5, 24, 79, 0, 1)
system

function ifn.cryp(ibuf, ifil, iopr, llof, lrnd)          '/* encrypt routine */
   cmsg = ""                          '/* initialize the User message string */
   ibit = 0                            '/* initialize the bit offset in cbuf */
   ieof = 0                                      '/* initialize the EOF flag */
   ilen = 0                       '/* initialize a temporary length variable */
   indx = 0                         '/* initialize the for-next loop counter */
   lbyt = 0                         '/* initialize the file pointer variable */
   cbuf = space$(2048)                        '/* initialize the file buffer */
   ctmp = space$(2048)                        '/* initialize the temp buffer */
   dim int1(1536)                          '/* allocate the sort index array */
   dim lnt2(1536)                      '/* allocate sort random number array */
   dim istk(1536)                          '/* allocate the sort stack array */

   for lbyt = 0 to llof - 1 step ibuf           '/* process in ibuf segments */
      if llof > ibuf then                     '/* so we don't divide by zero */
         cmsg = ltrim$(str$(lbyt \ (llof \ 100))) '/* convert pct. to string */
         cmsg = cmsg + "%"                  '/* append '%' symbol to message */
         i = ifn.msgs("    ", -25, 24, 79, 0, 0)'/* erase prev.complete msg. */
         i = ifn.msgs(cmsg, -25, 24, 79, 0, 0)  '/* show pct. completed msg. */
      end if
      if lbyt + ibuf >= llof then  '/* current file pointer + ibuf spans EOF */
         i = ifn.setm(cbuf, llof, lbyt, ibuf)   '/* reset file buffer length */
         ieof = 1                                    '/* set the EOF flag ON */
      end if
      get ifil, lbyt + 1, cbuf            '/* read data into the file buffer */
      do                              '/* loop to process bit groups in cbuf */
         l = lfn.rand(lrnd)              '/* get the next pseudorandom value */
         ilen = lrnd \ 832 + 256          '/* buffer bitlen: 256<=ilen<=1516 */
         if ibit + ilen > ibuf * 8 then'/* curr. bit-pointer+ilen spans cbuf */
            if ieof then                                  '/* EOF flag is ON */
               ilen = ibuf * 8 - ibit '/* reset bit-length of buffer segment */
            else                    '/* EOF flag is OFF; adjust file pointer */
               put ifil, lbyt + 1, cbuf           '/* write data to the file */
               lbyt = lbyt - (ibuf - ibit \ 8)'/* set lbyt to load from ibit */
               ibit = ibit mod 8    '/* set ibit to first byte of <new> cbuf */
               exit do                '/* exit loop to reload cbuf from lbyt */
            end if
         end if           '/* encrypt or decrypt the current segment [below] */
         for indx = 0 to ilen - 1            '/* loop through array elements */
            int1(indx) = indx       '/* bit offsets from current ibit offset */
            l = lfn.rand(lrnd)           '/* get the next pseudorandom value */
            lnt2(indx) = lrnd            '/* random values for sort function */
         next
         i = ifn.sort(int1(), lnt2(), istk(), ilen - 1)'/* sort random array */
         lset ctmp = cbuf               '/* copy data buffer to dest. buffer */
         if iopr then                      '/* this is the encrypt operation */
            for indx = 0 to ilen - 1              '/* loop through bit group */
               i = bitput(ctmp, indx + ibit, bitget(cbuf, int1(indx) + ibit))
            next                   '/* move bits to random positions [above] */
         else                              '/* this is the decrypt operation */
            for indx = 0 to ilen - 1              '/* loop through bit group */
               i = bitput(ctmp, int1(indx) + ibit, bitget(cbuf, indx + ibit))
            next              '/* restore bits from random positions [above] */
         end if
         lset cbuf = ctmp               '/* copy dest. buffer to data buffer */
         ibit = ibit + ilen           '/* increment ibit to next bit-segment */
         if ibit = ibuf * 8 then       '/* loop until ibit == length of cbuf */
            put ifil, lbyt + 1, cbuf          '/* put current buffer to file */
            ibit = 0                '/* set ibit to first byte of <new> cbuf */
            exit do                    '/* ibit == length of cbuf; exit loop */
         end if
      loop
   next
   cbuf = ""                                  '/* deallocate the file buffer */
   ctmp = ""                                  '/* deallocate the temp buffer */
   'free(int1);                          '/* deallocate the sort index array */
   'free(lnt2);                            '/* deallocate the sort PRN array */
   'free(istk);                          '/* deallocate the sort stack array */
end function

function bitget(cstr1, ibit)               '/* get a bit-value from a string */
   ival = 0                                     '/* initialize the bit value */

   select case ibit mod 8                '/* switch on bit# within character */
      case 0                                  '/* bit #0 in target character */
         ival = 1                                        '/* value of bit #0 */
        'break;
      case 1                                  '/* bit #1 in target character */
         ival = 2                                        '/* value of bit #1 */
        'break;
      case 2                                  '/* bit #2 in target character */
         ival = 4                                        '/* value of bit #2 */
        'break;
      case 3                                  '/* bit #3 in target character */
         ival = 8                                        '/* value of bit #3 */
        'break;
      case 4                                  '/* bit #4 in target character */
         ival = 16                                       '/* value of bit #4 */
        'break;
      case 5                                  '/* bit #5 in target character */
         ival = 32                                       '/* value of bit #5 */
        'break;
      case 6                                  '/* bit #6 in target character */
         ival = 64                                       '/* value of bit #6 */
        'break;
      case 7                                  '/* bit #7 in target character */
         ival = 128                                      '/* value of bit #7 */
        'break;
      case else
        'break;
   end select
   bitget = (midchar(cstr1, ibit \ 8 + 1) and ival) \ ival
end function                  '/* return the value of the target bit [above] */

function bitput(cstr1, ibit, iput)           '/* put a bit-value to a string */
   ival = 0                                     '/* initialize the bit value */
   ipos = ibit \ 8 + 1                  '/* position of 8-bit char. in cstr1 */
   ichr = midchar(cstr1, ipos)       '/* character at position ipos in cstr1 */
   select case ibit mod 8                '/* switch on bit# within character */
      case 0                                  '/* bit #0 in target character */
         ival = 1                                        '/* value of bit #0 */
        'break;
      case 1                                  '/* bit #1 in target character */
         ival = 2                                        '/* value of bit #1 */
        'break;
      case 2                                  '/* bit #2 in target character */
         ival = 4                                        '/* value of bit #2 */
        'break;
      case 3                                  '/* bit #3 in target character */
         ival = 8                                        '/* value of bit #3 */
        'break;
      case 4                                  '/* bit #4 in target character */
         ival = 16                                       '/* value of bit #4 */
        'break;
      case 5                                  '/* bit #5 in target character */
         ival = 32                                       '/* value of bit #5 */
        'break;
      case 6                                  '/* bit #6 in target character */
         ival = 64                                       '/* value of bit #6 */
        'break;
      case 7                                  '/* bit #7 in target character */
         ival = 128                                      '/* value of bit #7 */
        'break;
      case else
        'break;
   end select
   if iput then                                     '/* OK to set the bit ON */
      if (ichr and ival) = 0 then                  '/* bit is NOT already ON */
         mid$(cstr1, ipos) = char(ichr + ival) '/* set bit ON by adding ival */
      end if
   else                                            '/* OK to set the bit OFF */
      if (ichr and ival) then                     '/* bit is NOT already OFF */
         mid$(cstr1, ipos) = char(ichr - ival) '/* set bit OFF by subt. ival */
      end if
   end if
end function

function lfn.fxor(ibuf, ifil, lrnd, llof)       '/* perform file XOR process */
   cmsg = ""                          '/* initialize the User message string */
   ibit = 0                              '/* initialize the random bit value */
   ibitoffs = 0                        '/* initialize read-from bit position */
   ibuffbit = 0                         '/* initialize byte pointer variable */
   ibuffbyt = 0                       '/* initialize buffer pointer variable */
   lbyt = 0                         '/* initialize the file pointer variable */
   cbuf = space$(ibuf)                '/* allocate actual source-file buffer */

   for lbyt = 0 to llof - 1 step ibuf  '/* proc.source file in ibuf segments */
      if llof > ibuf then                     '/* so we don't divide by zero */
         cmsg = ltrim$(str$(lbyt \ (llof \ 100))) '/* convert pct. to string */
         cmsg = cmsg + "%"                  '/* append '%' symbol to message */
         i = ifn.msgs("    ", -25, 24, 79, 0, 0)'/* erase prev.complete msg. */
         i = ifn.msgs(cmsg, -25, 24, 79, 0, 0)  '/* show pct. completed msg. */
      end if
      if lbyt + ibuf > llof then        '/* curr.file pointer+ibuf spans EOF */
         i = ifn.setm(cbuf, llof, lbyt, ibuf)   '/* reset source-file buffer */
      end if
      get ifil, lbyt + 1, cbuf         '/* read data into source-file buffer */
      for ibuffbyt = 0 to ibuf - 1    '/* process each byte in source buffer */
         ibitoffs = ibuffbyt * 8   '/* read-from bit position in source file */
         for ibuffbit = 0 to 7          '/* process each bit in current byte */
            l = lfn.rand(lrnd)           '/* get the next pseudorandom value */
            if lrnd < 10 then             '/* the pseudorandom value is <= 9 */
               ibit = lrnd mod 2            '/* odd/even value of only digit */
            else                         '/* the pseudorandom value is >= 10 */
               ibit = (lrnd \ 10) mod 2  '/* odd/even value of last -1 digit */
            end if
            i = bitput(cbuf, ibitoffs + ibuffbit, _
                bitget(cbuf, ibitoffs + ibuffbit) xor ibit)
         next                       '/* XOR each bit in current byte [above] */
      next
      put ifil, lbyt + 1, cbuf        '/* write data from source-file buffer */
   next
   cbuf = ""                           '/* deallocate the source-file buffer */
end function

function ifn.sort(int1(), lnt2(), istk(), imax) '/* array Quicksort function */
   iex1 = 0                          '/* initialize the outer-loop exit flag */
   iex2 = 0                          '/* initialize the inner-loop exit flag */
   ilap = 0                             '/* initialize the low array pointer */
   ilsp = 0                             '/* initialize the low stack pointer */
   irdx = 0                                    '/* initialize the sort radix */
   itap = 0                             '/* initialize the top array pointer */
   itsp = 0                             '/* initialize the top stack pointer */
   iva1 = 0                '/* initialize array value from low stack pointer */
   lva2 = 0                '/* initialize array value from low stack pointer */

   istk(0) = 0                          '/* initialize the low array pointer */
   istk(1) = imax                       '/* initialize the top array pointer */
   while irdx >= 0                             '/* loop until sort radix < 0 */
      ilsp = istk(irdx + irdx)                 '/* set the low stack pointer */
      itsp = istk(irdx + irdx + 1)             '/* set the top stack pointer */
      irdx = irdx - 1                           '/* decrement the sort radix */
      iva1 = int1(ilsp)           '/* get array value from low stack pointer */
      lva2 = lnt2(ilsp)           '/* get array value from low stack pointer */
      ilap = ilsp                              '/* set the low array pointer */
      itap = itsp + 1                          '/* set the top array pointer */
      iex1 = 0                       '/* initialize the outer-loop exit flag */
      while not iex1                 '/* loop to sort within the radix limit */
         itap = itap - 1                 '/* decrement the top array pointer */
         if itap = ilap then        '/* top array pointer==low array pointer */
            iex1 = not 0                 '/* set the outer-loop exit flag ON */
         elseif lva2 > lnt2(itap) then   '/* value @low ptr > value @top ptr */
            int1(ilap) = int1(itap)        '/* swap low and top array values */
            lnt2(ilap) = lnt2(itap)        '/* swap low and top array values */
            iex2 = 0                 '/* initialize the inner-loop exit flag */
            while not iex2         '/* loop to compare and swap array values */
               ilap = ilap + 1           '/* increment the low array pointer */
               if itap = ilap then  '/* top array pointer==low array pointer */
                  iex1 = not 0           '/* set the outer-loop exit flag ON */
                  iex2 = not 0           '/* set the inner-loop exit flag ON */
               elseif lva2 < lnt2(ilap) then '/* value@low ptr<value@low ptr */
                  int1(itap) = int1(ilap)  '/* swap top and low array values */
                  lnt2(itap) = lnt2(ilap)  '/* swap top and low array values */
                  iex2 = not 0           '/* set the inner-loop exit flag ON */
               end if
            wend
         end if
      wend
      int1(ilap) = iva1           '/* put array value from low stack pointer */
      lnt2(ilap) = lva2           '/* put array value from low stack pointer */
      if itsp - ilap > 1 then                   '/* low segment-width is > 1 */
         irdx = irdx + 1                        '/* increment the sort radix */
         istk(irdx + irdx) = ilap + 1            '/* reset low array pointer */
         istk(irdx + irdx + 1) = itsp            '/* reset top array pointer */
      end if
      if itap - ilsp > 1 then                   '/* top segment-width is > 1 */
         irdx = irdx + 1                        '/* increment the sort radix */
         istk(irdx + irdx) = ilsp                '/* reset low array pointer */
         istk(irdx + irdx + 1) = itap - 1        '/* reset top array pointer */
      end if
   wend
end function

function ifn.msgs(cmsg, iofs, irow, icol, ibrp, iext)       '/* display msgs */
   if iofs >= 0 then                                  '/* OK to clear screen */
      cls                                               '/* clear the screen */
   end if
   locate 5, abs(iofs), 1                              '/* locate the cursor */
   print cmsg;                                  '/* display the user message */
   if ibrp then                            '/* OK to sound user-alert (beep) */
      beep                                          '/* sound the user-alert */
   end if
   if iext then                                   '/* OK to exit the program */
      locate 6, 1, 1                                 '/* relocate the cursor */
      close                                         '/* close all open files */
      system                                               '/* return to DOS */
   else                                          '/* do NOT exit the program */
      locate irow, icol, 0                             '/* 'hide' the cursor */
   end if
end function

function ifn.setm(cbuf, llof, lbyt, ibuf)'/* reallocate file buffer & length */
   ibuf = llof - lbyt                   '/* reset maximum file buffer length */
   cbuf = ""                                      '/* deallocate file buffer */
   cbuf = space$(ibuf)                            '/* reallocate file buffer */
end function
