Program u_Parser;
{
version 1.0
(c) Pavel Zampach 2003, zampach@volny.cz
}

{$R+}
{$UNDEF debug}

TYPE
  TElemName = string [64];
  
CONST
  NameChar  : set of char = ['A'..'Z', 'a'..'z', '0'..'9', '_', '-', '.', ':'];
  Space     : set of char = [' ', #9, #10, #13];

VAR 
  infile    : file of char;
  ActElem   : TElemName;
  Stack     : array [0..255] of TElemName;
  LineCount : word;
  c, LastC  : char;
  Status, StackPtr, EmptyCount : byte;
  
procedure error (Reason : string);
begin
  writeln ('Line ', LineCount, ': ', Reason);
  close (infile);
  Halt (1);
end;
  
procedure toStack;
begin
  if ActElem = '' then error ('Element without name');
  inc (StackPtr);
  Stack[StackPtr] := ActElem;
{$IFDEF debug} 
  writeln ('To stack: ', ActElem);
{$ENDIF}
end;  

procedure fromStack;
begin
  if StackPtr = 0 then
    error ('End tag </' + ActElem + '> without open tag');
  if ActElem <> Stack[StackPtr] then
    error ('Mismatched end tag: expected </' + Stack[StackPtr] + '>, got </' + ActElem + '>');
  dec (StackPtr);
  if StackPtr = 0 then inc (EmptyCount);
{$IFDEF debug} 
  writeln ('From stack: ', ActElem);
{$ENDIF}
end;

begin
  if ParamCount <> 1 then begin
    writeln ('Command line syntax error');
    writeln ('Use: u_parser filename');
    Halt (2);
  end;

  c         := #0;
  ActElem   := '';
  Status    := 0; 
  StackPtr  := 0;
  LineCount := 1;
  EmptyCount:= 0;

  assign (infile, ParamStr(1)); reset (infile);
  
  while not eof (infile) do begin
    LastC := c;
    read (infile, c);
    if c = #10 then inc (LineCount);
    
    case Status of
    
{basic status outside of element}
    0 : begin
      if c = '<' then Status := 1;
      if c = '&' then Status := 10;
    end;
    
{'<' was read}
    1 : begin
      if c = '!' then Status := 2;
      if c = '?' then Status := 8;
      if c = '/' then Status := 4;
      if c in NameChar then begin
        ActElem := ActElem + c;
        Status := 3;
      end;
    end;
    
{'<!' was read}
    2 : begin
      if c = '-' then Status := 5 else
      if c = '[' then Status := 6 else
      Status := 9;
    end;
    
{begin tag or empty tag name reading}
    3 : begin
      if c = '<' then error ('Unexpected "<"');
      if c in NameChar then ActElem := ActElem + c;
      if c in Space then Status := 7;
      if c = '>' then begin
        toStack;
        if LastC = '/' then fromStack;
        Status := 0;
        ActElem := '';
       end;  
    end;
    
{end tag name reading}
    4 : begin
      if c in NameChar then ActElem := ActElem + c else
      if c = '>' then begin
        fromStack;
        ActElem := '';
        Status := 0;
      end else
      error ('Unexpected char');
    end;
    
{'<!-' was read}
    5 : begin
      if (c = '>') and (LastC = '-') then Status := 0;
    end;
    
{'<![' was read}
    6 : begin
      if (c = '>') and (LastC = ']') then Status := 0;
    end;
    
{rest of tag reading}
    7 : begin
      if c = '<' then error ('Unexpected "<"');
      if c = '>' then begin
        toStack;
        if LastC = '/' then fromStack;
        Status := 0;
        ActElem := '';
       end;  
    end;
    
{'<?' was read}
    8 : begin
      if (c = '>') and (LastC = '?') then Status := 0;
    end;

{'<!' was read}
    9 : begin
      if c = '>' then Status := 0;
    end;
    
{'&' was read}
    10 : begin
      if c = ';' then Status := 0;
    end;
    
    end;  {case}
  end;    {WITH}
  
  if StackPtr > 0   then error ('End tag </' + Stack[StackPtr] + '> missing');
  if Status > 0     then error ('Unclosed tag, comment, PI etc.');
  if EmptyCount = 0 then error ('No element');
  if EmptyCount > 1 then error ('No root element');
  close (infile);
end.