#include "syncdir.h"
#include <setjmp.h>
#include <string.h>
#include <ctype.h>

static void fixList(char *lst)
{
  lst = strchr(lst, ';');
  while (lst)
  {
    *lst = 0;
    lst++;
    while (*lst == ';')
      memmove(lst+1, lst, strlen(lst));
    lst = strchr(lst, ';');
  }
}

static void parseError(const char *str)
{
  showHelp(str);
  longjmp(jmpbuf, SYNCDIR_ERROR_PARSE);
}

/*
   0 = program name
   1 = source
   2 = dest | first option
*/
BOOL parse(int argc, char **argv)
{
  if (argc < 3)
    parseError((argc == 1) ? 0 : HELP_NOT_ENOUGH_ARGS);
  else if (argv[1][0] == SWITCHCHAR)
    parseError(HELP_NO_SOURCE);
  else
  {
    char ixFlag = 0; /* 0 = none, 'i' = /i, 'x' = /x */
    int ii;
    source = fileTableInit(argv[1], FALSE);
    if (!source)
      longjmp(jmpbuf, SYNCDIR_ERROR_SOURCE);
    if (argv[2][0] == SWITCHCHAR)    
    {
      ii = 2;
      dest = fileTableInit("", FALSE);
    } else
    {
      ii = 3;
      dest = fileTableInit(argv[2], TRUE);
    }
    if (!dest)
      longjmp(jmpbuf, SYNCDIR_ERROR_DEST);

    for ( ; ii < argc; ii++)
    {
      const char *opt = argv[ii];
      while (*opt)
      {
        if (*opt == SWITCHCHAR)
        {
          opt++;
          switch (*opt)
          {
            case 'a': optionSet(0, OPT_ADD); break;
            case 'b': optionSet(0, OPT_BOTH); break;
            case 'c': optionSet(0, OPT_COPY); break;
            case 'd': 
              if (opt[1] == 'd')
              {
                optionSet(0, OPT_DELETE_DIR);
                opt++;
              } else if (opt[1] && opt[1] != SWITCHCHAR)
                parseError(HELP_BAD_DELETE_OPTION);
              else
                optionSet(0, OPT_DELETE);
              break;
            case 'f':
              opt++;
              if (!*opt || (*opt == SWITCHCHAR))
              {
                optionSet(0, OPT_FORCE_ALL);
                opt--;
              } else
              {
                while (*opt && (*opt != SWITCHCHAR))
                {
                  switch (*opt)
                  {
                    case 'a': optionSet(0, OPT_FORCE_ADD); break;
                    case 'u':
                    case 'c': optionSet(0, OPT_FORCE_COPY); break;
                    case 'd': optionSet(0, OPT_FORCE_DELETE); break;
                    default:
                      parseError(HELP_BAD_FORCE_OPTION);
                  }
                  opt++;
                }
                opt--;
              }
              break;
            case 'g':
              opt++;
              if (!isdigit(*opt))
                parseError(HELP_BAD_GRANULARITY);
              else
              {
                granularity = 0;
                while (isdigit(*opt))
                {
                  granularity = (granularity * 10) + (*opt - '0');
                  opt++;
                }
              }
              break;
            case 'l':
              {
                int len;
                logFileName[0] = 0;
                logFileName[1] = 0;
                for (opt++ ; ; opt++)
                {
                  if (*opt == '+')
                    logFileName[0] = '+';
                  else if (*opt == '!')
                    optionSet(0, OPT_LOG_ERRORS);
                  else
                    break;
                }
                for (len = 0; opt[len] && (opt[len] != SWITCHCHAR); len++)
                  ;
                if (len)
                {
                  strncat(logFileName, opt, len);
                } else
                  strcat(logFileName, "syncdir.log");
                opt += len - 1;
              }
              break;
            case 'n': optionSet(0, OPT_NOACTION); break;
            case 'q': optionSet(0, OPT_QUIET); break;
            case 'r': optionSet(0, OPT_RECURSE); break;
            case 'u': optionSet(0, OPT_UPDATE); break;
            case 'v': optionSet(0, OPT_VERBOSE); break;
            case 't': optionSet(0, OPT_RESET_ACCESS); break;
            case 'i': 
            case 'x':
              {
                char *ptr = (*opt == 'i') ? includeList : excludeList;
                int   len;
                ixFlag = *(opt++);
                for (len = 0; opt[len] && (opt[len] != SWITCHCHAR); len++)
                  ;
                if (len)
                {
                  if (*ptr)
                    strcat(ptr, ";");
                  strncat(ptr, opt, len);
                } 
                opt += len - 1;
              }
              break;
            default:
              parseError(HELP_BAD_SWITCH);
          }
          opt++;
        } else if (ixFlag)
        {
          char *ptr = (ixFlag == 'i') ? includeList : excludeList;
          if (*ptr)
            strcat(ptr, ";");
          strcat(ptr, opt);
          opt += strlen(opt);
        } else 
          parseError(HELP_BAD_SWITCH);
      }
    }
  }
  /*
     good sign. now for a little more testing...
  */
  if (optionTest(OPT_BOTH | OPT_ADD | OPT_DELETE))
    parseError(HELP_NO_B_A_D);
  else if (optionTest(OPT_COPY | OPT_UPDATE))
    parseError(HELP_NO_C_U);
  else if (includeList[0] == 0)
    strcpy(includeList, "*");
  fixList(includeList);
  fixList(excludeList);
  return TRUE;
}
