;-------------------------------------------------------------;
;CARPET uses the undocumented function 16 hex of the INT5F to ;
;draw different patterns on the screen. Runs only on HP200LX. ;
;CARPET loops endless, always changing the patterns.          ;
;Input: Esc = Exit program                                    ;
;       a-z = Change pattern manually                         ;
;any other key suspends drawing. Press any key to resume.     ;
;-------------------------------------------------------------;
;V1.0 Written by Stefan Peichl. Feel free to modify the source;
;-------------------------------------------------------------;
cseg   segment 'code'
assume cs:cseg,ds:cseg,es:cseg
org    100h

  start: 
mov    ax,4dd4h    ;check for HP
int    15h
cmp    dh,2        ;is it a 200LX?
jne    exit        ;no
mov    cx,639      ;use full screen width
mov    dx,199      ;use full screen height
mov    si,1        ;use 1 pixel line thickness
mov    bp,5        ;start with radius increment 5
  cls:
mov    ax,6        ;set graphics mode
int    5fh         ;using int5f
mov    ax,0a03h    ;set rule: XOR drawing on screen
int    5fh
xor    di,di       ;circle radius startup value = 0
  draw:
mov    ax,1600h    ;draw round shaped box with radius di
int    5fh
mov    ah,1        ;check for a key
int    16h
jne    input       ;a key has been pressed
  radius:
add    di,bp       ;increment radius
cmp    di,1350     ;still on screen?
jle    draw        ;yes, output
dec    bp          ;use lower radius increment
jne    cls         ;unless not 0
mov    bp,16       ;otherwise use 16
jmp    short cls   ;and start new
  input:
xor    ax,ax       ;read out key
int    16h
cmp    ax,011bh    ;Esc?
je     restore     ;yes, restore screen
xor    ah,ah       ;delete scan code
cmp    al,'a'
jb     suspend
cmp    al,'z'
ja     suspend
sub    al,96       ;convert a-z to 1-26
mov    bp,ax       ;and use it as new radius increment
jmp    short cls
  suspend:
xor    ax,ax       ;wait for any key
int    16h
jmp    short radius;and continue drawing
  restore:
mov    ax,3        ;80x25 text
int    10h
  exit:
int    20h         ;quit
cseg   ends
       end start
