/*
 * RUN Version 1.00
 * Run exm program under the MoreEXM
 * Copyright(C) 1995 Hiroyuki Sekiya
 */

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include "morelib.h"

#ifndef MAXPATH
#define MAXPATH	80
#endif

unsigned hotkey = 0;

void fatal(const char *msg)
{
	fputs(msg, stderr);
	exit(1);
}

void usage(void)
{
	fputs("RUN Version 1.00 Copyright(C) 1995 Hiroyuki Sekiya\n", stderr);
	fputs("Usage: run [-k<HOTKEY>] <FILENAME[.EXM]>\n", stderr);
	exit(1);
}

unsigned xtoi(char *hex)
{
	unsigned result;

	for (result=0; *hex != '\0'; hex++) {
		result <<= 4;
		if ('0' <= *hex && *hex <= '9')			result |= *hex - '0';
		else if ('a' <= *hex && *hex <= 'f')	result |= *hex - 'a' + 10;
		else if ('A' <= *hex && *hex <= 'F')	result |= *hex - 'A' + 10;
		else									return 0;
	}
	return result;
}

void PushKey(unsigned Code)
{
	_asm {
		mov		cx, [Code]
		mov		ah, 05h
		int		16h
	};
}

int IsInSysMgr(void)
{
	_asm {
		mov		ax, 5101h
		int		15h
		cmp		ax, 7072h
		mov		ax, 1
		je		done
		dec		ax
done:
	};
}

int exist(const char *filename)
{
	int Handle;

	if ((Handle = open(filename, O_RDONLY)) < 0)
		return 0;
	close(Handle);
	return 1;
}

int GetUnusedSocket(void)
{
	APPINF Info;
	int Socket, Max, Flag;

	Max = MoreUsedSockets() + MoreFreeSockets();
	for (Socket=0; Socket<Max; ++Socket) {
		switch (MoreAppInfo(Socket, &Info, &Flag)) {
		case 0:
			if ((Flag & 0x0001)==0 && (MoreGetFlags(Socket) & FL_LOCKED)==0)
				return Socket;		/* bNĂȂH */
			break;
		case 1:
			return Socket;			/* o^H */
		}
	}
	return -1;
}

/* EXMwb_[h */
int LoadExmHeader(APPINF *info)
{
	int Handle;

	if ((Handle = open(info->Path, O_RDONLY)) < 0) return -1;
	read(Handle, info->ExmHeader, sizeof(info->ExmHeader));
	close(Handle);
	return 0;
}

void loadexm(const char *filename)
{
	APPINF AppInf;
	int Socket;
	char tmpname[MAXPATH];
	int Result;

	/* %EXMPATH%%PATH%ătpXɊg */
	strcpy(tmpname, filename);
	if (strchr(tmpname, '.') == NULL) strcat(tmpname, ".exm");
	if (exist(tmpname))
		strcpy(AppInf.Path, tmpname);
	else {
		_searchenv(tmpname, "EXMPATH", AppInf.Path);
		if (AppInf.Path[0] == '\0') {
			_searchenv(tmpname, "PATH", AppInf.Path);
			if (AppInf.Path[0] == '\0')
				strcpy(AppInf.Path, tmpname);
		}
	}
	strncpy(AppInf.ExtName, filename, sizeof(AppInf.ExtName));

	if ((Socket = MoreSearchByPath(AppInf.Path)) >= 0) {
		/* pXœo^ς */
		MoreAppInfo(Socket, &AppInf, &Result);
		if (LoadExmHeader(&AppInf) == 0)
			MoreRegisterApp(Socket, &AppInf);
	} else if ((Socket = GetUnusedSocket()) >= 0) {
		/* o^\\Pbg */
		if (LoadExmHeader(&AppInf) != 0)
			fatal("Error: File not found.\n");
		if (hotkey != 0) {
			AppInf.HotKey = hotkey;
			Result = MoreRegisterApp(Socket, &AppInf);
		} else {
			for (AppInf.HotKey=0x80FF; AppInf.HotKey<0x8CFF; AppInf.HotKey+=0x100) {
				if ((Result = MoreRegisterApp(Socket, &AppInf)) == 0)
					break;
				if (Result == 1)
					continue;
			}
		}
		switch (Result) {
		case 0: break;
		case 1: fatal("Error: Same hotkey is used.\n");
		case 2: fatal("Error: Apprication is now running.\n");
		default: fatal("Error: Registration error.\n");
		}
	} else
		fatal("Error: Socket is full.\n");

	/* NL[vbV */
	PushKey(AppInf.HotKey);
}

int main(int argc, char *argv[])
{
	int i;

	if (argc < 2) usage();
	if (!IsInSysMgr()) fatal("Error: Not running sysmgr.\n");
	if (MoreInit() != 0) fatal("Error: Cannot access MoreEXM API.\n");

	for (i=1; i<argc; i++)
		if (argv[i][0] == '-' || argv[i][0] == '/')
			switch (toupper(argv[i][1])) {
			case 'K':
				hotkey = xtoi(&argv[i][2]);
				break;
			default:
				usage();
			}
	for (i=1; i<argc; i++)
		if (argv[i][0] != '-' && argv[i][0] != '/') {
			loadexm(argv[i]);
			break;
		}

	return 0;
}
