\ Fifteen Puzzle
\ P. Zampach (zampach@volny.cz), 2002

 500 SEPSSEG  
6000 200 MSDOSEXE

I80186
INCLUDE HPLXGR1
INCLUDE HPLX1
INCLUDE RAND
INCLUDE CARDS1
INCLUDE FILES1

DECIMAL

315 CONSTANT F1
316 CONSTANT F2
317 CONSTANT F3
318 CONSTANT F4
319 CONSTANT F5
320 CONSTANT F6
324 CONSTANT F10

VARIABLE StackPtr
VARIABLE HiStack
VARIABLE StackMrk
VARIABLE BackGame
VARIABLE fileid
VARIABLE from
VARIABLE to
CREATE nulltxt 0 C,
SCONSTANT fname FIFTEEN.DAT"


3200 CONSTANT storageLen
1000 CONSTANT storage \ must be greater then "Last used DSEG location" (854)

120 CONSTANT CardArrayLen
storage storageLen + CONSTANT CardArray
2 1 IN/OUT
\ [1..15,1..4]
: CardArray[] ( a b -- adr )
  1- 2* SWAP 1- 8 * + CardArray +
;

30 CONSTANT CardNoLen
CardArray CardArrayLen + CONSTANT CardNo
1 1 IN/OUT
\ [1..15]
: CardNo[] ( a -- adr )
  1- 2* CardNo +
;

250 CONSTANT StackLen
CardNo CardNoLen + CONSTANT Stack
1 1 IN/OUT
\ [1..StackLen] of byte
: Stack[] ( a -- adr )
  1- Stack +
;


\ ----- help routines -----

1 1 IN/OUT
: UPCASE  ( char -- CHAR )
   DUP [CHAR] a >= IF
     DUP [CHAR] z <= IF
       BL -
     THEN
   THEN
;

1 0 IN/OUT
: TIOR ( ior -- )
  IF
    GraphicsOff
    ." File error!"
    13 EMIT 10 EMIT
    BYE
  THEN
;

0 1 IN/OUT
: EKEY ( -- keycode )
  KEY ?DUP 0= IF
    KEY 256 +
  THEN
;

\ ----- program routines -----

2 2 IN/OUT
: CoXY  ( a ca -- x y )
  OVER 1- 5 / 65 * >R
  1- 16 * SWAP
  1- 5 MOD 124 * 35 + +
  R>
;


2 0 IN/OUT
: DrawCard ( a ca -- )
  2DUP CardArray[] @ -ROT CoXY 0 DisplayCard
;


2 0 IN/OUT
: InvertCard ( a ca -- )
  G_XOR SetReplacementRule
  BLACK Pen
  CoXY OVER wc + OVER hc + 1 DrawRectangle
  G_FORCE SetReplacementRule
;


2 0 IN/OUT
: WipeCard ( a ca -- )
  WHITE Pen
  CoXY OVER wc + OVER hc + 1 DrawRectangle
  BLACK Pen
;


0 0 IN/OUT
: LoadGame
  StackPtr  6            fileid @ READ-FILE TIOR DROP \ read 3 variables
  Stack     HiStack @    fileid @ READ-FILE TIOR DROP
  CardNo    CardNoLen    fileid @ READ-FILE TIOR DROP
  CardArray CardArrayLen fileid @ READ-FILE TIOR DROP
  fileid @ CLOSE-FILE TIOR
  fname COUNT DELETE-FILE TIOR
;


0 0 IN/OUT
: SaveGame
  fname COUNT W/O CREATE-FILE TIOR
  fileid !
  StackPtr  6            fileid @ WRITE-FILE TIOR     \ store 3 variables
  Stack     HiStack @    fileid @ WRITE-FILE TIOR
  CardNo    CardNoLen    fileid @ WRITE-FILE TIOR
  CardArray CardArrayLen fileid @ WRITE-FILE TIOR
  fileid @ CLOSE-FILE TIOR
;


0 0 IN/OUT
: InitGame
  StackPtr OFF
  HiStack  OFF
  StackMrk OFF
  RANDOMIZE Shuffle Shuffle
  16 1 DO
    I 3 = I 8 = OR IF
      I CardNo[] OFF
    ELSE
      4 I CardNo[] !
      5 1 DO
        GetNewCard J I CardArray[] !
      LOOP
    THEN
  LOOP
;


0 0 IN/OUT
: Init
  fname COUNT R/O OPEN-FILE
  IF         \ blank game
    DROP     \ dummy fileid
    InitGame
  ELSE       \ file opened succesfully
    fileid !
    LoadGame
  THEN
  \ draw screen
  GraphicsOn
  16 1 DO
    I CardNo[] @ IF
      I CardNo[] @ 1+ 1 DO
        J I DrawCard
      LOOP
    THEN
    MediumFont
    I 1 CoXY SWAP 12 - SWAP 22 + AT-GRXY
    I 64 + EMIT
  LOOP

  1 C" Help"   SetLabel
  2 C" Back"   SetLabel
  3 C" Forwd"  SetLabel
  4 C" Mark"   SetLabel
  5 C" ToMark" SetLabel
  6 C" ToFree" SetLabel
  7 nulltxt    SetLabel
  8 nulltxt    SetLabel
  9 nulltxt    SetLabel
 10 C" Exit"   SetLabel

 TRUE BackGame !
;


2 0 IN/OUT
: MoveCard ( from to -- )
  DUP CardNo[] 1 SWAP +!
  OVER DUP CardNo[] @ CardArray[] @ >R
  DUP  DUP CardNo[] @ CardArray[] R> <-
  OVER DUP CardNo[] @ WipeCard
  OVER CardNo[] -1 SWAP +!
  OVER CardNo[] @ IF
    OVER DUP CardNo[] @ DrawCard
  THEN
  DUP CardNo[] @ DrawCard       \ wipe TO from stack
  DROP                          \ wipe FROM from stack
;


1 0 IN/OUT
: Moving ( from -- )
  DUP from !
  CardNo[] @ 0= IF
    EXIT
  THEN
  from @ DUP CardNo[] @ InvertCard
  EKEY UPCASE 64 - to !
  \ conditions
  from @ DUP CardNo[] @ CardArray[] @ card
  to   @ DUP CardNo[] @ CardArray[] @ card <>
  to @ CardNo[] @    AND
  to @ CardNo[] @ 4 = OR
  to @ from @ =       OR
  to @ 15 >           OR
  to @  1 <           OR
  IF
    from @ DUP CardNo[] @ InvertCard
    EXIT
  THEN

  from @ to @ MoveCard

  StackPtr @ StackLen < IF
    1 StackPtr +!
  ELSE
    1 StackPtr !
  THEN
  StackPtr @ HiStack !
  StackMrk @ StackPtr @ > IF
    StackPtr @ StackMrk !
  THEN
  to @ 4 LSHIFT from @ OR StackPtr @ Stack[] C!

  BackGame OFF
  16 1 DO
    I CardNo[] @ DUP 1 >= SWAP 3 <= AND IF
      TRUE BackGame !
    THEN
    I CardNo[] @ 4 = IF
      BackGame @
      5 2 DO
        J 1 CardArray[] @ card
        J I CardArray[] @ card <> OR
      LOOP
      BackGame !
    THEN
  LOOP
;


0 0 IN/OUT
: BackStep
  StackPtr @ IF
    StackPtr @ Stack[] C@ DUP 4 RSHIFT SWAP 15 AND MoveCard
    -1 StackPtr +!
  THEN
;


0 0 IN/OUT
: ForwStep
  StackPtr @ HiStack @ < IF
    1 StackPtr +!
    StackPtr @ Stack[] C@ DUP 15 AND SWAP 4 RSHIFT MoveCard
  THEN
;


0 0 IN/OUT
: Help
  169 49 470 130 storage StoreArea
  170 50 460 120 C" Fifteen puzzle 1.2" 1 DrawTitleBox
  SmallFont
  200  67 AT-GRXY ." Pavel Zampach, 2002"
  200  75 AT-GRXY ." A-O piles   F10 Exit"
  200  83 AT-GRXY ." <- or F2 Back"
  200  91 AT-GRXY ." space or F3 Forward"
  200  99 AT-GRXY ." F4 Mark  F5 Back to mark"
  200 108 AT-GRXY ." F6 Back to free"
  EKEY DROP
  169 49 storage G_FORCE PlaceArea
;


0 0 IN/OUT
: ToMark
  BEGIN
    StackPtr @ StackMrk @ <>
  WHILE
    StackPtr @ StackMrk @ > IF
      BackStep
    ELSE
      ForwStep
    THEN
  REPEAT
;


0 0 IN/OUT
: ToFree
  BEGIN
    TRUE
    16 1 DO
      I CardNo[] @ 0> AND
    LOOP
  WHILE
    BackStep
  REPEAT
;


0 1 IN/OUT
: EndGame ( -- end_of_game )
  170 50 470 130 C" Game over" 1 DrawTitleBox
  220 75 AT-GRXY
  BackGame @ IF
    ." Game interrupted"
  ELSE
    ." Congratulations!" 
  THEN
  220 90  AT-GRXY StackPtr @ U. ." moves"
  220 105 AT-GRXY ." Play again (Y/N)?"
  EKEY UPCASE [CHAR] Y <>
;

0 0 IN/OUT
: MAIN
  HPX 0= IF
    ." Game for HP100/200LX only"
    13 EMIT 10 EMIT
    BYE
  THEN

  BEGIN
    Init
    BEGIN
      EKEY UPCASE  ( -- char )
      DUP F1 = IF Help THEN
      DUP [CHAR] A >= OVER [CHAR] O <= AND IF
        DUP 64 - Moving
      THEN
      DUP  8 = OVER F2 = OR IF BackStep THEN
      DUP BL = OVER F3 = OR IF ForwStep THEN
      DUP F4 = IF StackPtr @ StackMrk ! THEN
      DUP F5 = IF ToMark THEN
      DUP F6 = IF ToFree THEN
      F10 =  BackGame @ 0= OR    \ wipe the stack
    UNTIL
    EndGame
  UNTIL
  BackGame @ IF SaveGame THEN
  GraphicsOff
;

INCLUDE FILES2
INCLUDE CARDS2
INCLUDE HPLX2
INCLUDE HPLXGR2
INCLUDE FORTHLIB

END
