DECIMAL

\ Example of Forth's possibility: triangular array with non-linear constructor
CREATE P   \ positions of symbols
21 C, 28 C,
21 C, 15 C, 21 C, 42 C,
21 C, 15 C, 21 C, 42 C, 21 C, 28 C,
13 C, 15 C, 29 C, 15 C, 13 C, 42 C, 29 C, 42 C,
13 C, 15 C, 29 C, 15 C, 13 C, 42 C, 29 C, 42 C, 21 C, 28 C,
13 C, 15 C, 29 C, 15 C, 13 C, 28 C, 29 C, 28 C, 13 C, 41 C, 29 C, 41 C,
13 C, 15 C, 29 C, 15 C, 21 C, 22 C, 13 C, 28 C, 29 C, 28 C, 13 C, 41 C, 29 C, 41 C,
13 C, 15 C, 29 C, 15 C, 13 C, 24 C, 29 C, 24 C, 13 C, 33 C, 29 C, 33 C, 13 C, 42 C, 29 C, 42 C,
13 C, 15 C, 29 C, 15 C, 13 C, 24 C, 29 C, 24 C, 13 C, 33 C, 29 C, 33 C, 13 C, 42 C, 29 C, 42 C, 21 C, 19 C,
13 C, 15 C, 29 C, 15 C, 13 C, 24 C, 29 C, 24 C, 13 C, 33 C, 29 C, 33 C, 13 C, 42 C, 29 C, 42 C, 21 C, 19 C, 21 C, 37 C,

2 2 IN/OUT
\ [1..13, 0..9]
: P[a,b] ( a b -- P[a,b] P[a,b+1] )
  SWAP DUP 1- * + P +
  DUP C@ SWAP 1+ C@
;

\ Deck of cards
CREATE Deck
1 C, 0 C, 2 C, 0 C, 3 C, 0 C,  4 C,  0 C,  5 C,  0 C,  6 C,  0 C,
7 C, 0 C, 8 C, 0 C, 9 C, 0 C, 10 C,  0 C, 11 C,  0 C, 12 C,  0 C, 13 C, 0 C,
1 C, 1 C, 2 C, 1 C, 3 C, 1 C,  4 C,  1 C,  5 C,  1 C,  6 C,  1 C,
7 C, 1 C, 8 C, 1 C, 9 C, 1 C, 10 C,  1 C, 11 C,  1 C, 12 C,  1 C, 13 C, 1 C,
1 C, 2 C, 2 C, 2 C, 3 C, 2 C,  4 C,  2 C,  5 C,  2 C,  6 C,  2 C,
7 C, 2 C, 8 C, 2 C, 9 C, 2 C, 10 C,  2 C, 11 C,  2 C, 12 C,  2 C, 13 C, 2 C,
1 C, 3 C, 2 C, 3 C, 3 C, 3 C,  4 C,  3 C,  5 C,  3 C,  6 C,  3 C,
7 C, 3 C, 8 C, 3 C, 9 C, 3 C, 10 C,  3 C, 11 C,  3 C, 12 C,  3 C, 13 C, 3 C,

1 1 IN/OUT
\ [1..52]
: Deck[] ( n -- adr )
  1- 2* Deck +
;

\ images of card suit
CREATE Spade
1 C, 0 C, 1 C, 0 C, 8 C, 0 C, 8 C, 0 C, 16 C, 56 C, 124 C, 254 C, 254 C, 108 C, 16 C, 56 C,

CREATE Diamond
1 C, 0 C, 1 C, 0 C, 8 C, 0 C, 8 C, 0 C, 16 C, 40 C, 68 C, 130 C, 130 C, 68 C, 40 C, 16 C,

CREATE Club
1 C, 0 C, 1 C, 0 C, 8 C, 0 C, 8 C, 0 C, 16 C, 56 C, 56 C, 108 C, 254 C, 108 C, 16 C, 56 C,

CREATE Heart
1 C, 0 C, 1 C, 0 C, 8 C, 0 C, 8 C, 0 C, 108 C, 146 C, 130 C, 130 C, 130 C, 68 C, 40 C, 16 C,

\ images
CREATE Jack
   1 C,   0 C,   1 C,   0 C,  24 C,   0 C,  35 C,   0 C, 255 C, 255 C, 248 C, 135 C, 130 C,
   8 C, 130 C,  60 C,   8 C, 129 C, 228 C,   8 C, 129 C,  44 C,   8 C, 129 C,  66 C,  72 C,
 130 C,  78 C, 200 C, 130 C, 228 C, 200 C, 132 C, 156 C, 104 C, 153 C,   2 C, 232 C, 240 C,
   1 C, 184 C, 152 C,  32 C, 232 C, 140 C, 113 C, 168 C, 158 C,  35 C,  24 C, 155 C,   6 C,
 200 C, 141 C, 252 C, 200 C, 140 C,  81 C, 136 C, 140 C, 249 C, 136 C, 140 C,  81 C, 136 C,
 153 C, 253 C, 136 C, 155 C,   6 C, 200 C, 198 C,  35 C, 200 C, 172 C, 113 C, 136 C, 184 C,
  32 C, 200 C, 236 C,   0 C, 120 C, 186 C,   4 C, 200 C, 177 C, 201 C,   8 C, 153 C,  58 C,
   8 C, 155 C, 146 C,   8 C, 146 C,  20 C,   8 C, 129 C, 164 C,   8 C, 129 C,  60 C,   8 C,
 129 C, 226 C,   8 C, 130 C,  15 C,   8 C, 255 C, 255 C, 248 C,

CREATE Queen
   1 C,   0 C,   1 C,   0 C,  24 C,   0 C,  35 C,   0 C, 255 C, 255 C, 248 C, 130 C,  21 C,
   8 C, 130 C, 169 C,   8 C, 129 C,  14 C,   8 C, 129 C,  74 C,   8 C, 145 C, 107 C,   8 C,
 168 C, 154 C, 136 C, 146 C, 106 C,   8 C, 156 C,   5 C, 136 C, 178 C,  74 C, 104 C, 241 C,
  82 C,  24 C, 145 C,  36 C,  72 C, 180 C, 164 C,   8 C, 240 C, 132 C, 136 C, 146 C,  72 C,
  24 C, 144 C,  73 C,  24 C, 176 C,  48 C,  40 C, 162 C, 114 C,  40 C, 160 C,  80 C, 104 C,
 196 C, 144 C,  72 C, 192 C, 138 C,  72 C, 136 C, 136 C, 120 C, 129 C,  37 C, 104 C, 145 C,
  36 C,  72 C, 194 C,  82 C, 120 C, 178 C, 146 C, 104 C, 141 C,   1 C, 200 C, 130 C, 178 C,
  72 C, 138 C, 200 C, 168 C, 134 C, 180 C,  72 C, 130 C, 148 C,   8 C, 131 C, 132 C,   8 C,
 132 C, 170 C,   8 C, 132 C,  66 C,   8 C, 255 C, 255 C, 248 C,

CREATE King
   1 C,   0 C,   1 C,   0 C,  24 C,   0 C,  35 C,   0 C, 255 C, 255 C, 248 C, 133 C,  37 C,
   8 C, 130 C, 170 C,   8 C, 129 C, 252 C,   8 C, 129 C,  68 C, 104 C, 129 C,  84 C, 104 C,
 130 C,  72 C, 104 C, 130 C, 152 C, 104 C, 133 C,  72 C, 104 C, 137 C,  87 C, 104 C, 148 C,
  18 C, 232 C, 242 C,  10 C, 120 C, 137 C,   0 C, 248 C, 132 C, 148 C,  88 C, 130 C,  84 C,
 104 C, 225 C,  36 C, 120 C, 158 C, 144 C,   8 C, 128 C,  72 C,   8 C, 128 C,  39 C, 200 C,
 241 C,  18 C,  56 C, 177 C,  73 C,   8 C, 209 C,  68 C, 136 C, 248 C,   2 C,  72 C, 242 C,
 129 C,  56 C, 186 C,  64 C, 200 C, 183 C,  84 C, 136 C, 176 C, 149 C,   8 C, 176 C, 202 C,
   8 C, 176 C, 146 C,   8 C, 177 C,  84 C,   8 C, 177 C,  20 C,   8 C, 129 C, 252 C,   8 C,
 130 C, 170 C,   8 C, 133 C,  37 C,   8 C, 255 C, 255 C, 248 C,

?DEFINE DisplayBack [IF]
CREATE CardBack \ image of card back
   1 C,   0 C,   1 C,   0 C,  42 C,   0 C,  49 C,   0 C, 170 C, 170 C, 170 C, 170 C, 170 C,
 160 C,  85 C,  85 C,  85 C,  85 C,  85 C,  80 C, 170 C, 170 C, 170 C, 170 C, 170 C, 160 C,
  85 C,  85 C,  85 C,  85 C,  85 C,  80 C, 170 C, 170 C, 170 C, 170 C, 170 C, 160 C,  85 C,
  85 C,  85 C,  85 C,  85 C,  80 C, 170 C, 170 C, 170 C, 170 C, 170 C, 160 C,  85 C,  85 C,
  85 C,  85 C,  85 C,  80 C, 170 C, 170 C, 170 C, 170 C, 170 C, 160 C,  85 C,  85 C,  85 C,
  85 C,  85 C,  80 C, 170 C, 170 C, 170 C, 170 C, 170 C, 160 C,  85 C,  85 C,  85 C,  85 C,
  85 C,  80 C, 170 C, 171 C, 254 C, 170 C, 170 C, 160 C,  85 C,  87 C,   2 C,  85 C,  85 C,
  80 C, 170 C, 174 C,  43 C,  42 C, 170 C, 160 C,  85 C,  92 C,  85 C,  21 C,  85 C,  80 C,
 170 C, 168 C, 170 C, 170 C, 170 C, 160 C,  85 C,   3 C,  85 C,  85 C,  85 C,  80 C, 170 C,
 168 C, 170 C, 170 C, 170 C, 160 C,  85 C,  93 C,  95 C, 245 C,  85 C,  80 C, 170 C, 168 C,
 184 C,  18 C, 170 C, 160 C,  85 C,  93 C, 113 C,  89 C,  85 C,  80 C, 170 C, 168 C, 226 C,
 168 C, 170 C, 160 C,  85 C,  93 C,  69 C,  85 C,  85 C,  80 C, 170 C, 168 C, 234 C, 170 C,
 170 C, 160 C,  85 C,  93 C,  69 C,  85 C,  85 C,  80 C, 170 C, 172 C, 235 C, 170 C, 170 C,
 160 C,  85 C,  86 C,  71 C,  21 C,  85 C,  80 C, 170 C, 171 C, 254 C,  42 C, 170 C, 160 C,
  85 C,  85 C,  64 C,  85 C,  85 C,  80 C, 170 C, 170 C, 234 C, 170 C, 170 C, 160 C,  85 C,
  85 C,  69 C,  85 C,  85 C,  80 C, 170 C, 170 C, 234 C, 170 C, 170 C, 160 C,  85 C,  85 C,
 101 C,  93 C,  85 C,  80 C, 170 C, 170 C, 178 C, 184 C, 170 C, 160 C,  85 C,  85 C,  95 C,
 241 C,  85 C,  80 C, 170 C, 170 C, 168 C,   2 C, 170 C, 160 C,  85 C,  85 C,  85 C,  85 C,
  85 C,  80 C, 170 C, 170 C, 170 C, 170 C, 170 C, 160 C,  85 C,  85 C,  85 C,  85 C,  85 C,
  80 C, 170 C, 170 C, 170 C, 170 C, 170 C, 160 C,  85 C,  85 C,  85 C,  85 C,  85 C,  80 C,
 170 C, 170 C, 170 C, 170 C, 170 C, 160 C,  85 C,  85 C,  85 C,  85 C,  85 C,  80 C, 170 C,
 170 C, 170 C, 170 C, 170 C, 160 C,  85 C,  85 C,  85 C,  85 C,  85 C,  80 C, 170 C, 170 C,
 170 C, 170 C, 170 C, 160 C,  85 C,  85 C,  85 C,  85 C,  85 C,  80 C, 170 C, 170 C, 170 C,
 170 C, 170 C, 160 C,
[THEN]

VARIABLE CardPtr
VARIABLE suitadr
VARIABLE crd


0 0 IN/OUT
U: Shuffle ( -- )
  200 0 DO
    52 RND 1+ Deck[]
    DUP @
    52 RND 1+ Deck[]
    DUP @
    -ROT ! SWAP !
  LOOP
  CardPtr OFF
;

0 1 IN/OUT
U: GetNewCard ( -- card )
  CardPtr @ 52 >= IF Shuffle THEN
  CardPtr @ 1+ DUP CardPtr !
  Deck[] @
;


U: DisplayCard ( card x y TopOnly -- )
  >R LogOrig
  DUP card crd !
  suit 16 * Spade + suitadr !  \ address of suit image
  G_FORCE SetReplacementRule
  WHITE Pen
  0 0 wc
  R@ IF 13 ELSE hc THEN
  1 DrawRectangle

  BLACK Pen
  1  0  wc 1- HorizLine
  R@ IF   \ if TopOnly
    0      1      hc 1- VertLine
    wc     1      hc 1- VertLine
    wc 1-  1      hc 1- VertLine
  ELSE
    wc     1      hc 1- VertLine
    1      hc     wc 1- HorizLine
    0      1      hc 1- VertLine
    wc 1-  1      hc 1- VertLine
    1      hc 1-  wc 1- HorizLine
  THEN
  MediumFont
  crd @ CASE
     1 OF [CHAR] A CardChr ENDOF
    11 OF [CHAR] J CardChr ENDOF
    12 OF [CHAR] Q CardChr ENDOF
    13 OF [CHAR] K CardChr ENDOF
    10 OF [CHAR] 1 CardChr
          [CHAR] 0 7 2 AT-GRXY EMIT ENDOF
 \  default
    crd @ [CHAR] 0 + CardChr
  ENDCASE
  BLACK Pen
  21 2 suitadr @ G_FORCE PlaceArea
  R> IF       \ if TopOnly
    0 0 LogOrig
    EXIT
  THEN
  crd @ CASE
    11 OF 14 12 Jack  G_FORCE PlaceArea ENDOF
    12 OF 14 12 Queen G_FORCE PlaceArea ENDOF
    13 OF 14 12 King  G_FORCE PlaceArea ENDOF
 \  default
    crd @ 0 DO
      crd @ I 2* P[a,b] suitadr @ G_FORCE PlaceArea
    LOOP
  ENDCASE
  0 0 LogOrig
;


2 0 IN/OUT
U: DisplayBack ( x y -- )
  LogOrig
  1      0      wc 1- HorizLine
  wc     1      hc 1- VertLine
  1      hc     wc 1- HorizLine
  0      1      hc 1- VertLine
  wc 1-  1      hc 1- VertLine
  1      hc 1-  wc 1- HorizLine
  3 3 CardBack G_FORCE PlaceArea
  0 0 LogOrig
;

1 1 IN/OUT
U: card
  15 AND
;

1 1 IN/OUT
U: suit
  >< 3 AND
;

1 0 IN/OUT
U: CardChr ( char -- )
   1 2 AT-GRXY EMIT
;
