/* LTABLE.C -- Command Table Routines

	Written March 1991 by Craig A. Finseth
	Copyright 1991,2,3,4 by Craig A. Finseth
*/

#include "loki.h"

/* command table conventions are:

	base		0	RES_BASE
	control-x	1	RES_CTX
	meta		2	RES_ESC
	function keys	3	RES_FUNC
*/

/* In help strings:

	@	no command
	^	self-insert
*/

void (*cmddisp[])() = {

AAdd, AAnd, ACHS, AClear, ACubRt, ACube, ADiv, AEnter, AInv, ALast,
AMul, ANeg, ANot, AOr, APercent, ARCL, ARoll, ASLeft, ASRight, ASTO,
ASqRt, ASquare, ASub, ASwap, AXor,

CCharBD,

DDate, DNewDisplay, DTime,

FEnvDefault, FMode, FSave, FSetDenom,

KBegMac, KColon, KEndMac, KFromMac, KLoadMac,

MAbort, MAbout, MAll, MClear, MClearStk, MClearX, MCompl, MConv,
MCopy, MCtrlX, MCut, MDoKey, MEnter, MEnterASCII, MExit, MFont,
MHexLetters, MMacEval, MMenu, MMenuM, MMeta, MNumBeg, MNumEnd, MPane,
MPaneKey, MPaste, MQuote, MRadix, MRegisters, MSetTabs, MShow, MSpace,
MStatus, MType, MUArg, MWSize,

MInsChar,	/* SI */
MNotImpl,	/* UC */
	};

int Tab_Proc(int restable, KEYCODE key);
int Tab_ProcID(int restable, KEYCODE key);

/* ------------------------------------------------------------ */

/* Invoke the specifed key from the specified table. */

void
TabDispatch(KEYCODE key, int table)
	{
	if (key == KEYQUIT) {
		MExit();
		return;
		}
	if (key == KEYABORT) {
		MAbort();
		return;
		}

	if (key >= 256) table = 3;
	switch (table) {

	case 0:
		if (key > 127) {
			if (meta_handle == 'M')
				(* (void(*)()) Tab_Proc(RES_ESC, key & 0x7F)
					)();
			else if (meta_handle == 'I')
				MInsChar();
			else	MNotImpl();
			}		
		else	(* (void(*)()) Tab_Proc(RES_BASE, key & 0x7F) )();
		break;

	case 1:
		(* (void(*)()) Tab_Proc(RES_CTX, key & 0x7F) )();
		break;

	case 2:
		(* (void(*)()) Tab_Proc(RES_ESC, key & 0x7F) )();
		break;

	case 3:
		if (key >= 256) key &= 0xff;
		(* (void(*)()) Tab_Proc(RES_FUNC, key) )();
		break;
		}
	}


/* ------------------------------------------------------------ */

/* Invoke the specifed function. */

void
TabDo(int code)
	{
	(*cmddisp[code])();
	}


/* ------------------------------------------------------------ */

/* Return the id of the command implied by KEY and TABLE. */

int
TabGetCmdID(KEYCODE key, int table)
	{
	int cmd;

	if (key == KEYQUIT) return(RES_MEXIT);
	if (key == KEYABORT) return(RES_MABORT);
	if (key >= 256) table = 3;
	switch (table) {

	case 0:		cmd = Tab_ProcID(RES_BASE, key & 0x7f);break;
	case 1:		cmd = Tab_ProcID(RES_CTX, key & 0x7f); break;
	case 2:		cmd = Tab_ProcID(RES_ESC, key & 0x7f); break;
	case 3:		if (key >= 256) key &= 0xff;
			cmd = Tab_ProcID(RES_FUNC, key);
			break;
		}
	return(cmd);
	}


/* ------------------------------------------------------------ */

/* Return the next command table or 0 if not a prefix. */

int
TabTable(KEYCODE key, int table)
	{
	if (key == KEYQUIT) return(0);
	if (key == KEYABORT) return(0);

	if (key >= 256) return(3);
	if (table == 0) {
		if (key == ZCX) return(1);
		else if (key == ESC) return(2);
		else if (key >= 256) return(3);
		}
	return(0);
	}


/* ------------------------------------------------------------ */

/* Return the procedure that does the KEY from resource table
RESTABLE. */

int
Tab_Proc(int restable, KEYCODE key)
	{
	return((int)cmddisp[
		*((unsigned char *)Res_String(NULL, restable, 0) + key) ]);
	}


/* ------------------------------------------------------------ */

/* Return the id of the procedure that does the KEY from resource
table RESTABLE. */

int
Tab_ProcID(int restable, KEYCODE key)
	{
	return(*((unsigned char *)Res_String(NULL, restable, 0) + key));
	}


/* end of LTABLE.C -- Command Table Routines */
