/* WORD.C -- Word-Oriented Commands

	Written July 1991 by Craig A. Finseth
	Copyright 1991 by Craig A. Finseth
*/

#include "freyja.h"

void W_Fill();		/* void */
FLAG W_IsClose();	/* void */
FLAG W_IsCNumber();	/* void */
FLAG W_IsNLPunct();	/* void */
FLAG W_IsParaEnd();	/* void */
FLAG W_IsSentEnd();	/* void */
FLAG W_IsToken();	/* void */
void W_MoveBlock();	/* struct mark *from, struct mark *to */
void W_ToWord();	/* void */

/* ------------------------------------------------------------ */

/* "Rotate" the case of the current word L -> C -> U -> L. */

void
WCaseRotate()
	{
	FLAG waslower;

	BMarkToPoint(cwin->point);
	if (BIsEnd() || !W_IsToken()) WWordB();
	while (!BIsEnd() && !xisalpha(BGetChar())) BMoveBy(1);
	if (BIsEnd()) {
		BPointToMark(cwin->point);
		return;
		}

	if (xislower(BGetChar())) {
		BCharChange(xtoupper(BGetChar()));
		waslower = FALSE;
		}
	else	{
		BMoveBy(1);
		waslower = xislower(BGetChar());
		BMoveBy(-1);
		}
	while (!BIsEnd() && W_IsToken()) {
		BCharChange(waslower ? xtoupper(BGetChar()) :
			xtolower(BGetChar()));
		}
	BPointToMark(cwin->point);
	}


/* ------------------------------------------------------------ */

/* Move backward one number. */

void
WNumB()
	{
	MoveToB(W_IsCNumber);
	MovePastB(W_IsCNumber);
	}


/* ------------------------------------------------------------ */

/* Move forward one number. */

void
WNumF()
	{
	MoveToF(W_IsCNumber);
	MovePastF(W_IsCNumber);
	}


/* ------------------------------------------------------------ */

/* Mark the current number. */

void
WNumMark()
	{
	MovePastB(W_IsCNumber);
	BMarkToPoint(mark);
	MovePastF(W_IsCNumber);
	}


/* ------------------------------------------------------------ */

/* Move backward one paragraph. */

void
WParaB()
	{
	GoToNotGrayB();
	if (cbuf->c.fill != 'W') {
		while (SearchNLB()) {
			BMoveBy(1);
			if (W_IsParaEnd()) break;
			BMoveBy(-1);
			}
		}
	else	BSearchB(NL, NL);
	GoToNotGrayF();
	}


/* ------------------------------------------------------------ */

/* Move forward one paragraph. */

void
WParaF()
	{
	GoToNotGrayF();
	if (cbuf->c.fill != 'W')
		while (SearchNLF() && !W_IsParaEnd()) ;
	else	BSearchF(NL, NL);
	GoToNotGrayB();
	}


/* ------------------------------------------------------------ */

/* Fill the paragraph. */

void
WParaFill()
	{
	if (cbuf->c.fill != 'W')
		W_Fill();
	else	WWrap();
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Set the point and mark around paragraph. */

void
WParaMark()
	{
	BMoveBy(-1);
	WParaF();
	BMarkToPoint(mark);
	WParaB();
	}


/* ------------------------------------------------------------ */

/* Move backwards one sentence. */

void
WSentB()
	{
	FLAG waspend;

	WWordB();
	do	{
		MoveToB(W_IsNLPunct);
		if (BIsStart()) break;
		BMoveBy(-1);
		if (IsNL()) {
			BMoveBy(1);
			waspend = W_IsParaEnd();
			BMoveBy(-1);
			if (waspend) GoToNotGrayF();
			}
		else	{
			waspend = W_IsSentEnd();
			if (waspend && !BIsStart())
				MoveToF(W_IsToken);
			else	MoveToB(W_IsToken);
			if (waspend) GoToGrayB();
			}
		} while (!waspend);
	}


/* ------------------------------------------------------------ */

/* Delete the previous sentence. */

void
WSentBD()
	{
	BMarkToPoint(cwin->point);
	WSentB();
	RKillToMark(cwin->point, BACKWARD);
	}


/* ------------------------------------------------------------ */

/* Move forward a sentence. */

void
WSentF()
	{
	for (;;) {
		WWordF();
		MoveToF(W_IsNLPunct);
		if (BIsEnd()) break;
		if (IsNL()) {
			BMoveBy(1);
			if (W_IsParaEnd()) break;
			BMoveBy(-1);
			}
		else if (W_IsSentEnd()) break;
		}
	}


/* ------------------------------------------------------------ */

/* Delete the following sentence. */

void
WSentFD()
	{
	BMarkToPoint(cwin->point);
	if (uarg == 0) {
		WSentB();
		RKillToMark(cwin->point, BACKWARD);
		}
	else	{
		WSentF();
		RKillToMark(cwin->point, FORWARD);
		}
	}


/* ------------------------------------------------------------ */

/* Move backwards one word. */

void
WWordB()
	{
	MoveToB(W_IsToken);
	MovePastB(W_IsToken);
	}


/* ------------------------------------------------------------ */

/* Delete the previous word. */

void
WWordBD()
	{
	BMarkToPoint(cwin->point);
	WWordB();
	RKillToMark(cwin->point, BACKWARD);
	}


/* ------------------------------------------------------------ */

/* Capitalize the following word. */

void
WWordCap()
	{
	W_ToWord();
	if (BIsEnd()) return;
	BCharChange(xtoupper(BGetChar()));
	if (W_IsToken()) WWordLow();
	}


/* ------------------------------------------------------------ */

/* Move foward one word. */

void
WWordF()
	{
	MoveToF(W_IsToken);
	MovePastF(W_IsToken);
	}


/* ------------------------------------------------------------ */

/* Delete the following word. */

void
WWordFD()
	{
	BMarkToPoint(cwin->point);
	WWordF();
	RKillToMark(cwin->point, FORWARD);
	}


/* ------------------------------------------------------------ */

/* Lowercase the following word. */

void
WWordLow()
	{
	W_ToWord();
	while (!BIsEnd() && W_IsToken()) {
		BCharChange(xtolower(BGetChar()));
		}
	}


/* ------------------------------------------------------------ */

/* Transpose the adjoining words. */

void
WWordTran()
	{
	struct mark *mptr;

	MoveToF(W_IsToken);
	if (BIsEnd()) return;
	mptr = BMarkCreate();
	MovePastF(W_IsToken);
	BMarkToPoint(cwin->point);
	BPointToMark(mptr);
	MoveToB(W_IsToken);
	W_MoveBlock(mptr, cwin->point);

	MovePastB(W_IsToken);
	W_MoveBlock(mptr, cwin->point);
	BMarkDelete(mptr);
	BPointToMark(cwin->point);
	}


/* ------------------------------------------------------------ */

/* Uppercase the following word. */

void
WWordUp()
	{
	W_ToWord();
	while (!BIsEnd() && W_IsToken()) {
		BCharChange(xtoupper(BGetChar()));
		}
	}


/* ------------------------------------------------------------ */

/* Refill the current paragraph in wrap mode. */

void
WWrap()
	{
	char markstat = NUL;
	int col;
	int chr;
	int wid;
	int lastlen = 0;

	BMarkToPoint(cwin->point);
	if (BSearchB(NL, SNL)) BMoveBy(1);	/* to start of paragraph */

	wid = 0;
	for (col = 0; !BIsEnd(); col++, wid++) {
		chr = BGetCharAdv();

		if (chr == SP || chr == TAB) {
			if (markstat == NL && lastlen + col <
				 cbuf->c.right_margin) {
				BMoveBy(-wid - 1);
				BCharChange(SP);
				BMoveBy(wid + 1);
				col += lastlen + 1;
				}
			wid = 0;
			markstat = SP;
			}

		else if (chr == NL) {
			break;
			}

		else if (chr == SNL) {
			if (markstat == NL && lastlen + col <
				 cbuf->c.right_margin) {
				BMoveBy(-wid - 1);
				BCharChange(SP);
				BMoveBy(wid + 1);
				col += lastlen;
				}
			wid = 0;
			markstat = NL;
			lastlen = col;
			col = -1;
			}

			/* printing character */
		else if (markstat == SP && col >= cbuf->c.right_margin) {
			BMoveBy(-wid - 1);
			BCharChange(SNL);
			BMoveBy(wid + 1);
			markstat = NUL;
			col = wid;
			wid = 0;
			}
		}
	BPointToMark(cwin->point);
	}


/* ------------------------------------------------------------ */

/* Fill the current paragraph in hard newline mode. */

void
W_Fill()
	{
	struct mark *endptr;
	struct mark *mptr;
	FLAG isnl;

	mptr = BMarkCreate();

	CLineA();
	WParaF();
	endptr = BMarkCreate();
	WParaB();

	while (BIsBeforeMark(endptr)) {
		GoToGrayF();
		if (BGetCol() > cbuf->c.right_margin) {
			GoToGrayB();
			BMoveBy(-1);
			BCharChange(NL);
			BInsSpaces(cbuf->c.left_margin);
			GoToGrayF();
			}
		MovePastF(IsWhite);
		if (IsNL() && BIsBeforeMark(endptr)) {
			BCharChange(SP);
			WDelFWhite();
			}
		}
	BPointToMark(mptr);
	BMarkDelete(endptr);
	BMarkDelete(mptr);
	}


/* ------------------------------------------------------------ */

/* Do we have a closing character? */

FLAG
W_IsClose()
	{
	return(*sindex(")]}\"'", BGetChar()) != NUL);
	}


/* ------------------------------------------------------------ */

/* Check for a calculator number digit. */

FLAG
W_IsCNumber()
	{
	return(*sindex("0123456789.,-#abcdefABCDEF", BGetChar()) != NUL);
	}


/* ------------------------------------------------------------ */

/* Check for Newline or punctuation */

FLAG
W_IsNLPunct()
	{
	return(IsNL() || *sindex(".?!", BGetChar()) != NUL);
	}


/* ------------------------------------------------------------ */

/* Check for the end of a paragraph. */

FLAG
W_IsParaEnd()
	{
	return(BIsEnd() || IsGray() || *sindex(".@", BGetChar()) != NUL);
	}


/* ------------------------------------------------------------ */

/* Check for the end of a sentence.  This routine assumes that it
starts at a sentence end (e.g., '.').  It then skips over as many of
')}]"' or "'" as it finds, and tells you whether you wind up at a
whitespace character. */

FLAG
W_IsSentEnd()
	{
	BMoveBy(1);
	MovePastF(W_IsClose);
	return(BIsEnd() || IsGray());
	}		


/* ------------------------------------------------------------ */

/* Tell if current char is part of a token */

FLAG
W_IsToken()
	{
	return(xisalnum(BGetChar()));
	}


/* ------------------------------------------------------------ */

/* Move a block of characters between Point and From to before To.
Assume Point is before From */

void
W_MoveBlock(from, to)
	struct mark *from;
	struct mark *to;
	{
	int chr;

	while (BIsBeforeMark(from)) {
		chr = BGetChar();
		BMarkSwap(to);
		BInsChar(chr);
		BMarkSwap(to);
		BCharDelete(1);
		}
	}


/* ------------------------------------------------------------ */

/* Move to the beginning of a word. */

void
W_ToWord()
	{
	MoveToF(W_IsToken);
	}


/* end of WORD.C -- Word-Oriented Commands */
