/* MISC.C -- Miscellaneous Commands

	Written July 1991 by Craig A. Finseth
	Copyright 1991 by Craig A. Finseth
*/

#include "freyja.h"

void M_Change();	/* char *oldstr, char *newstr, char *savestr */
void M_Replace();	/* FLAG isquery */
FLAG M_Search();	/* char *str, FLAG isforward */

/* ------------------------------------------------------------ */

/* Move backward to grayspace. */

void
GoToGrayB()
	{
	MoveToB(IsGray);
	}


/* ------------------------------------------------------------ */

/* Move forward to grayspace. */

void
GoToGrayF()
	{
	MoveToF(IsGray);
	}


/* ------------------------------------------------------------ */

/* Move backward to. */

void
GoToNotGrayB()
	{
	MovePastB(IsGray);
	}


/* ------------------------------------------------------------ */

/* Move forward to non-grayspace. */

void
GoToNotGrayF()
	{
	MovePastF(IsGray);
	}


/* ------------------------------------------------------------ */

/* Tell if the current character is a newline. */

FLAG
IsNL()
	{
	char chr;

	chr = BGetChar();
	return(chr == NL || chr == SNL);
	}


/* ------------------------------------------------------------ */

/* Tell if the current character is gray space. */

FLAG
IsGray()
	{
	char chr;

	chr = BGetChar();
	return(chr == SP || chr == TAB || chr == NL || chr == SNL);
	}


/* ------------------------------------------------------------ */

/* Tell if the current character is whitespace. */

FLAG
IsWhite()
	{
	char chr;

	chr = BGetChar();
	return(chr == SP || chr == TAB);
	}


/* ------------------------------------------------------------ */

/* Abort the current command prefix. */

void
MAbort()
	{
	TBell();
	DModeLine();
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Handle the Control-X prefix. */

void
MCtrlX()
	{
	FLAG disp;

	disp = KDelayPrompt("Control-X:");
	table = TabTable(key, table);
	key = KGetChar();
	if (disp) DModeLine();
	TabDispatch(key, table);
	}


/* ------------------------------------------------------------ */

/* Exit the editor. */

void
MExit()
	{
	struct buffer *bptr;
	int k;

	uarg = 0;
	for (bptr = buffers; bptr < &buffers[NUMBUFFERS]; bptr++) {
		if (!BIsFree(bptr) && !IS_SYS(bptr->fname) && BIsMod(bptr)) {
			BBufGoto(bptr);
			DIncrDisplay();
			k = KAsk("Save before exiting? ");
			if (k == KEYABORT) {
#if defined(SYSMGR)
				JNoFini();
#endif
				return;
				}
			else if (k == KEYQUIT) BFileWrite();
			else if (k == 'Y' && !BFileWrite()) return;
			}
		}
	doabort = TRUE;
	}


/* ------------------------------------------------------------ */

/* Insert the arg. */

void
MIns8()
	{
	if (!isuarg) {
		DError("An explicit argument must be supplied.");
		}
	else	{
		BInsChar(uarg);
		}
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Self-insert. */

void
MInsChar()
	{
	struct mark *mptr;

	if (cbuf->c.fill == 'F' && BGetCol() >= cbuf->c.right_margin) {
		mptr = BMarkCreate();
		do	{
			GoToGrayB();
			MovePastB(IsWhite);
			} while (BGetCol() > cbuf->c.right_margin);
		if (BGetCol() == 0) {
			MovePastF(IsWhite);
			GoToGrayF();
			}
		if (BIsBeforeMark(mptr)) {
			MovePastF(IsWhite);
			BMoveBy(-1);
			BCharChange(NL);
			BInsSpaces(cbuf->c.left_margin);
			if (BIsBeforeMark(mptr)) BPointToMark(mptr);
			}
		else	BPointToMark(mptr);
		BMarkDelete(mptr);
		}
	BInsChar(key);
	}


/* ------------------------------------------------------------ */

/* Make the previous command a deletion command. */

void
MMakeDelete()
	{
	}


/* ------------------------------------------------------------ */

/* Handle the Meta prefix. */

void
MMeta()
	{
	FLAG disp;

	disp = KDelayPrompt("Meta:");
	table = TabTable(key, table);
	key = KGetChar();
	if (disp) DModeLine();
	TabDispatch(key, table);
	}


/* ------------------------------------------------------------ */

/* Not implemented. */

void
MNotImpl()
	{
	DError("Unknown command");
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Quote the next character. */

void
MQuote()
	{
	FLAG disp;
	int c;

	disp = KDelayPrompt("Quote:");
	c = KGetChar();
	while (uarg-- > 0) {
		BInsChar(c);
		}
	if (disp) DModeLine();
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Replace string. */

void
MReplace()
	{
	M_Replace(FALSE);
	}


/* ------------------------------------------------------------ */

/* Query replace string. */

void
MReplaceQ()
	{
	M_Replace(TRUE);
	}


/* ------------------------------------------------------------ */

/* Backward string search. */

void
MSearchB()
	{
	if (KGetStr("Reverse Search", stringarg, sizeof(stringarg)) != 'Y') {
		uarg = 0;
		return;
		}
	BMarkToPoint(cwin->point);
	while (uarg-- > 0) {
		if (!M_Search(stringarg, BACKWARD)) {
			BPointToMark(cwin->point);
			DError("String not found");
			break;
			}
		}
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Forward string search. */

void
MSearchF()
	{
	if (KGetStr("Forward Search", stringarg, sizeof(stringarg)) != 'Y') {
		uarg = 0;
		return;
		}
	BMarkToPoint(cwin->point);
	while (uarg-- > 0) {
		if (!M_Search(stringarg, FORWARD)) {
			BPointToMark(cwin->point);
			DError("String not found");
			break;
			}
		}
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Handle argument prefix. */

void
MUArg()
	{
	FLAG numflag = FALSE;
	FLAG wasechoed;

	uarg *= 4;
	wasechoed = KUArg(uarg);
	while (xisdigit(key = KGetChar()))  {
		if (!numflag) {
			uarg = 0;
			numflag = TRUE;
			}
		uarg = uarg * 10 + key - '0';
		wasechoed |= KUArg(uarg);
		}

	if (wasechoed) DModeLine();
	isuarg = TRUE;
	TabDispatch(key, table);
	}


/* ------------------------------------------------------------ */

/* Move back past a type of text. */

void
MovePastB(pred)
	FLAG (*pred)();
	{
	BMoveBy(-1);
	while (!BIsStart() && (*pred)()) BMoveBy(-1);
	if (!BIsStart()) BMoveBy(1);
	}


/* ------------------------------------------------------------ */

/* Move forward past a type of text. */

void
MovePastF(pred)
	FLAG (*pred)();
	{
	while (!BIsEnd() && (*pred)()) BMoveBy(1);
	}


/* ------------------------------------------------------------ */

/* Move back to a type of text. */

void
MoveToB(pred)
	FLAG (*pred)();
	{
	BMoveBy(-1);
	while (!BIsStart() && !(*pred)()) BMoveBy(-1);
	if (!BIsStart()) BMoveBy(1);
	}


/* ------------------------------------------------------------ */

/* Move forward to a type of text. */

void
MoveToF(pred)
	FLAG (*pred)();
	{
	while (!BIsEnd() && !(*pred)()) BMoveBy(1);
	}


/* ------------------------------------------------------------ */

/* Reverse search for the next newline. */

FLAG
SearchNLB()
	{
	return(BSearchB(NL, SNL));
	}


/* ------------------------------------------------------------ */

/* Search for the next newline. */

FLAG
SearchNLF()
	{
	return(BSearchF(NL, SNL));
	}


/* ------------------------------------------------------------ */

/* Change old string into new */

void
M_Change(oldstr, newstr, savestr)
	char *oldstr;
	char *newstr;
	char *savestr;
	{
	int newlen = strlen(newstr);
	int oldlen = strlen(oldstr);
	int cnt;

	BMoveBy(-oldlen);
	if (savestr != NULL) {
		for (cnt = 0; cnt < oldlen; ++cnt) {
			*savestr++ = BGetCharAdv();
			}
		*savestr = NUL;
		BMoveBy(-oldlen);
		}
	if (oldlen > newlen) BCharDelete(oldlen - newlen);

	cnt = min(oldlen, newlen);
	while (cnt-- > 0) BCharChange(*newstr++);

	while (*newstr != NUL) BInsChar(*newstr++);
	}


/* ------------------------------------------------------------ */

/* Do query replace and replace string */

void
M_Replace(isquery)
	FLAG isquery;
	{
	int key;
	char from[STRMAX];
	char to[STRMAX];
	char save[STRMAX];
	char buf[LINEBUFFSIZE];
	struct mark *mptr;

	uarg = 0;
	*from = NUL;
	*to = NUL;

	do	{
		if (KGetStr(isquery ? "Query Replace String" :
			"Replace String", from, sizeof(from)) != 'Y') return;
		} while (*from == NUL);
	if (KGetStr("with", to, sizeof(to)) != 'Y') return;

	mptr = BMarkCreate();
	key = isquery ? ',' : SP;

	xsprintf(buf, TMaxCol() < 60 ? "Repl '%s' w '%s'" :
		"Replacing '%s' with '%s'", from, to);

	while (M_Search(from, FORWARD)) {
		if (!isquery) {
			M_Change(from, to, NULL);
			continue;
			}
		DIncrDisplay();
		DEchoNM(buf);
		key = xtoupper(KGetChar());
		if (key == KEYQUIT || key == KEYABORT || key == BEL ||
			 key == ESC) {
			BMarkToPoint(mptr);
			break;
			}

		switch (key) {

#if defined(MSDOS)
		case KEYHELP:
#endif
		case '?':
			M_Search(from, BACKWARD);
			DIncrDisplay();
			DView("Commands are: Y)yes N)no ,)try !)all .)exit ;)do&exit");
			key = ',';
			break;

		case '!':
			isquery = FALSE;
		case SP:
		case ',':		/* test comes later... */
		case ';':
		case 'Y':
			M_Change(from, to, save);
			DIncrDisplay();
			if (key == ',' && KAsk("Confirm Replace?") != 'Y')
				M_Change(to, save, NULL);
			if (key == ';') BMoveToEnd();
			break;

		case '.':
			BMoveToEnd();
			break;

		case 'N':
		case DEL:
		case BS:
			break;

		default:
			TBell();
			}
		}
	DModeLine();
	BPointToMark(mptr);
	BMarkDelete(mptr);
	}


/* ------------------------------------------------------------ */

/* Search for STR in the specified direction. */

FLAG
M_Search(str, isforward)
	char *str;
	FLAG isforward;
	{
	int cnt;
	char c1;
	char c2;

	for (cnt = 0; str[cnt] != NUL; ) {
		c1 = *str;
		c2 = xtoupper(c1);
		if (isforward) {
			if (!BSearchF(c1, c2)) break;
			}
		else	{
			if (!BSearchB(c1, c2)) break;
			BMoveBy(1);
			}

		for (cnt = 1; !BIsEnd() && str[cnt] != NUL; ++cnt) {
			c1 = str[cnt];
			c2 = xtoupper(c1);
			if (BGetChar() != c1 && BGetChar() != c2) break;
			BMoveBy(1);
			}
		if (!isforward || str[cnt] != NUL)
			BMoveBy((isforward ? 1 : 0) - cnt);
		}
	return(str[cnt] == NUL);
	}


/* end of MISC.C -- Miscellaneous Commands */
